/*
		     Audio File Library Wrapper
 */

#ifndef AFW_H
#define AFW_H

#include <sys/types.h>
#include "ytypes.h"
#include "ysound.h"
#include "midiiow.h"


/*
 *	Audio format codes:
 */
#define AFWFileFormatUnknown		0
#define AFWFileFormatRaw		1
#define AFWFileFormatWav		2
#define AFWFileFormatVoc		3
#define AFWFileFormatMP3		4
#define AFWFileFormatMidi		10


/*
 *	Audio format wrapper data structure:
 */
typedef struct {

	/* Pointer to allocated native audio library data struct. */
	void *ptr;

	/*   One of AFWFileFormat* (determines pointer type of
	 *   member ptr).
	 */
	int file_format;

	/* Format as a sound object, one of SndObjType*. */
	int sndobj_format;

	/* Entire length of audio data (not size of file). */
	YDataLength entire_length;

	/* Audio library's buffer, this contains a *duplicate* of
	 * the loaded DSP data from the library's structure.
	 */
	SoundBuffer *buffer;
	YDataLength length;

	/* Block align and length. */
	YDataPosition block_align;
	YDataLength block_length;

	/* Audio parameters. */
	int sample_size;
	int channels;
	int sample_rate;
	int bytes_per_sec;

	/* MIDI Specific members. */
	pid_t pid;		/* PID of process playing MIDI. */

} AFWDataStruct;



extern int AFWOpen(const char *path, AFWDataStruct *af_data);

extern int AFWLoadSegment(
	AFWDataStruct *af_data,
	YDataPosition position,
	YDataLength length,
	Audio *audio
);

extern void AFWClose(AFWDataStruct *af_data, Audio *audio);


#endif	/* AFW_H */
