/*
 * YH - Console Chinese Environment -
 * Copyright (C) 1999 Red Flag Linux (office@sonata.iscas.ac.cn)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/*****************---readkbd.c----*********************/


#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <stdlib.h>

#include "chncon.h"
#include "../im/pimi.h"
#include "incode.h"

#define QUANJIAO_MIN		33
#define QUANJIAO_MAX		126

#define KEY_BACKSPACE		8

#define KEY_ENTER		13

#define KEY_ESC			27

#ifdef OPENSERVER
/* shift + fn */
#define KEY_F1			89
#define KEY_F2			90
#define KEY_F3			97
#define KEY_F10			104
#define KEY_F11			105
#else
#define KEY_F1			112
#define KEY_F2			113
#define KEY_F3			114
#define KEY_F10			121
#define KEY_F11			122
#endif

/*make the key value comply to uniware7*/
#ifdef linux

#define KEY_F4			115
#define KEY_F5			116
#define KEY_F6			117
#define KEY_F7			118
#define KEY_F8			119

#define CTRL_SPACE		200
#define SHIFT_F1		201
#define SHIFT_F2		202
#define SHIFT_F3		203
#define SHIFT_F4		204
#define SHIFT_F5		205
#define SHIFT_F6		206
#define SHIFT_F7		207
#define SHIFT_F8		208
#define CTRL_ALT_b		209
#define CTRL_ALT_g		210

#endif

#define				GBK	1;
#define 			BIG5	0;
int				incode;
extern unsigned short int	gbktoucs[];
extern unsigned short int	ucstobig5[];
static void			GbkStrToUcs();
static void			UcsStrToBig5();

static char			*imname;
static int			quanjiao;
static int			english;
static int			disabled;
static int			newdisabled;


static char	*msg =  " Shift+F1=л"
			" Shift+F2=ȫ/"
			" Shift+F3F10=л뷨";

static char	*quanjiaotab[];		/* defined in the bottom */

static int	filter(int n, char buf[], char outbuf[]);
static void	gen_out(char outbuf[]);
static void catch_hup();


/***************************functions**************************/

void	ReadKeybrd()
{
	struct sigaction	act;
	char			buf[64];
	char			promptbuf[120];
	int			n;
        FILE 			*fp;
	int 			i;
        
	act.sa_handler = catch_hup;
#if (defined(OPENSERVER) || defined(GEMINI))
	act.sa_sigaction = catch_hup;
#endif
	act.sa_flags = 0;
	memset(&act.sa_mask, 0, sizeof(act.sa_mask));
	sigaction(SIGHUP, &act, NULL);

	PIMIInit(pipeCom[1]);
	incode=GBK;		
	quanjiao = 0;
	english = 1;
	disabled = 0;
	newdisabled = 0;
	imname = NULL;
	gen_out(promptbuf);
	/************/
	{
		FILE *fp;
		fp=fopen("/usr/local/yh/lib/incode.txt","w");
		fprintf(fp,"%d",incode);
		fclose(fp);
	}

	while (1)
	{
		int		i;

		if (promptbuf[0] != '\0')
		{
		   if(!incode)
		   {
			int num1,num2,i;
			unsigned char *tmpbuf1,*tmpbuf2;
			tmpbuf1=promptbuf;
			tmpbuf2=malloc(83*2);
			GbkStrToUcs(tmpbuf1,tmpbuf2,83,83*2,&num1,&num2);
			tmpbuf1=malloc(num2);
			UcsStrToBig5(tmpbuf2,tmpbuf1,num2,num2,&num1,&num2);
			for(i=0;i<num2;i++) promptbuf[i]=tmpbuf1[i];
			free(tmpbuf1);
			free(tmpbuf2);
		   }		
			write(pipePrompt[1], promptbuf, 83);
			promptbuf[0] = '\0';
			kill(pidWrite, SIGPIPE);
		}

		n = read(0, buf, sizeof(buf));

		if (n > 0)
		{       
                        n = filter(n, buf, promptbuf);
			if (n > 0)
                        {
				if (!incode)
				{
				   unsigned char *tmpbuf1,*tmpbuf2;
				   int num1,num2,i;
				   tmpbuf1 = buf;

				   if((tmpbuf2=malloc(2*n))==NULL)  exit(1);
				   GbkStrToUcs(tmpbuf1,tmpbuf2,n,2*n,&num1,&num2);
				   n=num2;
				   if((tmpbuf1=malloc(n))==NULL)  exit(1); 
				   UcsStrToBig5(tmpbuf2,tmpbuf1,n,n,&num1,&num2);
				   n=num2;
				   for(i=0;i<n;i++) buf[i]=tmpbuf1[i];
				   free(tmpbuf1);
				   free(tmpbuf2);
				}
				write(fdm, buf, n);
                        }	
		}
	}
}

#ifdef linux


/* judge if the value in buf[] is shift-f1 to shift-f8*/
static int translate_key(n,buf)
int n;
unsigned char buf[];
{
   /*if it is BACKSPACE */
if ((n==1) && (buf[0]==127) && (!english))
   {
      buf[0]=KEY_BACKSPACE;
      return KEY_BACKSPACE;
   } 

/*if it is ctrl+space*/
if (n==1 && buf[0]==CTRL_SPACE)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F1;
	return KEY_F1;
   }

/*if it is shift-f1 to shift-f8*/
if (n==1 && buf[0]==SHIFT_F1)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F1;
	return KEY_F1;
   }
if (n==1 && buf[0]==SHIFT_F2)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F2;
	return KEY_F2;
   }
if (n==1 && buf[0]==SHIFT_F3)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F3;
	return KEY_F3;
   }
if (n==1 && buf[0]==SHIFT_F4)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F4;
	return KEY_F4; 
   }
if (n==1 && buf[0]==SHIFT_F5)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F5;
	return KEY_F5;
   }
if (n==1 && buf[0]==SHIFT_F6)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F6;
	return KEY_F6;
   }
if (n==1 && buf[0]==SHIFT_F7)
   {	
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F7;
	return KEY_F7;
   }
if (n==1 && buf[0]==SHIFT_F8)
   {
	buf[0]=27;
	buf[1]=91;
	buf[2]=KEY_F8;
	return KEY_F8;
   }

return -1;
}
#endif


static int  filter(n, buf, outbuf)
int	n;
char	buf[];
char	outbuf[];
{
	char	c;
        unsigned char tmpchar; 

        int flag=0;
        FILE *fp=NULL;
        
	outbuf[0] = '\0';
        
	/*
	 * process F1F12
	 */
#ifdef linux
        flag=translate_key(n,buf);
        
	if(n==1) tmpchar=buf[0];

        if (flag >= KEY_F1 && flag <= KEY_F8) 
#else
#ifdef OPENSERVER
	if ((n == 3) && (buf[0] == 27) && (buf[1] == 91) &&
	    ((buf[2] >= KEY_F1) && (buf[2] <= KEY_F11)))
#else
	if ((n == 3) && (buf[0] == 27) && (buf[1] == 79) &&
	    ((buf[2] >= KEY_F1) && (buf[2] <= KEY_F11)))
#endif
#endif
	{
		if (buf[2] == KEY_F1)
		{
			newdisabled = ! disabled;
			n = 0;
			gen_out(outbuf);
                }
		else if (! disabled)
		{
                        if (buf[2] == KEY_F2)
				quanjiao = ! quanjiao;
			#ifdef linux
                        else if (buf[2] == KEY_F8)
                        #else
                        else if (buf[2] == KEY_F11)
                        #endif
			{
				PIMIQuit();
				english = 1;
				imname = NULL;
				PIMIClear();
			}
			else
			{
				imname = PIMISelectIM(buf[2] - KEY_F3);
				 
                                if (imname == NULL)
				{
					english = 1;
					PIMIClear();
				}
				else
				{
                                        english = 0;
					imname = strdup(imname);
				}
			}

			n = 0;
			gen_out(outbuf);
		}
	}
	else if ((n==1) && (tmpchar==CTRL_ALT_b || tmpchar==CTRL_ALT_g))
	{
		if (tmpchar==CTRL_ALT_b)		incode=BIG5;	
		if (tmpchar==CTRL_ALT_g)		incode=GBK;
		{
			FILE *fp;
			fp=fopen("/usr/local/yh/lib/incode.txt","w");
			fprintf(fp,"%d",incode);
			fclose(fp);
		}
		n=0;
		gen_out(outbuf);
	}
	else if ((! disabled) && (n == 1))
	{
		char	c = buf[0];

		
                if (quanjiao)
		{
			if ((c >= QUANJIAO_MIN) && (c <= QUANJIAO_MAX))
			{
				strcpy(buf, quanjiaotab[c - QUANJIAO_MIN]);
				n = strlen(buf);
			}
		}
		#ifdef linux
                else if ((! english) && ((! iscntrl(c)) || 
			(flag>0 && c == KEY_BACKSPACE) || (c == KEY_ENTER)))
                #else
                else if ((! english) && ((! iscntrl(c)) || 
			(c == KEY_BACKSPACE) || (c == KEY_ENTER)))
                #endif
		{
			if (PIMIFilter(c) < 0)
			{
				english = 1;
				imname = NULL;
				PIMIClear();
				n = 0;
			}
			else
			{
				strcpy(buf, result);
				n = strlen(result);
			}

			gen_out(outbuf);
		}
	}

	return	n;
}


static void  gen_out(outbuf)
char	outbuf[];
{
	if (newdisabled != disabled)
	{
		disabled = newdisabled;
		sprintf(outbuf, "\033[%c", disabled ? '{' : '}');
	}
	else if (! disabled)
	{
		int		len;
		char		buf[256];

		sprintf(buf, "%s%s", extcode, cand);
		sprintf(outbuf, "\033[]%s%s%s%s",
		    quanjiao ? "ȫ" : "",
		    (english || (imname == NULL)) ? "Ӣ" : imname,
		    incode ? "GBK" : "BIG5",
		    english ? "" : buf);		    			

		len = strlen(outbuf);
		if (len < 83)
			memset(&outbuf[len], ' ', 83 - len);

		if (english)
		{
			int	lenmsg;

			lenmsg = strlen(msg);
			memcpy(&outbuf[22 + (60 - lenmsg) / 2], msg, lenmsg);
		}

		outbuf[83] = '\0';
	}
}


static void catch_hup()
{
	PIMIClearup();
	exit(0);
}


static char	*quanjiaotab[] =
{
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	""
};


/*Note: if nToConvert == -1, we assume that the input 
	string was ended by a zero (0).  */
static void    GbkStrToUcs(
		unsigned char *lpInGbkStr,	/*Gbk string*/
		unsigned char *lpOutUcsStr,	/*Ucs string*/
		int nToConvert, 	 /*number of bytes of Gbk string to be converted */
		int nSizeUcsBuff,	/*size of Ucs buffer lpOutUcsStr (in bytes) */
		int *lpnGbkConverted,  /*bytes of Gbk string being converted */
		int *lpnUcsConverted)  /*bytes of Ucs string being converted */
{
		register int nIn,nOut;
		unsigned int ord;
		unsigned char byte1,byte2;
		unsigned short int code;
		
		if (nToConvert == -1)  	nToConvert=strlen(lpInGbkStr);
		if (nSizeUcsBuff == -1) nSizeUcsBuff=nToConvert;

		nIn=0;  nOut=0;

		while ((nIn<nToConvert-1) && (nOut<nSizeUcsBuff-1))
		{
			byte1=lpInGbkStr[nIn++];
			/*begin not Gb char*/
			if (byte1<=0x7f)
			/*Ascii char*/
			{
				lpOutUcsStr[nOut++]=0;
				lpOutUcsStr[nOut++]=byte1; /*ignore, just copy one byte*/
				continue;
			}
			if (byte1<0x81 || byte1==0xff)
			{
				lpOutUcsStr[nOut++]=BAD_UCS1;
				lpOutUcsStr[nOut++]=BAD_UCS2;
				continue;
			}
			byte2=lpInGbkStr[nIn++];
			if (byte2<0x40 || byte2==0xff || byte2==0x7f)
			{
				lpOutUcsStr[nOut++]=BAD_UCS1;
				lpOutUcsStr[nOut++]=BAD_UCS2;
				continue;
			}
			/*end not Gb char*/

			/*begin Gb char*/
			ord=(byte1-0x81)*190+(byte2-0x40);
			if(byte2>0x7f) ord--;
			code=gbktoucs[ord];
			lpOutUcsStr[nOut++]=(code>>8)&0xff;
			lpOutUcsStr[nOut++]=code&0xff;
		}
		if (nIn==nToConvert-1 && nOut < nSizeUcsBuff-1)
		/* let's process the last char */
		{
			byte1 = lpInGbkStr[nIn++];
			if (byte1 <= 0x7f)
			{  /* the last char was not Hanzi character, just copy it*/
				lpOutUcsStr[nOut++] = 0;
				lpOutUcsStr[nOut++] = byte1;
			}
			else
			{
				lpOutUcsStr[nOut++]=BAD_UCS1;	
				lpOutUcsStr[nOut++]=BAD_UCS2;
			}
		}
		if (lpnGbkConverted) *lpnGbkConverted = nIn;
		if (lpnUcsConverted) *lpnUcsConverted = nOut;
		return;
}


/*Note: if nToConvert == -1, we assume that the input string was ended by a zero (0) */
static void UcsStrToBig5(
	unsigned char *lpInUcsStr,  /* Ucs string*/
	unsigned char *lpOutBig5Str,  /*Big5 string*/
	int nToConvert,   /*number of bytes of UCS string to be converted*/
	int nSizeBig5Buff, /*size of big5 buffer lpOutBig5Str (in bytes)*/
	int *lpnUcsConverted, /*bytes of Gb2312 string being converted*/
	int *lpnBig5Converted) /*bytes of Big5 string being converted*/
{
	register int nIn,nOut;
	unsigned int ord;
	unsigned char byte1,byte2;
	unsigned short int code;
	
	if (nToConvert == -1)  nToConvert = strlen(lpInUcsStr);
	if (nSizeBig5Buff == -1) nSizeBig5Buff = nToConvert;

	nIn=0; nOut=0;

	while ((nIn<nToConvert-1) && (nOut<nSizeBig5Buff-1))
	{
		byte1=lpInUcsStr[nIn++];
		byte2=lpInUcsStr[nIn++];
		if (byte1 == 0 && (byte2 & 0x80) == 0)
		{
			/*ascii */
			lpOutBig5Str[nOut++]=byte2;
			continue;
		}
		ord=(byte1<<8)+byte2;
		code=ucstobig5[ord];
		lpOutBig5Str[nOut++]=(code>>8) & 0xff;
		lpOutBig5Str[nOut++]= code & 0xff;	
	}
	if (lpnUcsConverted) *lpnUcsConverted = nIn;
	if (lpnBig5Converted) *lpnBig5Converted =nOut;
	return;
}
