/**
 * @file    message.c
 * @brief   Routines for displaying informational messages.
 *
 * @author  Denis Pollney
 * @date    1 Oct 2001
 *
 * @par Copyright (C) 2001-2002 Denis Pollney
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 * @par
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details
 * @par
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ygraph.h"

/**
 * @brief    Create a pop-up message dialog.
 *
 * @param    msg  The message text.
 */
void
message_dialog(gchar* msg)
{
  GtkWidget* msg_dialog;
  GtkWidget* label;
  GtkWidget* ok_button;

  msg_dialog = gtk_dialog_new();
  label = gtk_label_new(msg);
  ok_button = gtk_button_new_with_label(OKAY_BUTTON_LABEL);

  gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy),
			    GTK_OBJECT(msg_dialog));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(msg_dialog)->action_area), ok_button,
		     FALSE, FALSE, 0);

  gtk_misc_set_padding(GTK_MISC(label),
		       MESSAGE_X_PADDING, MESSAGE_Y_PADDING);
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(msg_dialog)->vbox), label);

  gtk_widget_show_all(msg_dialog);
}
