/* ncurses-gui.h
 * Definitions for the ncurses GUI
 *
 * $Id: ncurses-gui.h,v 1.6 2005/07/28 19:29:25 t0mac Exp $ 
 *
 * Yersinia
 * By David Barroso <tomac@wasahero.org> and Alfredo Andres <slay@wasahero.org>
 * Copyright 2005 Alfredo Andres and David Barroso
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __NCURSES_GUI_H__
#define __NCURSES_GUI_H__

#if defined(USE_NCURSES) && !defined(RENAMED_NCURSES)
#include <ncurses.h>
#else
#include <curses.h>
#endif

#ifdef HAVE_PANEL_H
#include <panel.h>
#endif

#include <ctype.h>

#include "thread-util.h"
#include "terminal-defs.h"
#include "admin.h"
#include "interfaces.h"
#include "attack.h"

#include "parser.h"


#define ERRORMSG_SIZE   512
#define NCURSES_MIN_ROWS 25
#define NCURSES_MIN_COLS 80
#define NCURSES_MAX_WINDOWS 11
#define NCURSES_REFRESH_TIME 2
#define NCURSES_BWINDOW_SIZE 7

#define NCURSES_KEY_TIMEOUT 250

#define KEY_CTRL_L 12

#define PARAM_SCREEN   10
#define LIST_FILECAPS  9
#define LIST_ATTACKS   8
#define IFACE_SCREEN   7
#define MAIN_SCREEN    6
#define SEC_SCREEN     5
#define ATTACK_SCREEN  4
#define INFO_SCREEN    3
#define HELP_SCREEN    2
#define SPLASH_SCREEN  1

#define INFO_HEIGHT    13 
#define INFO_WIDTH     44
#define MAX_PAD_HEIGHT 40 
#define MAX_PAD_WIDTH  70

#define NCURSES_XSTP_MODE    PROTO_STP
#define NCURSES_CDP_MODE     PROTO_CDP
#define NCURSES_DHCP_MODE    PROTO_DHCP
#define NCURSES_HSRP_MODE    PROTO_HSRP
#define NCURSES_DTP_MODE     PROTO_DTP
#define NCURSES_DOT1Q_MODE   PROTO_802_1Q
#define NCURSES_VTP_MODE     PROTO_VTP
#define NCURSES_DEFAULT_MODE NCURSES_XSTP_MODE

/* taken from tcpdump print-ascii.c 
 * http://www.tcpdump.org
 */
#define ASCII_LINELENGTH 300
#define HEXDUMP_BYTES_PER_LINE 16
#define HEXDUMP_SHORTS_PER_LINE (HEXDUMP_BYTES_PER_LINE / 2)
#define HEXDUMP_HEXSTUFF_PER_SHORT 5 /* 4 hex digits and a space */
#define HEXDUMP_HEXSTUFF_PER_LINE \
		(HEXDUMP_HEXSTUFF_PER_SHORT * HEXDUMP_SHORTS_PER_LINE)

#define VIEW_HEIGHT 15
#define VIEW_WIDTH 68

#if defined (TIOCGWINSZ) && defined (HAVE_NCURSES_RESIZETERM)
#define CAN_RESIZE 1
#endif

u_int8_t pointer[MAX_PROTOCOLS];
WINDOW *info_window;

void ncurses_gui(void *);
int8_t  ncurses_gui_init(WINDOW *[], PANEL *[], struct term_node *);
void ncurses_gui_add_node(void);
void ncurses_gui_th_exit(struct term_node *);
void ncurses_gui_splash_screen(WINDOW *, PANEL *);
void ncurses_gui_help_screen(u_int8_t, WINDOW *, PANEL *);
void ncurses_gui_attack_screen(struct term_node *, u_int8_t, WINDOW *, PANEL *);
int8_t ncurses_gui_attack_get_params(struct attack_param *, u_int8_t);
//int8_t ncurses_gui_update_fields(struct attack_param *, u_int8_t, int8_t, int8_t);
void ncurses_gui_get_printable_store(struct attack_param *, u_int8_t);
void ncurses_gui_refresh_mwindow(u_int8_t, WINDOW *, u_int8_t, struct term_node *);
void ncurses_gui_refresh_bwindow(u_int8_t, WINDOW *, struct term_node *);
void ncurses_gui_refresh(void);
void ncurses_gui_engine(WINDOW *[], PANEL *[], struct term_node *);
void ncurses_gui_edit_bwindow(u_int8_t, WINDOW *, WINDOW *, struct term_node *);
void ncurses_gui_ifaces_screen(struct term_node *, WINDOW *, PANEL *);
int8_t  ncurses_gui_show_info(u_int8_t, WINDOW *, u_int8_t, struct term_node *);
int8_t  ncurses_gui_view_packet(u_int8_t, WINDOW *, u_int8_t);
void    ncurses_gui_list_attacks(WINDOW *, struct term_node *);
void    ncurses_gui_list_filecaps(WINDOW *, struct term_node *);
int8_t  ncurses_gui_learn_packet(u_int8_t, u_int8_t, struct term_node *);
int8_t  ncurses_gui_error_window(u_int8_t, char *, ...);
int8_t  ncurses_gui_term_resize(struct term_node *);
int32_t ncurses_gui_popup_window(WINDOW *, struct position_fields *, u_int8_t, u_int8_t, u_int8_t);
int8_t  ncurses_gui_set_status_line(char *);
int8_t  ncurses_gui_edit_tlv(struct term_node *, u_int8_t);
int8_t  ncurses_gui_add_selected_tlv_type(WINDOW *, struct term_node *, u_int8_t);
int8_t  ncurses_gui_del_selected_tlv(struct term_node *, u_int8_t, u_int8_t);
int8_t  ncurses_gui_getstring_window(struct term_node *, char *, char *, u_int8_t, char *);
int32_t ncurses_gui_getconfirm(struct term_node *, char *, char *, char *);
int8_t  ncurses_gui_get_mode(u_int8_t, WINDOW *);

void resizeHandler(int);

/* Global stuff */
extern void   thread_error(char *, int8_t);
extern u_int32_t uptime;
extern struct term_tty *tty_tmp;
extern int8_t parser_write_config_file(struct term_tty *);


extern int8_t parser_get_formated_inet_address(u_int32_t, char *, u_int16_t);

/* Terminal stuff */
extern struct terminals *terms;
extern int8_t term_add_node(struct term_node **, int8_t, int32_t, pthread_t);

/* Interfaces stuff */
extern int16_t  interfaces_add(char *);
extern int8_t   interfaces_del(u_int16_t);
extern int8_t   interfaces_clear_stats(int8_t);
extern u_int8_t interfaces_get_last_int(u_int8_t);
extern struct   packet_stats packet_stats;

/* Attack stuff */
extern int8_t attack_stp_learn_packet(void);
extern int8_t attack_launch(struct term_node *, u_int16_t, u_int16_t, struct attack_param *, u_int8_t);
extern int8_t attack_kill_th(struct term_node *, pthread_t );
extern int8_t attack_init_params(struct term_node *, struct attack_param *, u_int8_t);
extern int8_t attack_filter_all_params(struct attack_param *, u_int8_t, u_int8_t *);
extern void   attack_free_params(struct attack_param *, u_int8_t);

/* XSTP stuff */
extern char **xstp_get_printable_packet(struct pcap_data *);
extern char **xstp_get_printable_store(struct term_node *);
extern int8_t xstp_load_values(struct pcap_data *, void *);
extern int8_t xstp_update_data(int8_t, int8_t, int8_t, struct term_node *);

/* CDP stuff */
extern char **cdp_get_printable_packet(struct pcap_data *);
extern char **cdp_get_printable_store(struct term_node *);
extern int8_t cdp_load_values(struct pcap_data *, void *);
extern char *cdp_get_type_info(u_int16_t);
extern int8_t cdp_update_data(int8_t state, int8_t key, int8_t position, struct term_node *node);

/* DTP stuff */
extern char **dtp_get_printable_packet(struct pcap_data *);
extern char **dtp_get_printable_store(struct term_node *);
extern int8_t dtp_load_values(struct pcap_data *, void *);

/* DHCP stuff */
extern char **dhcp_get_printable_packet(struct pcap_data *);
extern char **dhcp_get_printable_store(struct term_node *);
extern char *dhcp_get_type_info(u_int16_t);
extern int8_t dhcp_load_values(struct pcap_data *, void *);
extern int8_t dhcp_update_data(int8_t, int8_t, int8_t, struct term_node *);

/* HSRP stuff */
extern char **hsrp_get_printable_packet(struct pcap_data *);
extern char **hsrp_get_printable_store(struct term_node *);
extern int8_t hsrp_load_values(struct pcap_data *, void *);
extern int8_t hsrp_update_data(int8_t, int8_t, int8_t, struct term_node *);

/* 802.1Q estaf ;) */
extern char **dot1q_get_printable_packet(struct pcap_data *);
extern char **dot1q_get_printable_store(struct term_node *);
extern int8_t dot1q_load_values(struct pcap_data *, void *);
extern int8_t dot1q_update_data(int8_t, int8_t, int8_t, struct term_node *);

/* VTP estaf :DD */
extern char **vtp_get_printable_packet(struct pcap_data *);
extern char **vtp_get_printable_store(struct term_node *);
extern int8_t vtp_load_values(struct pcap_data *, void *);
extern int8_t vtp_update_data(int8_t, int8_t, int8_t, struct term_node *);

#endif
/* vim:set tabstop=4:set expandtab:set shiftwidth=4:set textwidth=78: */
