/* Generated by re2c 0.9.1-C on Sat Oct 30 21:13:55 2004
 */
#line 1 "./modules/arch/x86/x86id.re"
/*
 * x86 identifier recognition and instruction handling
 *
 *  Copyright (C) 2002  Peter Johnson
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND OTHER CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR OTHER CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <util.h>
RCSID("$Id: x86id.re 1163 2004-10-13 03:55:04Z peter $");

#define YASM_LIB_INTERNAL
#define YASM_BC_INTERNAL
#define YASM_EXPR_INTERNAL
#include <libyasm.h>

#include "modules/arch/x86/x86arch.h"


/* Opcode modifiers.  The opcode bytes are in "reverse" order because the
 * parameters are read from the arch-specific data in LSB->MSB order.
 * (only for asthetic reasons in the lexer code below, no practical reason).
 */
#define MOD_Gap0    (1UL<<0)	/* Eats a parameter */
#define MOD_Op2Add  (1UL<<1)	/* Parameter adds to opcode byte 2 */
#define MOD_Gap1    (1UL<<2)	/* Eats a parameter */
#define MOD_Op1Add  (1UL<<3)	/* Parameter adds to opcode byte 1 */
#define MOD_Gap2    (1UL<<4)	/* Eats a parameter */
#define MOD_Op0Add  (1UL<<5)	/* Parameter adds to opcode byte 0 */
#define MOD_PreAdd  (1UL<<6)	/* Parameter adds to "special" prefix */
#define MOD_SpAdd   (1UL<<7)	/* Parameter adds to "spare" value */
#define MOD_OpSizeR (1UL<<8)	/* Parameter replaces opersize */
#define MOD_Imm8    (1UL<<9)	/* Parameter is included as immediate byte */
#define MOD_AdSizeR (1UL<<10)	/* Parameter replaces addrsize (jmp only) */
#define MOD_DOpS64R (1UL<<11)	/* Parameter replaces default 64-bit opersize */

/* Modifiers that aren't actually used as modifiers.  Rather, if set, bits
 * 20-27 in the modifier are used as an index into an array.
 * Obviously, only one of these may be set at a time.
 */
#define MOD_ExtNone (0UL<<28)	/* No extended modifier */
#define MOD_ExtErr  (1UL<<28)	/* Extended error: index into error strings */
#define MOD_ExtWarn (2UL<<28)	/* Extended warning: index into warning strs */
#define MOD_Ext_MASK (0xFUL<<28)
#define MOD_ExtIndex_SHIFT	20
#define MOD_ExtIndex(indx)	(((unsigned long)(indx))<<MOD_ExtIndex_SHIFT)
#define MOD_ExtIndex_MASK	(0xFFUL<<MOD_ExtIndex_SHIFT)

/* Operand types.  These are more detailed than the "general" types for all
 * architectures, as they include the size, for instance.
 * Bit Breakdown (from LSB to MSB):
 *  - 5 bits = general type (must be exact match, except for =3):
 *             0 = immediate
 *             1 = any general purpose or FPU register
 *             2 = memory
 *             3 = any general purpose or FPU register OR memory
 *             4 = any MMX or XMM register
 *             5 = any MMX or XMM register OR memory
 *             6 = any segment register
 *             7 = any CR register
 *             8 = any DR register
 *             9 = any TR register
 *             A = ST0
 *             B = AL/AX/EAX/RAX (depending on size)
 *             C = CL/CX/ECX/RCX (depending on size)
 *             D = DL/DX/EDX/RDX (depending on size)
 *             E = CS
 *             F = DS
 *             10 = ES
 *             11 = FS
 *             12 = GS
 *             13 = SS
 *             14 = CR4
 *             15 = memory offset (an EA, but with no registers allowed)
 *                  [special case for MOV opcode]
 *  - 3 bits = size (user-specified, or from register size):
 *             0 = any size acceptable/no size spec acceptable (dep. on strict)
 *             1/2/3/4 = 8/16/32/64 bits (from user or reg size)
 *             5/6 = 80/128 bits (from user)
 *  - 1 bit = size implicit or explicit ("strictness" of size matching on
 *            non-registers -- registers are always strictly matched):
 *            0 = user size must exactly match size above.
 *            1 = user size either unspecified or exactly match size above.
 *  - 3 bits = target modification.
 *            0 = no target mod acceptable
 *            1 = NEAR
 *            2 = SHORT
 *            3 = FAR
 *            4 = TO
 *  - 1 bit = effective address size
 *            0 = any address size allowed except for 64-bit
 *            1 = only 64-bit address size allowed
 *
 * MSBs than the above are actions: what to do with the operand if the
 * instruction matches.  Essentially describes what part of the output bytecode
 * gets the operand.  This may require conversion (e.g. a register going into
 * an ea field).  Naturally, only one of each of these may be contained in the
 * operands of a single insn_info structure.
 *  - 4 bits = action:
 *             0 = does nothing (operand data is discarded)
 *             1 = operand data goes into ea field
 *             2 = operand data goes into imm field
 *             3 = operand data goes into sign-extended imm field
 *             4 = operand data goes into "spare" field
 *             5 = operand data is added to opcode byte 0
 *             6 = operand data is added to opcode byte 1
 *             7 = operand data goes into BOTH ea and spare
 *                 [special case for imul opcode]
 *             8 = relative jump (outputs a jmp instead of normal insn)
 *             9 = operand size goes into address size (jmp only)
 * The below describes postponed actions: actions which can't be completed at
 * parse-time due to things like EQU and complex expressions.  For these, some
 * additional data (stored in the second byte of the opcode with a one-byte
 * opcode) is passed to later stages of the assembler with flags set to
 * indicate postponed actions.
 *  - 3 bits = postponed action:
 *             0 = none
 *             1 = shift operation with a ,1 short form (instead of imm8).
 *             2 = large imm16/32 that can become a sign-extended imm8.
 *             3 = can be far jump
 *             4 = could become a short opcode mov with bits=64 and a32 prefix
 */
#define OPT_Imm		0x0
#define OPT_Reg		0x1
#define OPT_Mem		0x2
#define OPT_RM		0x3
#define OPT_SIMDReg	0x4
#define OPT_SIMDRM	0x5
#define OPT_SegReg	0x6
#define OPT_CRReg	0x7
#define OPT_DRReg	0x8
#define OPT_TRReg	0x9
#define OPT_ST0		0xA
#define OPT_Areg	0xB
#define OPT_Creg	0xC
#define OPT_Dreg	0xD
#define OPT_CS		0xE
#define OPT_DS		0xF
#define OPT_ES		0x10
#define OPT_FS		0x11
#define OPT_GS		0x12
#define OPT_SS		0x13
#define OPT_CR4		0x14
#define OPT_MemOffs	0x15
#define OPT_MASK	0x1F

#define OPS_Any		(0UL<<5)
#define OPS_8		(1UL<<5)
#define OPS_16		(2UL<<5)
#define OPS_32		(3UL<<5)
#define OPS_64		(4UL<<5)
#define OPS_80		(5UL<<5)
#define OPS_128		(6UL<<5)
#define OPS_MASK	(7UL<<5)
#define OPS_SHIFT	5

#define OPS_Relaxed	(1UL<<8)
#define OPS_RMASK	(1UL<<8)

#define OPEAS_Not64	(0UL<<9)
#define OPEAS_64	(1UL<<9)
#define OPEAS_MASK	(1UL<<9)

#define OPTM_None	(0UL<<10)
#define OPTM_Near	(1UL<<10)
#define OPTM_Short	(2UL<<10)
#define OPTM_Far	(3UL<<10)
#define OPTM_To		(4UL<<10)
#define OPTM_MASK	(7UL<<10)

#define OPA_None	(0UL<<13)
#define OPA_EA		(1UL<<13)
#define OPA_Imm		(2UL<<13)
#define OPA_SImm	(3UL<<13)
#define OPA_Spare	(4UL<<13)
#define OPA_Op0Add	(5UL<<13)
#define OPA_Op1Add	(6UL<<13)
#define OPA_SpareEA	(7UL<<13)
#define OPA_JmpRel	(8UL<<13)
#define OPA_AdSizeR	(9UL<<13)
#define OPA_MASK	(0xFUL<<13)

#define OPAP_None	(0UL<<17)
#define OPAP_ShiftOp	(1UL<<17)
#define OPAP_SImm8Avail	(2UL<<17)
#define OPAP_JmpFar	(3UL<<17)
#define OPAP_ShortMov	(4UL<<17)
#define OPAP_MASK	(7UL<<17)

typedef struct x86_insn_info {
    /* The CPU feature flags needed to execute this instruction.  This is OR'ed
     * with arch-specific data[2].  This combined value is compared with
     * cpu_enabled to see if all bits set here are set in cpu_enabled--if so,
     * the instruction is available on this CPU.
     */
    unsigned long cpu;

    /* Opcode modifiers for variations of instruction.  As each modifier reads
     * its parameter in LSB->MSB order from the arch-specific data[1] from the
     * lexer data, and the LSB of the arch-specific data[1] is reserved for the
     * count of insn_info structures in the instruction grouping, there can
     * only be a maximum of 3 modifiers.
     */
    unsigned long modifiers;

    /* Operand Size */
    unsigned char opersize;

    /* Default operand size in 64-bit mode (0 = 32-bit for readability). */
    unsigned char def_opersize_64;

    /* A special instruction prefix, used for some of the Intel SSE and SSE2
     * instructions.  Intel calls these 3-byte opcodes, but in AMD64's 64-bit
     * mode, they're treated like normal prefixes (e.g. the REX prefix needs
     * to be *after* the F2/F3/66 "prefix").
     * (0=no special prefix)
     */
    unsigned char special_prefix;

    /* The length of the basic opcode */
    unsigned char opcode_len;

    /* The basic 1-3 byte opcode (not including the special instruction
     * prefix).
     */
    unsigned char opcode[3];

    /* The 3-bit "spare" value (extended opcode) for the R/M byte field */
    unsigned char spare;

    /* The number of operands this form of the instruction takes */
    unsigned char num_operands;

    /* The types of each operand, see above */
    unsigned long operands[3];
} x86_insn_info;

/* Define lexer arch-specific data with 0-3 modifiers. */
#define DEF_INSN_DATA(group, mod, cpu)	do { \
    data[0] = (unsigned long)group##_insn; \
    data[1] = ((mod)<<8) | \
    	      ((unsigned char)(sizeof(group##_insn)/sizeof(x86_insn_info))); \
    data[2] = cpu; \
    } while (0)

#define RET_INSN(group, mod, cpu)	do { \
    DEF_INSN_DATA(group, mod, cpu); \
    return YASM_ARCH_CHECK_ID_INSN; \
    } while (0)

/*
 * General instruction groupings
 */

/* Placeholder for instructions invalid in 64-bit mode */
static const x86_insn_info not64_insn[] = {
    { CPU_Not64, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 0, {0, 0, 0} }
};

/* One byte opcode instructions with no operands */
static const x86_insn_info onebyte_insn[] = {
    { CPU_Any, MOD_Op0Add|MOD_OpSizeR|MOD_DOpS64R, 0, 0, 0, 1, {0, 0, 0}, 0, 0,
      {0, 0, 0} }
};

/* One byte opcode instructions with "special" prefix with no operands */
static const x86_insn_info onebyte_prefix_insn[] = {
    { CPU_Any, MOD_Op0Add|MOD_PreAdd, 0, 0, 0x00, 2, {0x00, 0, 0}, 0, 0,
      {0, 0, 0} }
};

/* Two byte opcode instructions with no operands */
static const x86_insn_info twobyte_insn[] = {
    { CPU_Any, MOD_Op1Add|MOD_Op0Add, 0, 0, 0, 2, {0, 0, 0}, 0, 0, {0, 0, 0} }
};

/* Three byte opcode instructions with no operands */
static const x86_insn_info threebyte_insn[] = {
    { CPU_Any, MOD_Op2Add|MOD_Op1Add|MOD_Op0Add, 0, 0, 0, 3, {0, 0, 0}, 0, 0,
      {0, 0, 0} }
};

/* One byte opcode instructions with general memory operand */
static const x86_insn_info onebytemem_insn[] = {
    { CPU_Any, MOD_Op0Add|MOD_SpAdd, 0, 0, 0, 1, {0, 0, 0}, 0, 1,
      {OPT_Mem|OPS_Any|OPA_EA, 0, 0} }
};

/* Two byte opcode instructions with general memory operand */
static const x86_insn_info twobytemem_insn[] = {
    { CPU_Any, MOD_Op1Add|MOD_Op0Add|MOD_SpAdd, 0, 0, 0, 2, {0, 0, 0}, 0, 1,
      {OPT_Mem|OPS_Any|OPA_EA, 0, 0} }
};

/* Move instructions */
static const x86_insn_info mov_insn[] = {
    /* Absolute forms for non-64-bit mode */
    { CPU_Not64, 0, 0, 0, 0, 1, {0xA0, 0, 0}, 0, 2,
      {OPT_Areg|OPS_8|OPA_None, OPT_MemOffs|OPS_8|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0xA1, 0, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_None, OPT_MemOffs|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xA1, 0, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_None, OPT_MemOffs|OPS_32|OPS_Relaxed|OPA_EA, 0} },

    { CPU_Not64, 0, 0, 0, 0, 1, {0xA2, 0, 0}, 0, 2,
      {OPT_MemOffs|OPS_8|OPS_Relaxed|OPA_EA, OPT_Areg|OPS_8|OPA_None, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0xA3, 0, 0}, 0, 2,
      {OPT_MemOffs|OPS_16|OPS_Relaxed|OPA_EA, OPT_Areg|OPS_16|OPA_None, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xA3, 0, 0}, 0, 2,
      {OPT_MemOffs|OPS_32|OPS_Relaxed|OPA_EA, OPT_Areg|OPS_32|OPA_None, 0} },

    /* 64-bit absolute forms for 64-bit mode */
    { CPU_Hammer|CPU_64, 0, 0, 0, 0, 1, {0xA0, 0, 0}, 0, 2,
      {OPT_Areg|OPS_8|OPA_None,
       OPT_MemOffs|OPS_8|OPS_Relaxed|OPEAS_64|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 16, 0, 0, 1, {0xA1, 0, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_None,
       OPT_MemOffs|OPS_16|OPS_Relaxed|OPEAS_64|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 32, 0, 0, 1, {0xA1, 0, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_None,
       OPT_MemOffs|OPS_32|OPS_Relaxed|OPEAS_64|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xA1, 0, 0}, 0, 2,
      {OPT_Areg|OPS_64|OPA_None,
       OPT_MemOffs|OPS_64|OPS_Relaxed|OPEAS_64|OPA_EA, 0} },

    { CPU_Hammer|CPU_64, 0, 0, 0, 0, 1, {0xA2, 0, 0}, 0, 2,
      {OPT_MemOffs|OPS_8|OPS_Relaxed|OPEAS_64|OPA_EA,
       OPT_Areg|OPS_8|OPA_None, 0} },
    { CPU_Hammer|CPU_64, 0, 16, 0, 0, 1, {0xA3, 0, 0}, 0, 2,
      {OPT_MemOffs|OPS_16|OPS_Relaxed|OPEAS_64|OPA_EA,
       OPT_Areg|OPS_16|OPA_None, 0} },
    { CPU_Hammer|CPU_64, 0, 32, 0, 0, 1, {0xA3, 0, 0}, 0, 2,
      {OPT_MemOffs|OPS_32|OPS_Relaxed|OPEAS_64|OPA_EA,
       OPT_Areg|OPS_32|OPA_None, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xA3, 0, 0}, 0, 2,
      {OPT_MemOffs|OPS_64|OPS_Relaxed|OPEAS_64|OPA_EA,
       OPT_Areg|OPS_64|OPA_None, 0} },

    /* General 32-bit forms using Areg / short absolute option */
    { CPU_Any, 0, 0, 0, 0, 1, {0x88, 0xA2, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA|OPAP_ShortMov, OPT_Areg|OPS_8|OPA_Spare,
       0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x89, 0xA3, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA|OPAP_ShortMov,
       OPT_Areg|OPS_16|OPA_Spare, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x89, 0xA3, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA|OPAP_ShortMov,
       OPT_Areg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x89, 0xA3, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA|OPAP_ShortMov,
       OPT_Areg|OPS_64|OPA_Spare, 0} },

    /* General 32-bit forms */
    { CPU_Any, 0, 0, 0, 0, 1, {0x88, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_8|OPA_Spare, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x89, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x89, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x89, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare, 0} },

    /* General 32-bit forms using Areg / short absolute option */
    { CPU_Any, 0, 0, 0, 0, 1, {0x8A, 0xA0, 0}, 0, 2,
      {OPT_Areg|OPS_8|OPA_Spare, OPT_RM|OPS_8|OPS_Relaxed|OPA_EA|OPAP_ShortMov,
       0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x8B, 0xA1, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_Spare,
       OPT_RM|OPS_16|OPS_Relaxed|OPA_EA|OPAP_ShortMov, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x8B, 0xA1, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_Spare,
       OPT_RM|OPS_32|OPS_Relaxed|OPA_EA|OPAP_ShortMov, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x8B, 0xA1, 0}, 0, 2,
      {OPT_Areg|OPS_64|OPA_Spare,
       OPT_RM|OPS_64|OPS_Relaxed|OPA_EA|OPAP_ShortMov, 0} },

    /* General 32-bit forms */
    { CPU_Any, 0, 0, 0, 0, 1, {0x8A, 0, 0}, 0, 2,
      {OPT_Reg|OPS_8|OPA_Spare, OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x8B, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x8B, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x8B, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} },

    /* Segment register forms */
    { CPU_Any, 0, 0, 0, 0, 1, {0x8C, 0, 0}, 0, 2,
      {OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA,
       OPT_SegReg|OPS_16|OPS_Relaxed|OPA_Spare, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x8C, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_EA, OPT_SegReg|OPS_16|OPS_Relaxed|OPA_Spare, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x8C, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_EA, OPT_SegReg|OPS_16|OPS_Relaxed|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x8C, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_EA, OPT_SegReg|OPS_16|OPS_Relaxed|OPA_Spare, 0} },

    { CPU_Any, 0, 0, 0, 0, 1, {0x8E, 0, 0}, 0, 2,
      {OPT_SegReg|OPS_16|OPS_Relaxed|OPA_Spare,
       OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, 0, 0, 0, 0, 1, {0x8E, 0, 0}, 0, 2,
      {OPT_SegReg|OPS_16|OPS_Relaxed|OPA_Spare, OPT_Reg|OPS_32|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 0, 0, 0, 1, {0x8E, 0, 0}, 0, 2,
      {OPT_SegReg|OPS_16|OPS_Relaxed|OPA_Spare, OPT_Reg|OPS_64|OPA_EA, 0} },

    /* Immediate forms */
    { CPU_Any, 0, 0, 0, 0, 1, {0xB0, 0, 0}, 0, 2,
      {OPT_Reg|OPS_8|OPA_Op0Add, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xB8, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Op0Add, OPT_Imm|OPS_16|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xB8, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Op0Add, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xB8, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Op0Add, OPT_Imm|OPS_64|OPS_Relaxed|OPA_Imm, 0} },
    /* Need two sets here, one for strictness on left side, one for right. */
    { CPU_Any, 0, 0, 0, 0, 1, {0xC6, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_8|OPA_Imm, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xC7, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_16|OPA_Imm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xC7, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_32|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xC7, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_32|OPA_Imm, 0} },
    { CPU_Any, 0, 0, 0, 0, 1, {0xC6, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xC7, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPA_EA, OPT_Imm|OPS_16|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xC7, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPA_EA, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xC7, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPA_EA, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },

    /* CR/DR forms */
    { CPU_586|CPU_Priv|CPU_Not64, 0, 0, 0, 0, 2, {0x0F, 0x22, 0}, 0, 2,
      {OPT_CR4|OPS_32|OPA_Spare, OPT_Reg|OPS_32|OPA_EA, 0} },
    { CPU_386|CPU_Priv|CPU_Not64, 0, 0, 0, 0, 2, {0x0F, 0x22, 0}, 0, 2,
      {OPT_CRReg|OPS_32|OPA_Spare, OPT_Reg|OPS_32|OPA_EA, 0} },
    { CPU_Hammer|CPU_Priv|CPU_64, 0, 0, 0, 0, 2, {0x0F, 0x22, 0}, 0, 2,
      {OPT_CRReg|OPS_32|OPA_Spare, OPT_Reg|OPS_64|OPA_EA, 0} },
    { CPU_586|CPU_Priv|CPU_Not64, 0, 0, 0, 0, 2, {0x0F, 0x20, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_EA, OPT_CR4|OPS_32|OPA_Spare, 0} },
    { CPU_386|CPU_Priv|CPU_Not64, 0, 0, 0, 0, 2, {0x0F, 0x20, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_EA, OPT_CRReg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_Priv|CPU_64, 0, 0, 0, 0, 2, {0x0F, 0x20, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_EA, OPT_CRReg|OPS_32|OPA_Spare, 0} },

    { CPU_386|CPU_Priv|CPU_Not64, 0, 0, 0, 0, 2, {0x0F, 0x23, 0}, 0, 2,
      {OPT_DRReg|OPS_32|OPA_Spare, OPT_Reg|OPS_32|OPA_EA, 0} },
    { CPU_Hammer|CPU_Priv|CPU_64, 0, 0, 0, 0, 2, {0x0F, 0x23, 0}, 0, 2,
      {OPT_DRReg|OPS_32|OPA_Spare, OPT_Reg|OPS_64|OPA_EA, 0} },
    { CPU_386|CPU_Priv|CPU_Not64, 0, 0, 0, 0, 2, {0x0F, 0x21, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_EA, OPT_DRReg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_Priv|CPU_64, 0, 0, 0, 0, 2, {0x0F, 0x21, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_EA, OPT_DRReg|OPS_32|OPA_Spare, 0} }
};

/* Move with sign/zero extend */
static const x86_insn_info movszx_insn[] = {
    { CPU_386, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_8|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_8|OPA_EA, 0} },
    { CPU_386, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 1, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_16|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 1, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_16|OPA_EA, 0} }
};

/* Move with sign-extend doubleword (64-bit mode only) */
static const x86_insn_info movsxd_insn[] = {
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x63, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_32|OPA_EA, 0} }
};

/* Push instructions */
static const x86_insn_info push_insn[] = {
    { CPU_Any, 0, 16, 64, 0, 1, {0x50, 0, 0}, 0, 1,
      {OPT_Reg|OPS_16|OPA_Op0Add, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0x50, 0, 0}, 0, 1,
      {OPT_Reg|OPS_32|OPA_Op0Add, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 0, 64, 0, 1, {0x50, 0, 0}, 0, 1,
      {OPT_Reg|OPS_64|OPA_Op0Add, 0, 0} },
    { CPU_Any, 0, 16, 64, 0, 1, {0xFF, 0, 0}, 6, 1,
      {OPT_RM|OPS_16|OPA_EA, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xFF, 0, 0}, 6, 1,
      {OPT_RM|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 0, 64, 0, 1, {0xFF, 0, 0}, 6, 1,
      {OPT_RM|OPS_64|OPA_EA, 0, 0} },
    { CPU_Any, 0, 0, 64, 0, 1, {0x6A, 0, 0}, 0, 1,
      {OPT_Imm|OPS_8|OPA_SImm, 0, 0} },
    { CPU_Any, 0, 16, 64, 0, 1, {0x68, 0, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPA_Imm, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0x68, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_Imm, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0x68, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_SImm, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0x0E, 0, 0}, 0, 1,
      {OPT_CS|OPS_Any|OPA_None, 0, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0x0E, 0, 0}, 0, 1,
      {OPT_CS|OPS_16|OPA_None, 0, 0} },
    { CPU_Not64, 0, 32, 0, 0, 1, {0x0E, 0, 0}, 0, 1,
      {OPT_CS|OPS_32|OPA_None, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0x16, 0, 0}, 0, 1,
      {OPT_SS|OPS_Any|OPA_None, 0, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0x16, 0, 0}, 0, 1,
      {OPT_SS|OPS_16|OPA_None, 0, 0} },
    { CPU_Not64, 0, 32, 0, 0, 1, {0x16, 0, 0}, 0, 1,
      {OPT_SS|OPS_32|OPA_None, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0x1E, 0, 0}, 0, 1,
      {OPT_DS|OPS_Any|OPA_None, 0, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0x1E, 0, 0}, 0, 1,
      {OPT_DS|OPS_16|OPA_None, 0, 0} },
    { CPU_Not64, 0, 32, 0, 0, 1, {0x1E, 0, 0}, 0, 1,
      {OPT_DS|OPS_32|OPA_None, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0x06, 0, 0}, 0, 1,
      {OPT_ES|OPS_Any|OPA_None, 0, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0x06, 0, 0}, 0, 1,
      {OPT_ES|OPS_16|OPA_None, 0, 0} },
    { CPU_Not64, 0, 32, 0, 0, 1, {0x06, 0, 0}, 0, 1,
      {OPT_ES|OPS_32|OPA_None, 0, 0} },
    { CPU_386, 0, 0, 0, 0, 2, {0x0F, 0xA0, 0}, 0, 1,
      {OPT_FS|OPS_Any|OPA_None, 0, 0} },
    { CPU_386, 0, 16, 0, 0, 2, {0x0F, 0xA0, 0}, 0, 1,
      {OPT_FS|OPS_16|OPA_None, 0, 0} },
    { CPU_386, 0, 32, 0, 0, 2, {0x0F, 0xA0, 0}, 0, 1,
      {OPT_FS|OPS_32|OPA_None, 0, 0} },
    { CPU_386, 0, 0, 0, 0, 2, {0x0F, 0xA8, 0}, 0, 1,
      {OPT_GS|OPS_Any|OPA_None, 0, 0} },
    { CPU_386, 0, 16, 0, 0, 2, {0x0F, 0xA8, 0}, 0, 1,
      {OPT_GS|OPS_16|OPA_None, 0, 0} },
    { CPU_386, 0, 32, 0, 0, 2, {0x0F, 0xA8, 0}, 0, 1,
      {OPT_GS|OPS_32|OPA_None, 0, 0} }
};

/* Pop instructions */
static const x86_insn_info pop_insn[] = {
    { CPU_Any, 0, 16, 64, 0, 1, {0x58, 0, 0}, 0, 1,
      {OPT_Reg|OPS_16|OPA_Op0Add, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0x58, 0, 0}, 0, 1,
      {OPT_Reg|OPS_32|OPA_Op0Add, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 0, 64, 0, 1, {0x58, 0, 0}, 0, 1,
      {OPT_Reg|OPS_64|OPA_Op0Add, 0, 0} },
    { CPU_Any, 0, 16, 64, 0, 1, {0x8F, 0, 0}, 0, 1,
      {OPT_RM|OPS_16|OPA_EA, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0x8F, 0, 0}, 0, 1,
      {OPT_RM|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 0, 64, 0, 1, {0x8F, 0, 0}, 0, 1,
      {OPT_RM|OPS_64|OPA_EA, 0, 0} },
    /* POP CS is debateably valid on the 8086, if obsolete and undocumented.
     * We don't include it because it's VERY unlikely it will ever be used
     * anywhere.  If someone really wants it they can db 0x0F it.
     */
    /*{ CPU_Any|CPU_Undoc|CPU_Obs, 0, 0, 1, {0x0F, 0, 0}, 0, 1,
        {OPT_CS|OPS_Any|OPA_None, 0, 0} },*/
    { CPU_Not64, 0, 0, 0, 0, 1, {0x17, 0, 0}, 0, 1,
      {OPT_SS|OPS_Any|OPA_None, 0, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0x17, 0, 0}, 0, 1,
      {OPT_SS|OPS_16|OPA_None, 0, 0} },
    { CPU_Not64, 0, 32, 0, 0, 1, {0x17, 0, 0}, 0, 1,
      {OPT_SS|OPS_32|OPA_None, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0x1F, 0, 0}, 0, 1,
      {OPT_DS|OPS_Any|OPA_None, 0, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0x1F, 0, 0}, 0, 1,
      {OPT_DS|OPS_16|OPA_None, 0, 0} },
    { CPU_Not64, 0, 32, 0, 0, 1, {0x1F, 0, 0}, 0, 1,
      {OPT_DS|OPS_32|OPA_None, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0x07, 0, 0}, 0, 1,
      {OPT_ES|OPS_Any|OPA_None, 0, 0} },
    { CPU_Not64, 0, 16, 0, 0, 1, {0x07, 0, 0}, 0, 1,
      {OPT_ES|OPS_16|OPA_None, 0, 0} },
    { CPU_Not64, 0, 32, 0, 0, 1, {0x07, 0, 0}, 0, 1,
      {OPT_ES|OPS_32|OPA_None, 0, 0} },
    { CPU_386, 0, 0, 0, 0, 2, {0x0F, 0xA1, 0}, 0, 1,
      {OPT_FS|OPS_Any|OPA_None, 0, 0} },
    { CPU_386, 0, 16, 0, 0, 2, {0x0F, 0xA1, 0}, 0, 1,
      {OPT_FS|OPS_16|OPA_None, 0, 0} },
    { CPU_386, 0, 32, 0, 0, 2, {0x0F, 0xA1, 0}, 0, 1,
      {OPT_FS|OPS_32|OPA_None, 0, 0} },
    { CPU_386, 0, 0, 0, 0, 2, {0x0F, 0xA9, 0}, 0, 1,
      {OPT_GS|OPS_Any|OPA_None, 0, 0} },
    { CPU_386, 0, 16, 0, 0, 2, {0x0F, 0xA9, 0}, 0, 1,
      {OPT_GS|OPS_16|OPA_None, 0, 0} },
    { CPU_386, 0, 32, 0, 0, 2, {0x0F, 0xA9, 0}, 0, 1,
      {OPT_GS|OPS_32|OPA_None, 0, 0} }
};

/* Exchange instructions */
static const x86_insn_info xchg_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 1, {0x86, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_8|OPA_Spare, 0} },
    { CPU_Any, 0, 0, 0, 0, 1, {0x86, 0, 0}, 0, 2,
      {OPT_Reg|OPS_8|OPA_Spare, OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x90, 0, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_None, OPT_Reg|OPS_16|OPA_Op0Add, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x90, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Op0Add, OPT_Areg|OPS_16|OPA_None, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x87, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x87, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x90, 0, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_None, OPT_Reg|OPS_32|OPA_Op0Add, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x90, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Op0Add, OPT_Areg|OPS_32|OPA_None, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x87, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x87, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x90, 0, 0}, 0, 2,
      {OPT_Areg|OPS_64|OPA_None, OPT_Reg|OPS_64|OPA_Op0Add, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x90, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Op0Add, OPT_Areg|OPS_64|OPA_None, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x87, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x87, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};

/* In/out from ports */
static const x86_insn_info in_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 1, {0xE4, 0, 0}, 0, 2,
      {OPT_Areg|OPS_8|OPA_None, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xE5, 0, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_None, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xE5, 0, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_None, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, 0, 0, 0, 0, 1, {0xEC, 0, 0}, 0, 2,
      {OPT_Areg|OPS_8|OPA_None, OPT_Dreg|OPS_16|OPA_None, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xED, 0, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_None, OPT_Dreg|OPS_16|OPA_None, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xED, 0, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_None, OPT_Dreg|OPS_16|OPA_None, 0} }
};
static const x86_insn_info out_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 1, {0xE6, 0, 0}, 0, 2,
      {OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, OPT_Areg|OPS_8|OPA_None, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xE7, 0, 0}, 0, 2,
      {OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, OPT_Areg|OPS_16|OPA_None, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xE7, 0, 0}, 0, 2,
      {OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, OPT_Areg|OPS_32|OPA_None, 0} },
    { CPU_Any, 0, 0, 0, 0, 1, {0xEE, 0, 0}, 0, 2,
      {OPT_Dreg|OPS_16|OPA_None, OPT_Areg|OPS_8|OPA_None, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xEF, 0, 0}, 0, 2,
      {OPT_Dreg|OPS_16|OPA_None, OPT_Areg|OPS_16|OPA_None, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xEF, 0, 0}, 0, 2,
      {OPT_Dreg|OPS_16|OPA_None, OPT_Areg|OPS_32|OPA_None, 0} }
};

/* Load effective address */
static const x86_insn_info lea_insn[] = {
    { CPU_Any, 0, 16, 0, 0, 1, {0x8D, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x8D, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x8D, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};

/* Load segment registers from memory */
static const x86_insn_info ldes_insn[] = {
    { CPU_Not64, MOD_Op0Add, 16, 0, 0, 1, {0, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_Mem|OPS_Any|OPA_EA, 0} },
    { CPU_386|CPU_Not64, MOD_Op0Add, 32, 0, 0, 1, {0, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_Mem|OPS_Any|OPA_EA, 0} }
};
static const x86_insn_info lfgss_insn[] = {
    { CPU_386, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_Mem|OPS_Any|OPA_EA, 0} },
    { CPU_386, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_Mem|OPS_Any|OPA_EA, 0} }
};

/* Arithmetic - general */
static const x86_insn_info arith_insn[] = {
    { CPU_Any, MOD_Op0Add, 0, 0, 0, 1, {0x04, 0, 0}, 0, 2,
      {OPT_Areg|OPS_8|OPA_None, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, MOD_Op0Add, 16, 0, 0, 1, {0x05, 0, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_None, OPT_Imm|OPS_16|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_386, MOD_Op0Add, 32, 0, 0, 1, {0x05, 0, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_None, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, MOD_Op0Add, 64, 0, 0, 1, {0x05, 0, 0}, 0, 2,
      {OPT_Areg|OPS_64|OPA_None, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },

    { CPU_Any, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0x80, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0x80, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_8|OPA_Imm, 0} },
    { CPU_Any, MOD_Gap0|MOD_SpAdd, 16, 0, 0, 1, {0x83, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPA_EA, OPT_Imm|OPS_8|OPA_SImm, 0} },
    { CPU_Any, MOD_Gap0|MOD_SpAdd, 16, 0, 0, 1, {0x81, 0x83, 0}, 0, 2,
      {OPT_RM|OPS_16|OPA_EA,
       OPT_Imm|OPS_16|OPS_Relaxed|OPA_Imm|OPAP_SImm8Avail, 0} },
    { CPU_Any, MOD_Gap0|MOD_SpAdd, 16, 0, 0, 1, {0x81, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_16|OPA_Imm, 0} },
    { CPU_386, MOD_Gap0|MOD_SpAdd, 32, 0, 0, 1, {0x83, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPA_EA, OPT_Imm|OPS_8|OPA_SImm, 0} },
    { CPU_386, MOD_Gap0|MOD_SpAdd, 32, 0, 0, 1, {0x81, 0x83, 0}, 0, 2,
      {OPT_RM|OPS_32|OPA_EA,
       OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm|OPAP_SImm8Avail, 0} },
    { CPU_386, MOD_Gap0|MOD_SpAdd, 32, 0, 0, 1, {0x81, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_32|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, MOD_Gap0|MOD_SpAdd, 64, 0, 0, 1, {0x83, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPA_EA, OPT_Imm|OPS_8|OPA_SImm, 0} },
    { CPU_Hammer|CPU_64, MOD_Gap0|MOD_SpAdd, 64, 0, 0, 1, {0x81, 0x83, 0},
      0, 2, {OPT_RM|OPS_64|OPA_EA,
       	     OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm|OPAP_SImm8Avail, 0} },
    { CPU_Hammer|CPU_64, MOD_Gap0|MOD_SpAdd, 64, 0, 0, 1, {0x81, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_32|OPA_Imm, 0} },

    { CPU_Any, MOD_Op0Add, 0, 0, 0, 1, {0x00, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_8|OPA_Spare, 0} },
    { CPU_Any, MOD_Op0Add, 16, 0, 0, 1, {0x01, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_386, MOD_Op0Add, 32, 0, 0, 1, {0x01, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, MOD_Op0Add, 64, 0, 0, 1, {0x01, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare, 0} },
    { CPU_Any, MOD_Op0Add, 0, 0, 0, 1, {0x02, 0, 0}, 0, 2,
      {OPT_Reg|OPS_8|OPA_Spare, OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Any, MOD_Op0Add, 16, 0, 0, 1, {0x03, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, MOD_Op0Add, 32, 0, 0, 1, {0x03, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, MOD_Op0Add, 64, 0, 0, 1, {0x03, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};

/* Arithmetic - inc/dec */
static const x86_insn_info incdec_insn[] = {
    { CPU_Any, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0xFE, 0, 0}, 0, 1,
      {OPT_RM|OPS_8|OPA_EA, 0, 0} },
    { CPU_Not64, MOD_Op0Add, 16, 0, 0, 1, {0, 0, 0}, 0, 1,
      {OPT_Reg|OPS_16|OPA_Op0Add, 0, 0} },
    { CPU_Any, MOD_Gap0|MOD_SpAdd, 16, 0, 0, 1, {0xFF, 0, 0}, 0, 1,
      {OPT_RM|OPS_16|OPA_EA, 0, 0} },
    { CPU_386|CPU_Not64, MOD_Op0Add, 32, 0, 0, 1, {0, 0, 0}, 0, 1,
      {OPT_Reg|OPS_32|OPA_Op0Add, 0, 0} },
    { CPU_386, MOD_Gap0|MOD_SpAdd, 32, 0, 0, 1, {0xFF, 0, 0}, 0, 1,
      {OPT_RM|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, MOD_Gap0|MOD_SpAdd, 64, 0, 0, 1, {0xFF, 0, 0}, 0, 1,
      {OPT_RM|OPS_64|OPA_EA, 0, 0} },
};

/* Arithmetic - "F6" opcodes (div/idiv/mul/neg/not) */
static const x86_insn_info f6_insn[] = {
    { CPU_Any, MOD_SpAdd, 0, 0, 0, 1, {0xF6, 0, 0}, 0, 1,
      {OPT_RM|OPS_8|OPA_EA, 0, 0} },
    { CPU_Any, MOD_SpAdd, 16, 0, 0, 1, {0xF7, 0, 0}, 0, 1,
      {OPT_RM|OPS_16|OPA_EA, 0, 0} },
    { CPU_386, MOD_SpAdd, 32, 0, 0, 1, {0xF7, 0, 0}, 0, 1,
      {OPT_RM|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, MOD_SpAdd, 64, 0, 0, 1, {0xF7, 0, 0}, 0, 1,
      {OPT_RM|OPS_64|OPA_EA, 0, 0} },
};

/* Arithmetic - test instruction */
static const x86_insn_info test_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 1, {0xA8, 0, 0}, 0, 2,
      {OPT_Areg|OPS_8|OPA_None, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xA9, 0, 0}, 0, 2,
      {OPT_Areg|OPS_16|OPA_None, OPT_Imm|OPS_16|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xA9, 0, 0}, 0, 2,
      {OPT_Areg|OPS_32|OPA_None, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xA9, 0, 0}, 0, 2,
      {OPT_Areg|OPS_64|OPA_None, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },

    { CPU_Any, 0, 0, 0, 0, 1, {0xF6, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, 0, 0, 0, 0, 1, {0xF6, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_8|OPA_Imm, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xF7, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPA_EA, OPT_Imm|OPS_16|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xF7, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_16|OPA_Imm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xF7, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPA_EA, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xF7, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_32|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xF7, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPA_EA, OPT_Imm|OPS_32|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xF7, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_32|OPA_Imm, 0} },

    { CPU_Any, 0, 0, 0, 0, 1, {0x84, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_8|OPA_Spare, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x85, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x85, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x85, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare, 0} },

    { CPU_Any, 0, 0, 0, 0, 1, {0x84, 0, 0}, 0, 2,
      {OPT_Reg|OPS_8|OPA_Spare, OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0x85, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x85, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x85, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};

/* Arithmetic - aad/aam */
static const x86_insn_info aadm_insn[] = {
    { CPU_Any, MOD_Op0Add, 0, 0, 0, 2, {0xD4, 0x0A, 0}, 0, 0, {0, 0, 0} },
    { CPU_Any, MOD_Op0Add, 0, 0, 0, 1, {0xD4, 0, 0}, 0, 1,
      {OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0, 0} }
};

/* Arithmetic - imul */
static const x86_insn_info imul_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 1, {0xF6, 0, 0}, 5, 1,
      {OPT_RM|OPS_8|OPA_EA, 0, 0} },
    { CPU_Any, 0, 16, 0, 0, 1, {0xF7, 0, 0}, 5, 1,
      {OPT_RM|OPS_16|OPA_EA, 0, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xF7, 0, 0}, 5, 1,
      {OPT_RM|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0xF7, 0, 0}, 5, 1,
      {OPT_RM|OPS_64|OPA_EA, 0, 0} },

    { CPU_386, 0, 16, 0, 0, 2, {0x0F, 0xAF, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, 0, 32, 0, 0, 2, {0x0F, 0xAF, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 2, {0x0F, 0xAF, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} },

    { CPU_186, 0, 16, 0, 0, 1, {0x6B, 0, 0}, 0, 3,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPA_SImm} },
    { CPU_386, 0, 32, 0, 0, 1, {0x6B, 0, 0}, 0, 3,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPA_SImm} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x6B, 0, 0}, 0, 3,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPA_SImm} },

    { CPU_186, 0, 16, 0, 0, 1, {0x6B, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_SpareEA, OPT_Imm|OPS_8|OPA_SImm, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x6B, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_SpareEA, OPT_Imm|OPS_8|OPA_SImm, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x6B, 0, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_SpareEA, OPT_Imm|OPS_8|OPA_SImm, 0} },

    { CPU_186, 0, 16, 0, 0, 1, {0x69, 0x6B, 0}, 0, 3,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_16|OPS_Relaxed|OPA_SImm|OPAP_SImm8Avail} },
    { CPU_386, 0, 32, 0, 0, 1, {0x69, 0x6B, 0}, 0, 3,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_32|OPS_Relaxed|OPA_SImm|OPAP_SImm8Avail} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x69, 0x6B, 0}, 0, 3,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_32|OPS_Relaxed|OPA_SImm|OPAP_SImm8Avail} },

    { CPU_186, 0, 16, 0, 0, 1, {0x69, 0x6B, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_SpareEA,
       OPT_Imm|OPS_16|OPS_Relaxed|OPA_SImm|OPAP_SImm8Avail, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x69, 0x6B, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_SpareEA,
       OPT_Imm|OPS_32|OPS_Relaxed|OPA_SImm|OPAP_SImm8Avail, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0x69, 0x6B, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_SpareEA,
       OPT_Imm|OPS_32|OPS_Relaxed|OPA_SImm|OPAP_SImm8Avail, 0} }
};

/* Shifts - standard */
static const x86_insn_info shift_insn[] = {
    { CPU_Any, MOD_SpAdd, 0, 0, 0, 1, {0xD2, 0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPA_EA, OPT_Creg|OPS_8|OPA_None, 0} },
    /* FIXME: imm8 is only avail on 186+, but we use imm8 to get to postponed
     * ,1 form, so it has to be marked as Any.  We need to store the active
     * CPU flags somewhere to pass that parse-time info down the line.
     */
    { CPU_Any, MOD_SpAdd, 0, 0, 0, 1, {0xC0, 0xD0, 0}, 0, 2,
      {OPT_RM|OPS_8|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm|OPAP_ShiftOp,
       0} },
    { CPU_Any, MOD_SpAdd, 16, 0, 0, 1, {0xD3, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPA_EA, OPT_Creg|OPS_8|OPA_None, 0} },
    { CPU_Any, MOD_SpAdd, 16, 0, 0, 1, {0xC1, 0xD1, 0}, 0, 2,
      {OPT_RM|OPS_16|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm|OPAP_ShiftOp,
       0} },
    { CPU_Any, MOD_SpAdd, 32, 0, 0, 1, {0xD3, 0, 0}, 0, 2,
      {OPT_RM|OPS_32|OPA_EA, OPT_Creg|OPS_8|OPA_None, 0} },
    { CPU_Any, MOD_SpAdd, 32, 0, 0, 1, {0xC1, 0xD1, 0}, 0, 2,
      {OPT_RM|OPS_32|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm|OPAP_ShiftOp,
       0} },
    { CPU_Hammer|CPU_64, MOD_SpAdd, 64, 0, 0, 1, {0xD3, 0, 0}, 0, 2,
      {OPT_RM|OPS_64|OPA_EA, OPT_Creg|OPS_8|OPA_None, 0} },
    { CPU_Hammer|CPU_64, MOD_SpAdd, 64, 0, 0, 1, {0xC1, 0xD1, 0}, 0, 2,
      {OPT_RM|OPS_64|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm|OPAP_ShiftOp,
       0} }
};

/* Shifts - doubleword */
static const x86_insn_info shlrd_insn[] = {
    { CPU_386, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0x00, 0}, 0, 3,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} },
    { CPU_386, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0x01, 0}, 0, 3,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare,
       OPT_Creg|OPS_8|OPA_None} },
    { CPU_386, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x00, 0}, 0, 3,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} },
    { CPU_386, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x01, 0}, 0, 3,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare,
       OPT_Creg|OPS_8|OPA_None} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 0x00, 0}, 0, 3,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 0x01, 0}, 0, 3,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare,
       OPT_Creg|OPS_8|OPA_None} }
};

/* Control transfer instructions (unconditional) */
static const x86_insn_info call_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPA_JmpRel, 0, 0} },
    { CPU_Any, 0, 16, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPA_JmpRel, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_JmpRel, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_JmpRel, 0, 0} },

    { CPU_Any, 0, 16, 64, 0, 1, {0xE8, 0x9A, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPTM_Near|OPA_JmpRel|OPAP_JmpFar, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xE8, 0x9A, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPTM_Near|OPA_JmpRel|OPAP_JmpFar, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0xE8, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPTM_Near|OPA_JmpRel, 0, 0} },
    { CPU_Any, 0, 0, 64, 0, 1, {0xE8, 0x9A, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPTM_Near|OPA_JmpRel|OPAP_JmpFar, 0, 0} },

    { CPU_Any, 0, 16, 0, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_RM|OPS_16|OPA_EA, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_RM|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_RM|OPS_64|OPA_EA, 0, 0} },
    { CPU_Any, 0, 0, 64, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_Mem|OPS_Any|OPA_EA, 0, 0} },
    { CPU_Any, 0, 16, 64, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_RM|OPS_16|OPTM_Near|OPA_EA, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_RM|OPS_32|OPTM_Near|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_RM|OPS_64|OPTM_Near|OPA_EA, 0, 0} },
    { CPU_Any, 0, 0, 64, 0, 1, {0xFF, 0, 0}, 2, 1,
      {OPT_Mem|OPS_Any|OPTM_Near|OPA_EA, 0, 0} },

    { CPU_Not64, 0, 16, 0, 0, 1, {0x9A, 0, 0}, 3, 1,
      {OPT_Imm|OPS_16|OPTM_Far|OPA_JmpRel, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0x9A, 0, 0}, 3, 1,
      {OPT_Imm|OPS_32|OPTM_Far|OPA_JmpRel, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0x9A, 0, 0}, 3, 1,
      {OPT_Imm|OPS_Any|OPTM_Far|OPA_JmpRel, 0, 0} },

    { CPU_Any, 0, 16, 0, 0, 1, {0xFF, 0, 0}, 3, 1,
      {OPT_Mem|OPS_16|OPTM_Far|OPA_EA, 0, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xFF, 0, 0}, 3, 1,
      {OPT_Mem|OPS_32|OPTM_Far|OPA_EA, 0, 0} },
    { CPU_Any, 0, 0, 0, 0, 1, {0xFF, 0, 0}, 3, 1,
      {OPT_Mem|OPS_Any|OPTM_Far|OPA_EA, 0, 0} }
};
static const x86_insn_info jmp_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPA_JmpRel, 0, 0} },
    { CPU_Any, 0, 16, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPA_JmpRel, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_JmpRel, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 1, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_JmpRel, 0, 0} },

    { CPU_Any, 0, 0, 64, 0, 1, {0xEB, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPTM_Short|OPA_JmpRel, 0, 0} },
    { CPU_Any, 0, 16, 64, 0, 1, {0xE9, 0xEA, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPTM_Near|OPA_JmpRel|OPAP_JmpFar, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xE9, 0xEA, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPTM_Near|OPA_JmpRel|OPAP_JmpFar, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0xE9, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPTM_Near|OPA_JmpRel, 0, 0} },
    { CPU_Any, 0, 0, 64, 0, 1, {0xE9, 0xEA, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPTM_Near|OPA_JmpRel|OPAP_JmpFar, 0, 0} },

    { CPU_Any, 0, 16, 64, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_RM|OPS_16|OPA_EA, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_RM|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_RM|OPS_64|OPA_EA, 0, 0} },
    { CPU_Any, 0, 0, 64, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_Mem|OPS_Any|OPA_EA, 0, 0} },
    { CPU_Any, 0, 16, 64, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_RM|OPS_16|OPTM_Near|OPA_EA, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_RM|OPS_32|OPTM_Near|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_RM|OPS_64|OPTM_Near|OPA_EA, 0, 0} },
    { CPU_Any, 0, 0, 64, 0, 1, {0xFF, 0, 0}, 4, 1,
      {OPT_Mem|OPS_Any|OPTM_Near|OPA_EA, 0, 0} },

    { CPU_Not64, 0, 16, 0, 0, 1, {0xEA, 0, 0}, 3, 1,
      {OPT_Imm|OPS_16|OPTM_Far|OPA_JmpRel, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 1, {0xEA, 0, 0}, 3, 1,
      {OPT_Imm|OPS_32|OPTM_Far|OPA_JmpRel, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 1, {0xEA, 0, 0}, 3, 1,
      {OPT_Imm|OPS_Any|OPTM_Far|OPA_JmpRel, 0, 0} },

    { CPU_Any, 0, 16, 0, 0, 1, {0xFF, 0, 0}, 5, 1,
      {OPT_Mem|OPS_16|OPTM_Far|OPA_EA, 0, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0xFF, 0, 0}, 5, 1,
      {OPT_Mem|OPS_32|OPTM_Far|OPA_EA, 0, 0} },
    { CPU_Any, 0, 0, 0, 0, 1, {0xFF, 0, 0}, 5, 1,
      {OPT_Mem|OPS_Any|OPTM_Far|OPA_EA, 0, 0} }
};
static const x86_insn_info retnf_insn[] = {
    { CPU_Any, MOD_Op0Add, 0, 0, 0, 1, {0x01, 0, 0}, 0, 0, {0, 0, 0} },
    { CPU_Any, MOD_Op0Add, 0, 0, 0, 1, {0x00, 0, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPS_Relaxed|OPA_Imm, 0, 0} }
};
static const x86_insn_info enter_insn[] = {
    { CPU_186|CPU_Not64, 0, 0, 0, 0, 1, {0xC8, 0, 0}, 0, 2,
      {OPT_Imm|OPS_16|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm,
       0} },
    { CPU_Hammer|CPU_64, 0, 64, 64, 0, 1, {0xC8, 0, 0}, 0, 2,
      {OPT_Imm|OPS_16|OPS_Relaxed|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm,
       0} }
};

/* Conditional jumps */
static const x86_insn_info jcc_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPA_JmpRel, 0, 0} },
    { CPU_Any, 0, 16, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPA_JmpRel, 0, 0} },
    { CPU_386|CPU_Not64, 0, 32, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_JmpRel, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPA_JmpRel, 0, 0} },

    { CPU_Any, MOD_Op0Add, 0, 64, 0, 1, {0x70, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPTM_Short|OPA_JmpRel, 0, 0} },
    { CPU_386, MOD_Op1Add, 16, 64, 0, 2, {0x0F, 0x80, 0}, 0, 1,
      {OPT_Imm|OPS_16|OPTM_Near|OPA_JmpRel, 0, 0} },
    { CPU_386|CPU_Not64, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x80, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPTM_Near|OPA_JmpRel, 0, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 64, 0, 2, {0x0F, 0x80, 0}, 0, 1,
      {OPT_Imm|OPS_32|OPTM_Near|OPA_JmpRel, 0, 0} },
    { CPU_386, MOD_Op1Add, 0, 64, 0, 2, {0x0F, 0x80, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPTM_Near|OPA_JmpRel, 0, 0} }
};
static const x86_insn_info jcxz_insn[] = {
    { CPU_Any, MOD_AdSizeR, 0, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPA_JmpRel, 0, 0} },
    { CPU_Any, MOD_AdSizeR, 0, 64, 0, 1, {0xE3, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPTM_Short|OPA_JmpRel, 0, 0} }
};

/* Loop instructions */
static const x86_insn_info loop_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPA_JmpRel, 0, 0} },
    { CPU_Not64, 0, 0, 0, 0, 0, {0, 0, 0}, 0, 2,
      {OPT_Imm|OPS_Any|OPA_JmpRel, OPT_Creg|OPS_16|OPA_AdSizeR, 0} },
    { CPU_386, 0, 0, 64, 0, 0, {0, 0, 0}, 0, 2,
      {OPT_Imm|OPS_Any|OPA_JmpRel, OPT_Creg|OPS_32|OPA_AdSizeR, 0} },
    { CPU_Hammer|CPU_64, 0, 0, 64, 0, 0, {0, 0, 0}, 0, 2,
      {OPT_Imm|OPS_Any|OPA_JmpRel, OPT_Creg|OPS_64|OPA_AdSizeR, 0} },

    { CPU_Not64, MOD_Op0Add, 0, 0, 0, 1, {0xE0, 0, 0}, 0, 1,
      {OPT_Imm|OPS_Any|OPTM_Short|OPA_JmpRel, 0, 0} },
    { CPU_Any, MOD_Op0Add, 0, 64, 0, 1, {0xE0, 0, 0}, 0, 2,
      {OPT_Imm|OPS_Any|OPTM_Short|OPA_JmpRel, OPT_Creg|OPS_16|OPA_AdSizeR, 0}
    },
    { CPU_386, MOD_Op0Add, 0, 64, 0, 1, {0xE0, 0, 0}, 0, 2,
      {OPT_Imm|OPS_Any|OPTM_Short|OPA_JmpRel, OPT_Creg|OPS_32|OPA_AdSizeR, 0}
    },
    { CPU_Hammer|CPU_64, MOD_Op0Add, 0, 64, 0, 1, {0xE0, 0, 0}, 0, 2,
      {OPT_Imm|OPS_Any|OPTM_Short|OPA_JmpRel, OPT_Creg|OPS_64|OPA_AdSizeR, 0} }
};

/* Set byte on flag instructions */
static const x86_insn_info setcc_insn[] = {
    { CPU_386, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x90, 0}, 2, 1,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, 0, 0} }
};

/* Bit manipulation - bit tests */
static const x86_insn_info bittest_insn[] = {
    { CPU_386, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_386, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare, 0} },
    { CPU_386, MOD_Gap0|MOD_SpAdd, 16, 0, 0, 2, {0x0F, 0xBA, 0}, 0, 2,
      {OPT_RM|OPS_16|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_386, MOD_Gap0|MOD_SpAdd, 32, 0, 0, 2, {0x0F, 0xBA, 0}, 0, 2,
      {OPT_RM|OPS_32|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_Hammer|CPU_64, MOD_Gap0|MOD_SpAdd, 64, 0, 0, 2, {0x0F, 0xBA, 0},
      0, 2, {OPT_RM|OPS_64|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} }
};

/* Bit manipulation - bit scans - also used for lar/lsl */
static const x86_insn_info bsfr_insn[] = {
    { CPU_286, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};

/* Interrupts and operating system instructions */
static const x86_insn_info int_insn[] = {
    { CPU_Any, 0, 0, 0, 0, 1, {0xCD, 0, 0}, 0, 1,
      {OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0, 0} }
};
static const x86_insn_info bound_insn[] = {
    { CPU_186, 0, 16, 0, 0, 1, {0x62, 0, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386, 0, 32, 0, 0, 1, {0x62, 0, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0} }
};

/* Protection control */
static const x86_insn_info arpl_insn[] = {
    { CPU_286|CPU_Prot, 0, 0, 0, 0, 1, {0x63, 0, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} }
};
static const x86_insn_info str_insn[] = {
    { CPU_Hammer, 0, 16, 0, 0, 2, {0x0F, 0x00, 0}, 1, 1,
      {OPT_Reg|OPS_16|OPA_EA, 0, 0} },
    { CPU_Hammer, 0, 32, 0, 0, 2, {0x0F, 0x00, 0}, 1, 1,
      {OPT_Reg|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 2, {0x0F, 0x00, 0}, 1, 1,
      {OPT_Reg|OPS_64|OPA_EA, 0, 0} },
    { CPU_286, MOD_Op1Add|MOD_SpAdd, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 1,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0, 0} }
};
static const x86_insn_info prot286_insn[] = {
    { CPU_286, MOD_Op1Add|MOD_SpAdd, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 1,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0, 0} }
};
static const x86_insn_info sldtmsw_insn[] = {
    { CPU_286, MOD_Op1Add|MOD_SpAdd, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 1,
      {OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0, 0} },
    { CPU_386, MOD_Op1Add|MOD_SpAdd, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 1,
      {OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add|MOD_SpAdd, 0, 0, 0, 2, {0x0F, 0x00, 0},
      0, 1, {OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0, 0} },
    { CPU_286, MOD_Op1Add|MOD_SpAdd, 16, 0, 0, 2, {0x0F, 0x00, 0}, 0, 1,
      {OPT_Reg|OPS_16|OPA_EA, 0, 0} },
    { CPU_386, MOD_Op1Add|MOD_SpAdd, 32, 0, 0, 2, {0x0F, 0x00, 0}, 0, 1,
      {OPT_Reg|OPS_32|OPA_EA, 0, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add|MOD_SpAdd, 64, 0, 0, 2, {0x0F, 0x00, 0},
      0, 1, {OPT_Reg|OPS_64|OPA_EA, 0, 0} }
};

/* Floating point instructions - load/store with pop (integer and normal) */
static const x86_insn_info fldstp_insn[] = {
    { CPU_FPU, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0xD9, 0, 0}, 0, 1,
      {OPT_Mem|OPS_32|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0xDD, 0, 0}, 0, 1,
      {OPT_Mem|OPS_64|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Gap0|MOD_Gap1|MOD_SpAdd, 0, 0, 0, 1, {0xDB, 0, 0}, 0, 1,
      {OPT_Mem|OPS_80|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xD9, 0x00, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} }
};
static const x86_insn_info fildstp_insn[] = {
    { CPU_FPU, MOD_SpAdd, 0, 0, 0, 1, {0xDF, 0, 0}, 0, 1,
      {OPT_Mem|OPS_16|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_SpAdd, 0, 0, 0, 1, {0xDB, 0, 0}, 0, 1,
      {OPT_Mem|OPS_32|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0xDF, 0, 0}, 0, 1,
      {OPT_Mem|OPS_64|OPA_EA, 0, 0} }
};
static const x86_insn_info fbldstp_insn[] = {
    { CPU_FPU, MOD_SpAdd, 0, 0, 0, 1, {0xDF, 0, 0}, 0, 1,
      {OPT_Mem|OPS_80|OPS_Relaxed|OPA_EA, 0, 0} }
};
/* Floating point instructions - store (normal) */
static const x86_insn_info fst_insn[] = {
    { CPU_FPU, 0, 0, 0, 0, 1, {0xD9, 0, 0}, 2, 1, {OPT_Mem|OPS_32|OPA_EA, 0, 0} },
    { CPU_FPU, 0, 0, 0, 0, 1, {0xDD, 0, 0}, 2, 1, {OPT_Mem|OPS_64|OPA_EA, 0, 0} },
    { CPU_FPU, 0, 0, 0, 0, 2, {0xDD, 0xD0, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} }
};
/* Floating point instructions - exchange (with ST0) */
static const x86_insn_info fxch_insn[] = {
    { CPU_FPU, 0, 0, 0, 0, 2, {0xD9, 0xC8, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} },
    { CPU_FPU, 0, 0, 0, 0, 2, {0xD9, 0xC8, 0}, 0, 2,
      {OPT_ST0|OPS_80|OPA_None, OPT_Reg|OPS_80|OPA_Op1Add, 0} },
    { CPU_FPU, 0, 0, 0, 0, 2, {0xD9, 0xC8, 0}, 0, 2,
      {OPT_Reg|OPS_80|OPA_Op1Add, OPT_ST0|OPS_80|OPA_None, 0} },
    { CPU_FPU, 0, 0, 0, 0, 2, {0xD9, 0xC9, 0}, 0, 0, {0, 0, 0} }
};
/* Floating point instructions - comparisons */
static const x86_insn_info fcom_insn[] = {
    { CPU_FPU, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0xD8, 0, 0}, 0, 1,
      {OPT_Mem|OPS_32|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Gap0|MOD_SpAdd, 0, 0, 0, 1, {0xDC, 0, 0}, 0, 1,
      {OPT_Mem|OPS_64|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xD8, 0x00, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} },
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xD8, 0x00, 0}, 0, 2,
      {OPT_ST0|OPS_80|OPA_None, OPT_Reg|OPS_80|OPA_Op1Add, 0} }
};
/* Floating point instructions - extended comparisons */
static const x86_insn_info fcom2_insn[] = {
    { CPU_286|CPU_FPU, MOD_Op0Add|MOD_Op1Add, 0, 0, 0, 2, {0x00, 0x00, 0},
      0, 1, {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} },
    { CPU_286|CPU_FPU, MOD_Op0Add|MOD_Op1Add, 0, 0, 0, 2, {0x00, 0x00, 0},
      0, 2, {OPT_ST0|OPS_80|OPA_None, OPT_Reg|OPS_80|OPA_Op1Add, 0} }
};
/* Floating point instructions - arithmetic */
static const x86_insn_info farith_insn[] = {
    { CPU_FPU, MOD_Gap0|MOD_Gap1|MOD_SpAdd, 0, 0, 0, 1, {0xD8, 0, 0}, 0, 1,
      {OPT_Mem|OPS_32|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Gap0|MOD_Gap1|MOD_SpAdd, 0, 0, 0, 1, {0xDC, 0, 0}, 0, 1,
      {OPT_Mem|OPS_64|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Gap0|MOD_Op1Add, 0, 0, 0, 2, {0xD8, 0x00, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} },
    { CPU_FPU, MOD_Gap0|MOD_Op1Add, 0, 0, 0, 2, {0xD8, 0x00, 0}, 0, 2,
      {OPT_ST0|OPS_80|OPA_None, OPT_Reg|OPS_80|OPA_Op1Add, 0} },
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xDC, 0x00, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPTM_To|OPA_Op1Add, 0, 0} },
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xDC, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_80|OPA_Op1Add, OPT_ST0|OPS_80|OPA_None, 0} }
};
static const x86_insn_info farithp_insn[] = {
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xDE, 0x01, 0}, 0, 0, {0, 0, 0} },
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xDE, 0x00, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} },
    { CPU_FPU, MOD_Op1Add, 0, 0, 0, 2, {0xDE, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_80|OPA_Op1Add, OPT_ST0|OPS_80|OPA_None, 0} }
};
/* Floating point instructions - integer arith/store wo pop/compare */
static const x86_insn_info fiarith_insn[] = {
    { CPU_FPU, MOD_Op0Add|MOD_SpAdd, 0, 0, 0, 1, {0x04, 0, 0}, 0, 1,
      {OPT_Mem|OPS_16|OPA_EA, 0, 0} },
    { CPU_FPU, MOD_Op0Add|MOD_SpAdd, 0, 0, 0, 1, {0x00, 0, 0}, 0, 1,
      {OPT_Mem|OPS_32|OPA_EA, 0, 0} }
};
/* Floating point instructions - processor control */
static const x86_insn_info fldnstcw_insn[] = {
    { CPU_FPU, MOD_SpAdd, 0, 0, 0, 1, {0xD9, 0, 0}, 0, 1,
      {OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0, 0} }
};
static const x86_insn_info fstcw_insn[] = {
    { CPU_FPU, 0, 0, 0, 0, 2, {0x9B, 0xD9, 0}, 7, 1,
      {OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0, 0} }
};
static const x86_insn_info fnstsw_insn[] = {
    { CPU_FPU, 0, 0, 0, 0, 1, {0xDD, 0, 0}, 7, 1,
      {OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0, 0} },
    { CPU_FPU, 0, 0, 0, 0, 2, {0xDF, 0xE0, 0}, 0, 1,
      {OPT_Areg|OPS_16|OPA_None, 0, 0} }
};
static const x86_insn_info fstsw_insn[] = {
    { CPU_FPU, 0, 0, 0, 0, 2, {0x9B, 0xDD, 0}, 7, 1,
      {OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0, 0} },
    { CPU_FPU, 0, 0, 0, 0, 3, {0x9B, 0xDF, 0xE0}, 0, 1,
      {OPT_Areg|OPS_16|OPA_None, 0, 0} }
};
static const x86_insn_info ffree_insn[] = {
    { CPU_FPU, MOD_Op0Add, 0, 0, 0, 2, {0x00, 0xC0, 0}, 0, 1,
      {OPT_Reg|OPS_80|OPA_Op1Add, 0, 0} }
};

/* 486 extensions */
static const x86_insn_info bswap_insn[] = {
    { CPU_486, 0, 32, 0, 0, 2, {0x0F, 0xC8, 0}, 0, 1,
      {OPT_Reg|OPS_32|OPA_Op1Add, 0, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 2, {0x0F, 0xC8, 0}, 0, 1,
      {OPT_Reg|OPS_64|OPA_Op1Add, 0, 0} }
};
static const x86_insn_info cmpxchgxadd_insn[] = {
    { CPU_486, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_8|OPA_Spare, 0} },
    { CPU_486, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0x01, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_486, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x01, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 0x01, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare, 0} }
};

/* Pentium extensions */
static const x86_insn_info cmpxchg8b_insn[] = {
    { CPU_586, 0, 0, 0, 0, 2, {0x0F, 0xC7, 0}, 1, 1,
      {OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0, 0} }
};

/* Pentium II/Pentium Pro extensions */
static const x86_insn_info cmovcc_insn[] = {
    { CPU_686, MOD_Op1Add, 16, 0, 0, 2, {0x0F, 0x40, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_686, MOD_Op1Add, 32, 0, 0, 2, {0x0F, 0x40, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_Hammer|CPU_64, MOD_Op1Add, 64, 0, 0, 2, {0x0F, 0x40, 0}, 0, 2,
      {OPT_Reg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};
static const x86_insn_info fcmovcc_insn[] = {
    { CPU_686|CPU_FPU, MOD_Op0Add|MOD_Op1Add, 0, 0, 0, 2, {0x00, 0x00, 0},
      0, 2, {OPT_ST0|OPS_80|OPA_None, OPT_Reg|OPS_80|OPA_Op1Add, 0} }
};

/* Pentium4 extensions */
static const x86_insn_info movnti_insn[] = {
    { CPU_P4, 0, 0, 0, 0, 2, {0x0F, 0xC3, 0}, 0, 2,
      {OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_Hammer|CPU_64, 0, 64, 0, 0, 2, {0x0F, 0xC3, 0}, 0, 2,
      {OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_64|OPA_Spare, 0} }
};
static const x86_insn_info clflush_insn[] = {
    { CPU_P3, 0, 0, 0, 0, 2, {0x0F, 0xAE, 0}, 7, 1,
      {OPT_Mem|OPS_8|OPS_Relaxed|OPA_EA, 0, 0} }
};

/* MMX/SSE2 instructions */
static const x86_insn_info movd_insn[] = {
    { CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0x6E, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_MMX|CPU_Hammer|CPU_64, 0, 64, 0, 0, 2, {0x0F, 0x6E, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} },
    { CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0x7E, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_64|OPA_Spare, 0} },
    { CPU_MMX|CPU_Hammer|CPU_64, 0, 64, 0, 0, 2, {0x0F, 0x7E, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_64|OPA_Spare, 0} },
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0x6E, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_SSE2|CPU_Hammer|CPU_64, 0, 64, 0, 0x66, 2, {0x0F, 0x6E, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, 0} },
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0x7E, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} },
    { CPU_SSE2|CPU_Hammer|CPU_64, 0, 64, 0, 0x66, 2, {0x0F, 0x7E, 0}, 0, 2,
      {OPT_RM|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} }
};
static const x86_insn_info movq_insn[] = {
    { CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0x6F, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0x7F, 0}, 0, 2,
      {OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_64|OPA_Spare, 0}
    },
    { CPU_SSE2, 0, 0, 0, 0xF3, 2, {0x0F, 0x7E, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} },
    { CPU_SSE2, 0, 0, 0, 0xF3, 2, {0x0F, 0x7E, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0xD6, 0}, 0, 2,
      {OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0}
    }
};
static const x86_insn_info mmxsse2_insn[] = {
    { CPU_MMX, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_SSE2, MOD_Op1Add, 0, 0, 0x66, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info pshift_insn[] = {
    { CPU_MMX, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_MMX, MOD_Gap0|MOD_Op1Add|MOD_SpAdd, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0,
      2, {OPT_SIMDReg|OPS_64|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} },
    { CPU_SSE2, MOD_Op1Add, 0, 0, 0x66, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_SSE2, MOD_Gap0|MOD_Op1Add|MOD_SpAdd, 0, 0, 0x66, 2, {0x0F, 0x00, 0},
      0, 2,
      {OPT_SIMDReg|OPS_128|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} }
};

/* PIII (Katmai) new instructions / SIMD instructiosn */
static const x86_insn_info sseps_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_xmm_xmm64_ss_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0}
    },
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_xmm_xmm64_ps_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0x00}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0}
    },
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0x00}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_xmm_xmm32_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0}
    },
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_r32_xmm64_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0}
    },
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_r32_xmm32_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0}
    },
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_mm_xmm64_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0x00}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0}
    },
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0x00}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_mm_xmm_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_xmm_mm_ss_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_xmm_mm_ps_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0x00}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info cvt_xmm_rm32_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info ssess_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info ssecmpps_insn[] = {
    { CPU_SSE, MOD_Imm8, 0, 0, 0, 2, {0x0F, 0xC2, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info ssecmpss_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Imm8, 0, 0, 0x00, 2, {0x0F, 0xC2, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    }
};
static const x86_insn_info ssepsimm_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 3,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} }
};
static const x86_insn_info ssessimm_insn[] = {
    { CPU_SSE, MOD_PreAdd|MOD_Op1Add, 0, 0, 0x00, 2, {0x0F, 0x00, 0}, 0, 3,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} }
};
static const x86_insn_info ldstmxcsr_insn[] = {
    { CPU_SSE, MOD_SpAdd, 0, 0, 0, 2, {0x0F, 0xAE, 0}, 0, 1,
      {OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0, 0} }
};
static const x86_insn_info maskmovq_insn[] = {
    { CPU_P3|CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0xF7, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDReg|OPS_64|OPA_EA, 0} }
};
static const x86_insn_info movaups_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x01, 0}, 0, 2,
      {OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0}
    }
};
static const x86_insn_info movhllhps_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} }
};
static const x86_insn_info movhlps_insn[] = {
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0} },
    { CPU_SSE, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x01, 0}, 0, 2,
      {OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} }
};
static const x86_insn_info movmskps_insn[] = {
    { CPU_SSE, 0, 0, 0, 0, 2, {0x0F, 0x50, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} }
};
static const x86_insn_info movntps_insn[] = {
    { CPU_SSE, 0, 0, 0, 0, 2, {0x0F, 0x2B, 0}, 0, 2,
      {OPT_Mem|OPS_128|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} }
};
static const x86_insn_info movntq_insn[] = {
    { CPU_SSE, 0, 0, 0, 0, 2, {0x0F, 0xE7, 0}, 0, 2,
      {OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_64|OPA_Spare, 0} }
};
static const x86_insn_info movss_insn[] = {
    { CPU_SSE, 0, 0, 0, 0xF3, 2, {0x0F, 0x10, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} },
    { CPU_SSE, 0, 0, 0, 0xF3, 2, {0x0F, 0x10, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0} },
    { CPU_SSE, 0, 0, 0, 0xF3, 2, {0x0F, 0x11, 0}, 0, 2,
      {OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} }
};
static const x86_insn_info pextrw_insn[] = {
    { CPU_P3|CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0xC5, 0}, 0, 3,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_64|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} },
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0xC5, 0}, 0, 3,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} }
};
static const x86_insn_info pinsrw_insn[] = {
    { CPU_P3|CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0xC4, 0}, 0, 3,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_Reg|OPS_32|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} },
    { CPU_P3|CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0xC4, 0}, 0, 3,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} },
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0xC4, 0}, 0, 3,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Reg|OPS_32|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} },
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0xC4, 0}, 0, 3,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} }
};
static const x86_insn_info pmovmskb_insn[] = {
    { CPU_P3|CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0xD7, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_64|OPA_EA, 0} },
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0xD7, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} }
};
static const x86_insn_info pshufw_insn[] = {
    { CPU_P3|CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0x70, 0}, 0, 3,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} }
};

/* SSE2 instructions */
static const x86_insn_info cmpsd_insn[] = {
    { CPU_Any, 0, 32, 0, 0, 1, {0xA7, 0, 0}, 0, 0, {0, 0, 0} },
    { CPU_SSE2, 0, 0, 0, 0xF2, 2, {0x0F, 0xC2, 0}, 0, 3,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA,
       OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm} }
};
static const x86_insn_info movaupd_insn[] = {
    { CPU_SSE2, MOD_Op1Add, 0, 0, 0x66, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_SSE2, MOD_Op1Add, 0, 0, 0x66, 2, {0x0F, 0x01, 0}, 0, 2,
      {OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0}
    }
};
static const x86_insn_info movhlpd_insn[] = {
    { CPU_SSE2, MOD_Op1Add, 0, 0, 0x66, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0} },
    { CPU_SSE2, MOD_Op1Add, 0, 0, 0x66, 2, {0x0F, 0x01, 0}, 0, 2,
      {OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} }
};
static const x86_insn_info movmskpd_insn[] = {
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0x50, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} }
};
static const x86_insn_info movntpddq_insn[] = {
    { CPU_SSE2, MOD_Op1Add, 0, 0, 0x66, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_Mem|OPS_128|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} }
};
static const x86_insn_info movsd_insn[] = {
    { CPU_Any, 0, 32, 0, 0, 1, {0xA5, 0, 0}, 0, 0, {0, 0, 0} },
    { CPU_SSE2, 0, 0, 0, 0xF2, 2, {0x0F, 0x10, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} },
    { CPU_SSE2, 0, 0, 0, 0xF2, 2, {0x0F, 0x10, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0} },
    { CPU_SSE2, 0, 0, 0, 0xF2, 2, {0x0F, 0x11, 0}, 0, 2,
      {OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0} }
};
static const x86_insn_info maskmovdqu_insn[] = {
    { CPU_SSE2, 0, 0, 0, 0x66, 2, {0x0F, 0xF7, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} }
};
static const x86_insn_info movdqau_insn[] = {
    { CPU_SSE2, MOD_PreAdd, 0, 0, 0x00, 2, {0x0F, 0x6F, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, 0}
    },
    { CPU_SSE2, MOD_PreAdd, 0, 0, 0x00, 2, {0x0F, 0x7F, 0}, 0, 2,
      {OPT_SIMDRM|OPS_128|OPS_Relaxed|OPA_EA, OPT_SIMDReg|OPS_128|OPA_Spare, 0}
    }
};
static const x86_insn_info movdq2q_insn[] = {
    { CPU_SSE2, 0, 0, 0, 0xF2, 2, {0x0F, 0xD6, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDReg|OPS_128|OPA_EA, 0} }
};
static const x86_insn_info movq2dq_insn[] = {
    { CPU_SSE2, 0, 0, 0, 0xF3, 2, {0x0F, 0xD6, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_Spare, OPT_SIMDReg|OPS_64|OPA_EA, 0} }
};
static const x86_insn_info pslrldq_insn[] = {
    { CPU_SSE2, MOD_SpAdd, 0, 0, 0x66, 2, {0x0F, 0x73, 0}, 0, 2,
      {OPT_SIMDReg|OPS_128|OPA_EA, OPT_Imm|OPS_8|OPS_Relaxed|OPA_Imm, 0} }
};

/* AMD 3DNow! instructions */
static const x86_insn_info now3d_insn[] = {
    { CPU_3DNow, MOD_Imm8, 0, 0, 0, 2, {0x0F, 0x0F, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};

/* Cyrix MMX instructions */
static const x86_insn_info cyrixmmx_insn[] = {
    { CPU_Cyrix|CPU_MMX, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_SIMDRM|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};
static const x86_insn_info pmachriw_insn[] = {
    { CPU_Cyrix|CPU_MMX, 0, 0, 0, 0, 2, {0x0F, 0x5E, 0}, 0, 2,
      {OPT_SIMDReg|OPS_64|OPA_Spare, OPT_Mem|OPS_64|OPS_Relaxed|OPA_EA, 0} }
};

/* Cyrix extensions */
static const x86_insn_info rsdc_insn[] = {
    { CPU_486|CPU_Cyrix|CPU_SMM, 0, 0, 0, 0, 2, {0x0F, 0x79, 0}, 0, 2,
      {OPT_SegReg|OPS_16|OPA_Spare, OPT_Mem|OPS_80|OPS_Relaxed|OPA_EA, 0} }
};
static const x86_insn_info cyrixsmm_insn[] = {
    { CPU_486|CPU_Cyrix|CPU_SMM, MOD_Op1Add, 0, 0, 0, 2, {0x0F, 0x00, 0}, 0, 1,
      {OPT_Mem|OPS_80|OPS_Relaxed|OPA_EA, 0, 0} }
};
static const x86_insn_info svdc_insn[] = {
    { CPU_486|CPU_Cyrix|CPU_SMM, 0, 0, 0, 0, 2, {0x0F, 0x78, 0}, 0, 2,
      {OPT_Mem|OPS_80|OPS_Relaxed|OPA_EA, OPT_SegReg|OPS_16|OPA_Spare, 0} }
};

/* Obsolete/undocumented instructions */
static const x86_insn_info ibts_insn[] = {
    { CPU_386|CPU_Undoc|CPU_Obs, 0, 16, 0, 0, 2, {0x0F, 0xA7, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_386|CPU_Undoc|CPU_Obs, 0, 32, 0, 0, 2, {0x0F, 0xA7, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} }
};
static const x86_insn_info umov_insn[] = {
    { CPU_386|CPU_Undoc, 0, 0, 0, 0, 2, {0x0F, 0x10, 0}, 0, 2,
      {OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_8|OPA_Spare, 0} },
    { CPU_386|CPU_Undoc, 0, 16, 0, 0, 2, {0x0F, 0x11, 0}, 0, 2,
      {OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_16|OPA_Spare, 0} },
    { CPU_386|CPU_Undoc, 0, 32, 0, 0, 2, {0x0F, 0x11, 0}, 0, 2,
      {OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, OPT_Reg|OPS_32|OPA_Spare, 0} },
    { CPU_386|CPU_Undoc, 0, 0, 0, 0, 2, {0x0F, 0x12, 0}, 0, 2,
      {OPT_Reg|OPS_8|OPA_Spare, OPT_RM|OPS_8|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386|CPU_Undoc, 0, 16, 0, 0, 2, {0x0F, 0x13, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_RM|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386|CPU_Undoc, 0, 32, 0, 0, 2, {0x0F, 0x13, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_RM|OPS_32|OPS_Relaxed|OPA_EA, 0} }
};
static const x86_insn_info xbts_insn[] = {
    { CPU_386|CPU_Undoc|CPU_Obs, 0, 16, 0, 0, 2, {0x0F, 0xA6, 0}, 0, 2,
      {OPT_Reg|OPS_16|OPA_Spare, OPT_Mem|OPS_16|OPS_Relaxed|OPA_EA, 0} },
    { CPU_386|CPU_Undoc|CPU_Obs, 0, 32, 0, 0, 2, {0x0F, 0xA6, 0}, 0, 2,
      {OPT_Reg|OPS_32|OPA_Spare, OPT_Mem|OPS_32|OPS_Relaxed|OPA_EA, 0} }
};


static yasm_bytecode *
x86_new_jmp(yasm_arch *arch, const unsigned long data[4], int num_operands,
	    yasm_insn_operands *operands, x86_insn_info *jinfo,
	    yasm_bytecode *prev_bc, unsigned long line)
{
    yasm_arch_x86 *arch_x86 = (yasm_arch_x86 *)arch;
    x86_new_jmp_data d;
    int num_info = (int)(data[1]&0xFF);
    x86_insn_info *info = (x86_insn_info *)data[0];
    unsigned long mod_data = data[1] >> 8;
    yasm_insn_operand *op;
    static const unsigned char size_lookup[] = {0, 8, 16, 32, 64, 80, 128, 0};

    d.line = line;

    /* We know the target is in operand 0, but sanity check for Imm. */
    op = yasm_ops_first(operands);
    if (op->type != YASM_INSN__OPERAND_IMM)
	yasm_internal_error(N_("invalid operand conversion"));

    /* Far target needs to become "seg imm:imm". */
    if ((jinfo->operands[0] & OPTM_MASK) == OPTM_Far) {
	yasm_expr *copy = yasm_expr_copy(op->data.val);
	d.target = yasm_expr_create_tree(
	    yasm_expr_create_branch(YASM_EXPR_SEG, op->data.val, line),
	    YASM_EXPR_SEGOFF, copy, line);
    } else
	d.target = op->data.val;

    /* Need to save jump origin for relative jumps. */
    d.origin = yasm_symtab_define_label2("$", prev_bc, 0, line);

    /* Initially assume no far opcode is available. */
    d.far_op_len = 0;

    /* See if the user explicitly specified short/near/far. */
    switch ((int)(jinfo->operands[0] & OPTM_MASK)) {
	case OPTM_Short:
	    d.op_sel = JMP_SHORT_FORCED;
	    break;
	case OPTM_Near:
	    d.op_sel = JMP_NEAR_FORCED;
	    break;
	case OPTM_Far:
	    d.op_sel = JMP_FAR;
	    d.far_op_len = info->opcode_len;
	    d.far_op[0] = info->opcode[0];
	    d.far_op[1] = info->opcode[1];
	    d.far_op[2] = info->opcode[2];
	    break;
	default:
	    d.op_sel = JMP_NONE;
    }

    /* Set operand size */
    d.opersize = jinfo->opersize;

    /* Check for address size setting in second operand, if present */
    if (jinfo->num_operands > 1 &&
	(jinfo->operands[1] & OPA_MASK) == OPA_AdSizeR)
	d.addrsize = (unsigned char)size_lookup[(jinfo->operands[1] &
						 OPS_MASK)>>OPS_SHIFT];
    else
	d.addrsize = 0;

    /* Check for address size override */
    if (jinfo->modifiers & MOD_AdSizeR)
	d.addrsize = (unsigned char)(mod_data & 0xFF);

    /* Scan through other infos for this insn looking for short/near versions.
     * Needs to match opersize and number of operands, also be within CPU.
     */
    d.short_op_len = 0;
    d.near_op_len = 0;
    for (; num_info>0 && (d.short_op_len == 0 || d.near_op_len == 0);
	 num_info--, info++) {
	unsigned long cpu = info->cpu | data[2];

	if ((cpu & CPU_64) && arch_x86->mode_bits != 64)
	    continue;
	if ((cpu & CPU_Not64) && arch_x86->mode_bits == 64)
	    continue;
	cpu &= ~(CPU_64 | CPU_Not64);

	if ((arch_x86->cpu_enabled & cpu) != cpu)
	    continue;

	if (info->num_operands == 0)
	    continue;

	if ((info->operands[0] & OPA_MASK) != OPA_JmpRel)
	    continue;

	if (info->opersize != d.opersize)
	    continue;

	switch ((int)(info->operands[0] & OPTM_MASK)) {
	    case OPTM_Short:
		d.short_op_len = info->opcode_len;
		d.short_op[0] = info->opcode[0];
		d.short_op[1] = info->opcode[1];
		d.short_op[2] = info->opcode[2];
		if (info->modifiers & MOD_Op0Add)
		    d.short_op[0] += (unsigned char)(mod_data & 0xFF);
		break;
	    case OPTM_Near:
		d.near_op_len = info->opcode_len;
		d.near_op[0] = info->opcode[0];
		d.near_op[1] = info->opcode[1];
		d.near_op[2] = info->opcode[2];
		if (info->modifiers & MOD_Op1Add)
		    d.near_op[1] += (unsigned char)(mod_data & 0xFF);
		if ((info->operands[0] & OPAP_MASK) == OPAP_JmpFar) {
		    d.far_op_len = 1;
		    d.far_op[0] = info->opcode[info->opcode_len];
		}
		break;
	}
    }

    return yasm_x86__bc_create_jmp(arch, &d);
}

yasm_bytecode *
yasm_x86__parse_insn(yasm_arch *arch, const unsigned long data[4],
		     int num_operands, yasm_insn_operands *operands,
		     yasm_bytecode *prev_bc, unsigned long line)
{
    yasm_arch_x86 *arch_x86 = (yasm_arch_x86 *)arch;
    x86_new_insn_data d;
    int num_info = (int)(data[1]&0xFF);
    x86_insn_info *info = (x86_insn_info *)data[0];
    unsigned long mod_data = data[1] >> 8;
    int found = 0;
    yasm_insn_operand *op;
    int i;
    static const unsigned int size_lookup[] = {0, 1, 2, 4, 8, 10, 16, 0};

    /* Just do a simple linear search through the info array for a match.
     * First match wins.
     */
    for (; num_info>0 && !found; num_info--, info++) {
	unsigned long cpu;
	unsigned int size;
	int mismatch = 0;

	/* Match CPU */
	cpu = info->cpu | data[2];

	if ((cpu & CPU_64) && arch_x86->mode_bits != 64)
	    continue;
	if ((cpu & CPU_Not64) && arch_x86->mode_bits == 64)
	    continue;
	cpu &= ~(CPU_64 | CPU_Not64);

	if ((arch_x86->cpu_enabled & cpu) != cpu)
	    continue;

	/* Match # of operands */
	if (num_operands != info->num_operands)
	    continue;

	if (!operands) {
	    found = 1;	    /* no operands -> must have a match here. */
	    break;
	}

	/* Match each operand type and size */
	for(i = 0, op = yasm_ops_first(operands); op && i<info->num_operands &&
	    !mismatch; op = yasm_operand_next(op), i++) {
	    /* Check operand type */
	    switch ((int)(info->operands[i] & OPT_MASK)) {
		case OPT_Imm:
		    if (op->type != YASM_INSN__OPERAND_IMM)
			mismatch = 1;
		    break;
		case OPT_RM:
		    if (op->type == YASM_INSN__OPERAND_MEMORY)
			break;
		    /*@fallthrough@*/
		case OPT_Reg:
		    if (op->type != YASM_INSN__OPERAND_REG)
			mismatch = 1;
		    else {
			switch ((x86_expritem_reg_size)(op->data.reg&~0xFUL)) {
			    case X86_REG8:
			    case X86_REG8X:
			    case X86_REG16:
			    case X86_REG32:
			    case X86_REG64:
			    case X86_FPUREG:
				break;
			    default:
				mismatch = 1;
				break;
			}
		    }
		    break;
		case OPT_Mem:
		    if (op->type != YASM_INSN__OPERAND_MEMORY)
			mismatch = 1;
		    break;
		case OPT_SIMDRM:
		    if (op->type == YASM_INSN__OPERAND_MEMORY)
			break;
		    /*@fallthrough@*/
		case OPT_SIMDReg:
		    if (op->type != YASM_INSN__OPERAND_REG)
			mismatch = 1;
		    else {
			switch ((x86_expritem_reg_size)(op->data.reg&~0xFUL)) {
			    case X86_MMXREG:
			    case X86_XMMREG:
				break;
			    default:
				mismatch = 1;
				break;
			}
		    }
		    break;
		case OPT_SegReg:
		    if (op->type != YASM_INSN__OPERAND_SEGREG)
			mismatch = 1;
		    break;
		case OPT_CRReg:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			(op->data.reg & ~0xFUL) != X86_CRREG)
			mismatch = 1;
		    break;
		case OPT_DRReg:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			(op->data.reg & ~0xFUL) != X86_DRREG)
			mismatch = 1;
		    break;
		case OPT_TRReg:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			(op->data.reg & ~0xFUL) != X86_TRREG)
			mismatch = 1;
		    break;
		case OPT_ST0:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			op->data.reg != X86_FPUREG)
			mismatch = 1;
		    break;
		case OPT_Areg:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			((info->operands[i] & OPS_MASK) == OPS_8 &&
			 op->data.reg != (X86_REG8 | 0) &&
			 op->data.reg != (X86_REG8X | 0)) ||
			((info->operands[i] & OPS_MASK) == OPS_16 &&
			 op->data.reg != (X86_REG16 | 0)) ||
			((info->operands[i] & OPS_MASK) == OPS_32 &&
			 op->data.reg != (X86_REG32 | 0)) ||
			((info->operands[i] & OPS_MASK) == OPS_64 &&
			 op->data.reg != (X86_REG64 | 0)))
			mismatch = 1;
		    break;
		case OPT_Creg:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			((info->operands[i] & OPS_MASK) == OPS_8 &&
			 op->data.reg != (X86_REG8 | 1) &&
			 op->data.reg != (X86_REG8X | 1)) ||
			((info->operands[i] & OPS_MASK) == OPS_16 &&
			 op->data.reg != (X86_REG16 | 1)) ||
			((info->operands[i] & OPS_MASK) == OPS_32 &&
			 op->data.reg != (X86_REG32 | 1)) ||
			((info->operands[i] & OPS_MASK) == OPS_64 &&
			 op->data.reg != (X86_REG64 | 1)))
			mismatch = 1;
		    break;
		case OPT_Dreg:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			((info->operands[i] & OPS_MASK) == OPS_8 &&
			 op->data.reg != (X86_REG8 | 2) &&
			 op->data.reg != (X86_REG8X | 2)) ||
			((info->operands[i] & OPS_MASK) == OPS_16 &&
			 op->data.reg != (X86_REG16 | 2)) ||
			((info->operands[i] & OPS_MASK) == OPS_32 &&
			 op->data.reg != (X86_REG32 | 2)) ||
			((info->operands[i] & OPS_MASK) == OPS_64 &&
			 op->data.reg != (X86_REG64 | 2)))
			mismatch = 1;
		    break;
		case OPT_CS:
		    if (op->type != YASM_INSN__OPERAND_SEGREG ||
			(op->data.reg & 0xF) != 1)
			mismatch = 1;
		    break;
		case OPT_DS:
		    if (op->type != YASM_INSN__OPERAND_SEGREG ||
			(op->data.reg & 0xF) != 3)
			mismatch = 1;
		    break;
		case OPT_ES:
		    if (op->type != YASM_INSN__OPERAND_SEGREG ||
			(op->data.reg & 0xF) != 0)
			mismatch = 1;
		    break;
		case OPT_FS:
		    if (op->type != YASM_INSN__OPERAND_SEGREG ||
			(op->data.reg & 0xF) != 4)
			mismatch = 1;
		    break;
		case OPT_GS:
		    if (op->type != YASM_INSN__OPERAND_SEGREG ||
			(op->data.reg & 0xF) != 5)
			mismatch = 1;
		    break;
		case OPT_SS:
		    if (op->type != YASM_INSN__OPERAND_SEGREG ||
			(op->data.reg & 0xF) != 2)
			mismatch = 1;
		    break;
		case OPT_CR4:
		    if (op->type != YASM_INSN__OPERAND_REG ||
			op->data.reg != (X86_CRREG | 4))
			mismatch = 1;
		    break;
		case OPT_MemOffs:
		    if (op->type != YASM_INSN__OPERAND_MEMORY ||
			yasm_expr__contains(yasm_ea_get_disp(op->data.ea),
					    YASM_EXPR_REG))
			mismatch = 1;
		    break;
		default:
		    yasm_internal_error(N_("invalid operand type"));
	    }

	    if (mismatch)
		break;

	    /* Check operand size */
	    size = size_lookup[(info->operands[i] & OPS_MASK)>>OPS_SHIFT];
	    if (op->type == YASM_INSN__OPERAND_REG && op->size == 0) {
		/* Register size must exactly match */
		if (yasm_x86__get_reg_size(arch, op->data.reg) != size)
		    mismatch = 1;
	    } else {
		if ((info->operands[i] & OPS_RMASK) == OPS_Relaxed) {
		    /* Relaxed checking */
		    if (size != 0 && op->size != size && op->size != 0)
			mismatch = 1;
		} else {
		    /* Strict checking */
		    if (op->size != size)
			mismatch = 1;
		}
	    }

	    if (mismatch)
		break;

	    /* Check for 64-bit effective address size */
	    if (op->type == YASM_INSN__OPERAND_MEMORY) {
		if ((info->operands[i] & OPEAS_MASK) == OPEAS_64) {
		    if (op->data.ea->len != 8)
			mismatch = 1;
		} else if (op->data.ea->len == 8)
		    mismatch = 1;
	    }

	    if (mismatch)
		break;

	    /* Check target modifier */
	    switch ((int)(info->operands[i] & OPTM_MASK)) {
		case OPTM_None:
		    if (op->targetmod != 0)
			mismatch = 1;
		    break;
		case OPTM_Near:
		    if (op->targetmod != X86_NEAR)
			mismatch = 1;
		    break;
		case OPTM_Short:
		    if (op->targetmod != X86_SHORT)
			mismatch = 1;
		    break;
		case OPTM_Far:
		    if (op->targetmod != X86_FAR)
			mismatch = 1;
		    break;
		case OPTM_To:
		    if (op->targetmod != X86_TO)
			mismatch = 1;
		    break;
		default:
		    yasm_internal_error(N_("invalid target modifier type"));
	    }
	}

	if (!mismatch) {
	    found = 1;
	    break;
	}
    }

    if (!found) {
	/* Didn't find a matching one */
	yasm__error(line, N_("invalid combination of opcode and operands"));
	return NULL;
    }

    /* Extended error/warning handling */
    switch ((int)(info->modifiers & MOD_Ext_MASK)) {
	case MOD_ExtNone:
	    /* No extended modifier, so just continue */
	    break;
	case MOD_ExtErr:
	    switch ((int)((info->modifiers & MOD_ExtIndex_MASK)
			  >> MOD_ExtIndex_SHIFT)) {
		case 0:
		    yasm__error(line, N_("mismatch in operand sizes"));
		    break;
		case 1:
		    yasm__error(line, N_("operand size not specified"));
		    break;
		default:
		    yasm_internal_error(N_("unrecognized x86 ext mod index"));
	    }
	    return NULL;    /* It was an error */
	case MOD_ExtWarn:
	    switch ((int)((info->modifiers & MOD_ExtIndex_MASK)
			  >> MOD_ExtIndex_SHIFT)) {
		default:
		    yasm_internal_error(N_("unrecognized x86 ext mod index"));
	    }
	    break;
	default:
	    yasm_internal_error(N_("unrecognized x86 extended modifier"));
    }

    /* Shortcut to JmpRel */
    if (operands && (info->operands[0] & OPA_MASK) == OPA_JmpRel)
	return x86_new_jmp(arch, data, num_operands, operands, info, prev_bc,
			   line);

    /* Copy what we can from info */
    d.line = line;
    d.ea = NULL;
    d.ea_origin = NULL;
    d.imm = NULL;
    d.opersize = info->opersize;
    d.def_opersize_64 = info->def_opersize_64;
    d.special_prefix = info->special_prefix;
    d.op_len = info->opcode_len;
    d.op[0] = info->opcode[0];
    d.op[1] = info->opcode[1];
    d.op[2] = info->opcode[2];
    d.spare = info->spare;
    d.im_len = 0;
    d.im_sign = 0;
    d.shift_op = 0;
    d.signext_imm8_op = 0;
    d.shortmov_op = 0;
    d.rex = 0;

    /* Apply modifiers */
    if (info->modifiers & MOD_Gap0)
	mod_data >>= 8;
    if (info->modifiers & MOD_Op2Add) {
	d.op[2] += (unsigned char)(mod_data & 0xFF);
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_Gap1)
	mod_data >>= 8;
    if (info->modifiers & MOD_Op1Add) {
	d.op[1] += (unsigned char)(mod_data & 0xFF);
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_Gap2)
	mod_data >>= 8;
    if (info->modifiers & MOD_Op0Add) {
	d.op[0] += (unsigned char)(mod_data & 0xFF);
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_PreAdd) {
	d.special_prefix += (unsigned char)(mod_data & 0xFF);
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_SpAdd) {
	d.spare += (unsigned char)(mod_data & 0xFF);
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_OpSizeR) {
	d.opersize = (unsigned char)(mod_data & 0xFF);
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_Imm8) {
	d.imm = yasm_expr_create_ident(yasm_expr_int(
	    yasm_intnum_create_uint(mod_data & 0xFF)), line);
	d.im_len = 1;
	mod_data >>= 8;
    }
    if (info->modifiers & MOD_DOpS64R) {
	d.def_opersize_64 = (unsigned char)(mod_data & 0xFF);
	/*mod_data >>= 8;*/
    }

    /* Go through operands and assign */
    if (operands) {
	for(i = 0, op = yasm_ops_first(operands); op && i<info->num_operands;
	    op = yasm_operand_next(op), i++) {
	    switch ((int)(info->operands[i] & OPA_MASK)) {
		case OPA_None:
		    /* Throw away the operand contents */
		    switch (op->type) {
			case YASM_INSN__OPERAND_REG:
			case YASM_INSN__OPERAND_SEGREG:
			    break;
			case YASM_INSN__OPERAND_MEMORY:
			    yasm_ea_destroy(op->data.ea);
			    break;
			case YASM_INSN__OPERAND_IMM:
			    yasm_expr_destroy(op->data.val);
			    break;
		    }
		    break;
		case OPA_EA:
		    switch (op->type) {
			case YASM_INSN__OPERAND_REG:
			    d.ea =
				yasm_x86__ea_create_reg(op->data.reg, &d.rex,
							arch_x86->mode_bits);
			    break;
			case YASM_INSN__OPERAND_SEGREG:
			    yasm_internal_error(
				N_("invalid operand conversion"));
			case YASM_INSN__OPERAND_MEMORY:
			    d.ea = op->data.ea;
			    if ((info->operands[i] & OPT_MASK) == OPT_MemOffs)
				/* Special-case for MOV MemOffs instruction */
				yasm_x86__ea_set_disponly(d.ea);
			    else if (arch_x86->mode_bits == 64)
				/* Save origin for possible RIP-relative */
				d.ea_origin = yasm_symtab_define_label2("$",
				    prev_bc, 0, line);
			    break;
			case YASM_INSN__OPERAND_IMM:
			    d.ea = yasm_x86__ea_create_imm(op->data.val,
				size_lookup[(info->operands[i] &
					     OPS_MASK)>>OPS_SHIFT]);
			    break;
		    }
		    break;
		case OPA_Imm:
		    if (op->type == YASM_INSN__OPERAND_IMM) {
			d.imm = op->data.val;
			d.im_len = size_lookup[(info->operands[i] &
						OPS_MASK)>>OPS_SHIFT];
		    } else
			yasm_internal_error(N_("invalid operand conversion"));
		    break;
		case OPA_SImm:
		    if (op->type == YASM_INSN__OPERAND_IMM) {
			d.imm = op->data.val;
			d.im_len = size_lookup[(info->operands[i] &
						OPS_MASK)>>OPS_SHIFT];
			d.im_sign = 1;
		    } else
			yasm_internal_error(N_("invalid operand conversion"));
		    break;
		case OPA_Spare:
		    if (op->type == YASM_INSN__OPERAND_SEGREG)
			d.spare = (unsigned char)(op->data.reg&7);
		    else if (op->type == YASM_INSN__OPERAND_REG) {
			if (yasm_x86__set_rex_from_reg(&d.rex, &d.spare,
				op->data.reg, arch_x86->mode_bits,
				X86_REX_R)) {
			    yasm__error(line,
				N_("invalid combination of opcode and operands"));
			    return NULL;
			}
		    } else
			yasm_internal_error(N_("invalid operand conversion"));
		    break;
		case OPA_Op0Add:
		    if (op->type == YASM_INSN__OPERAND_REG) {
			unsigned char opadd;
			if (yasm_x86__set_rex_from_reg(&d.rex, &opadd,
				op->data.reg, arch_x86->mode_bits,
				X86_REX_B)) {
			    yasm__error(line,
				N_("invalid combination of opcode and operands"));
			    return NULL;
			}
			d.op[0] += opadd;
		    } else
			yasm_internal_error(N_("invalid operand conversion"));
		    break;
		case OPA_Op1Add:
		    if (op->type == YASM_INSN__OPERAND_REG) {
			unsigned char opadd;
			if (yasm_x86__set_rex_from_reg(&d.rex, &opadd,
				op->data.reg, arch_x86->mode_bits,
				X86_REX_B)) {
			    yasm__error(line,
				N_("invalid combination of opcode and operands"));
			    return NULL;
			}
			d.op[1] += opadd;
		    } else
			yasm_internal_error(N_("invalid operand conversion"));
		    break;
		case OPA_SpareEA:
		    if (op->type == YASM_INSN__OPERAND_REG) {
			d.ea = yasm_x86__ea_create_reg(op->data.reg, &d.rex,
						       arch_x86->mode_bits);
			if (!d.ea ||
			    yasm_x86__set_rex_from_reg(&d.rex, &d.spare,
				op->data.reg, arch_x86->mode_bits,
				X86_REX_R)) {
			    yasm__error(line,
				N_("invalid combination of opcode and operands"));
			    if (d.ea)
				yasm_xfree(d.ea);
			    return NULL;
			}
		    } else
			yasm_internal_error(N_("invalid operand conversion"));
		    break;
		default:
		    yasm_internal_error(N_("unknown operand action"));
	    }

	    switch ((int)(info->operands[i] & OPAP_MASK)) {
		case OPAP_None:
		    break;
		case OPAP_ShiftOp:
		    d.shift_op = 1;
		    break;
		case OPAP_SImm8Avail:
		    d.signext_imm8_op = 1;
		    break;
		case OPAP_ShortMov:
		    d.shortmov_op = 1;
		    break;
		default:
		    yasm_internal_error(
			N_("unknown operand postponed action"));
	    }
	}
    }

    /* Create the bytecode and return it */
    return yasm_x86__bc_create_insn(arch, &d);
}


#define YYCTYPE		char
#define YYCURSOR	id
#define YYLIMIT		id
#define YYMARKER	marker
#define YYFILL(n)

#line 2387 "./modules/arch/x86/x86id.re"


void
yasm_x86__parse_cpu(yasm_arch *arch, const char *id, unsigned long line)
{
    yasm_arch_x86 *arch_x86 = (yasm_arch_x86 *)arch;
    /*const char *marker;*/

    
#line 2373 "x86id.c"
{
	YYCTYPE yych;

	goto yy0;
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	switch(yych){
	case '\000':	goto yy25;
	case '1':	goto yy5;
	case '2':	goto yy6;
	case '3':	goto yy7;
	case '4':	goto yy8;
	case '5':	goto yy9;
	case '6':	goto yy11;
	case '8':	goto yy2;
	case 'A':	case 'a':	goto yy14;
	case 'C':	case 'c':	goto yy21;
	case 'F':	case 'f':	goto yy18;
	case 'H':	case 'h':	goto yy16;
	case 'I':	case 'i':	goto yy4;
	case 'K':	case 'k':	goto yy12;
	case 'M':	case 'm':	goto yy20;
	case 'N':	case 'n':	goto yy19;
	case 'O':	case 'o':	goto yy17;
	case 'P':	case 'p':	goto yy10;
	case 'S':	case 's':	goto yy15;
	case 'U':	case 'u':	goto yy22;
	case 'W':	case 'w':	goto yy13;
	default:	goto yy23;
	}
yy2:	yych = *++YYCURSOR;
	if(yych == '0')	goto yy209;
	goto yy24;
yy3:
#line 2508 "./modules/arch/x86/x86id.re"
{
	    yasm__warning(YASM_WARN_GENERAL, line,
			  N_("unrecognized CPU identifier `%s'"), id);
	    return;
	}
#line 2416 "x86id.c"
yy4:	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych <= '3'){
			if(yych <= '0')	goto yy24;
			if(yych <= '1')	goto yy5;
			if(yych <= '2')	goto yy6;
			goto yy198;
		} else {
			if(yych <= '4')	goto yy8;
			if(yych <= '5')	goto yy9;
			if(yych <= '6')	goto yy11;
			goto yy24;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy199;
			if(yych == 'T')	goto yy200;
			goto yy24;
		} else {
			if(yych <= 'a')	goto yy199;
			if(yych == 't')	goto yy200;
			goto yy24;
		}
	}
yy5:	yych = *++YYCURSOR;
	if(yych == '8')	goto yy195;
	goto yy24;
yy6:	yych = *++YYCURSOR;
	if(yych == '8')	goto yy192;
	goto yy24;
yy7:	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych == '8')	goto yy184;
		goto yy24;
	} else {
		if(yych <= 'D')	goto yy185;
		if(yych == 'd')	goto yy185;
		goto yy24;
	}
yy8:	yych = *++YYCURSOR;
	if(yych == '8')	goto yy181;
	goto yy24;
yy9:	yych = *++YYCURSOR;
	if(yych == '8')	goto yy180;
	goto yy24;
yy10:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= '4'){
			if(yych <= '1')	goto yy24;
			if(yych <= '2')	goto yy156;
			if(yych <= '3')	goto yy151;
			goto yy142;
		} else {
			if(yych <= '6'){
				if(yych <= '5')	goto yy158;
				goto yy154;
			} else {
				if(yych == 'E')	goto yy160;
				goto yy24;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'Q'){
				if(yych <= 'P')	goto yy161;
				goto yy24;
			} else {
				if(yych <= 'R')	goto yy162;
				if(yych <= 'd')	goto yy24;
				goto yy160;
			}
		} else {
			if(yych <= 'p'){
				if(yych <= 'o')	goto yy24;
				goto yy161;
			} else {
				if(yych == 'r')	goto yy162;
				goto yy24;
			}
		}
	}
yy11:	yych = *++YYCURSOR;
	if(yych == '8')	goto yy153;
	goto yy24;
yy12:	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych <= '5')	goto yy24;
		if(yych <= '6')	goto yy144;
		if(yych <= '7')	goto yy146;
		goto yy24;
	} else {
		if(yych <= 'A')	goto yy147;
		if(yych == 'a')	goto yy147;
		goto yy24;
	}
yy13:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy133;
	if(yych == 'i')	goto yy133;
	goto yy24;
yy14:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'M')	goto yy122;
		if(yych <= 'S')	goto yy24;
		goto yy123;
	} else {
		if(yych <= 'm'){
			if(yych <= 'l')	goto yy24;
			goto yy122;
		} else {
			if(yych == 't')	goto yy123;
			goto yy24;
		}
	}
yy15:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'L'){
			if(yych <= 'K')	goto yy24;
			goto yy109;
		} else {
			if(yych <= 'M')	goto yy110;
			if(yych <= 'R')	goto yy24;
			goto yy111;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'k')	goto yy24;
			if(yych <= 'l')	goto yy109;
			goto yy110;
		} else {
			if(yych == 's')	goto yy111;
			goto yy24;
		}
	}
yy16:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy105;
	if(yych == 'a')	goto yy105;
	goto yy24;
yy17:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'B')	goto yy95;
		if(yych <= 'O')	goto yy24;
		goto yy96;
	} else {
		if(yych <= 'b'){
			if(yych <= 'a')	goto yy24;
			goto yy95;
		} else {
			if(yych == 'p')	goto yy96;
			goto yy24;
		}
	}
yy18:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy92;
	if(yych == 'p')	goto yy92;
	goto yy24;
yy19:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy40;
	if(yych == 'o')	goto yy40;
	goto yy24;
yy20:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy37;
	if(yych == 'm')	goto yy37;
	goto yy24;
yy21:	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy32;
	if(yych == 'y')	goto yy32;
	goto yy24;
yy22:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy27;
	if(yych == 'n')	goto yy27;
	goto yy24;
yy23:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy24:	if(yych <= '\000')	goto yy3;
	goto yy23;
yy25:	yych = *++YYCURSOR;

#line 2513 "./modules/arch/x86/x86id.re"
{
	    yasm__warning(YASM_WARN_GENERAL, line,
			  N_("unrecognized CPU identifier `%s'"), id);
	    return;
	}
#line 2601 "x86id.c"
yy27:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy28;
	if(yych != 'd')	goto yy24;
yy28:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy29;
	if(yych != 'o')	goto yy24;
yy29:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy30;
	if(yych != 'c')	goto yy24;
yy30:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2500 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_Undoc; return; }
#line 2616 "x86id.c"
yy32:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy33;
	if(yych != 'r')	goto yy24;
yy33:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy34;
	if(yych != 'i')	goto yy24;
yy34:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy35;
	if(yych != 'x')	goto yy24;
yy35:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2492 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_Cyrix; return; }
#line 2631 "x86id.c"
yy37:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy38;
	if(yych != 'x')	goto yy24;
yy38:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2484 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_MMX; return; }
#line 2640 "x86id.c"
yy40:	yych = *++YYCURSOR;
	switch(yych){
	case '3':	goto yy44;
	case 'A':	case 'a':	goto yy46;
	case 'C':	case 'c':	goto yy45;
	case 'F':	case 'f':	goto yy41;
	case 'M':	case 'm':	goto yy42;
	case 'O':	case 'o':	goto yy49;
	case 'P':	case 'p':	goto yy47;
	case 'S':	case 's':	goto yy43;
	case 'U':	case 'u':	goto yy48;
	default:	goto yy24;
	}
yy41:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy89;
	if(yych == 'p')	goto yy89;
	goto yy24;
yy42:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy86;
	if(yych == 'm')	goto yy86;
	goto yy24;
yy43:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'M')	goto yy78;
		if(yych <= 'R')	goto yy24;
		goto yy79;
	} else {
		if(yych <= 'm'){
			if(yych <= 'l')	goto yy24;
			goto yy78;
		} else {
			if(yych == 's')	goto yy79;
			goto yy24;
		}
	}
yy44:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy73;
	if(yych == 'd')	goto yy73;
	goto yy24;
yy45:	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy68;
	if(yych == 'y')	goto yy68;
	goto yy24;
yy46:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy65;
	if(yych == 'm')	goto yy65;
	goto yy24;
yy47:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy58;
	if(yych == 'r')	goto yy58;
	goto yy24;
yy48:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy53;
	if(yych == 'n')	goto yy53;
	goto yy24;
yy49:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy50;
	if(yych != 'b')	goto yy24;
yy50:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy51;
	if(yych != 's')	goto yy24;
yy51:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2503 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_Obs; return; }
#line 2707 "x86id.c"
yy53:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy54;
	if(yych != 'd')	goto yy24;
yy54:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy55;
	if(yych != 'o')	goto yy24;
yy55:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy56;
	if(yych != 'c')	goto yy24;
yy56:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2501 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_Undoc; return; }
#line 2722 "x86id.c"
yy58:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy60;
		if(yych <= 'N')	goto yy24;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy24;
			goto yy60;
		} else {
			if(yych != 'o')	goto yy24;
		}
	}
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy63;
	if(yych == 't')	goto yy63;
	goto yy24;
yy60:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy61;
	if(yych != 'v')	goto yy24;
yy61:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2505 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_Priv; return; }
#line 2747 "x86id.c"
yy63:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2499 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_Prot; return; }
#line 2753 "x86id.c"
yy65:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy66;
	if(yych != 'd')	goto yy24;
yy66:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2495 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_AMD; return; }
#line 2762 "x86id.c"
yy68:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy69;
	if(yych != 'r')	goto yy24;
yy69:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy70;
	if(yych != 'i')	goto yy24;
yy70:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy71;
	if(yych != 'x')	goto yy24;
yy71:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2493 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_Cyrix; return; }
#line 2777 "x86id.c"
yy73:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy74;
	if(yych != 'n')	goto yy24;
yy74:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy75;
	if(yych != 'o')	goto yy24;
yy75:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy76;
	if(yych != 'w')	goto yy24;
yy76:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2491 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_3DNow; return; }
#line 2792 "x86id.c"
yy78:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy84;
	if(yych == 'm')	goto yy84;
	goto yy24;
yy79:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy80;
	if(yych != 'e')	goto yy24;
yy80:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy81;
	if(yych == '2')	goto yy82;
	goto yy23;
yy81:
#line 2487 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_SSE; return; }
#line 2807 "x86id.c"
yy82:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2489 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_SSE2; return; }
#line 2813 "x86id.c"
yy84:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2497 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_SMM; return; }
#line 2819 "x86id.c"
yy86:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy87;
	if(yych != 'x')	goto yy24;
yy87:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2485 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_MMX; return; }
#line 2828 "x86id.c"
yy89:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy90;
	if(yych != 'u')	goto yy24;
yy90:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2483 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled &= ~CPU_FPU; return; }
#line 2837 "x86id.c"
yy92:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy93;
	if(yych != 'u')	goto yy24;
yy93:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2482 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_FPU; return; }
#line 2846 "x86id.c"
yy95:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy103;
	if(yych == 's')	goto yy103;
	goto yy24;
yy96:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy97;
	if(yych != 't')	goto yy24;
yy97:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy98;
	if(yych != 'e')	goto yy24;
yy98:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy99;
	if(yych != 'r')	goto yy24;
yy99:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy100;
	if(yych != 'o')	goto yy24;
yy100:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy101;
	if(yych != 'n')	goto yy24;
yy101:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2471 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_K6|
		CPU_Athlon|CPU_Hammer|CPU_FPU|CPU_MMX|CPU_SSE|CPU_3DNow|
		CPU_SMM|CPU_Prot|CPU_Priv;
	    return;
	}
#line 2877 "x86id.c"
yy103:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2502 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_Obs; return; }
#line 2883 "x86id.c"
yy105:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy106;
	if(yych != 'm')	goto yy24;
yy106:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy107;
	if(yych != 'm')	goto yy24;
yy107:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy108;
	if(yych != 'e')	goto yy24;
yy108:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy101;
	if(yych == 'r')	goto yy101;
	goto yy24;
yy109:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy118;
	if(yych == 'e')	goto yy118;
	goto yy24;
yy110:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy116;
	if(yych == 'm')	goto yy116;
	goto yy24;
yy111:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy112;
	if(yych != 'e')	goto yy24;
yy112:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy113;
	if(yych == '2')	goto yy114;
	goto yy23;
yy113:
#line 2486 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_SSE; return; }
#line 2915 "x86id.c"
yy114:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2488 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_SSE2; return; }
#line 2921 "x86id.c"
yy116:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2496 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_SMM; return; }
#line 2927 "x86id.c"
yy118:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy119;
	if(yych != 'd')	goto yy24;
yy119:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy120;
	if(yych != 'g')	goto yy24;
yy120:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy121;
	if(yych != 'e')	goto yy24;
yy121:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy16;
	if(yych == 'h')	goto yy16;
	goto yy24;
yy122:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy131;
	if(yych == 'd')	goto yy131;
	goto yy24;
yy123:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy124;
	if(yych != 'h')	goto yy24;
yy124:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy125;
	if(yych != 'l')	goto yy24;
yy125:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy126;
	if(yych != 'o')	goto yy24;
yy126:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy127;
	if(yych != 'n')	goto yy24;
yy127:	yych = *++YYCURSOR;
	if(yych <= '-'){
		if(yych <= '\000')	goto yy128;
		if(yych <= ',')	goto yy23;
		goto yy129;
	} else {
		if(yych == '6')	goto yy130;
		goto yy23;
	}
yy128:
#line 2463 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_K6|
		CPU_Athlon|CPU_FPU|CPU_MMX|CPU_SSE|CPU_3DNow|CPU_SMM|CPU_Prot|
		CPU_Priv;
	    return;
	}
#line 2975 "x86id.c"
yy129:	yych = *++YYCURSOR;
	if(yych != '6')	goto yy24;
yy130:	yych = *++YYCURSOR;
	if(yych == '4')	goto yy101;
	goto yy24;
yy131:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2494 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_AMD; return; }
#line 2986 "x86id.c"
yy133:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy134;
	if(yych != 'l')	goto yy24;
yy134:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy135;
	if(yych != 'l')	goto yy24;
yy135:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy136;
	if(yych != 'i')	goto yy24;
yy136:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy137;
	if(yych != 'a')	goto yy24;
yy137:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy138;
	if(yych != 'm')	goto yy24;
yy138:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy139;
	if(yych != 'e')	goto yy24;
yy139:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy140;
	if(yych != 't')	goto yy24;
yy140:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy141;
	if(yych != 't')	goto yy24;
yy141:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy142;
	if(yych != 'e')	goto yy24;
yy142:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2444 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_P3|CPU_P4|
		CPU_FPU|CPU_MMX|CPU_SSE|CPU_SSE2|CPU_SMM|CPU_Prot|CPU_Priv;
	    return;
	}
#line 3024 "x86id.c"
yy144:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2457 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_K6|CPU_FPU|
		CPU_MMX|CPU_3DNow|CPU_SMM|CPU_Prot|CPU_Priv;
	    return;
	}
#line 3035 "x86id.c"
yy146:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy128;
	goto yy23;
yy147:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy148;
	if(yych != 't')	goto yy24;
yy148:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy149;
	if(yych != 'm')	goto yy24;
yy149:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy150;
	if(yych != 'a')	goto yy24;
yy150:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy151;
	if(yych != 'i')	goto yy24;
yy151:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2438 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_P3|CPU_FPU|
		CPU_MMX|CPU_SSE|CPU_SMM|CPU_Prot|CPU_Priv;
	    return;
	}
#line 3061 "x86id.c"
yy153:	yych = *++YYCURSOR;
	if(yych != '6')	goto yy24;
yy154:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2426 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_FPU|
		CPU_SMM|CPU_Prot|CPU_Priv;
	    return;
	}
#line 3074 "x86id.c"
yy156:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;
yy157:
#line 2432 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_FPU|
		CPU_MMX|CPU_SMM|CPU_Prot|CPU_Priv;
	    return;
	}
#line 3085 "x86id.c"
yy158:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;
yy159:
#line 2420 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_FPU|CPU_SMM|
		CPU_Prot|CPU_Priv;
	    return;
	}
#line 3096 "x86id.c"
yy160:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy170;
	if(yych == 'n')	goto yy170;
	goto yy24;
yy161:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy169;
	if(yych == 'r')	goto yy169;
	goto yy24;
yy162:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy164;
		if(yych <= 'N')	goto yy24;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy24;
			goto yy164;
		} else {
			if(yych != 'o')	goto yy24;
		}
	}
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy167;
	if(yych == 't')	goto yy167;
	goto yy24;
yy164:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy165;
	if(yych != 'v')	goto yy24;
yy165:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2504 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_Priv; return; }
#line 3129 "x86id.c"
yy167:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2498 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_Prot; return; }
#line 3135 "x86id.c"
yy169:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy154;
	if(yych == 'o')	goto yy154;
	goto yy24;
yy170:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy171;
	if(yych != 't')	goto yy24;
yy171:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy172;
	if(yych != 'i')	goto yy24;
yy172:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy173;
	if(yych != 'u')	goto yy24;
yy173:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy174;
	if(yych != 'm')	goto yy24;
yy174:	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= '1'){
			if(yych <= '\000')	goto yy159;
			if(yych != '-')	goto yy23;
		} else {
			if(yych <= '2')	goto yy156;
			if(yych <= '3')	goto yy151;
			if(yych <= '4')	goto yy142;
			goto yy23;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'I')	goto yy176;
			if(yych == 'P')	goto yy177;
			goto yy23;
		} else {
			if(yych <= 'i')	goto yy176;
			if(yych == 'p')	goto yy177;
			goto yy23;
		}
	}
	yych = *++YYCURSOR;
	if(yych <= '4'){
		if(yych <= '1')	goto yy24;
		if(yych <= '2')	goto yy156;
		if(yych <= '3')	goto yy151;
		goto yy142;
	} else {
		if(yych <= 'I'){
			if(yych <= 'H')	goto yy24;
		} else {
			if(yych != 'i')	goto yy24;
		}
	}
yy176:	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych == 'I')	goto yy179;
		if(yych <= 'U')	goto yy24;
		goto yy142;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy24;
			goto yy179;
		} else {
			if(yych == 'v')	goto yy142;
			goto yy24;
		}
	}
yy177:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy178;
	if(yych != 'r')	goto yy24;
yy178:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy154;
	if(yych == 'o')	goto yy154;
	goto yy24;
yy179:	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= '\000')	goto yy157;
		if(yych <= 'H')	goto yy23;
		goto yy151;
	} else {
		if(yych == 'i')	goto yy151;
		goto yy23;
	}
yy180:	yych = *++YYCURSOR;
	if(yych == '6')	goto yy158;
	goto yy24;
yy181:	yych = *++YYCURSOR;
	if(yych != '6')	goto yy24;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2414 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_FPU|CPU_SMM|CPU_Prot|
		CPU_Priv;
	    return;
	}
#line 3232 "x86id.c"
yy184:	yych = *++YYCURSOR;
	if(yych == '6')	goto yy190;
	goto yy24;
yy185:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy186;
	if(yych != 'n')	goto yy24;
yy186:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy187;
	if(yych != 'o')	goto yy24;
yy187:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy188;
	if(yych != 'w')	goto yy24;
yy188:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2490 "./modules/arch/x86/x86id.re"
{ arch_x86->cpu_enabled |= CPU_3DNow; return; }
#line 3250 "x86id.c"
yy190:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2409 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_SMM|CPU_Prot|CPU_Priv;
	    return;
	}
#line 3260 "x86id.c"
yy192:	yych = *++YYCURSOR;
	if(yych != '6')	goto yy24;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2405 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled = CPU_186|CPU_286|CPU_Priv;
	    return;
	}
#line 3271 "x86id.c"
yy195:	yych = *++YYCURSOR;
	if(yych != '6')	goto yy24;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2401 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled = CPU_186|CPU_Priv;
	    return;
	}
#line 3282 "x86id.c"
yy198:	yych = *++YYCURSOR;
	if(yych == '8')	goto yy184;
	goto yy24;
yy199:	yych = *++YYCURSOR;
	if(yych == '-')	goto yy207;
	if(yych == '6')	goto yy208;
	goto yy24;
yy200:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy201;
	if(yych != 'a')	goto yy24;
yy201:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy202;
	if(yych != 'n')	goto yy24;
yy202:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy203;
	if(yych != 'i')	goto yy24;
yy203:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy204;
	if(yych != 'u')	goto yy24;
yy204:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy205;
	if(yych != 'm')	goto yy24;
yy205:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2450 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled =
		CPU_186|CPU_286|CPU_386|CPU_486|CPU_586|CPU_686|CPU_P3|CPU_P4|
		CPU_IA64|CPU_FPU|CPU_MMX|CPU_SSE|CPU_SSE2|CPU_SMM|CPU_Prot|
		CPU_Priv;
	    return;
	}
#line 3316 "x86id.c"
yy207:	yych = *++YYCURSOR;
	if(yych != '6')	goto yy24;
yy208:	yych = *++YYCURSOR;
	if(yych == '4')	goto yy205;
	goto yy24;
yy209:	yych = *++YYCURSOR;
	if(yych <= '3'){
		if(yych <= '0')	goto yy24;
		if(yych <= '1')	goto yy5;
		if(yych <= '2')	goto yy6;
		goto yy198;
	} else {
		if(yych <= '4')	goto yy8;
		if(yych != '8')	goto yy24;
	}
	yych = *++YYCURSOR;
	if(yych != '6')	goto yy24;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy23;

#line 2397 "./modules/arch/x86/x86id.re"
{
	    arch_x86->cpu_enabled = CPU_Priv;
	    return;
	}
#line 3342 "x86id.c"
}
#line 2518 "./modules/arch/x86/x86id.re"

}

yasm_arch_check_id_retval
yasm_x86__parse_check_id(yasm_arch *arch, unsigned long data[4],
			 const char *id, unsigned long line)
{
    yasm_arch_x86 *arch_x86 = (yasm_arch_x86 *)arch;
    const char *oid = id;
    /*const char *marker;*/
    
#line 3356 "x86id.c"
{
	YYCTYPE yych;

	goto yy213;
	++YYCURSOR;
yy213:
	if((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	switch(yych){
	case '\000':	goto yy240;
	case 'A':	case 'a':	goto yy221;
	case 'B':	case 'b':	goto yy229;
	case 'C':	case 'c':	goto yy224;
	case 'D':	case 'd':	goto yy225;
	case 'E':	case 'e':	goto yy228;
	case 'F':	case 'f':	goto yy218;
	case 'G':	case 'g':	goto yy230;
	case 'H':	case 'h':	goto yy234;
	case 'I':	case 'i':	goto yy232;
	case 'J':	case 'j':	goto yy233;
	case 'L':	case 'l':	goto yy222;
	case 'M':	case 'm':	goto yy226;
	case 'N':	case 'n':	goto yy215;
	case 'O':	case 'o':	goto yy220;
	case 'P':	case 'p':	goto yy231;
	case 'R':	case 'r':	goto yy223;
	case 'S':	case 's':	goto yy217;
	case 'T':	case 't':	goto yy219;
	case 'U':	case 'u':	goto yy237;
	case 'V':	case 'v':	goto yy235;
	case 'W':	case 'w':	goto yy236;
	case 'X':	case 'x':	goto yy227;
	default:	goto yy238;
	}
yy215:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'E')	goto yy2340;
		if(yych <= 'N')	goto yy239;
		goto yy2341;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
			goto yy2340;
		} else {
			if(yych == 'o')	goto yy2341;
			goto yy239;
		}
	}
yy216:
#line 3834 "./modules/arch/x86/x86id.re"
{
	    return YASM_ARCH_CHECK_ID_NONE;
	}
#line 3410 "x86id.c"
yy217:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy2102;
	case 'B':	case 'b':	goto yy2103;
	case 'C':	case 'c':	goto yy2104;
	case 'E':	case 'e':	goto yy2105;
	case 'F':	case 'f':	goto yy2106;
	case 'G':	case 'g':	goto yy2107;
	case 'H':	case 'h':	goto yy2108;
	case 'I':	case 'i':	goto yy2109;
	case 'L':	case 'l':	goto yy2111;
	case 'M':	case 'm':	goto yy2112;
	case 'P':	case 'p':	goto yy2113;
	case 'Q':	case 'q':	goto yy2115;
	case 'S':	case 's':	goto yy2116;
	case 'T':	case 't':	goto yy2118;
	case 'U':	case 'u':	goto yy2119;
	case 'V':	case 'v':	goto yy2120;
	case 'W':	case 'w':	goto yy2121;
	case 'Y':	case 'y':	goto yy2122;
	default:	goto yy239;
	}
yy218:	yych = *++YYCURSOR;
	switch(yych){
	case '2':	goto yy1771;
	case 'A':	case 'a':	goto yy1772;
	case 'B':	case 'b':	goto yy1773;
	case 'C':	case 'c':	goto yy1774;
	case 'D':	case 'd':	goto yy1775;
	case 'E':	case 'e':	goto yy1776;
	case 'F':	case 'f':	goto yy1777;
	case 'I':	case 'i':	goto yy1778;
	case 'L':	case 'l':	goto yy1779;
	case 'M':	case 'm':	goto yy1780;
	case 'N':	case 'n':	goto yy1781;
	case 'P':	case 'p':	goto yy1782;
	case 'R':	case 'r':	goto yy1783;
	case 'S':	case 's':	goto yy1784;
	case 'T':	case 't':	goto yy1786;
	case 'U':	case 'u':	goto yy1787;
	case 'W':	case 'w':	goto yy1788;
	case 'X':	case 'x':	goto yy1789;
	case 'Y':	case 'y':	goto yy1790;
	default:	goto yy239;
	}
yy219:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'N'){
			if(yych == 'E')	goto yy1762;
			goto yy239;
		} else {
			if(yych <= 'O')	goto yy1763;
			if(yych <= 'Q')	goto yy239;
			goto yy1765;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'e')	goto yy1762;
			goto yy239;
		} else {
			if(yych <= 'o')	goto yy1763;
			if(yych == 'r')	goto yy1765;
			goto yy239;
		}
	}
yy220:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '2'){
			if(yych == '1')	goto yy1736;
			goto yy239;
		} else {
			if(yych <= '3')	goto yy1737;
			if(yych == '6')	goto yy1738;
			goto yy239;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'R')	goto yy1739;
			if(yych == 'U')	goto yy1741;
			goto yy239;
		} else {
			if(yych <= 'r')	goto yy1739;
			if(yych == 'u')	goto yy1741;
			goto yy239;
		}
	}
yy221:	yych = *++YYCURSOR;
	switch(yych){
	case '1':	goto yy1679;
	case '3':	goto yy1680;
	case '6':	goto yy1681;
	case 'A':	case 'a':	goto yy1682;
	case 'D':	case 'd':	goto yy1683;
	case 'H':	case 'h':	goto yy1684;
	case 'L':	case 'l':	goto yy1686;
	case 'N':	case 'n':	goto yy1688;
	case 'R':	case 'r':	goto yy1689;
	case 'X':	case 'x':	goto yy1690;
	default:	goto yy239;
	}
yy222:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy1586;
	case 'D':	case 'd':	goto yy1587;
	case 'E':	case 'e':	goto yy1588;
	case 'F':	case 'f':	goto yy1589;
	case 'G':	case 'g':	goto yy1590;
	case 'I':	case 'i':	goto yy1591;
	case 'L':	case 'l':	goto yy1592;
	case 'M':	case 'm':	goto yy1593;
	case 'O':	case 'o':	goto yy1594;
	case 'S':	case 's':	goto yy1595;
	case 'T':	case 't':	goto yy1596;
	default:	goto yy239;
	}
yy223:	yych = *++YYCURSOR;
	switch(yych){
	case '1':	goto yy1474;
	case '8':
	case '9':	goto yy1475;
	case 'A':	case 'a':	goto yy1477;
	case 'B':	case 'b':	goto yy1478;
	case 'C':	case 'c':	goto yy1479;
	case 'D':	case 'd':	goto yy1480;
	case 'E':	case 'e':	goto yy1481;
	case 'I':	case 'i':	goto yy1482;
	case 'O':	case 'o':	goto yy1483;
	case 'S':	case 's':	goto yy1484;
	default:	goto yy239;
	}
yy224:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy1132;
	case 'B':	case 'b':	goto yy1133;
	case 'D':	case 'd':	goto yy1134;
	case 'H':	case 'h':	goto yy1135;
	case 'L':	case 'l':	goto yy1137;
	case 'M':	case 'm':	goto yy1139;
	case 'O':	case 'o':	goto yy1140;
	case 'P':	case 'p':	goto yy1141;
	case 'R':	case 'r':	goto yy1142;
	case 'S':	case 's':	goto yy1143;
	case 'V':	case 'v':	goto yy1145;
	case 'W':	case 'w':	goto yy1146;
	case 'X':	case 'x':	goto yy1147;
	default:	goto yy239;
	}
yy225:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy1097;
	case 'E':	case 'e':	goto yy1098;
	case 'H':	case 'h':	goto yy1099;
	case 'I':	case 'i':	goto yy1101;
	case 'L':	case 'l':	goto yy1103;
	case 'R':	case 'r':	goto yy1105;
	case 'S':	case 's':	goto yy1106;
	case 'X':	case 'x':	goto yy1108;
	default:	goto yy239;
	}
yy226:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy949;
	case 'F':	case 'f':	goto yy950;
	case 'I':	case 'i':	goto yy951;
	case 'M':	case 'm':	goto yy952;
	case 'O':	case 'o':	goto yy953;
	case 'U':	case 'u':	goto yy954;
	default:	goto yy239;
	}
yy227:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy917;
	case 'B':	case 'b':	goto yy918;
	case 'C':	case 'c':	goto yy919;
	case 'L':	case 'l':	goto yy920;
	case 'M':	case 'm':	goto yy921;
	case 'O':	case 'o':	goto yy922;
	default:	goto yy239;
	}
yy228:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy886;
	case 'B':	case 'b':	goto yy887;
	case 'C':	case 'c':	goto yy888;
	case 'D':	case 'd':	goto yy889;
	case 'M':	case 'm':	goto yy890;
	case 'N':	case 'n':	goto yy891;
	case 'S':	case 's':	goto yy892;
	default:	goto yy239;
	}
yy229:	yych = *++YYCURSOR;
	switch(yych){
	case 'H':	case 'h':	goto yy854;
	case 'L':	case 'l':	goto yy856;
	case 'O':	case 'o':	goto yy858;
	case 'P':	case 'p':	goto yy859;
	case 'S':	case 's':	goto yy861;
	case 'T':	case 't':	goto yy862;
	case 'X':	case 'x':	goto yy864;
	default:	goto yy239;
	}
yy230:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy852;
	if(yych == 's')	goto yy852;
	goto yy239;
yy231:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy429;
	case 'C':	case 'c':	goto yy430;
	case 'D':	case 'd':	goto yy431;
	case 'E':	case 'e':	goto yy432;
	case 'F':	case 'f':	goto yy433;
	case 'I':	case 'i':	goto yy434;
	case 'M':	case 'm':	goto yy435;
	case 'O':	case 'o':	goto yy436;
	case 'R':	case 'r':	goto yy437;
	case 'S':	case 's':	goto yy438;
	case 'U':	case 'u':	goto yy439;
	case 'X':	case 'x':	goto yy440;
	default:	goto yy239;
	}
yy232:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy380;
	case 'D':	case 'd':	goto yy381;
	case 'M':	case 'm':	goto yy382;
	case 'N':	case 'n':	goto yy383;
	case 'R':	case 'r':	goto yy385;
	default:	goto yy239;
	}
yy233:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy304;
	case 'B':	case 'b':	goto yy306;
	case 'C':	case 'c':	goto yy308;
	case 'E':	case 'e':	goto yy310;
	case 'G':	case 'g':	goto yy312;
	case 'L':	case 'l':	goto yy314;
	case 'M':	case 'm':	goto yy316;
	case 'N':	case 'n':	goto yy317;
	case 'O':	case 'o':	goto yy318;
	case 'P':	case 'p':	goto yy320;
	case 'R':	case 'r':	goto yy322;
	case 'S':	case 's':	goto yy323;
	case 'Z':	case 'z':	goto yy325;
	default:	goto yy239;
	}
yy234:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy301;
	if(yych == 'l')	goto yy301;
	goto yy239;
yy235:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy295;
	if(yych == 'e')	goto yy295;
	goto yy239;
yy236:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'A'){
			if(yych <= '@')	goto yy239;
			goto yy276;
		} else {
			if(yych <= 'B')	goto yy277;
			if(yych <= 'Q')	goto yy239;
			goto yy278;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= '`')	goto yy239;
			if(yych <= 'a')	goto yy276;
			goto yy277;
		} else {
			if(yych == 'r')	goto yy278;
			goto yy239;
		}
	}
yy237:	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= 'D'){
			if(yych <= 'B')	goto yy239;
			if(yych <= 'C')	goto yy242;
			goto yy243;
		} else {
			if(yych <= 'L')	goto yy239;
			if(yych <= 'M')	goto yy244;
			goto yy245;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'b')	goto yy239;
			if(yych <= 'c')	goto yy242;
			goto yy243;
		} else {
			if(yych <= 'l')	goto yy239;
			if(yych <= 'm')	goto yy244;
			if(yych <= 'n')	goto yy245;
			goto yy239;
		}
	}
yy238:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy239:	if(yych <= '\000')	goto yy216;
	goto yy238;
yy240:	yych = *++YYCURSOR;

#line 3837 "./modules/arch/x86/x86id.re"
{
	    return YASM_ARCH_CHECK_ID_NONE;
	}
#line 3720 "x86id.c"
yy242:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy268;
	if(yych == 'o')	goto yy268;
	goto yy239;
yy243:	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy239;
	if(yych <= '1')	goto yy266;
	if(yych <= '2')	goto yy264;
	goto yy239;
yy244:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy261;
	if(yych == 'o')	goto yy261;
	goto yy239;
yy245:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy246;
	if(yych != 'p')	goto yy239;
yy246:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy247;
	if(yych != 'c')	goto yy239;
yy247:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy248;
	if(yych != 'k')	goto yy239;
yy248:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'H')	goto yy249;
		if(yych <= 'K')	goto yy239;
		goto yy250;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy239;
		} else {
			if(yych == 'l')	goto yy250;
			goto yy239;
		}
	}
yy249:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy256;
	if(yych == 'p')	goto yy256;
	goto yy239;
yy250:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy251;
	if(yych != 'p')	goto yy239;
yy251:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy252;
		if(yych <= 'R')	goto yy239;
		goto yy254;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy254;
			goto yy239;
		}
	}
yy252:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3722 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6614, CPU_SSE2); }
#line 3781 "x86id.c"
yy254:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3670 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x14, CPU_SSE); }
#line 3787 "x86id.c"
yy256:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy257;
		if(yych <= 'R')	goto yy239;
		goto yy259;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy259;
			goto yy239;
		}
	}
yy257:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3721 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6615, CPU_SSE2); }
#line 3806 "x86id.c"
yy259:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3669 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x15, CPU_SSE); }
#line 3812 "x86id.c"
yy261:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy262;
	if(yych != 'v')	goto yy239;
yy262:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3829 "./modules/arch/x86/x86id.re"
{ RET_INSN(umov, 0, CPU_386|CPU_Undoc); }
#line 3821 "x86id.c"
yy264:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3490 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F0B, CPU_286); }
#line 3827 "x86id.c"
yy266:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3491 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0FB9, CPU_286|CPU_Undoc); }
#line 3833 "x86id.c"
yy268:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy269;
	if(yych != 'm')	goto yy239;
yy269:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy270;
	if(yych != 'i')	goto yy239;
yy270:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy271;
	if(yych != 's')	goto yy239;
yy271:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy274;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy274;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3668 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF32E, CPU_SSE); }
#line 3860 "x86id.c"
yy274:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3720 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF22E, CPU_SSE2); }
#line 3866 "x86id.c"
yy276:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy292;
	if(yych == 'i')	goto yy292;
	goto yy239;
yy277:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy287;
	if(yych == 'i')	goto yy287;
	goto yy239;
yy278:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'M')	goto yy279;
		if(yych <= 'R')	goto yy239;
		goto yy280;
	} else {
		if(yych <= 'm'){
			if(yych <= 'l')	goto yy239;
		} else {
			if(yych == 's')	goto yy280;
			goto yy239;
		}
	}
yy279:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy284;
	if(yych == 's')	goto yy284;
	goto yy239;
yy280:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy281;
	if(yych != 'h')	goto yy239;
yy281:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy282;
	if(yych != 'r')	goto yy239;
yy282:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3815 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F37, CPU_686|CPU_Cyrix|CPU_SMM); }
#line 3903 "x86id.c"
yy284:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy285;
	if(yych != 'r')	goto yy239;
yy285:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3468 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F30, CPU_586|CPU_Priv); }
#line 3912 "x86id.c"
yy287:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy288;
	if(yych != 'n')	goto yy239;
yy288:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy289;
	if(yych != 'v')	goto yy239;
yy289:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy290;
	if(yych != 'd')	goto yy239;
yy290:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3463 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F09, CPU_486|CPU_Priv); }
#line 3927 "x86id.c"
yy292:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy293;
	if(yych != 't')	goto yy239;
yy293:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3456 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x009B, CPU_Any); }
#line 3936 "x86id.c"
yy295:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy296;
	if(yych != 'r')	goto yy239;
yy296:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'R')	goto yy297;
		if(yych <= 'V')	goto yy239;
		goto yy299;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy239;
		} else {
			if(yych == 'w')	goto yy299;
			goto yy239;
		}
	}
yy297:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3371 "./modules/arch/x86/x86id.re"
{ RET_INSN(prot286, 0x0400, CPU_286|CPU_Prot); }
#line 3958 "x86id.c"
yy299:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3372 "./modules/arch/x86/x86id.re"
{ RET_INSN(prot286, 0x0500, CPU_286|CPU_Prot); }
#line 3964 "x86id.c"
yy301:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy302;
	if(yych != 't')	goto yy239;
yy302:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3349 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00F4, CPU_Priv); }
#line 3973 "x86id.c"
yy304:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy305;
		if(yych <= 'D')	goto yy238;
		goto yy378;
	} else {
		if(yych == 'e')	goto yy378;
		goto yy238;
	}
yy305:
#line 3180 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x07, CPU_Any); }
#line 3986 "x86id.c"
yy306:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy307;
		if(yych <= 'D')	goto yy238;
		goto yy376;
	} else {
		if(yych == 'e')	goto yy376;
		goto yy238;
	}
yy307:
#line 3167 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x02, CPU_Any); }
#line 3999 "x86id.c"
yy308:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= '\000')	goto yy309;
		if(yych <= 'W')	goto yy238;
		goto yy373;
	} else {
		if(yych == 'x')	goto yy373;
		goto yy238;
	}
yy309:
#line 3168 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x02, CPU_Any); }
#line 4012 "x86id.c"
yy310:	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= '\000')	goto yy311;
		if(yych <= 'B')	goto yy238;
		goto yy369;
	} else {
		if(yych == 'c')	goto yy369;
		goto yy238;
	}
yy311:
#line 3173 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x04, CPU_Any); }
#line 4025 "x86id.c"
yy312:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy313;
		if(yych <= 'D')	goto yy238;
		goto yy367;
	} else {
		if(yych == 'e')	goto yy367;
		goto yy238;
	}
yy313:
#line 3194 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0F, CPU_Any); }
#line 4038 "x86id.c"
yy314:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy315;
		if(yych <= 'D')	goto yy238;
		goto yy365;
	} else {
		if(yych == 'e')	goto yy365;
		goto yy238;
	}
yy315:
#line 3187 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0C, CPU_Any); }
#line 4051 "x86id.c"
yy316:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy363;
	if(yych == 'p')	goto yy363;
	goto yy239;
yy317:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy337;
	case 'B':	case 'b':	goto yy339;
	case 'C':	case 'c':	goto yy341;
	case 'E':	case 'e':	goto yy343;
	case 'G':	case 'g':	goto yy351;
	case 'L':	case 'l':	goto yy353;
	case 'O':	case 'o':	goto yy335;
	case 'P':	case 'p':	goto yy349;
	case 'S':	case 's':	goto yy347;
	case 'Z':	case 'z':	goto yy345;
	default:	goto yy239;
	}
yy318:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3165 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x00, CPU_Any); }
#line 4075 "x86id.c"
yy320:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'E')	goto yy331;
			if(yych <= 'N')	goto yy238;
			goto yy333;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy238;
			goto yy331;
		} else {
			if(yych == 'o')	goto yy333;
			goto yy238;
		}
	}

#line 3183 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0A, CPU_Any); }
#line 4097 "x86id.c"
yy322:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy327;
	if(yych == 'c')	goto yy327;
	goto yy239;
yy323:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3181 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x08, CPU_Any); }
#line 4107 "x86id.c"
yy325:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3174 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x04, CPU_Any); }
#line 4113 "x86id.c"
yy327:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy328;
	if(yych != 'x')	goto yy239;
yy328:	yych = *++YYCURSOR;
	if(yych == 'Z')	goto yy329;
	if(yych != 'z')	goto yy239;
yy329:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3197 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(jcxz, 64, CPU_Hammer|CPU_64);
	}
#line 4133 "x86id.c"
yy331:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3184 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0A, CPU_Any); }
#line 4139 "x86id.c"
yy333:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3186 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0B, CPU_Any); }
#line 4145 "x86id.c"
yy335:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3166 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x01, CPU_Any); }
#line 4151 "x86id.c"
yy337:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy338;
		if(yych <= 'D')	goto yy238;
		goto yy361;
	} else {
		if(yych == 'e')	goto yy361;
		goto yy238;
	}
yy338:
#line 3178 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x06, CPU_Any); }
#line 4164 "x86id.c"
yy339:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy340;
		if(yych <= 'D')	goto yy238;
		goto yy359;
	} else {
		if(yych == 'e')	goto yy359;
		goto yy238;
	}
yy340:
#line 3170 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x03, CPU_Any); }
#line 4177 "x86id.c"
yy341:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3171 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x03, CPU_Any); }
#line 4183 "x86id.c"
yy343:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3175 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x05, CPU_Any); }
#line 4189 "x86id.c"
yy345:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3176 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x05, CPU_Any); }
#line 4195 "x86id.c"
yy347:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3182 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x09, CPU_Any); }
#line 4201 "x86id.c"
yy349:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3185 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0B, CPU_Any); }
#line 4207 "x86id.c"
yy351:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy352;
		if(yych <= 'D')	goto yy238;
		goto yy357;
	} else {
		if(yych == 'e')	goto yy357;
		goto yy238;
	}
yy352:
#line 3192 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0E, CPU_Any); }
#line 4220 "x86id.c"
yy353:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy354;
		if(yych <= 'D')	goto yy238;
		goto yy355;
	} else {
		if(yych == 'e')	goto yy355;
		goto yy238;
	}
yy354:
#line 3189 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0D, CPU_Any); }
#line 4233 "x86id.c"
yy355:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3193 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0F, CPU_Any); }
#line 4239 "x86id.c"
yy357:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3188 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0C, CPU_Any); }
#line 4245 "x86id.c"
yy359:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3179 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x07, CPU_Any); }
#line 4251 "x86id.c"
yy361:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3169 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x02, CPU_Any); }
#line 4257 "x86id.c"
yy363:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3158 "./modules/arch/x86/x86id.re"
{ RET_INSN(jmp, 0, CPU_Any); }
#line 4263 "x86id.c"
yy365:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3191 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0E, CPU_Any); }
#line 4269 "x86id.c"
yy367:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3190 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x0D, CPU_Any); }
#line 4275 "x86id.c"
yy369:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy370;
	if(yych != 'x')	goto yy239;
yy370:	yych = *++YYCURSOR;
	if(yych == 'Z')	goto yy371;
	if(yych != 'z')	goto yy239;
yy371:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3196 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcxz, 32, CPU_386); }
#line 4287 "x86id.c"
yy373:	yych = *++YYCURSOR;
	if(yych == 'Z')	goto yy374;
	if(yych != 'z')	goto yy239;
yy374:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3195 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcxz, 16, CPU_Any); }
#line 4296 "x86id.c"
yy376:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3177 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x06, CPU_Any); }
#line 4302 "x86id.c"
yy378:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3172 "./modules/arch/x86/x86id.re"
{ RET_INSN(jcc, 0x03, CPU_Any); }
#line 4308 "x86id.c"
yy380:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy426;
	if(yych == 't')	goto yy426;
	goto yy239;
yy381:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy423;
	if(yych == 'i')	goto yy423;
	goto yy239;
yy382:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy420;
	if(yych == 'u')	goto yy420;
	goto yy239;
yy383:	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'R'){
			if(yych <= '\000')	goto yy384;
			if(yych == 'C')	goto yy395;
			goto yy238;
		} else {
			if(yych <= 'S')	goto yy397;
			if(yych <= 'T')	goto yy398;
			if(yych <= 'U')	goto yy238;
			goto yy400;
		}
	} else {
		if(yych <= 's'){
			if(yych == 'c')	goto yy395;
			if(yych <= 'r')	goto yy238;
			goto yy397;
		} else {
			if(yych <= 't')	goto yy398;
			if(yych == 'v')	goto yy400;
			goto yy238;
		}
	}
yy384:
#line 2986 "./modules/arch/x86/x86id.re"
{ RET_INSN(in, 0, CPU_Any); }
#line 4347 "x86id.c"
yy385:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy386;
	if(yych != 'e')	goto yy239;
yy386:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy387;
	if(yych != 't')	goto yy239;
yy387:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych <= '\000')	goto yy388;
			if(yych <= 'C')	goto yy238;
			goto yy391;
		} else {
			if(yych == 'Q')	goto yy393;
			if(yych <= 'V')	goto yy238;
			goto yy389;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'd')	goto yy391;
			goto yy238;
		} else {
			if(yych <= 'q')	goto yy393;
			if(yych == 'w')	goto yy389;
			goto yy238;
		}
	}
yy388:
#line 3329 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00CF, CPU_Any); }
#line 4378 "x86id.c"
yy389:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3330 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x10CF, CPU_Any); }
#line 4384 "x86id.c"
yy391:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3331 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x20CF, CPU_386); }
#line 4390 "x86id.c"
yy393:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3332 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x40CF, CPU_Hammer|CPU_64);
	}
#line 4404 "x86id.c"
yy395:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3063 "./modules/arch/x86/x86id.re"
{ RET_INSN(incdec, 0x0040, CPU_Any); }
#line 4410 "x86id.c"
yy397:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'C'){
			if(yych == 'B')	goto yy414;
			goto yy239;
		} else {
			if(yych <= 'D')	goto yy416;
			if(yych <= 'V')	goto yy239;
			goto yy418;
		}
	} else {
		if(yych <= 'c'){
			if(yych == 'b')	goto yy414;
			goto yy239;
		} else {
			if(yych <= 'd')	goto yy416;
			if(yych == 'w')	goto yy418;
			goto yy239;
		}
	}
yy398:	yych = *++YYCURSOR;
	if(yych <= '3'){
		if(yych <= '/'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= '0')	goto yy407;
			if(yych <= '2')	goto yy238;
			goto yy408;
		}
	} else {
		if(yych <= 'O'){
			if(yych <= 'N')	goto yy238;
			goto yy410;
		} else {
			if(yych == 'o')	goto yy410;
			goto yy238;
		}
	}

#line 3319 "./modules/arch/x86/x86id.re"
{ RET_INSN(int, 0, CPU_Any); }
#line 4452 "x86id.c"
yy400:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'D')	goto yy401;
		if(yych <= 'K')	goto yy239;
		goto yy403;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'l')	goto yy403;
			goto yy239;
		}
	}
yy401:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3462 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F08, CPU_486|CPU_Priv); }
#line 4471 "x86id.c"
yy403:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy404;
	if(yych != 'p')	goto yy239;
yy404:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy405;
	if(yych != 'g')	goto yy239;
yy405:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3464 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x070F01, CPU_486|CPU_Priv); }
#line 4483 "x86id.c"
yy407:	yych = *++YYCURSOR;
	if(yych == '3')	goto yy412;
	goto yy239;
yy408:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3320 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00CC, CPU_Any); }
#line 4492 "x86id.c"
yy410:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3322 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x00CE, CPU_Any);
	}
#line 4504 "x86id.c"
yy412:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3321 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00CC, CPU_Any); }
#line 4510 "x86id.c"
yy414:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3256 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x006C, CPU_Any); }
#line 4516 "x86id.c"
yy416:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3258 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x206D, CPU_386); }
#line 4522 "x86id.c"
yy418:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3257 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x106D, CPU_Any); }
#line 4528 "x86id.c"
yy420:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy421;
	if(yych != 'l')	goto yy239;
yy421:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3142 "./modules/arch/x86/x86id.re"
{ RET_INSN(imul, 0, CPU_Any); }
#line 4537 "x86id.c"
yy423:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy424;
	if(yych != 'v')	goto yy239;
yy424:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3144 "./modules/arch/x86/x86id.re"
{ RET_INSN(f6, 0x07, CPU_Any); }
#line 4546 "x86id.c"
yy426:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy427;
	if(yych != 's')	goto yy239;
yy427:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3818 "./modules/arch/x86/x86id.re"
{ RET_INSN(ibts, 0, CPU_386|CPU_Undoc|CPU_Obs); }
#line 4555 "x86id.c"
yy429:	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'M'){
			if(yych <= 'B')	goto yy239;
			if(yych <= 'C')	goto yy792;
			if(yych <= 'D')	goto yy793;
			goto yy239;
		} else {
			if(yych <= 'N')	goto yy794;
			if(yych <= 'T')	goto yy239;
			if(yych <= 'U')	goto yy791;
			goto yy795;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'b')	goto yy239;
			if(yych <= 'c')	goto yy792;
			if(yych <= 'd')	goto yy793;
			goto yy239;
		} else {
			if(yych <= 't'){
				if(yych <= 'n')	goto yy794;
				goto yy239;
			} else {
				if(yych <= 'u')	goto yy791;
				if(yych <= 'v')	goto yy795;
				goto yy239;
			}
		}
	}
yy430:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy773;
	if(yych == 'm')	goto yy773;
	goto yy239;
yy431:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy767;
	if(yych == 'i')	goto yy767;
	goto yy239;
yy432:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy762;
	if(yych == 'x')	goto yy762;
	goto yy239;
yy433:	yych = *++YYCURSOR;
	switch(yych){
	case '2':	goto yy692;
	case 'A':	case 'a':	goto yy693;
	case 'C':	case 'c':	goto yy694;
	case 'M':	case 'm':	goto yy695;
	case 'N':	case 'n':	goto yy696;
	case 'P':	case 'p':	goto yy697;
	case 'R':	case 'r':	goto yy698;
	case 'S':	case 's':	goto yy699;
	default:	goto yy239;
	}
yy434:	yych = *++YYCURSOR;
	if(yych <= 'M'){
		if(yych == '2')	goto yy682;
		goto yy239;
	} else {
		if(yych <= 'N')	goto yy681;
		if(yych == 'n')	goto yy681;
		goto yy239;
	}
yy435:	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'I'){
			if(yych == 'A')	goto yy603;
			if(yych <= 'H')	goto yy239;
			goto yy605;
		} else {
			if(yych <= 'O'){
				if(yych <= 'N')	goto yy239;
				goto yy606;
			} else {
				if(yych <= 'T')	goto yy239;
				if(yych <= 'U')	goto yy604;
				goto yy607;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'a'){
				if(yych <= '`')	goto yy239;
				goto yy603;
			} else {
				if(yych == 'i')	goto yy605;
				goto yy239;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'o')	goto yy606;
				goto yy239;
			} else {
				if(yych <= 'u')	goto yy604;
				if(yych <= 'v')	goto yy607;
				goto yy239;
			}
		}
	}
yy436:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'P')	goto yy585;
		if(yych <= 'Q')	goto yy239;
		goto yy587;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
			goto yy585;
		} else {
			if(yych == 'r')	goto yy587;
			goto yy239;
		}
	}
yy437:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy565;
	if(yych == 'e')	goto yy565;
	goto yy239;
yy438:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy496;
	case 'H':	case 'h':	goto yy497;
	case 'L':	case 'l':	goto yy493;
	case 'R':	case 'r':	goto yy494;
	case 'U':	case 'u':	goto yy495;
	case 'W':	case 'w':	goto yy498;
	default:	goto yy239;
	}
yy439:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'N')	goto yy445;
		if(yych <= 'R')	goto yy239;
		goto yy444;
	} else {
		if(yych <= 'n'){
			if(yych <= 'm')	goto yy239;
			goto yy445;
		} else {
			if(yych == 's')	goto yy444;
			goto yy239;
		}
	}
yy440:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy441;
	if(yych != 'o')	goto yy239;
yy441:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy442;
	if(yych != 'r')	goto yy239;
yy442:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3589 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xEF, CPU_MMX); }
#line 4708 "x86id.c"
yy444:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy477;
	if(yych == 'h')	goto yy477;
	goto yy239;
yy445:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy446;
	if(yych != 'p')	goto yy239;
yy446:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy447;
	if(yych != 'c')	goto yy239;
yy447:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy448;
	if(yych != 'k')	goto yy239;
yy448:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'H')	goto yy449;
		if(yych <= 'K')	goto yy239;
		goto yy450;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy239;
		} else {
			if(yych == 'l')	goto yy450;
			goto yy239;
		}
	}
yy449:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych == 'B')	goto yy464;
			if(yych <= 'C')	goto yy239;
			goto yy465;
		} else {
			if(yych == 'Q')	goto yy466;
			if(yych <= 'V')	goto yy239;
			goto yy467;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'b')	goto yy464;
			if(yych <= 'c')	goto yy239;
			goto yy465;
		} else {
			if(yych <= 'q'){
				if(yych <= 'p')	goto yy239;
				goto yy466;
			} else {
				if(yych == 'w')	goto yy467;
				goto yy239;
			}
		}
	}
yy450:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych == 'B')	goto yy451;
			if(yych <= 'C')	goto yy239;
			goto yy452;
		} else {
			if(yych == 'Q')	goto yy453;
			if(yych <= 'V')	goto yy239;
			goto yy454;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'b')	goto yy451;
			if(yych <= 'c')	goto yy239;
			goto yy452;
		} else {
			if(yych <= 'q'){
				if(yych <= 'p')	goto yy239;
				goto yy453;
			} else {
				if(yych == 'w')	goto yy454;
				goto yy239;
			}
		}
	}
yy451:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy462;
	if(yych == 'w')	goto yy462;
	goto yy239;
yy452:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy460;
	if(yych == 'q')	goto yy460;
	goto yy239;
yy453:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy457;
	if(yych == 'd')	goto yy457;
	goto yy239;
yy454:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy455;
	if(yych != 'd')	goto yy239;
yy455:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3587 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x61, CPU_MMX); }
#line 4807 "x86id.c"
yy457:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy458;
	if(yych != 'q')	goto yy239;
yy458:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3750 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x666C, CPU_SSE2); }
#line 4816 "x86id.c"
yy460:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3588 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x62, CPU_MMX); }
#line 4822 "x86id.c"
yy462:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3586 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x60, CPU_MMX); }
#line 4828 "x86id.c"
yy464:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy475;
	if(yych == 'w')	goto yy475;
	goto yy239;
yy465:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy473;
	if(yych == 'q')	goto yy473;
	goto yy239;
yy466:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy470;
	if(yych == 'd')	goto yy470;
	goto yy239;
yy467:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy468;
	if(yych != 'd')	goto yy239;
yy468:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3584 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x69, CPU_MMX); }
#line 4849 "x86id.c"
yy470:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy471;
	if(yych != 'q')	goto yy239;
yy471:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3749 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x666D, CPU_SSE2); }
#line 4858 "x86id.c"
yy473:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3585 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x6A, CPU_MMX); }
#line 4864 "x86id.c"
yy475:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3583 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x68, CPU_MMX); }
#line 4870 "x86id.c"
yy477:	yych = *++YYCURSOR;
	if(yych <= 'F'){
		if(yych <= '@'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'A')	goto yy479;
			if(yych <= 'E')	goto yy238;
			goto yy481;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy238;
			goto yy479;
		} else {
			if(yych == 'f')	goto yy481;
			goto yy238;
		}
	}

#line 2938 "./modules/arch/x86/x86id.re"
{ RET_INSN(push, 0, CPU_Any); }
#line 4892 "x86id.c"
yy479:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'C'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'D')	goto yy489;
			if(yych <= 'V')	goto yy238;
			goto yy491;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy238;
			goto yy489;
		} else {
			if(yych == 'w')	goto yy491;
			goto yy238;
		}
	}

#line 2939 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x0060, CPU_186);
	}
#line 4920 "x86id.c"
yy481:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych <= '\000')	goto yy482;
			if(yych <= 'C')	goto yy238;
			goto yy483;
		} else {
			if(yych == 'Q')	goto yy485;
			if(yych <= 'V')	goto yy238;
			goto yy487;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'd')	goto yy483;
			goto yy238;
		} else {
			if(yych <= 'q')	goto yy485;
			if(yych == 'w')	goto yy487;
			goto yy238;
		}
	}
yy482:
#line 3028 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x009C, CPU_Any); }
#line 4945 "x86id.c"
yy483:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3029 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x209C, CPU_386); }
#line 4951 "x86id.c"
yy485:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3031 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x409C, CPU_Hammer|CPU_64);
	}
#line 4965 "x86id.c"
yy487:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3030 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x109C, CPU_Any); }
#line 4971 "x86id.c"
yy489:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2946 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x2060, CPU_386);
	}
#line 4983 "x86id.c"
yy491:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2953 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x1060, CPU_186);
	}
#line 4995 "x86id.c"
yy493:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy556;
	if(yych == 'l')	goto yy556;
	goto yy239;
yy494:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'A')	goto yy542;
		if(yych <= 'K')	goto yy239;
		goto yy543;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy239;
			goto yy542;
		} else {
			if(yych == 'l')	goto yy543;
			goto yy239;
		}
	}
yy495:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy519;
	if(yych == 'b')	goto yy519;
	goto yy239;
yy496:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy515;
	if(yych == 'd')	goto yy515;
	goto yy239;
yy497:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy503;
	if(yych == 'u')	goto yy503;
	goto yy239;
yy498:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy499;
	if(yych != 'a')	goto yy239;
yy499:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy500;
	if(yych != 'p')	goto yy239;
yy500:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy501;
	if(yych != 'd')	goto yy239;
yy501:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3778 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xBB, CPU_Athlon|CPU_3DNow); }
#line 5040 "x86id.c"
yy503:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy504;
	if(yych != 'f')	goto yy239;
yy504:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'H'){
			if(yych == 'D')	goto yy505;
			if(yych <= 'G')	goto yy239;
			goto yy507;
		} else {
			if(yych == 'L')	goto yy508;
			if(yych <= 'V')	goto yy239;
			goto yy509;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'd')	goto yy505;
			if(yych <= 'g')	goto yy239;
			goto yy507;
		} else {
			if(yych <= 'l'){
				if(yych <= 'k')	goto yy239;
				goto yy508;
			} else {
				if(yych == 'w')	goto yy509;
				goto yy239;
			}
		}
	}
yy505:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3744 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssessimm, 0x6670, CPU_SSE2); }
#line 5075 "x86id.c"
yy507:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy513;
	if(yych == 'w')	goto yy513;
	goto yy239;
yy508:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy511;
	if(yych == 'w')	goto yy511;
	goto yy239;
yy509:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3656 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshufw, 0, CPU_P3|CPU_MMX); }
#line 5089 "x86id.c"
yy511:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3746 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssessimm, 0xF270, CPU_SSE2); }
#line 5095 "x86id.c"
yy513:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3745 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssessimm, 0xF370, CPU_SSE2); }
#line 5101 "x86id.c"
yy515:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy516;
	if(yych != 'b')	goto yy239;
yy516:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy517;
	if(yych != 'w')	goto yy239;
yy517:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3655 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xF6, CPU_P3|CPU_MMX); }
#line 5113 "x86id.c"
yy519:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy520;
	case 'D':	case 'd':	goto yy524;
	case 'Q':	case 'q':	goto yy526;
	case 'S':	case 's':	goto yy528;
	case 'U':	case 'u':	goto yy529;
	case 'W':	case 'w':	goto yy522;
	default:	goto yy239;
	}
yy520:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3575 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xF8, CPU_MMX); }
#line 5129 "x86id.c"
yy522:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3576 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xF9, CPU_MMX); }
#line 5135 "x86id.c"
yy524:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3577 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xFA, CPU_MMX); }
#line 5141 "x86id.c"
yy526:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3578 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xFB, CPU_MMX); }
#line 5147 "x86id.c"
yy528:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'H'){
			if(yych == 'B')	goto yy535;
			goto yy239;
		} else {
			if(yych <= 'I')	goto yy537;
			if(yych <= 'V')	goto yy239;
			goto yy538;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'b')	goto yy535;
			goto yy239;
		} else {
			if(yych <= 'i')	goto yy537;
			if(yych == 'w')	goto yy538;
			goto yy239;
		}
	}
yy529:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy530;
	if(yych != 's')	goto yy239;
yy530:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'B')	goto yy531;
		if(yych <= 'V')	goto yy239;
		goto yy533;
	} else {
		if(yych <= 'b'){
			if(yych <= 'a')	goto yy239;
		} else {
			if(yych == 'w')	goto yy533;
			goto yy239;
		}
	}
yy531:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3581 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xD8, CPU_MMX); }
#line 5189 "x86id.c"
yy533:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3582 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xD9, CPU_MMX); }
#line 5195 "x86id.c"
yy535:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3579 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xE8, CPU_MMX); }
#line 5201 "x86id.c"
yy537:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy540;
	if(yych == 'w')	goto yy540;
	goto yy239;
yy538:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3580 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xE9, CPU_MMX); }
#line 5211 "x86id.c"
yy540:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3804 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x55, CPU_Cyrix|CPU_MMX); }
#line 5217 "x86id.c"
yy542:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'D')	goto yy554;
		if(yych <= 'V')	goto yy239;
		goto yy552;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy554;
		} else {
			if(yych == 'w')	goto yy552;
			goto yy239;
		}
	}
yy543:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'P'){
			if(yych == 'D')	goto yy546;
			goto yy239;
		} else {
			if(yych <= 'Q')	goto yy548;
			if(yych <= 'V')	goto yy239;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'd')	goto yy546;
			goto yy239;
		} else {
			if(yych <= 'q')	goto yy548;
			if(yych != 'w')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3572 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0271D1, CPU_MMX); }
#line 5255 "x86id.c"
yy546:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '\000')	goto yy547;
		if(yych <= 'P')	goto yy238;
		goto yy550;
	} else {
		if(yych == 'q')	goto yy550;
		goto yy238;
	}
yy547:
#line 3573 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0272D2, CPU_MMX); }
#line 5268 "x86id.c"
yy548:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3574 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0273D3, CPU_MMX); }
#line 5274 "x86id.c"
yy550:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3748 "./modules/arch/x86/x86id.re"
{ RET_INSN(pslrldq, 0x03, CPU_SSE2); }
#line 5280 "x86id.c"
yy552:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3570 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0471E1, CPU_MMX); }
#line 5286 "x86id.c"
yy554:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3571 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0472E2, CPU_MMX); }
#line 5292 "x86id.c"
yy556:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'P'){
			if(yych == 'D')	goto yy559;
			goto yy239;
		} else {
			if(yych <= 'Q')	goto yy561;
			if(yych <= 'V')	goto yy239;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'd')	goto yy559;
			goto yy239;
		} else {
			if(yych <= 'q')	goto yy561;
			if(yych != 'w')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3567 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0671F1, CPU_MMX); }
#line 5316 "x86id.c"
yy559:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '\000')	goto yy560;
		if(yych <= 'P')	goto yy238;
		goto yy563;
	} else {
		if(yych == 'q')	goto yy563;
		goto yy238;
	}
yy560:
#line 3568 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0672F2, CPU_MMX); }
#line 5329 "x86id.c"
yy561:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3569 "./modules/arch/x86/x86id.re"
{ RET_INSN(pshift, 0x0673F3, CPU_MMX); }
#line 5335 "x86id.c"
yy563:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3747 "./modules/arch/x86/x86id.re"
{ RET_INSN(pslrldq, 0x07, CPU_SSE2); }
#line 5341 "x86id.c"
yy565:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy566;
	if(yych != 'f')	goto yy239;
yy566:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy567;
	if(yych != 'e')	goto yy239;
yy567:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy568;
	if(yych != 't')	goto yy239;
yy568:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy569;
	if(yych != 'c')	goto yy239;
yy569:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy570;
	if(yych != 'h')	goto yy239;
yy570:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'N'){
			if(yych <= '\000')	goto yy571;
			if(yych <= 'M')	goto yy238;
			goto yy572;
		} else {
			if(yych == 'T')	goto yy573;
			if(yych <= 'V')	goto yy238;
			goto yy574;
		}
	} else {
		if(yych <= 's'){
			if(yych == 'n')	goto yy572;
			goto yy238;
		} else {
			if(yych <= 't')	goto yy573;
			if(yych == 'w')	goto yy574;
			goto yy238;
		}
	}
yy571:
#line 3752 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x000F0D, CPU_3DNow); }
#line 5381 "x86id.c"
yy572:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy582;
	if(yych == 't')	goto yy582;
	goto yy239;
yy573:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy239;
	if(yych <= '0')	goto yy576;
	if(yych <= '1')	goto yy578;
	if(yych <= '2')	goto yy580;
	goto yy239;
yy574:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3753 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x010F0D, CPU_3DNow); }
#line 5397 "x86id.c"
yy576:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3652 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x010F18, CPU_P3); }
#line 5403 "x86id.c"
yy578:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3653 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x020F18, CPU_P3); }
#line 5409 "x86id.c"
yy580:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3654 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x030F18, CPU_P3); }
#line 5415 "x86id.c"
yy582:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy583;
	if(yych != 'a')	goto yy239;
yy583:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3651 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x000F18, CPU_P3); }
#line 5424 "x86id.c"
yy585:	yych = *++YYCURSOR;
	if(yych <= 'F'){
		if(yych <= '@'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'A')	goto yy589;
			if(yych <= 'E')	goto yy238;
			goto yy591;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy238;
			goto yy589;
		} else {
			if(yych == 'f')	goto yy591;
			goto yy238;
		}
	}

#line 2961 "./modules/arch/x86/x86id.re"
{ RET_INSN(pop, 0, CPU_Any); }
#line 5446 "x86id.c"
yy587:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3566 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xEB, CPU_MMX); }
#line 5452 "x86id.c"
yy589:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'C'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'D')	goto yy599;
			if(yych <= 'V')	goto yy238;
			goto yy601;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy238;
			goto yy599;
		} else {
			if(yych == 'w')	goto yy601;
			goto yy238;
		}
	}

#line 2962 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x0061, CPU_186);
	}
#line 5480 "x86id.c"
yy591:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych <= '\000')	goto yy592;
			if(yych <= 'C')	goto yy238;
			goto yy593;
		} else {
			if(yych == 'Q')	goto yy597;
			if(yych <= 'V')	goto yy238;
			goto yy595;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'd')	goto yy593;
			goto yy238;
		} else {
			if(yych <= 'q')	goto yy597;
			if(yych == 'w')	goto yy595;
			goto yy238;
		}
	}
yy592:
#line 3040 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x40009D, CPU_Any); }
#line 5505 "x86id.c"
yy593:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3041 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x00209D, CPU_386);
	}
#line 5517 "x86id.c"
yy595:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3048 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x40109D, CPU_Any); }
#line 5523 "x86id.c"
yy597:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3049 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x40409D, CPU_Hammer|CPU_64);
	}
#line 5537 "x86id.c"
yy599:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2969 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x2061, CPU_386);
	}
#line 5549 "x86id.c"
yy601:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2976 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x1061, CPU_186);
	}
#line 5561 "x86id.c"
yy603:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= 'D'){
			if(yych <= 'B')	goto yy239;
			if(yych <= 'C')	goto yy660;
			goto yy661;
		} else {
			if(yych == 'G')	goto yy662;
			if(yych <= 'W')	goto yy239;
			goto yy663;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'b')	goto yy239;
			if(yych <= 'c')	goto yy660;
			if(yych <= 'd')	goto yy661;
			goto yy239;
		} else {
			if(yych <= 'g')	goto yy662;
			if(yych == 'x')	goto yy663;
			goto yy239;
		}
	}
yy604:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy637;
	if(yych == 'l')	goto yy637;
	goto yy239;
yy605:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy630;
	if(yych == 'n')	goto yy630;
	goto yy239;
yy606:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy624;
	if(yych == 'v')	goto yy624;
	goto yy239;
yy607:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= 'L'){
			if(yych == 'G')	goto yy608;
			if(yych <= 'K')	goto yy239;
			goto yy609;
		} else {
			if(yych == 'N')	goto yy610;
			if(yych <= 'Y')	goto yy239;
			goto yy611;
		}
	} else {
		if(yych <= 'l'){
			if(yych == 'g')	goto yy608;
			if(yych <= 'k')	goto yy239;
			goto yy609;
		} else {
			if(yych <= 'n'){
				if(yych <= 'm')	goto yy239;
				goto yy610;
			} else {
				if(yych == 'z')	goto yy611;
				goto yy239;
			}
		}
	}
yy608:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy620;
	if(yych == 'e')	goto yy620;
	goto yy239;
yy609:	yych = *++YYCURSOR;
	if(yych == 'Z')	goto yy617;
	if(yych == 'z')	goto yy617;
	goto yy239;
yy610:	yych = *++YYCURSOR;
	if(yych == 'Z')	goto yy614;
	if(yych == 'z')	goto yy614;
	goto yy239;
yy611:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy612;
	if(yych != 'b')	goto yy239;
yy612:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3803 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x58, CPU_Cyrix|CPU_MMX); }
#line 5643 "x86id.c"
yy614:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy615;
	if(yych != 'b')	goto yy239;
yy615:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3802 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x5A, CPU_Cyrix|CPU_MMX); }
#line 5652 "x86id.c"
yy617:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy618;
	if(yych != 'b')	goto yy239;
yy618:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3801 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x5B, CPU_Cyrix|CPU_MMX); }
#line 5661 "x86id.c"
yy620:	yych = *++YYCURSOR;
	if(yych == 'Z')	goto yy621;
	if(yych != 'z')	goto yy239;
yy621:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy622;
	if(yych != 'b')	goto yy239;
yy622:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3800 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x5C, CPU_Cyrix|CPU_MMX); }
#line 5673 "x86id.c"
yy624:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy625;
	if(yych != 'm')	goto yy239;
yy625:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy626;
	if(yych != 's')	goto yy239;
yy626:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy627;
	if(yych != 'k')	goto yy239;
yy627:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy628;
	if(yych != 'b')	goto yy239;
yy628:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3649 "./modules/arch/x86/x86id.re"
{ RET_INSN(pmovmskb, 0, CPU_SSE); }
#line 5691 "x86id.c"
yy630:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'S')	goto yy631;
		if(yych <= 'T')	goto yy239;
		goto yy632;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy239;
		} else {
			if(yych == 'u')	goto yy632;
			goto yy239;
		}
	}
yy631:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy635;
	if(yych == 'w')	goto yy635;
	goto yy239;
yy632:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy633;
	if(yych != 'b')	goto yy239;
yy633:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3648 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xDA, CPU_P3|CPU_MMX); }
#line 5717 "x86id.c"
yy635:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3647 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xEA, CPU_P3|CPU_MMX); }
#line 5723 "x86id.c"
yy637:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'K'){
			if(yych != 'H')	goto yy239;
		} else {
			if(yych <= 'L')	goto yy639;
			if(yych <= 'T')	goto yy239;
			goto yy640;
		}
	} else {
		if(yych <= 'k'){
			if(yych != 'h')	goto yy239;
		} else {
			if(yych <= 'l')	goto yy639;
			if(yych == 'u')	goto yy640;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'T'){
			if(yych == 'R')	goto yy646;
			goto yy239;
		} else {
			if(yych <= 'U')	goto yy647;
			if(yych <= 'V')	goto yy239;
			goto yy648;
		}
	} else {
		if(yych <= 't'){
			if(yych == 'r')	goto yy646;
			goto yy239;
		} else {
			if(yych <= 'u')	goto yy647;
			if(yych == 'w')	goto yy648;
			goto yy239;
		}
	}
yy639:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy644;
	if(yych == 'w')	goto yy644;
	goto yy239;
yy640:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy641;
	if(yych != 'd')	goto yy239;
yy641:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy642;
	if(yych != 'q')	goto yy239;
yy642:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3743 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xF4, CPU_SSE2); }
#line 5777 "x86id.c"
yy644:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3565 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xD5, CPU_MMX); }
#line 5783 "x86id.c"
yy646:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'I')	goto yy653;
		if(yych <= 'V')	goto yy239;
		goto yy652;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy239;
			goto yy653;
		} else {
			if(yych == 'w')	goto yy652;
			goto yy239;
		}
	}
yy647:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy650;
	if(yych == 'w')	goto yy650;
	goto yy239;
yy648:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3564 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xE5, CPU_MMX); }
#line 5807 "x86id.c"
yy650:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3650 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xE4, CPU_P3|CPU_MMX); }
#line 5813 "x86id.c"
yy652:	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych == 'A')	goto yy656;
		if(yych <= 'B')	goto yy239;
		goto yy658;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy239;
			goto yy656;
		} else {
			if(yych == 'c')	goto yy658;
			goto yy239;
		}
	}
yy653:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy654;
	if(yych != 'w')	goto yy239;
yy654:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3798 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x5D, CPU_Cyrix|CPU_MMX); }
#line 5836 "x86id.c"
yy656:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3777 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xB7, CPU_3DNow); }
#line 5842 "x86id.c"
yy658:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3799 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x59, CPU_Cyrix|CPU_MMX); }
#line 5848 "x86id.c"
yy660:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy676;
	if(yych == 'h')	goto yy676;
	goto yy239;
yy661:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy672;
	if(yych == 'd')	goto yy672;
	goto yy239;
yy662:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy670;
	if(yych == 'w')	goto yy670;
	goto yy239;
yy663:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'S')	goto yy664;
		if(yych <= 'T')	goto yy239;
		goto yy665;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy239;
		} else {
			if(yych == 'u')	goto yy665;
			goto yy239;
		}
	}
yy664:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy668;
	if(yych == 'w')	goto yy668;
	goto yy239;
yy665:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy666;
	if(yych != 'b')	goto yy239;
yy666:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3646 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xDE, CPU_P3|CPU_MMX); }
#line 5886 "x86id.c"
yy668:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3645 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xEE, CPU_P3|CPU_MMX); }
#line 5892 "x86id.c"
yy670:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3797 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x52, CPU_Cyrix|CPU_MMX); }
#line 5898 "x86id.c"
yy672:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy673;
	if(yych != 'w')	goto yy239;
yy673:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy674;
	if(yych != 'd')	goto yy239;
yy674:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3563 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xF5, CPU_MMX); }
#line 5910 "x86id.c"
yy676:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy677;
	if(yych != 'r')	goto yy239;
yy677:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy678;
	if(yych != 'i')	goto yy239;
yy678:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy679;
	if(yych != 'w')	goto yy239;
yy679:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3796 "./modules/arch/x86/x86id.re"
{ RET_INSN(pmachriw, 0, CPU_Cyrix|CPU_MMX); }
#line 5925 "x86id.c"
yy681:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy688;
	if(yych == 's')	goto yy688;
	goto yy239;
yy682:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy683;
	if(yych != 'f')	goto yy239;
yy683:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'D')	goto yy684;
		if(yych <= 'V')	goto yy239;
		goto yy686;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'w')	goto yy686;
			goto yy239;
		}
	}
yy684:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3775 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x0D, CPU_3DNow); }
#line 5951 "x86id.c"
yy686:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3776 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x0C, CPU_Athlon|CPU_3DNow); }
#line 5957 "x86id.c"
yy688:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy689;
	if(yych != 'r')	goto yy239;
yy689:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy690;
	if(yych != 'w')	goto yy239;
yy690:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3644 "./modules/arch/x86/x86id.re"
{ RET_INSN(pinsrw, 0, CPU_P3|CPU_MMX); }
#line 5969 "x86id.c"
yy692:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy757;
	if(yych == 'i')	goto yy757;
	goto yy239;
yy693:	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= 'B')	goto yy239;
		if(yych <= 'C')	goto yy751;
		goto yy752;
	} else {
		if(yych <= 'b')	goto yy239;
		if(yych <= 'c')	goto yy751;
		if(yych <= 'd')	goto yy752;
		goto yy239;
	}
yy694:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy741;
	if(yych == 'm')	goto yy741;
	goto yy239;
yy695:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'H'){
			if(yych == 'A')	goto yy732;
			goto yy239;
		} else {
			if(yych <= 'I')	goto yy733;
			if(yych <= 'T')	goto yy239;
			goto yy734;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'a')	goto yy732;
			goto yy239;
		} else {
			if(yych <= 'i')	goto yy733;
			if(yych == 'u')	goto yy734;
			goto yy239;
		}
	}
yy696:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy728;
	if(yych == 'a')	goto yy728;
	goto yy239;
yy697:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy723;
	if(yych == 'n')	goto yy723;
	goto yy239;
yy698:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'C')	goto yy705;
		if(yych <= 'R')	goto yy239;
		goto yy706;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy239;
			goto yy705;
		} else {
			if(yych == 's')	goto yy706;
			goto yy239;
		}
	}
yy699:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy700;
	if(yych != 'u')	goto yy239;
yy700:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy701;
	if(yych != 'b')	goto yy239;
yy701:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= '\000')	goto yy702;
		if(yych <= 'Q')	goto yy238;
		goto yy703;
	} else {
		if(yych == 'r')	goto yy703;
		goto yy238;
	}
yy702:
#line 3773 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x9A, CPU_3DNow); }
#line 6049 "x86id.c"
yy703:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3774 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xAA, CPU_3DNow); }
#line 6055 "x86id.c"
yy705:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy715;
	if(yych == 'p')	goto yy715;
	goto yy239;
yy706:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy707;
	if(yych != 'q')	goto yy239;
yy707:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'I')	goto yy708;
		if(yych <= 'Q')	goto yy239;
		goto yy709;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy239;
		} else {
			if(yych == 'r')	goto yy709;
			goto yy239;
		}
	}
yy708:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy712;
	if(yych == 't')	goto yy712;
	goto yy239;
yy709:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy710;
	if(yych != 't')	goto yy239;
yy710:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3772 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x97, CPU_3DNow); }
#line 6088 "x86id.c"
yy712:	yych = *++YYCURSOR;
	if(yych != '1')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3771 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xA7, CPU_3DNow); }
#line 6096 "x86id.c"
yy715:	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= '\000')	goto yy716;
		if(yych <= 'H')	goto yy238;
		goto yy717;
	} else {
		if(yych == 'i')	goto yy717;
		goto yy238;
	}
yy716:
#line 3768 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x96, CPU_3DNow); }
#line 6109 "x86id.c"
yy717:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy718;
	if(yych != 't')	goto yy239;
yy718:	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy239;
	if(yych <= '1')	goto yy719;
	if(yych <= '2')	goto yy721;
	goto yy239;
yy719:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3769 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xA6, CPU_3DNow); }
#line 6123 "x86id.c"
yy721:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3770 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xB6, CPU_3DNow); }
#line 6129 "x86id.c"
yy723:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy724;
	if(yych != 'a')	goto yy239;
yy724:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy725;
	if(yych != 'c')	goto yy239;
yy725:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy726;
	if(yych != 'c')	goto yy239;
yy726:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3767 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x8E, CPU_Athlon|CPU_3DNow); }
#line 6144 "x86id.c"
yy728:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy729;
	if(yych != 'c')	goto yy239;
yy729:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy730;
	if(yych != 'c')	goto yy239;
yy730:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3766 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x8A, CPU_Athlon|CPU_3DNow); }
#line 6156 "x86id.c"
yy732:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy739;
	if(yych == 'x')	goto yy739;
	goto yy239;
yy733:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy737;
	if(yych == 'n')	goto yy737;
	goto yy239;
yy734:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy735;
	if(yych != 'l')	goto yy239;
yy735:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3765 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xB4, CPU_3DNow); }
#line 6173 "x86id.c"
yy737:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3764 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x94, CPU_3DNow); }
#line 6179 "x86id.c"
yy739:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3763 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xA4, CPU_3DNow); }
#line 6185 "x86id.c"
yy741:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy742;
	if(yych != 'p')	goto yy239;
yy742:	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych == 'E')	goto yy743;
		if(yych <= 'F')	goto yy239;
		goto yy744;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
		} else {
			if(yych == 'g')	goto yy744;
			goto yy239;
		}
	}
yy743:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy749;
	if(yych == 'q')	goto yy749;
	goto yy239;
yy744:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'E')	goto yy745;
		if(yych <= 'S')	goto yy239;
		goto yy747;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
		} else {
			if(yych == 't')	goto yy747;
			goto yy239;
		}
	}
yy745:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3761 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x90, CPU_3DNow); }
#line 6224 "x86id.c"
yy747:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3762 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xA0, CPU_3DNow); }
#line 6230 "x86id.c"
yy749:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3760 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xB0, CPU_3DNow); }
#line 6236 "x86id.c"
yy751:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy755;
	if(yych == 'c')	goto yy755;
	goto yy239;
yy752:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy753;
	if(yych != 'd')	goto yy239;
yy753:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3759 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x9E, CPU_3DNow); }
#line 6249 "x86id.c"
yy755:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3758 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xAE, CPU_3DNow); }
#line 6255 "x86id.c"
yy757:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'D')	goto yy758;
		if(yych <= 'V')	goto yy239;
		goto yy760;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'w')	goto yy760;
			goto yy239;
		}
	}
yy758:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3756 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x1D, CPU_3DNow); }
#line 6274 "x86id.c"
yy760:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3757 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0x1C, CPU_Athlon|CPU_3DNow); }
#line 6280 "x86id.c"
yy762:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy763;
	if(yych != 't')	goto yy239;
yy763:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy764;
	if(yych != 'r')	goto yy239;
yy764:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy765;
	if(yych != 'w')	goto yy239;
yy765:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3643 "./modules/arch/x86/x86id.re"
{ RET_INSN(pextrw, 0, CPU_P3|CPU_MMX); }
#line 6295 "x86id.c"
yy767:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy768;
	if(yych != 's')	goto yy239;
yy768:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy769;
	if(yych != 't')	goto yy239;
yy769:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy770;
	if(yych != 'i')	goto yy239;
yy770:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy771;
	if(yych != 'b')	goto yy239;
yy771:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3795 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x54, CPU_Cyrix|CPU_MMX); }
#line 6313 "x86id.c"
yy773:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy774;
	if(yych != 'p')	goto yy239;
yy774:	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych == 'E')	goto yy775;
		if(yych <= 'F')	goto yy239;
		goto yy776;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
		} else {
			if(yych == 'g')	goto yy776;
			goto yy239;
		}
	}
yy775:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy784;
	if(yych == 'q')	goto yy784;
	goto yy239;
yy776:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy777;
	if(yych != 't')	goto yy239;
yy777:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'C'){
			if(yych != 'B')	goto yy239;
		} else {
			if(yych <= 'D')	goto yy782;
			if(yych <= 'V')	goto yy239;
			goto yy780;
		}
	} else {
		if(yych <= 'c'){
			if(yych != 'b')	goto yy239;
		} else {
			if(yych <= 'd')	goto yy782;
			if(yych == 'w')	goto yy780;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3560 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x64, CPU_MMX); }
#line 6360 "x86id.c"
yy780:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3561 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x65, CPU_MMX); }
#line 6366 "x86id.c"
yy782:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3562 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x66, CPU_MMX); }
#line 6372 "x86id.c"
yy784:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'C'){
			if(yych != 'B')	goto yy239;
		} else {
			if(yych <= 'D')	goto yy789;
			if(yych <= 'V')	goto yy239;
			goto yy787;
		}
	} else {
		if(yych <= 'c'){
			if(yych != 'b')	goto yy239;
		} else {
			if(yych <= 'd')	goto yy789;
			if(yych == 'w')	goto yy787;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3557 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x74, CPU_MMX); }
#line 6396 "x86id.c"
yy787:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3558 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x75, CPU_MMX); }
#line 6402 "x86id.c"
yy789:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3559 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x76, CPU_MMX); }
#line 6408 "x86id.c"
yy791:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy849;
	if(yych == 's')	goto yy849;
	goto yy239;
yy792:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy835;
	if(yych == 'k')	goto yy835;
	goto yy239;
yy793:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy812;
	if(yych == 'd')	goto yy812;
	goto yy239;
yy794:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy808;
	if(yych == 'd')	goto yy808;
	goto yy239;
yy795:	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych == 'E')	goto yy796;
		if(yych <= 'F')	goto yy239;
		goto yy797;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
		} else {
			if(yych == 'g')	goto yy797;
			goto yy239;
		}
	}
yy796:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy806;
	if(yych == 'b')	goto yy806;
	goto yy239;
yy797:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'T'){
			if(yych != 'B')	goto yy239;
		} else {
			if(yych <= 'U')	goto yy802;
			if(yych <= 'V')	goto yy239;
			goto yy800;
		}
	} else {
		if(yych <= 't'){
			if(yych != 'b')	goto yy239;
		} else {
			if(yych <= 'u')	goto yy802;
			if(yych == 'w')	goto yy800;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3641 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xE0, CPU_P3|CPU_MMX); }
#line 6465 "x86id.c"
yy800:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3642 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xE3, CPU_P3|CPU_MMX); }
#line 6471 "x86id.c"
yy802:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy803;
	if(yych != 's')	goto yy239;
yy803:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy804;
	if(yych != 'b')	goto yy239;
yy804:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3755 "./modules/arch/x86/x86id.re"
{ RET_INSN(now3d, 0xBF, CPU_3DNow); }
#line 6483 "x86id.c"
yy806:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3794 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x50, CPU_Cyrix|CPU_MMX); }
#line 6489 "x86id.c"
yy808:	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= '\000')	goto yy809;
		if(yych <= 'M')	goto yy238;
		goto yy810;
	} else {
		if(yych == 'n')	goto yy810;
		goto yy238;
	}
yy809:
#line 3555 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xDB, CPU_MMX); }
#line 6502 "x86id.c"
yy810:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3556 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xDF, CPU_MMX); }
#line 6508 "x86id.c"
yy812:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy813;
	case 'D':	case 'd':	goto yy817;
	case 'Q':	case 'q':	goto yy819;
	case 'S':	case 's':	goto yy821;
	case 'U':	case 'u':	goto yy822;
	case 'W':	case 'w':	goto yy815;
	default:	goto yy239;
	}
yy813:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3547 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xFC, CPU_MMX); }
#line 6524 "x86id.c"
yy815:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3548 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xFD, CPU_MMX); }
#line 6530 "x86id.c"
yy817:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3549 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xFE, CPU_MMX); }
#line 6536 "x86id.c"
yy819:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3550 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xD4, CPU_MMX); }
#line 6542 "x86id.c"
yy821:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'H'){
			if(yych == 'B')	goto yy828;
			goto yy239;
		} else {
			if(yych <= 'I')	goto yy830;
			if(yych <= 'V')	goto yy239;
			goto yy831;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'b')	goto yy828;
			goto yy239;
		} else {
			if(yych <= 'i')	goto yy830;
			if(yych == 'w')	goto yy831;
			goto yy239;
		}
	}
yy822:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy823;
	if(yych != 's')	goto yy239;
yy823:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'B')	goto yy824;
		if(yych <= 'V')	goto yy239;
		goto yy826;
	} else {
		if(yych <= 'b'){
			if(yych <= 'a')	goto yy239;
		} else {
			if(yych == 'w')	goto yy826;
			goto yy239;
		}
	}
yy824:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3553 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xDC, CPU_MMX); }
#line 6584 "x86id.c"
yy826:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3554 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xDD, CPU_MMX); }
#line 6590 "x86id.c"
yy828:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3551 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xEC, CPU_MMX); }
#line 6596 "x86id.c"
yy830:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy833;
	if(yych == 'w')	goto yy833;
	goto yy239;
yy831:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3552 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0xED, CPU_MMX); }
#line 6606 "x86id.c"
yy833:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3793 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixmmx, 0x51, CPU_Cyrix|CPU_MMX); }
#line 6612 "x86id.c"
yy835:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'S')	goto yy836;
		if(yych <= 'T')	goto yy239;
		goto yy837;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy239;
		} else {
			if(yych == 'u')	goto yy837;
			goto yy239;
		}
	}
yy836:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy842;
	if(yych == 's')	goto yy842;
	goto yy239;
yy837:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy838;
	if(yych != 's')	goto yy239;
yy838:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy839;
	if(yych != 'w')	goto yy239;
yy839:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy840;
	if(yych != 'b')	goto yy239;
yy840:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3546 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x67, CPU_MMX); }
#line 6644 "x86id.c"
yy842:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'D')	goto yy843;
		if(yych <= 'V')	goto yy239;
		goto yy844;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'w')	goto yy844;
			goto yy239;
		}
	}
yy843:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy847;
	if(yych == 'w')	goto yy847;
	goto yy239;
yy844:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy845;
	if(yych != 'b')	goto yy239;
yy845:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3545 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x63, CPU_MMX); }
#line 6670 "x86id.c"
yy847:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3544 "./modules/arch/x86/x86id.re"
{ RET_INSN(mmxsse2, 0x6B, CPU_MMX); }
#line 6676 "x86id.c"
yy849:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy850;
	if(yych != 'e')	goto yy239;
yy850:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3539 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte_prefix, 0xF390, CPU_P4); }
#line 6685 "x86id.c"
yy852:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2908 "./modules/arch/x86/x86id.re"
{ data[0] = 0x6505; return YASM_ARCH_CHECK_ID_SEGREG; }
#line 6691 "x86id.c"
yy854:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2828 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 7; return YASM_ARCH_CHECK_ID_REG; }
#line 6697 "x86id.c"
yy856:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2824 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 3; return YASM_ARCH_CHECK_ID_REG; }
#line 6703 "x86id.c"
yy858:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy882;
	if(yych == 'u')	goto yy882;
	goto yy239;
yy859:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '\000')	goto yy860;
		if(yych <= 'K')	goto yy238;
		goto yy880;
	} else {
		if(yych == 'l')	goto yy880;
		goto yy238;
	}
yy860:
#line 2799 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 5; return YASM_ARCH_CHECK_ID_REG; }
#line 6720 "x86id.c"
yy861:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'Q'){
			if(yych == 'F')	goto yy872;
			goto yy239;
		} else {
			if(yych <= 'R')	goto yy874;
			if(yych <= 'V')	goto yy239;
			goto yy876;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'f')	goto yy872;
			goto yy239;
		} else {
			if(yych <= 'r')	goto yy874;
			if(yych == 'w')	goto yy876;
			goto yy239;
		}
	}
yy862:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'C'){
			if(yych <= '\000')	goto yy863;
			if(yych <= 'B')	goto yy238;
			goto yy866;
		} else {
			if(yych <= 'Q')	goto yy238;
			if(yych <= 'R')	goto yy868;
			goto yy870;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'c')	goto yy866;
			goto yy238;
		} else {
			if(yych <= 'r')	goto yy868;
			if(yych <= 's')	goto yy870;
			goto yy238;
		}
	}
yy863:
#line 3314 "./modules/arch/x86/x86id.re"
{ RET_INSN(bittest, 0x04A3, CPU_386); }
#line 6765 "x86id.c"
yy864:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2797 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 3; return YASM_ARCH_CHECK_ID_REG; }
#line 6771 "x86id.c"
yy866:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3315 "./modules/arch/x86/x86id.re"
{ RET_INSN(bittest, 0x07BB, CPU_386); }
#line 6777 "x86id.c"
yy868:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3316 "./modules/arch/x86/x86id.re"
{ RET_INSN(bittest, 0x06B3, CPU_386); }
#line 6783 "x86id.c"
yy870:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3317 "./modules/arch/x86/x86id.re"
{ RET_INSN(bittest, 0x05AB, CPU_386); }
#line 6789 "x86id.c"
yy872:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3312 "./modules/arch/x86/x86id.re"
{ RET_INSN(bsfr, 0xBC, CPU_386); }
#line 6795 "x86id.c"
yy874:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3313 "./modules/arch/x86/x86id.re"
{ RET_INSN(bsfr, 0xBD, CPU_386); }
#line 6801 "x86id.c"
yy876:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy877;
	if(yych != 'a')	goto yy239;
yy877:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy878;
	if(yych != 'p')	goto yy239;
yy878:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3458 "./modules/arch/x86/x86id.re"
{ RET_INSN(bswap, 0, CPU_486); }
#line 6813 "x86id.c"
yy880:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2838 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG8X | 5;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 6827 "x86id.c"
yy882:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy883;
	if(yych != 'n')	goto yy239;
yy883:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy884;
	if(yych != 'd')	goto yy239;
yy884:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3342 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(bound, 0, CPU_186);
	}
#line 6845 "x86id.c"
yy886:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy915;
	if(yych == 'x')	goto yy915;
	goto yy239;
yy887:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == 'P')	goto yy913;
		if(yych <= 'W')	goto yy239;
		goto yy911;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
			goto yy913;
		} else {
			if(yych == 'x')	goto yy911;
			goto yy239;
		}
	}
yy888:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy909;
	if(yych == 'x')	goto yy909;
	goto yy239;
yy889:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == 'I')	goto yy907;
		if(yych <= 'W')	goto yy239;
		goto yy905;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy239;
			goto yy907;
		} else {
			if(yych == 'x')	goto yy905;
			goto yy239;
		}
	}
yy890:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy902;
	if(yych == 'm')	goto yy902;
	goto yy239;
yy891:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy898;
	if(yych == 't')	goto yy898;
	goto yy239;
yy892:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= 'H'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'I')	goto yy896;
			if(yych <= 'O')	goto yy238;
			goto yy894;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy238;
			goto yy896;
		} else {
			if(yych == 'p')	goto yy894;
			goto yy238;
		}
	}

#line 2885 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64)
		yasm__warning(YASM_WARN_GENERAL, line,
		    N_("`%s' segment register ignored in 64-bit mode"), oid);
	    data[0] = 0x2600;
	    return YASM_ARCH_CHECK_ID_SEGREG;
	}
#line 6917 "x86id.c"
yy894:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2771 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 4; return YASM_ARCH_CHECK_ID_REG; }
#line 6923 "x86id.c"
yy896:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2773 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 6; return YASM_ARCH_CHECK_ID_REG; }
#line 6929 "x86id.c"
yy898:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy899;
	if(yych != 'e')	goto yy239;
yy899:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy900;
	if(yych != 'r')	goto yy239;
yy900:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3162 "./modules/arch/x86/x86id.re"
{ RET_INSN(enter, 0, CPU_186); }
#line 6941 "x86id.c"
yy902:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy903;
	if(yych != 's')	goto yy239;
yy903:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3541 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F77, CPU_MMX); }
#line 6950 "x86id.c"
yy905:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2769 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 2; return YASM_ARCH_CHECK_ID_REG; }
#line 6956 "x86id.c"
yy907:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2774 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 7; return YASM_ARCH_CHECK_ID_REG; }
#line 6962 "x86id.c"
yy909:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2768 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 1; return YASM_ARCH_CHECK_ID_REG; }
#line 6968 "x86id.c"
yy911:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2770 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 3; return YASM_ARCH_CHECK_ID_REG; }
#line 6974 "x86id.c"
yy913:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2772 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 5; return YASM_ARCH_CHECK_ID_REG; }
#line 6980 "x86id.c"
yy915:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2767 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG32 | 0; return YASM_ARCH_CHECK_ID_REG; }
#line 6986 "x86id.c"
yy917:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy946;
	if(yych == 'd')	goto yy946;
	goto yy239;
yy918:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy943;
	if(yych == 't')	goto yy943;
	goto yy239;
yy919:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy940;
	if(yych == 'h')	goto yy940;
	goto yy239;
yy920:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy936;
	if(yych == 'a')	goto yy936;
	goto yy239;
yy921:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy930;
	if(yych == 'm')	goto yy930;
	goto yy239;
yy922:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy923;
	if(yych != 'r')	goto yy239;
yy923:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy924;
		if(yych <= 'O')	goto yy238;
		goto yy925;
	} else {
		if(yych == 'p')	goto yy925;
		goto yy238;
	}
yy924:
#line 3071 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0630, CPU_Any); }
#line 7022 "x86id.c"
yy925:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy928;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy928;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3671 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x57, CPU_SSE); }
#line 7040 "x86id.c"
yy928:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3723 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6657, CPU_SSE2); }
#line 7046 "x86id.c"
yy930:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy239;
	if(yych == '1')	goto yy933;
	if(yych >= ':')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;
yy932:
#line 2655 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64 &&
		(oid[3] == '8' || oid[3] == '9')) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_XMMREG | (oid[3]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 7065 "x86id.c"
yy933:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy932;
	if(yych <= '/')	goto yy238;
	if(yych >= '6')	goto yy238;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2665 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_XMMREG | (10+oid[4]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 7083 "x86id.c"
yy936:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy937;
	if(yych != 't')	goto yy239;
yy937:	yych = *++YYCURSOR;
	if(yych <= 'B'){
		if(yych <= '\000')	goto yy938;
		if(yych <= 'A')	goto yy238;
		goto yy939;
	} else {
		if(yych == 'b')	goto yy939;
		goto yy238;
	}
yy938:
#line 3310 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00D7, CPU_Any); }
#line 7099 "x86id.c"
yy939:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy938;
	goto yy238;
yy940:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy941;
	if(yych != 'g')	goto yy239;
yy941:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2984 "./modules/arch/x86/x86id.re"
{ RET_INSN(xchg, 0, CPU_Any); }
#line 7111 "x86id.c"
yy943:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy944;
	if(yych != 's')	goto yy239;
yy944:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3830 "./modules/arch/x86/x86id.re"
{ RET_INSN(xbts, 0, CPU_386|CPU_Undoc|CPU_Obs); }
#line 7120 "x86id.c"
yy946:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy947;
	if(yych != 'd')	goto yy239;
yy947:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3459 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmpxchgxadd, 0xC0, CPU_486); }
#line 7129 "x86id.c"
yy949:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == 'S')	goto yy1075;
		if(yych <= 'W')	goto yy239;
		goto yy1076;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy239;
			goto yy1075;
		} else {
			if(yych == 'x')	goto yy1076;
			goto yy239;
		}
	}
yy950:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1070;
	if(yych == 'e')	goto yy1070;
	goto yy239;
yy951:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1059;
	if(yych == 'n')	goto yy1059;
	goto yy239;
yy952:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy239;
	if(yych <= '7')	goto yy1057;
	goto yy239;
yy953:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy967;
	if(yych == 'v')	goto yy967;
	goto yy239;
yy954:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy955;
	if(yych != 'l')	goto yy239;
yy955:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'O'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'P')	goto yy957;
			if(yych <= 'R')	goto yy238;
			goto yy958;
		}
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy238;
			goto yy957;
		} else {
			if(yych == 's')	goto yy958;
			goto yy238;
		}
	}

#line 3141 "./modules/arch/x86/x86id.re"
{ RET_INSN(f6, 0x04, CPU_Any); }
#line 7184 "x86id.c"
yy957:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy965;
		if(yych <= 'R')	goto yy239;
		goto yy963;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy965;
		} else {
			if(yych == 's')	goto yy963;
			goto yy239;
		}
	}
yy958:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy961;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy961;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3639 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF359, CPU_SSE); }
#line 7216 "x86id.c"
yy961:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3713 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF259, CPU_SSE2); }
#line 7222 "x86id.c"
yy963:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3638 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x59, CPU_SSE); }
#line 7228 "x86id.c"
yy965:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3712 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6659, CPU_SSE2); }
#line 7234 "x86id.c"
yy967:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= 'L'){
			if(yych <= 'C'){
				if(yych <= '\000')	goto yy968;
				if(yych == 'A')	goto yy969;
				goto yy238;
			} else {
				if(yych <= 'G'){
					if(yych <= 'D')	goto yy970;
					goto yy238;
				} else {
					if(yych <= 'H')	goto yy972;
					if(yych <= 'K')	goto yy238;
					goto yy973;
				}
			}
		} else {
			if(yych <= 'R'){
				if(yych <= 'N'){
					if(yych <= 'M')	goto yy974;
					goto yy975;
				} else {
					if(yych == 'Q')	goto yy976;
					goto yy238;
				}
			} else {
				if(yych <= 'T'){
					if(yych <= 'S')	goto yy978;
					goto yy238;
				} else {
					if(yych <= 'U')	goto yy979;
					if(yych <= 'Y')	goto yy238;
					goto yy980;
				}
			}
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'd'){
				if(yych == 'a')	goto yy969;
				if(yych <= 'c')	goto yy238;
				goto yy970;
			} else {
				if(yych <= 'h'){
					if(yych <= 'g')	goto yy238;
					goto yy972;
				} else {
					if(yych <= 'k')	goto yy238;
					if(yych <= 'l')	goto yy973;
					goto yy974;
				}
			}
		} else {
			if(yych <= 's'){
				if(yych <= 'p'){
					if(yych <= 'n')	goto yy975;
					goto yy238;
				} else {
					if(yych <= 'q')	goto yy976;
					if(yych <= 'r')	goto yy238;
					goto yy978;
				}
			} else {
				if(yych <= 'u'){
					if(yych <= 't')	goto yy238;
					goto yy979;
				} else {
					if(yych == 'z')	goto yy980;
					goto yy238;
				}
			}
		}
	}
yy968:
#line 2924 "./modules/arch/x86/x86id.re"
{ RET_INSN(mov, 0, CPU_Any); }
#line 7312 "x86id.c"
yy969:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1052;
	if(yych == 'p')	goto yy1052;
	goto yy239;
yy970:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '\000')	goto yy971;
		if(yych <= 'P')	goto yy238;
		goto yy1044;
	} else {
		if(yych == 'q')	goto yy1044;
		goto yy238;
	}
yy971:
#line 3542 "./modules/arch/x86/x86id.re"
{ RET_INSN(movd, 0, CPU_MMX); }
#line 7329 "x86id.c"
yy972:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'L')	goto yy1035;
		if(yych <= 'O')	goto yy239;
		goto yy1036;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy239;
			goto yy1035;
		} else {
			if(yych == 'p')	goto yy1036;
			goto yy239;
		}
	}
yy973:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'H')	goto yy1026;
		if(yych <= 'O')	goto yy239;
		goto yy1027;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy239;
			goto yy1026;
		} else {
			if(yych == 'p')	goto yy1027;
			goto yy239;
		}
	}
yy974:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1019;
	if(yych == 's')	goto yy1019;
	goto yy239;
yy975:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1006;
	if(yych == 't')	goto yy1006;
	goto yy239;
yy976:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy977;
	if(yych == '2')	goto yy1002;
	goto yy238;
yy977:
#line 3543 "./modules/arch/x86/x86id.re"
{ RET_INSN(movq, 0, CPU_MMX); }
#line 7373 "x86id.c"
yy978:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy990;
	case 'D':	case 'd':	goto yy994;
	case 'Q':	case 'q':	goto yy996;
	case 'S':	case 's':	goto yy998;
	case 'W':	case 'w':	goto yy992;
	case 'X':	case 'x':	goto yy988;
	default:	goto yy239;
	}
yy979:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy983;
	if(yych == 'p')	goto yy983;
	goto yy239;
yy980:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy981;
	if(yych != 'x')	goto yy239;
yy981:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2936 "./modules/arch/x86/x86id.re"
{ RET_INSN(movszx, 0xB6, CPU_386); }
#line 7396 "x86id.c"
yy983:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy984;
		if(yych <= 'R')	goto yy239;
		goto yy986;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy986;
			goto yy239;
		}
	}
yy984:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3711 "./modules/arch/x86/x86id.re"
{ RET_INSN(movaupd, 0x10, CPU_SSE2); }
#line 7415 "x86id.c"
yy986:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3637 "./modules/arch/x86/x86id.re"
{ RET_INSN(movaups, 0x10, CPU_SSE); }
#line 7421 "x86id.c"
yy988:	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= '\000')	goto yy989;
		if(yych <= 'C')	goto yy238;
		goto yy1000;
	} else {
		if(yych == 'd')	goto yy1000;
		goto yy238;
	}
yy989:
#line 2926 "./modules/arch/x86/x86id.re"
{ RET_INSN(movszx, 0xBE, CPU_386); }
#line 7434 "x86id.c"
yy990:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3274 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00A4, CPU_Any); }
#line 7440 "x86id.c"
yy992:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3275 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x10A5, CPU_Any); }
#line 7446 "x86id.c"
yy994:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3276 "./modules/arch/x86/x86id.re"
{ RET_INSN(movsd, 0, CPU_Any); }
#line 7452 "x86id.c"
yy996:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3277 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x40A5, CPU_Any);
	}
#line 7466 "x86id.c"
yy998:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3636 "./modules/arch/x86/x86id.re"
{ RET_INSN(movss, 0, CPU_SSE); }
#line 7472 "x86id.c"
yy1000:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2927 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(movsxd, 0, CPU_Hammer|CPU_64);
	}
#line 7486 "x86id.c"
yy1002:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1003;
	if(yych != 'd')	goto yy239;
yy1003:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1004;
	if(yych != 'q')	goto yy239;
yy1004:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3742 "./modules/arch/x86/x86id.re"
{ RET_INSN(movq2dq, 0, CPU_SSE2); }
#line 7498 "x86id.c"
yy1006:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= 'H'){
			if(yych != 'D')	goto yy239;
		} else {
			if(yych <= 'I')	goto yy1008;
			if(yych <= 'O')	goto yy239;
			if(yych <= 'P')	goto yy1010;
			goto yy1011;
		}
	} else {
		if(yych <= 'i'){
			if(yych == 'd')	goto yy1007;
			if(yych <= 'h')	goto yy239;
			goto yy1008;
		} else {
			if(yych <= 'o')	goto yy239;
			if(yych <= 'p')	goto yy1010;
			if(yych <= 'q')	goto yy1011;
			goto yy239;
		}
	}
yy1007:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1017;
	if(yych == 'q')	goto yy1017;
	goto yy239;
yy1008:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3535 "./modules/arch/x86/x86id.re"
{ RET_INSN(movnti, 0, CPU_P4); }
#line 7530 "x86id.c"
yy1010:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1015;
		if(yych <= 'R')	goto yy239;
		goto yy1013;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1015;
		} else {
			if(yych == 's')	goto yy1013;
			goto yy239;
		}
	}
yy1011:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3635 "./modules/arch/x86/x86id.re"
{ RET_INSN(movntq, 0, CPU_SSE); }
#line 7550 "x86id.c"
yy1013:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3634 "./modules/arch/x86/x86id.re"
{ RET_INSN(movntps, 0, CPU_SSE); }
#line 7556 "x86id.c"
yy1015:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3708 "./modules/arch/x86/x86id.re"
{ RET_INSN(movntpddq, 0x2B, CPU_SSE2); }
#line 7562 "x86id.c"
yy1017:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3709 "./modules/arch/x86/x86id.re"
{ RET_INSN(movntpddq, 0xE7, CPU_SSE2); }
#line 7568 "x86id.c"
yy1019:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy1020;
	if(yych != 'k')	goto yy239;
yy1020:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1021;
	if(yych != 'p')	goto yy239;
yy1021:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1022;
		if(yych <= 'R')	goto yy239;
		goto yy1024;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1024;
			goto yy239;
		}
	}
yy1022:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3707 "./modules/arch/x86/x86id.re"
{ RET_INSN(movmskpd, 0, CPU_SSE2); }
#line 7593 "x86id.c"
yy1024:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3633 "./modules/arch/x86/x86id.re"
{ RET_INSN(movmskps, 0, CPU_SSE); }
#line 7599 "x86id.c"
yy1026:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1032;
	if(yych == 'p')	goto yy1032;
	goto yy239;
yy1027:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1028;
		if(yych <= 'R')	goto yy239;
		goto yy1030;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1030;
			goto yy239;
		}
	}
yy1028:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3706 "./modules/arch/x86/x86id.re"
{ RET_INSN(movhlpd, 0x12, CPU_SSE2); }
#line 7622 "x86id.c"
yy1030:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3632 "./modules/arch/x86/x86id.re"
{ RET_INSN(movhlps, 0x12, CPU_SSE); }
#line 7628 "x86id.c"
yy1032:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1033;
	if(yych != 's')	goto yy239;
yy1033:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3631 "./modules/arch/x86/x86id.re"
{ RET_INSN(movhllhps, 0x16, CPU_SSE); }
#line 7637 "x86id.c"
yy1035:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1041;
	if(yych == 'p')	goto yy1041;
	goto yy239;
yy1036:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1037;
		if(yych <= 'R')	goto yy239;
		goto yy1039;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1039;
			goto yy239;
		}
	}
yy1037:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3705 "./modules/arch/x86/x86id.re"
{ RET_INSN(movhlpd, 0x16, CPU_SSE2); }
#line 7660 "x86id.c"
yy1039:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3630 "./modules/arch/x86/x86id.re"
{ RET_INSN(movhlps, 0x16, CPU_SSE); }
#line 7666 "x86id.c"
yy1041:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1042;
	if(yych != 's')	goto yy239;
yy1042:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3629 "./modules/arch/x86/x86id.re"
{ RET_INSN(movhllhps, 0x12, CPU_SSE); }
#line 7675 "x86id.c"
yy1044:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= '2'){
			if(yych <= '1')	goto yy239;
		} else {
			if(yych == 'A')	goto yy1046;
			goto yy239;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'U')	goto yy1048;
			if(yych <= '`')	goto yy239;
			goto yy1046;
		} else {
			if(yych == 'u')	goto yy1048;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1050;
	if(yych == 'q')	goto yy1050;
	goto yy239;
yy1046:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3739 "./modules/arch/x86/x86id.re"
{ RET_INSN(movdqau, 0x66, CPU_SSE2); }
#line 7703 "x86id.c"
yy1048:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3740 "./modules/arch/x86/x86id.re"
{ RET_INSN(movdqau, 0xF3, CPU_SSE2); }
#line 7709 "x86id.c"
yy1050:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3741 "./modules/arch/x86/x86id.re"
{ RET_INSN(movdq2q, 0, CPU_SSE2); }
#line 7715 "x86id.c"
yy1052:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1053;
		if(yych <= 'R')	goto yy239;
		goto yy1055;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1055;
			goto yy239;
		}
	}
yy1053:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3704 "./modules/arch/x86/x86id.re"
{ RET_INSN(movaupd, 0x28, CPU_SSE2); }
#line 7734 "x86id.c"
yy1055:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3628 "./modules/arch/x86/x86id.re"
{ RET_INSN(movaups, 0x28, CPU_SSE); }
#line 7740 "x86id.c"
yy1057:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2651 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_MMXREG | (oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 7749 "x86id.c"
yy1059:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1060;
		if(yych <= 'R')	goto yy239;
		goto yy1061;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1061;
			goto yy239;
		}
	}
yy1060:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1068;
		if(yych <= 'R')	goto yy239;
		goto yy1066;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1068;
		} else {
			if(yych == 's')	goto yy1066;
			goto yy239;
		}
	}
yy1061:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1064;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1064;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3627 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF35D, CPU_SSE); }
#line 7794 "x86id.c"
yy1064:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3703 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF25D, CPU_SSE2); }
#line 7800 "x86id.c"
yy1066:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3626 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x5D, CPU_SSE); }
#line 7806 "x86id.c"
yy1068:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3702 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x665D, CPU_SSE2); }
#line 7812 "x86id.c"
yy1070:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1071;
	if(yych != 'n')	goto yy239;
yy1071:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1072;
	if(yych != 'c')	goto yy239;
yy1072:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1073;
	if(yych != 'e')	goto yy239;
yy1073:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3538 "./modules/arch/x86/x86id.re"
{ RET_INSN(threebyte, 0x0FAEF0, CPU_P3); }
#line 7827 "x86id.c"
yy1075:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy1087;
	if(yych == 'k')	goto yy1087;
	goto yy239;
yy1076:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1077;
		if(yych <= 'R')	goto yy239;
		goto yy1078;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1078;
			goto yy239;
		}
	}
yy1077:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1085;
		if(yych <= 'R')	goto yy239;
		goto yy1083;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1085;
		} else {
			if(yych == 's')	goto yy1083;
			goto yy239;
		}
	}
yy1078:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1081;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1081;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3625 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF35F, CPU_SSE); }
#line 7876 "x86id.c"
yy1081:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3701 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF25F, CPU_SSE2); }
#line 7882 "x86id.c"
yy1083:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3624 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x5F, CPU_SSE); }
#line 7888 "x86id.c"
yy1085:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3700 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x665F, CPU_SSE2); }
#line 7894 "x86id.c"
yy1087:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1088;
	if(yych != 'm')	goto yy239;
yy1088:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1089;
	if(yych != 'o')	goto yy239;
yy1089:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1090;
	if(yych != 'v')	goto yy239;
yy1090:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych == 'D')	goto yy1091;
		if(yych <= 'P')	goto yy239;
		goto yy1092;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'q')	goto yy1092;
			goto yy239;
		}
	}
yy1091:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1094;
	if(yych == 'q')	goto yy1094;
	goto yy239;
yy1092:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3623 "./modules/arch/x86/x86id.re"
{ RET_INSN(maskmovq, 0, CPU_P3|CPU_MMX); }
#line 7926 "x86id.c"
yy1094:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy1095;
	if(yych != 'u')	goto yy239;
yy1095:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3738 "./modules/arch/x86/x86id.re"
{ RET_INSN(maskmovdqu, 0, CPU_SSE2); }
#line 7935 "x86id.c"
yy1097:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'A')	goto yy1128;
		if(yych <= 'R')	goto yy239;
		goto yy1130;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy239;
			goto yy1128;
		} else {
			if(yych == 's')	goto yy1130;
			goto yy239;
		}
	}
yy1098:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1126;
	if(yych == 'c')	goto yy1126;
	goto yy239;
yy1099:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2827 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 6; return YASM_ARCH_CHECK_ID_REG; }
#line 7959 "x86id.c"
yy1101:	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'K'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'L')	goto yy1112;
			if(yych <= 'U')	goto yy238;
			goto yy1114;
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy238;
			goto yy1112;
		} else {
			if(yych == 'v')	goto yy1114;
			goto yy238;
		}
	}

#line 2801 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 7; return YASM_ARCH_CHECK_ID_REG; }
#line 7981 "x86id.c"
yy1103:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2823 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 2; return YASM_ARCH_CHECK_ID_REG; }
#line 7987 "x86id.c"
yy1105:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy239;
	if(yych <= '7')	goto yy1110;
	goto yy239;
yy1106:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2900 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64)
		yasm__warning(YASM_WARN_GENERAL, line,
		    N_("`%s' segment register ignored in 64-bit mode"), oid);
	    data[0] = 0x3e03;
	    return YASM_ARCH_CHECK_ID_SEGREG;
	}
#line 8003 "x86id.c"
yy1108:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2796 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 2; return YASM_ARCH_CHECK_ID_REG; }
#line 8009 "x86id.c"
yy1110:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2637 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_DRREG | (oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 8018 "x86id.c"
yy1112:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2856 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG8X | 7;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 8032 "x86id.c"
yy1114:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'O'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'P')	goto yy1116;
			if(yych <= 'R')	goto yy238;
			goto yy1117;
		}
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy238;
			goto yy1116;
		} else {
			if(yych == 's')	goto yy1117;
			goto yy238;
		}
	}

#line 3143 "./modules/arch/x86/x86id.re"
{ RET_INSN(f6, 0x06, CPU_Any); }
#line 8054 "x86id.c"
yy1116:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1124;
		if(yych <= 'R')	goto yy239;
		goto yy1122;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1124;
		} else {
			if(yych == 's')	goto yy1122;
			goto yy239;
		}
	}
yy1117:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1120;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1120;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3621 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF35E, CPU_SSE); }
#line 8086 "x86id.c"
yy1120:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3699 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF25E, CPU_SSE2); }
#line 8092 "x86id.c"
yy1122:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3620 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x5E, CPU_SSE); }
#line 8098 "x86id.c"
yy1124:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3698 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x665E, CPU_SSE2); }
#line 8104 "x86id.c"
yy1126:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3065 "./modules/arch/x86/x86id.re"
{ RET_INSN(incdec, 0x0148, CPU_Any); }
#line 8110 "x86id.c"
yy1128:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3089 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x0027, CPU_Any);
	}
#line 8122 "x86id.c"
yy1130:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3096 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x002F, CPU_Any);
	}
#line 8134 "x86id.c"
yy1132:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1471;
	if(yych == 'l')	goto yy1471;
	goto yy239;
yy1133:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1469;
	if(yych == 'w')	goto yy1469;
	goto yy239;
yy1134:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych == 'O')	goto yy1465;
		if(yych <= 'P')	goto yy239;
		goto yy1463;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy239;
			goto yy1465;
		} else {
			if(yych == 'q')	goto yy1463;
			goto yy239;
		}
	}
yy1135:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2826 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 5; return YASM_ARCH_CHECK_ID_REG; }
#line 8162 "x86id.c"
yy1137:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'E'){
			if(yych <= 'B'){
				if(yych >= '\001')	goto yy238;
			} else {
				if(yych <= 'C')	goto yy1448;
				if(yych <= 'D')	goto yy1450;
				goto yy238;
			}
		} else {
			if(yych <= 'H'){
				if(yych <= 'F')	goto yy1455;
				goto yy238;
			} else {
				if(yych <= 'I')	goto yy1452;
				if(yych <= 'S')	goto yy238;
				goto yy1454;
			}
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'c'){
				if(yych <= 'b')	goto yy238;
				goto yy1448;
			} else {
				if(yych <= 'd')	goto yy1450;
				if(yych <= 'e')	goto yy238;
				goto yy1455;
			}
		} else {
			if(yych <= 'i'){
				if(yych <= 'h')	goto yy238;
				goto yy1452;
			} else {
				if(yych == 't')	goto yy1454;
				goto yy238;
			}
		}
	}

#line 2822 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 1; return YASM_ARCH_CHECK_ID_REG; }
#line 8206 "x86id.c"
yy1139:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= 'C'){
			if(yych <= 'B')	goto yy239;
			goto yy1254;
		} else {
			if(yych <= 'N')	goto yy239;
			if(yych <= 'O')	goto yy1258;
			goto yy1256;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'c')	goto yy1254;
			goto yy239;
		} else {
			if(yych <= 'o')	goto yy1258;
			if(yych <= 'p')	goto yy1256;
			goto yy239;
		}
	}
yy1140:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1247;
	if(yych == 'm')	goto yy1247;
	goto yy239;
yy1141:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy1243;
	if(yych == 'u')	goto yy1243;
	goto yy239;
yy1142:	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych == '0')	goto yy1241;
		goto yy239;
	} else {
		if(yych <= '4')	goto yy1241;
		if(yych == '8')	goto yy1241;
		goto yy239;
	}
yy1143:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2892 "./modules/arch/x86/x86id.re"
{ data[0] = 0x2e01; return YASM_ARCH_CHECK_ID_SEGREG; }
#line 8249 "x86id.c"
yy1145:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1153;
	if(yych == 't')	goto yy1153;
	goto yy239;
yy1146:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1149;
	if(yych == 'd')	goto yy1149;
	goto yy239;
yy1147:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2795 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 1; return YASM_ARCH_CHECK_ID_REG; }
#line 8263 "x86id.c"
yy1149:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1150;
		if(yych <= 'D')	goto yy238;
		goto yy1151;
	} else {
		if(yych == 'e')	goto yy1151;
		goto yy238;
	}
yy1150:
#line 3129 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x1099, CPU_Any); }
#line 8276 "x86id.c"
yy1151:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3119 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x2098, CPU_386); }
#line 8282 "x86id.c"
yy1153:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'O'){
			if(yych != 'D')	goto yy239;
		} else {
			if(yych <= 'P')	goto yy1155;
			if(yych <= 'R')	goto yy239;
			if(yych <= 'S')	goto yy1156;
			goto yy1157;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'd')	goto yy1154;
			if(yych <= 'o')	goto yy239;
			goto yy1155;
		} else {
			if(yych <= 'r')	goto yy239;
			if(yych <= 's')	goto yy1156;
			if(yych <= 't')	goto yy1157;
			goto yy239;
		}
	}
yy1154:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1234;
	if(yych == 'q')	goto yy1234;
	goto yy239;
yy1155:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'H'){
			if(yych == 'D')	goto yy1209;
			goto yy239;
		} else {
			if(yych <= 'I')	goto yy1207;
			if(yych <= 'R')	goto yy239;
			goto yy1208;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'd')	goto yy1209;
			goto yy239;
		} else {
			if(yych <= 'i')	goto yy1207;
			if(yych == 's')	goto yy1208;
			goto yy239;
		}
	}
yy1156:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'H'){
			if(yych == 'D')	goto yy1188;
			goto yy239;
		} else {
			if(yych <= 'I')	goto yy1186;
			if(yych <= 'R')	goto yy239;
			goto yy1187;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'd')	goto yy1188;
			goto yy239;
		} else {
			if(yych <= 'i')	goto yy1186;
			if(yych == 's')	goto yy1187;
			goto yy239;
		}
	}
yy1157:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1158;
		if(yych <= 'R')	goto yy239;
		goto yy1159;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1159;
			goto yy239;
		}
	}
yy1158:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1170;
		if(yych <= 'R')	goto yy239;
		goto yy1171;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1170;
		} else {
			if(yych == 's')	goto yy1171;
			goto yy239;
		}
	}
yy1159:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1160;
		if(yych <= 'R')	goto yy239;
		goto yy1161;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1161;
			goto yy239;
		}
	}
yy1160:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1166;
	goto yy239;
yy1161:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy239;
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1163;
	if(yych != 's')	goto yy239;
yy1163:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1164;
	if(yych != 'i')	goto yy239;
yy1164:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3619 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_r32_xmm32, 0xF32C, CPU_SSE); }
#line 8405 "x86id.c"
yy1166:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1167;
	if(yych != 's')	goto yy239;
yy1167:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1168;
	if(yych != 'i')	goto yy239;
yy1168:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3735 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_r32_xmm64, 0xF22C, CPU_SSE2); }
#line 8417 "x86id.c"
yy1170:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1179;
	goto yy239;
yy1171:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy239;
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'D')	goto yy1173;
		if(yych <= 'O')	goto yy239;
		goto yy1174;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'p')	goto yy1174;
			goto yy239;
		}
	}
yy1173:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1177;
	if(yych == 'q')	goto yy1177;
	goto yy239;
yy1174:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1175;
	if(yych != 'i')	goto yy239;
yy1175:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3618 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_mm_xmm64, 0x2C, CPU_SSE); }
#line 8448 "x86id.c"
yy1177:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3737 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF35B, CPU_SSE2); }
#line 8454 "x86id.c"
yy1179:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'D')	goto yy1180;
		if(yych <= 'O')	goto yy239;
		goto yy1181;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'p')	goto yy1181;
			goto yy239;
		}
	}
yy1180:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1184;
	if(yych == 'q')	goto yy1184;
	goto yy239;
yy1181:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1182;
	if(yych != 'i')	goto yy239;
yy1182:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3734 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_mm_xmm, 0x662C, CPU_SSE2); }
#line 8480 "x86id.c"
yy1184:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3736 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x66E6, CPU_SSE2); }
#line 8486 "x86id.c"
yy1186:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1201;
	goto yy239;
yy1187:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1195;
	goto yy239;
yy1188:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy239;
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1190;
	if(yych != 's')	goto yy239;
yy1190:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'I')	goto yy1191;
		if(yych <= 'R')	goto yy239;
		goto yy1193;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy239;
		} else {
			if(yych == 's')	goto yy1193;
			goto yy239;
		}
	}
yy1191:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3731 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_r32_xmm64, 0xF22D, CPU_SSE2); }
#line 8516 "x86id.c"
yy1193:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3732 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_xmm64_ss, 0xF25A, CPU_SSE2); }
#line 8522 "x86id.c"
yy1195:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1196;
	if(yych != 's')	goto yy239;
yy1196:	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych == 'D')	goto yy1197;
		if(yych <= 'H')	goto yy239;
		goto yy1199;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'i')	goto yy1199;
			goto yy239;
		}
	}
yy1197:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3733 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_xmm32, 0xF35A, CPU_SSE2); }
#line 8544 "x86id.c"
yy1199:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3617 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_r32_xmm32, 0xF32D, CPU_SSE); }
#line 8550 "x86id.c"
yy1201:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1202;
	if(yych != 's')	goto yy239;
yy1202:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1203;
		if(yych <= 'R')	goto yy239;
		goto yy1205;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1205;
			goto yy239;
		}
	}
yy1203:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3697 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_rm32, 0xF22A, CPU_SSE2); }
#line 8572 "x86id.c"
yy1205:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3616 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_rm32, 0xF32A, CPU_SSE); }
#line 8578 "x86id.c"
yy1207:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1228;
	goto yy239;
yy1208:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1219;
	goto yy239;
yy1209:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy239;
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'D')	goto yy1211;
		if(yych <= 'O')	goto yy239;
		goto yy1212;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 'p')	goto yy1212;
			goto yy239;
		}
	}
yy1211:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1217;
	if(yych == 'q')	goto yy1217;
	goto yy239;
yy1212:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'I')	goto yy1213;
		if(yych <= 'R')	goto yy239;
		goto yy1215;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy239;
		} else {
			if(yych == 's')	goto yy1215;
			goto yy239;
		}
	}
yy1213:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3727 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_mm_xmm, 0x662D, CPU_SSE2); }
#line 8622 "x86id.c"
yy1215:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3728 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x665A, CPU_SSE2); }
#line 8628 "x86id.c"
yy1217:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3725 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF2E6, CPU_SSE2); }
#line 8634 "x86id.c"
yy1219:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'D')	goto yy1221;
		if(yych <= 'O')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1221;
		} else {
			if(yych != 'p')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych == 'D')	goto yy1224;
		if(yych <= 'H')	goto yy239;
		goto yy1226;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1224;
		} else {
			if(yych == 'i')	goto yy1226;
			goto yy239;
		}
	}
yy1221:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1222;
	if(yych != 'q')	goto yy239;
yy1222:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3730 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x665B, CPU_SSE2); }
#line 8669 "x86id.c"
yy1224:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3729 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_xmm64_ps, 0x5A, CPU_SSE2); }
#line 8675 "x86id.c"
yy1226:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3615 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_mm_xmm64, 0x2D, CPU_SSE); }
#line 8681 "x86id.c"
yy1228:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1229;
	if(yych != 'p')	goto yy239;
yy1229:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1230;
		if(yych <= 'R')	goto yy239;
		goto yy1232;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1232;
			goto yy239;
		}
	}
yy1230:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3696 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_mm_ss, 0x662A, CPU_SSE2); }
#line 8703 "x86id.c"
yy1232:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3614 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_mm_ps, 0x2A, CPU_SSE); }
#line 8709 "x86id.c"
yy1234:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy239;
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1236;
	if(yych != 'p')	goto yy239;
yy1236:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1237;
		if(yych <= 'R')	goto yy239;
		goto yy1239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1239;
			goto yy239;
		}
	}
yy1237:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3724 "./modules/arch/x86/x86id.re"
{ RET_INSN(cvt_xmm_xmm64_ss, 0xF3E6, CPU_SSE2); }
#line 8733 "x86id.c"
yy1239:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3726 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x5B, CPU_SSE2); }
#line 8739 "x86id.c"
yy1241:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2628 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64 && oid[2] == '8') {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_CRREG | (oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 8753 "x86id.c"
yy1243:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1244;
	if(yych != 'i')	goto yy239;
yy1244:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1245;
	if(yych != 'd')	goto yy239;
yy1245:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3466 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0FA2, CPU_486); }
#line 8765 "x86id.c"
yy1247:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1248;
	if(yych != 'i')	goto yy239;
yy1248:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1249;
	if(yych != 's')	goto yy239;
yy1249:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1250;
		if(yych <= 'R')	goto yy239;
		goto yy1252;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1252;
			goto yy239;
		}
	}
yy1250:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3695 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x662F, CPU_SSE2); }
#line 8790 "x86id.c"
yy1252:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3613 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x2F, CPU_SSE); }
#line 8796 "x86id.c"
yy1254:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3013 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00F5, CPU_Any); }
#line 8802 "x86id.c"
yy1256:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= 'N'){
			if(yych <= 'E'){
				if(yych <= '\000')	goto yy1257;
				if(yych <= 'D')	goto yy238;
				goto yy1321;
			} else {
				if(yych == 'L')	goto yy1322;
				if(yych <= 'M')	goto yy238;
				goto yy1323;
			}
		} else {
			if(yych <= 'S'){
				if(yych <= 'O')	goto yy1324;
				if(yych <= 'P')	goto yy1325;
				if(yych <= 'R')	goto yy238;
				goto yy1326;
			} else {
				if(yych == 'U')	goto yy1327;
				if(yych <= 'W')	goto yy238;
				goto yy1328;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= 'k'){
				if(yych == 'e')	goto yy1321;
				goto yy238;
			} else {
				if(yych <= 'l')	goto yy1322;
				if(yych <= 'm')	goto yy238;
				if(yych <= 'n')	goto yy1323;
				goto yy1324;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'p')	goto yy1325;
				if(yych == 's')	goto yy1326;
				goto yy238;
			} else {
				if(yych <= 'u')	goto yy1327;
				if(yych == 'x')	goto yy1328;
				goto yy238;
			}
		}
	}
yy1257:
#line 3067 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0738, CPU_Any); }
#line 8853 "x86id.c"
yy1258:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1259;
	if(yych != 'v')	goto yy239;
yy1259:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy1267;
	case 'B':	case 'b':	goto yy1263;
	case 'C':	case 'c':	goto yy1265;
	case 'E':	case 'e':	goto yy1269;
	case 'G':	case 'g':	goto yy1279;
	case 'L':	case 'l':	goto yy1277;
	case 'N':	case 'n':	goto yy1262;
	case 'O':	case 'o':	goto yy1260;
	case 'P':	case 'p':	goto yy1275;
	case 'S':	case 's':	goto yy1273;
	case 'Z':	case 'z':	goto yy1271;
	default:	goto yy239;
	}
yy1260:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3492 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x00, CPU_686); }
#line 8877 "x86id.c"
yy1262:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy1293;
	case 'B':	case 'b':	goto yy1295;
	case 'C':	case 'c':	goto yy1297;
	case 'E':	case 'e':	goto yy1299;
	case 'G':	case 'g':	goto yy1301;
	case 'L':	case 'l':	goto yy1303;
	case 'O':	case 'o':	goto yy1305;
	case 'P':	case 'p':	goto yy1307;
	case 'S':	case 's':	goto yy1309;
	case 'Z':	case 'z':	goto yy1311;
	default:	goto yy239;
	}
yy1263:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1264;
		if(yych <= 'D')	goto yy238;
		goto yy1291;
	} else {
		if(yych == 'e')	goto yy1291;
		goto yy238;
	}
yy1264:
#line 3494 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x02, CPU_686); }
#line 8904 "x86id.c"
yy1265:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3495 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x02, CPU_686); }
#line 8910 "x86id.c"
yy1267:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1268;
		if(yych <= 'D')	goto yy238;
		goto yy1289;
	} else {
		if(yych == 'e')	goto yy1289;
		goto yy238;
	}
yy1268:
#line 3507 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x07, CPU_686); }
#line 8923 "x86id.c"
yy1269:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3500 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x04, CPU_686); }
#line 8929 "x86id.c"
yy1271:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3501 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x04, CPU_686); }
#line 8935 "x86id.c"
yy1273:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3508 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x08, CPU_686); }
#line 8941 "x86id.c"
yy1275:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'E')	goto yy1285;
			if(yych <= 'N')	goto yy238;
			goto yy1287;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy238;
			goto yy1285;
		} else {
			if(yych == 'o')	goto yy1287;
			goto yy238;
		}
	}

#line 3510 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0A, CPU_686); }
#line 8963 "x86id.c"
yy1277:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1278;
		if(yych <= 'D')	goto yy238;
		goto yy1283;
	} else {
		if(yych == 'e')	goto yy1283;
		goto yy238;
	}
yy1278:
#line 3514 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0C, CPU_686); }
#line 8976 "x86id.c"
yy1279:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1280;
		if(yych <= 'D')	goto yy238;
		goto yy1281;
	} else {
		if(yych == 'e')	goto yy1281;
		goto yy238;
	}
yy1280:
#line 3521 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0F, CPU_686); }
#line 8989 "x86id.c"
yy1281:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3517 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0D, CPU_686); }
#line 8995 "x86id.c"
yy1283:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3518 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0E, CPU_686); }
#line 9001 "x86id.c"
yy1285:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3511 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0A, CPU_686); }
#line 9007 "x86id.c"
yy1287:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3513 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0B, CPU_686); }
#line 9013 "x86id.c"
yy1289:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3499 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x03, CPU_686); }
#line 9019 "x86id.c"
yy1291:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3504 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x06, CPU_686); }
#line 9025 "x86id.c"
yy1293:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1294;
		if(yych <= 'D')	goto yy238;
		goto yy1319;
	} else {
		if(yych == 'e')	goto yy1319;
		goto yy238;
	}
yy1294:
#line 3505 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x06, CPU_686); }
#line 9038 "x86id.c"
yy1295:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1296;
		if(yych <= 'D')	goto yy238;
		goto yy1317;
	} else {
		if(yych == 'e')	goto yy1317;
		goto yy238;
	}
yy1296:
#line 3497 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x03, CPU_686); }
#line 9051 "x86id.c"
yy1297:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3498 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x03, CPU_686); }
#line 9057 "x86id.c"
yy1299:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3502 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x05, CPU_686); }
#line 9063 "x86id.c"
yy1301:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1302;
		if(yych <= 'D')	goto yy238;
		goto yy1315;
	} else {
		if(yych == 'e')	goto yy1315;
		goto yy238;
	}
yy1302:
#line 3519 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0E, CPU_686); }
#line 9076 "x86id.c"
yy1303:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1304;
		if(yych <= 'D')	goto yy238;
		goto yy1313;
	} else {
		if(yych == 'e')	goto yy1313;
		goto yy238;
	}
yy1304:
#line 3516 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0D, CPU_686); }
#line 9089 "x86id.c"
yy1305:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3493 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x01, CPU_686); }
#line 9095 "x86id.c"
yy1307:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3512 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0B, CPU_686); }
#line 9101 "x86id.c"
yy1309:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3509 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x09, CPU_686); }
#line 9107 "x86id.c"
yy1311:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3503 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x05, CPU_686); }
#line 9113 "x86id.c"
yy1313:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3520 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0F, CPU_686); }
#line 9119 "x86id.c"
yy1315:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3515 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x0C, CPU_686); }
#line 9125 "x86id.c"
yy1317:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3506 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x07, CPU_686); }
#line 9131 "x86id.c"
yy1319:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3496 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmovcc, 0x02, CPU_686); }
#line 9137 "x86id.c"
yy1321:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1437;
	if(yych == 'q')	goto yy1437;
	goto yy239;
yy1322:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'E')	goto yy1415;
		if(yych <= 'S')	goto yy239;
		goto yy1416;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
			goto yy1415;
		} else {
			if(yych == 't')	goto yy1416;
			goto yy239;
		}
	}
yy1323:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'E')	goto yy1380;
		if(yych <= 'K')	goto yy239;
		goto yy1381;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
			goto yy1380;
		} else {
			if(yych == 'l')	goto yy1381;
			goto yy239;
		}
	}
yy1324:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1368;
	if(yych == 'r')	goto yy1368;
	goto yy239;
yy1325:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1366;
		if(yych <= 'R')	goto yy239;
		goto yy1364;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1366;
		} else {
			if(yych == 's')	goto yy1364;
			goto yy239;
		}
	}
yy1326:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy1354;
	case 'D':	case 'd':	goto yy1358;
	case 'Q':	case 'q':	goto yy1360;
	case 'S':	case 's':	goto yy1362;
	case 'W':	case 'w':	goto yy1356;
	default:	goto yy239;
	}
yy1327:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1340;
	if(yych == 'n')	goto yy1340;
	goto yy239;
yy1328:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1329;
	if(yych != 'c')	goto yy239;
yy1329:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1330;
	if(yych != 'h')	goto yy239;
yy1330:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1331;
	if(yych != 'g')	goto yy239;
yy1331:	yych = *++YYCURSOR;
	if(yych <= '4'){
		if(yych <= '\000')	goto yy1332;
		if(yych <= '3')	goto yy238;
		goto yy1333;
	} else {
		if(yych == '8')	goto yy1334;
		goto yy238;
	}
yy1332:
#line 3460 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmpxchgxadd, 0xB0, CPU_486); }
#line 9222 "x86id.c"
yy1333:	yych = *++YYCURSOR;
	if(yych == '8')	goto yy1337;
	goto yy239;
yy1334:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1335;
	if(yych != 'b')	goto yy239;
yy1335:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3471 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmpxchg8b, 0, CPU_586); }
#line 9234 "x86id.c"
yy1337:	yych = *++YYCURSOR;
	if(yych != '6')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3461 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmpxchgxadd, 0xA6, CPU_486|CPU_Undoc); }
#line 9242 "x86id.c"
yy1340:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1341;
	if(yych != 'o')	goto yy239;
yy1341:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1342;
	if(yych != 'r')	goto yy239;
yy1342:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1343;
	if(yych != 'd')	goto yy239;
yy1343:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1344;
		if(yych <= 'R')	goto yy239;
		goto yy1345;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1345;
			goto yy239;
		}
	}
yy1344:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1350;
		if(yych <= 'R')	goto yy239;
		goto yy1352;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1350;
		} else {
			if(yych == 's')	goto yy1352;
			goto yy239;
		}
	}
yy1345:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1346;
		if(yych <= 'R')	goto yy239;
		goto yy1348;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1348;
			goto yy239;
		}
	}
yy1346:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3692 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x03F2, CPU_SSE2); }
#line 9297 "x86id.c"
yy1348:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3610 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x03F3, CPU_SSE); }
#line 9303 "x86id.c"
yy1350:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3691 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0366, CPU_SSE2); }
#line 9309 "x86id.c"
yy1352:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3609 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x03, CPU_SSE); }
#line 9315 "x86id.c"
yy1354:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3244 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00A6, CPU_Any); }
#line 9321 "x86id.c"
yy1356:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3245 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x10A7, CPU_Any); }
#line 9327 "x86id.c"
yy1358:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3246 "./modules/arch/x86/x86id.re"
{ RET_INSN(cmpsd, 0, CPU_Any); }
#line 9333 "x86id.c"
yy1360:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3247 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x40A7, CPU_Hammer|CPU_64);
	}
#line 9347 "x86id.c"
yy1362:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3612 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssessimm, 0xF3C2, CPU_SSE); }
#line 9353 "x86id.c"
yy1364:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3611 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssepsimm, 0xC2, CPU_SSE); }
#line 9359 "x86id.c"
yy1366:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3693 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssessimm, 0x66C2, CPU_SSE2); }
#line 9365 "x86id.c"
yy1368:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1369;
	if(yych != 'd')	goto yy239;
yy1369:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1370;
		if(yych <= 'R')	goto yy239;
		goto yy1371;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1371;
			goto yy239;
		}
	}
yy1370:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1376;
		if(yych <= 'R')	goto yy239;
		goto yy1378;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1376;
		} else {
			if(yych == 's')	goto yy1378;
			goto yy239;
		}
	}
yy1371:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1372;
		if(yych <= 'R')	goto yy239;
		goto yy1374;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1374;
			goto yy239;
		}
	}
yy1372:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3690 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x07F2, CPU_SSE2); }
#line 9414 "x86id.c"
yy1374:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3608 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x07F3, CPU_SSE); }
#line 9420 "x86id.c"
yy1376:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3689 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0766, CPU_SSE2); }
#line 9426 "x86id.c"
yy1378:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3607 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x07, CPU_SSE); }
#line 9432 "x86id.c"
yy1380:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy1404;
	if(yych == 'q')	goto yy1404;
	goto yy239;
yy1381:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'E')	goto yy1382;
		if(yych <= 'S')	goto yy239;
		goto yy1383;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
		} else {
			if(yych == 't')	goto yy1383;
			goto yy239;
		}
	}
yy1382:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1394;
		if(yych <= 'R')	goto yy239;
		goto yy1395;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
			goto yy1394;
		} else {
			if(yych == 's')	goto yy1395;
			goto yy239;
		}
	}
yy1383:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1384;
		if(yych <= 'R')	goto yy239;
		goto yy1385;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1385;
			goto yy239;
		}
	}
yy1384:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1390;
		if(yych <= 'R')	goto yy239;
		goto yy1392;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1390;
		} else {
			if(yych == 's')	goto yy1392;
			goto yy239;
		}
	}
yy1385:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1386;
		if(yych <= 'R')	goto yy239;
		goto yy1388;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1388;
			goto yy239;
		}
	}
yy1386:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3688 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x05F2, CPU_SSE2); }
#line 9509 "x86id.c"
yy1388:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3606 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x05F3, CPU_SSE); }
#line 9515 "x86id.c"
yy1390:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3687 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0566, CPU_SSE2); }
#line 9521 "x86id.c"
yy1392:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3605 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x05, CPU_SSE); }
#line 9527 "x86id.c"
yy1394:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1400;
		if(yych <= 'R')	goto yy239;
		goto yy1402;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1400;
		} else {
			if(yych == 's')	goto yy1402;
			goto yy239;
		}
	}
yy1395:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1396;
		if(yych <= 'R')	goto yy239;
		goto yy1398;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1398;
			goto yy239;
		}
	}
yy1396:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3686 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x06F2, CPU_SSE2); }
#line 9560 "x86id.c"
yy1398:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3604 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x06F3, CPU_SSE); }
#line 9566 "x86id.c"
yy1400:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3685 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0666, CPU_SSE2); }
#line 9572 "x86id.c"
yy1402:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3603 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x06, CPU_SSE); }
#line 9578 "x86id.c"
yy1404:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1405;
		if(yych <= 'R')	goto yy239;
		goto yy1406;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1406;
			goto yy239;
		}
	}
yy1405:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1411;
		if(yych <= 'R')	goto yy239;
		goto yy1413;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1411;
		} else {
			if(yych == 's')	goto yy1413;
			goto yy239;
		}
	}
yy1406:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1407;
		if(yych <= 'R')	goto yy239;
		goto yy1409;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1409;
			goto yy239;
		}
	}
yy1407:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3684 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x04F2, CPU_SSE2); }
#line 9624 "x86id.c"
yy1409:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3602 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x04F3, CPU_SSE); }
#line 9630 "x86id.c"
yy1411:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3683 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0466, CPU_SSE2); }
#line 9636 "x86id.c"
yy1413:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3601 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x04, CPU_SSE); }
#line 9642 "x86id.c"
yy1415:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1427;
		if(yych <= 'R')	goto yy239;
		goto yy1428;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
			goto yy1427;
		} else {
			if(yych == 's')	goto yy1428;
			goto yy239;
		}
	}
yy1416:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1417;
		if(yych <= 'R')	goto yy239;
		goto yy1418;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1418;
			goto yy239;
		}
	}
yy1417:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1425;
		if(yych <= 'R')	goto yy239;
		goto yy1423;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1425;
		} else {
			if(yych == 's')	goto yy1423;
			goto yy239;
		}
	}
yy1418:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1421;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1421;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3600 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x01F3, CPU_SSE); }
#line 9701 "x86id.c"
yy1421:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3682 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x01F2, CPU_SSE2); }
#line 9707 "x86id.c"
yy1423:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3599 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x01, CPU_SSE); }
#line 9713 "x86id.c"
yy1425:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3681 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0166, CPU_SSE2); }
#line 9719 "x86id.c"
yy1427:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1435;
		if(yych <= 'R')	goto yy239;
		goto yy1433;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1435;
		} else {
			if(yych == 's')	goto yy1433;
			goto yy239;
		}
	}
yy1428:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1431;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1431;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3598 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x02F3, CPU_SSE); }
#line 9751 "x86id.c"
yy1431:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3680 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x02F2, CPU_SSE2); }
#line 9757 "x86id.c"
yy1433:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3597 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x02, CPU_SSE); }
#line 9763 "x86id.c"
yy1435:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3679 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0266, CPU_SSE2); }
#line 9769 "x86id.c"
yy1437:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1438;
		if(yych <= 'R')	goto yy239;
		goto yy1439;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1439;
			goto yy239;
		}
	}
yy1438:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1446;
		if(yych <= 'R')	goto yy239;
		goto yy1444;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1446;
		} else {
			if(yych == 's')	goto yy1444;
			goto yy239;
		}
	}
yy1439:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1442;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1442;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3596 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x00F3, CPU_SSE); }
#line 9814 "x86id.c"
yy1442:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3678 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x00F2, CPU_SSE2); }
#line 9820 "x86id.c"
yy1444:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3595 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpps, 0x00, CPU_SSE); }
#line 9826 "x86id.c"
yy1446:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3677 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssecmpss, 0x0066, CPU_SSE2); }
#line 9832 "x86id.c"
yy1448:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3009 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00F8, CPU_Any); }
#line 9838 "x86id.c"
yy1450:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3010 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00FC, CPU_Any); }
#line 9844 "x86id.c"
yy1452:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3011 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00FA, CPU_Any); }
#line 9850 "x86id.c"
yy1454:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1461;
	if(yych == 's')	goto yy1461;
	goto yy239;
yy1455:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1456;
	if(yych != 'l')	goto yy239;
yy1456:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy1457;
	if(yych != 'u')	goto yy239;
yy1457:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1458;
	if(yych != 's')	goto yy239;
yy1458:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1459;
	if(yych != 'h')	goto yy239;
yy1459:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3536 "./modules/arch/x86/x86id.re"
{ RET_INSN(clflush, 0, CPU_P3); }
#line 9872 "x86id.c"
yy1461:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3012 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F06, CPU_286|CPU_Priv); }
#line 9878 "x86id.c"
yy1463:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy1464;
		if(yych <= 'D')	goto yy238;
		goto yy1467;
	} else {
		if(yych == 'e')	goto yy1467;
		goto yy238;
	}
yy1464:
#line 3130 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x2099, CPU_386); }
#line 9891 "x86id.c"
yy1465:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3131 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x4099, CPU_Hammer|CPU_64);
	}
#line 9905 "x86id.c"
yy1467:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3120 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x4098, CPU_Hammer|CPU_64);
	}
#line 9919 "x86id.c"
yy1469:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3118 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x1098, CPU_Any); }
#line 9925 "x86id.c"
yy1471:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1472;
	if(yych != 'l')	goto yy239;
yy1472:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3157 "./modules/arch/x86/x86id.re"
{ RET_INSN(call, 0, CPU_Any); }
#line 9934 "x86id.c"
yy1474:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy239;
	if(yych <= '5')	goto yy1578;
	goto yy239;
yy1475:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'B'){
			if(yych <= '\000')	goto yy1476;
			if(yych <= 'A')	goto yy238;
			goto yy1576;
		} else {
			if(yych == 'D')	goto yy1572;
			if(yych <= 'V')	goto yy238;
			goto yy1574;
		}
	} else {
		if(yych <= 'c'){
			if(yych == 'b')	goto yy1576;
			goto yy238;
		} else {
			if(yych <= 'd')	goto yy1572;
			if(yych == 'w')	goto yy1574;
			goto yy238;
		}
	}
yy1476:
#line 2748 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | (oid[1]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 9971 "x86id.c"
yy1477:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy1570;
	if(yych == 'x')	goto yy1570;
	goto yy239;
yy1478:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == 'P')	goto yy1568;
		if(yych <= 'W')	goto yy239;
		goto yy1566;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
			goto yy1568;
		} else {
			if(yych == 'x')	goto yy1566;
			goto yy239;
		}
	}
yy1479:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= 'P'){
			if(yych == 'L')	goto yy1555;
			if(yych <= 'O')	goto yy239;
			goto yy1559;
		} else {
			if(yych == 'R')	goto yy1557;
			if(yych <= 'W')	goto yy239;
			goto yy1553;
		}
	} else {
		if(yych <= 'p'){
			if(yych == 'l')	goto yy1555;
			if(yych <= 'o')	goto yy239;
			goto yy1559;
		} else {
			if(yych <= 'r'){
				if(yych <= 'q')	goto yy239;
				goto yy1557;
			} else {
				if(yych == 'x')	goto yy1553;
				goto yy239;
			}
		}
	}
yy1480:	yych = *++YYCURSOR;
	switch(yych){
	case 'I':	case 'i':	goto yy1535;
	case 'M':	case 'm':	goto yy1538;
	case 'P':	case 'p':	goto yy1539;
	case 'S':	case 's':	goto yy1540;
	case 'T':	case 't':	goto yy1537;
	case 'X':	case 'x':	goto yy1533;
	default:	goto yy239;
	}
yy1481:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'P')	goto yy1516;
		if(yych <= 'S')	goto yy239;
		goto yy1518;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
			goto yy1516;
		} else {
			if(yych == 't')	goto yy1518;
			goto yy239;
		}
	}
yy1482:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1514;
	if(yych == 'p')	goto yy1514;
	goto yy239;
yy1483:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'L')	goto yy1510;
		if(yych <= 'Q')	goto yy239;
		goto yy1512;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy239;
			goto yy1510;
		} else {
			if(yych == 'r')	goto yy1512;
			goto yy239;
		}
	}
yy1484:	yych = *++YYCURSOR;
	switch(yych){
	case 'D':	case 'd':	goto yy1492;
	case 'I':	case 'i':	goto yy1487;
	case 'L':	case 'l':	goto yy1493;
	case 'M':	case 'm':	goto yy1489;
	case 'P':	case 'p':	goto yy1485;
	case 'Q':	case 'q':	goto yy1491;
	case 'T':	case 't':	goto yy1494;
	default:	goto yy239;
	}
yy1485:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2712 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 4;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10082 "x86id.c"
yy1487:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2730 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 6;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10096 "x86id.c"
yy1489:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3341 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0FAA, CPU_586|CPU_SMM); }
#line 10102 "x86id.c"
yy1491:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1502;
	if(yych == 'r')	goto yy1502;
	goto yy239;
yy1492:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1500;
	if(yych == 'c')	goto yy1500;
	goto yy239;
yy1493:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1497;
	if(yych == 'd')	goto yy1497;
	goto yy239;
yy1494:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1495;
	if(yych != 's')	goto yy239;
yy1495:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3809 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixsmm, 0x7D, CPU_486|CPU_Cyrix|CPU_SMM); }
#line 10123 "x86id.c"
yy1497:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1498;
	if(yych != 't')	goto yy239;
yy1498:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3808 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixsmm, 0x7B, CPU_486|CPU_Cyrix|CPU_SMM); }
#line 10132 "x86id.c"
yy1500:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3807 "./modules/arch/x86/x86id.re"
{ RET_INSN(rsdc, 0, CPU_486|CPU_Cyrix|CPU_SMM); }
#line 10138 "x86id.c"
yy1502:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1503;
	if(yych != 't')	goto yy239;
yy1503:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1504;
		if(yych <= 'R')	goto yy239;
		goto yy1505;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1505;
			goto yy239;
		}
	}
yy1504:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1508;
	if(yych == 's')	goto yy1508;
	goto yy239;
yy1505:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1506;
	if(yych != 's')	goto yy239;
yy1506:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3660 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF352, CPU_SSE); }
#line 10167 "x86id.c"
yy1508:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3659 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x52, CPU_SSE); }
#line 10173 "x86id.c"
yy1510:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3146 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x00, CPU_Any); }
#line 10179 "x86id.c"
yy1512:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3147 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x01, CPU_Any); }
#line 10185 "x86id.c"
yy1514:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2911 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_RIP;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10199 "x86id.c"
yy1516:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= 'E'){
			if(yych <= '\000')	goto yy1517;
			if(yych <= 'D')	goto yy238;
			goto yy1524;
		} else {
			if(yych == 'N')	goto yy1526;
			if(yych <= 'Y')	goto yy238;
			goto yy1527;
		}
	} else {
		if(yych <= 'm'){
			if(yych == 'e')	goto yy1524;
			goto yy238;
		} else {
			if(yych <= 'n')	goto yy1526;
			if(yych == 'z')	goto yy1527;
			goto yy238;
		}
	}
yy1517:
#line 2611 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_LOCKREP;
	    data[1] = 0xF3;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 10228 "x86id.c"
yy1518:	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= 'E'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'F')	goto yy1520;
			if(yych <= 'M')	goto yy238;
			goto yy1522;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'e')	goto yy238;
			goto yy1520;
		} else {
			if(yych == 'n')	goto yy1522;
			goto yy238;
		}
	}

#line 3159 "./modules/arch/x86/x86id.re"
{ RET_INSN(retnf, 0xC2, CPU_Any); }
#line 10250 "x86id.c"
yy1520:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3161 "./modules/arch/x86/x86id.re"
{ RET_INSN(retnf, 0xCA, CPU_Any); }
#line 10256 "x86id.c"
yy1522:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3160 "./modules/arch/x86/x86id.re"
{ RET_INSN(retnf, 0xC2, CPU_Any); }
#line 10262 "x86id.c"
yy1524:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2616 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_LOCKREP;
	    data[1] = 0xF3;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 10272 "x86id.c"
yy1526:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == 'E')	goto yy1529;
		if(yych <= 'Y')	goto yy239;
		goto yy1531;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
			goto yy1529;
		} else {
			if(yych == 'z')	goto yy1531;
			goto yy239;
		}
	}
yy1527:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2621 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_LOCKREP;
	    data[1] = 0xF3;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 10296 "x86id.c"
yy1529:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2601 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_LOCKREP;
	    data[1] = 0xF2;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 10306 "x86id.c"
yy1531:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2606 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_LOCKREP;
	    data[1] = 0xF2;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 10316 "x86id.c"
yy1533:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2694 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 2;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10330 "x86id.c"
yy1535:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2739 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 7;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10344 "x86id.c"
yy1537:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1550;
	if(yych == 's')	goto yy1550;
	goto yy239;
yy1538:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1547;
	if(yych == 's')	goto yy1547;
	goto yy239;
yy1539:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1544;
	if(yych == 'm')	goto yy1544;
	goto yy239;
yy1540:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1541;
	if(yych != 'h')	goto yy239;
yy1541:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1542;
	if(yych != 'r')	goto yy239;
yy1542:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3806 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F36, CPU_686|CPU_Cyrix|CPU_SMM); }
#line 10368 "x86id.c"
yy1544:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1545;
	if(yych != 'c')	goto yy239;
yy1545:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3489 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F33, CPU_686); }
#line 10377 "x86id.c"
yy1547:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1548;
	if(yych != 'r')	goto yy239;
yy1548:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3470 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F32, CPU_586|CPU_Priv); }
#line 10386 "x86id.c"
yy1550:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1551;
	if(yych != 'c')	goto yy239;
yy1551:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3469 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F31, CPU_586); }
#line 10395 "x86id.c"
yy1553:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2685 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 1;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10409 "x86id.c"
yy1555:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3148 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x02, CPU_Any); }
#line 10415 "x86id.c"
yy1557:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3149 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x03, CPU_Any); }
#line 10421 "x86id.c"
yy1559:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy1560;
		if(yych <= 'R')	goto yy239;
		goto yy1561;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy1561;
			goto yy239;
		}
	}
yy1560:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1564;
	if(yych == 's')	goto yy1564;
	goto yy239;
yy1561:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1562;
	if(yych != 's')	goto yy239;
yy1562:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3658 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF353, CPU_SSE); }
#line 10447 "x86id.c"
yy1564:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3657 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x53, CPU_SSE); }
#line 10453 "x86id.c"
yy1566:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2703 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 3;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10467 "x86id.c"
yy1568:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2721 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 5;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10481 "x86id.c"
yy1570:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2676 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | 0;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10495 "x86id.c"
yy1572:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2775 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG32 | (oid[1]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10509 "x86id.c"
yy1574:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2802 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG16 | (oid[1]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10523 "x86id.c"
yy1576:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2865 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG8 | (oid[1]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10537 "x86id.c"
yy1578:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'B'){
			if(yych <= '\000')	goto yy1579;
			if(yych <= 'A')	goto yy238;
			goto yy1580;
		} else {
			if(yych == 'D')	goto yy1582;
			if(yych <= 'V')	goto yy238;
			goto yy1584;
		}
	} else {
		if(yych <= 'c'){
			if(yych == 'b')	goto yy1580;
			goto yy238;
		} else {
			if(yych <= 'd')	goto yy1582;
			if(yych == 'w')	goto yy1584;
			goto yy238;
		}
	}
yy1579:
#line 2757 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG64 | (10+oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10570 "x86id.c"
yy1580:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2874 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG8 | (10+oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10584 "x86id.c"
yy1582:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2784 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG32 | (10+oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10598 "x86id.c"
yy1584:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2811 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG16 | (10+oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 10612 "x86id.c"
yy1586:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'H')	goto yy1674;
		if(yych <= 'Q')	goto yy239;
		goto yy1675;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy239;
			goto yy1674;
		} else {
			if(yych == 'r')	goto yy1675;
			goto yy239;
		}
	}
yy1587:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'M')	goto yy1668;
		if(yych <= 'R')	goto yy239;
		goto yy1666;
	} else {
		if(yych <= 'm'){
			if(yych <= 'l')	goto yy239;
			goto yy1668;
		} else {
			if(yych == 's')	goto yy1666;
			goto yy239;
		}
	}
yy1588:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'A')	goto yy1659;
		if(yych <= 'R')	goto yy239;
		goto yy1661;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy239;
			goto yy1659;
		} else {
			if(yych == 's')	goto yy1661;
			goto yy239;
		}
	}
yy1589:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'E')	goto yy1654;
		if(yych <= 'R')	goto yy239;
		goto yy1652;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
			goto yy1654;
		} else {
			if(yych == 's')	goto yy1652;
			goto yy239;
		}
	}
yy1590:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1649;
		if(yych <= 'R')	goto yy239;
		goto yy1647;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1649;
		} else {
			if(yych == 's')	goto yy1647;
			goto yy239;
		}
	}
yy1591:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1644;
	if(yych == 'd')	goto yy1644;
	goto yy239;
yy1592:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1641;
	if(yych == 'd')	goto yy1641;
	goto yy239;
yy1593:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1638;
	if(yych == 's')	goto yy1638;
	goto yy239;
yy1594:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'B'){
			if(yych == 'A')	goto yy1606;
			goto yy239;
		} else {
			if(yych <= 'C')	goto yy1603;
			if(yych <= 'D')	goto yy1605;
			if(yych <= 'N')	goto yy239;
			goto yy1604;
		}
	} else {
		if(yych <= 'c'){
			if(yych == 'a')	goto yy1606;
			if(yych <= 'b')	goto yy239;
			goto yy1603;
		} else {
			if(yych <= 'd')	goto yy1605;
			if(yych == 'o')	goto yy1604;
			goto yy239;
		}
	}
yy1595:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'L')	goto yy1601;
		if(yych <= 'R')	goto yy239;
		goto yy1599;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy239;
			goto yy1601;
		} else {
			if(yych == 's')	goto yy1599;
			goto yy239;
		}
	}
yy1596:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1597;
	if(yych != 'r')	goto yy239;
yy1597:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3365 "./modules/arch/x86/x86id.re"
{ RET_INSN(prot286, 0x0300, CPU_286|CPU_Prot|CPU_Priv); }
#line 10739 "x86id.c"
yy1599:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3007 "./modules/arch/x86/x86id.re"
{ RET_INSN(lfgss, 0xB2, CPU_386); }
#line 10745 "x86id.c"
yy1601:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3364 "./modules/arch/x86/x86id.re"
{ RET_INSN(bsfr, 0x03, CPU_286|CPU_Prot); }
#line 10751 "x86id.c"
yy1603:	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy1636;
	if(yych == 'k')	goto yy1636;
	goto yy239;
yy1604:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1625;
	if(yych == 'p')	goto yy1625;
	goto yy239;
yy1605:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1616;
	if(yych == 's')	goto yy1616;
	goto yy239;
yy1606:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1607;
	if(yych != 'd')	goto yy239;
yy1607:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1608;
	if(yych != 'a')	goto yy239;
yy1608:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1609;
	if(yych != 'l')	goto yy239;
yy1609:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1610;
	if(yych != 'l')	goto yy239;
yy1610:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy1611;
	if(yych == '2')	goto yy1612;
	goto yy238;
yy1611:
#line 3819 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F07, CPU_386|CPU_Undoc); }
#line 10783 "x86id.c"
yy1612:	yych = *++YYCURSOR;
	if(yych != '8')	goto yy239;
	yych = *++YYCURSOR;
	if(yych != '6')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3820 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F05, CPU_286|CPU_Undoc); }
#line 10793 "x86id.c"
yy1616:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych == 'B')	goto yy1617;
			if(yych <= 'C')	goto yy239;
			goto yy1621;
		} else {
			if(yych == 'Q')	goto yy1623;
			if(yych <= 'V')	goto yy239;
			goto yy1619;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'b')	goto yy1617;
			if(yych <= 'c')	goto yy239;
			goto yy1621;
		} else {
			if(yych <= 'q'){
				if(yych <= 'p')	goto yy239;
				goto yy1623;
			} else {
				if(yych == 'w')	goto yy1619;
				goto yy239;
			}
		}
	}
yy1617:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3262 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00AC, CPU_Any); }
#line 10825 "x86id.c"
yy1619:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3263 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x10AD, CPU_Any); }
#line 10831 "x86id.c"
yy1621:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3264 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x20AD, CPU_386); }
#line 10837 "x86id.c"
yy1623:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3265 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x40AD, CPU_Hammer|CPU_64);
	}
#line 10851 "x86id.c"
yy1625:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= 'E'){
			if(yych <= '\000')	goto yy1626;
			if(yych <= 'D')	goto yy238;
			goto yy1629;
		} else {
			if(yych == 'N')	goto yy1631;
			if(yych <= 'Y')	goto yy238;
			goto yy1627;
		}
	} else {
		if(yych <= 'm'){
			if(yych == 'e')	goto yy1629;
			goto yy238;
		} else {
			if(yych <= 'n')	goto yy1631;
			if(yych == 'z')	goto yy1627;
			goto yy238;
		}
	}
yy1626:
#line 3207 "./modules/arch/x86/x86id.re"
{ RET_INSN(loop, 0x02, CPU_Any); }
#line 10876 "x86id.c"
yy1627:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3208 "./modules/arch/x86/x86id.re"
{ RET_INSN(loop, 0x01, CPU_Any); }
#line 10882 "x86id.c"
yy1629:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3209 "./modules/arch/x86/x86id.re"
{ RET_INSN(loop, 0x01, CPU_Any); }
#line 10888 "x86id.c"
yy1631:	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == 'E')	goto yy1632;
		if(yych <= 'Y')	goto yy239;
		goto yy1634;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
		} else {
			if(yych == 'z')	goto yy1634;
			goto yy239;
		}
	}
yy1632:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3211 "./modules/arch/x86/x86id.re"
{ RET_INSN(loop, 0x00, CPU_Any); }
#line 10907 "x86id.c"
yy1634:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3210 "./modules/arch/x86/x86id.re"
{ RET_INSN(loop, 0x00, CPU_Any); }
#line 10913 "x86id.c"
yy1636:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2596 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_LOCKREP; 
	    data[1] = 0xF0;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 10923 "x86id.c"
yy1638:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1639;
	if(yych != 'w')	goto yy239;
yy1639:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3363 "./modules/arch/x86/x86id.re"
{ RET_INSN(prot286, 0x0601, CPU_286|CPU_Priv); }
#line 10932 "x86id.c"
yy1641:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1642;
	if(yych != 't')	goto yy239;
yy1642:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3362 "./modules/arch/x86/x86id.re"
{ RET_INSN(prot286, 0x0200, CPU_286|CPU_Prot|CPU_Priv); }
#line 10941 "x86id.c"
yy1644:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1645;
	if(yych != 't')	goto yy239;
yy1645:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3361 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x030F01, CPU_286|CPU_Priv); }
#line 10950 "x86id.c"
yy1647:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3006 "./modules/arch/x86/x86id.re"
{ RET_INSN(lfgss, 0xB5, CPU_386); }
#line 10956 "x86id.c"
yy1649:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1650;
	if(yych != 't')	goto yy239;
yy1650:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3360 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x020F01, CPU_286|CPU_Priv); }
#line 10965 "x86id.c"
yy1652:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3005 "./modules/arch/x86/x86id.re"
{ RET_INSN(lfgss, 0xB4, CPU_386); }
#line 10971 "x86id.c"
yy1654:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1655;
	if(yych != 'n')	goto yy239;
yy1655:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1656;
	if(yych != 'c')	goto yy239;
yy1656:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1657;
	if(yych != 'e')	goto yy239;
yy1657:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3537 "./modules/arch/x86/x86id.re"
{ RET_INSN(threebyte, 0x0FAEE8, CPU_P3); }
#line 10986 "x86id.c"
yy1659:	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= '\000')	goto yy1660;
		if(yych <= 'U')	goto yy238;
		goto yy1663;
	} else {
		if(yych == 'v')	goto yy1663;
		goto yy238;
	}
yy1660:
#line 2989 "./modules/arch/x86/x86id.re"
{ RET_INSN(lea, 0, CPU_Any); }
#line 10999 "x86id.c"
yy1661:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2998 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(ldes, 0xC4, CPU_Any);
	}
#line 11011 "x86id.c"
yy1663:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1664;
	if(yych != 'e')	goto yy239;
yy1664:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3163 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x4000C9, CPU_186); }
#line 11020 "x86id.c"
yy1666:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2991 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(ldes, 0xC5, CPU_Any);
	}
#line 11032 "x86id.c"
yy1668:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy1669;
	if(yych != 'x')	goto yy239;
yy1669:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1670;
	if(yych != 'c')	goto yy239;
yy1670:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1671;
	if(yych != 's')	goto yy239;
yy1671:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1672;
	if(yych != 'r')	goto yy239;
yy1672:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3622 "./modules/arch/x86/x86id.re"
{ RET_INSN(ldstmxcsr, 0x02, CPU_SSE); }
#line 11050 "x86id.c"
yy1674:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy1677;
	if(yych == 'f')	goto yy1677;
	goto yy239;
yy1675:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3359 "./modules/arch/x86/x86id.re"
{ RET_INSN(bsfr, 0x02, CPU_286|CPU_Prot); }
#line 11060 "x86id.c"
yy1677:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3014 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
 	    RET_INSN(onebyte, 0x009F, CPU_Any);
	}
#line 11072 "x86id.c"
yy1679:	yych = *++YYCURSOR;
	if(yych == '6')	goto yy1734;
	goto yy239;
yy1680:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1732;
	goto yy239;
yy1681:	yych = *++YYCURSOR;
	if(yych == '4')	goto yy1730;
	goto yy239;
yy1682:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy1722;
			if(yych <= 'C')	goto yy239;
			goto yy1726;
		} else {
			if(yych == 'M')	goto yy1728;
			if(yych <= 'R')	goto yy239;
			goto yy1724;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy1722;
			if(yych <= 'c')	goto yy239;
			goto yy1726;
		} else {
			if(yych <= 'm'){
				if(yych <= 'l')	goto yy239;
				goto yy1728;
			} else {
				if(yych == 's')	goto yy1724;
				goto yy239;
			}
		}
	}
yy1683:	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= 'B')	goto yy239;
		if(yych <= 'C')	goto yy1710;
		goto yy1708;
	} else {
		if(yych <= 'b')	goto yy239;
		if(yych <= 'c')	goto yy1710;
		if(yych <= 'd')	goto yy1708;
		goto yy239;
	}
yy1684:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2825 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 4; return YASM_ARCH_CHECK_ID_REG; }
#line 11124 "x86id.c"
yy1686:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2821 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG8 | 0; return YASM_ARCH_CHECK_ID_REG; }
#line 11130 "x86id.c"
yy1688:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1695;
	if(yych == 'd')	goto yy1695;
	goto yy239;
yy1689:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1692;
	if(yych == 'p')	goto yy1692;
	goto yy239;
yy1690:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2794 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 0; return YASM_ARCH_CHECK_ID_REG; }
#line 11144 "x86id.c"
yy1692:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1693;
	if(yych != 'l')	goto yy239;
yy1693:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3352 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(arpl, 0, CPU_286|CPU_Prot);
	}
#line 11159 "x86id.c"
yy1695:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= 'M'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'N')	goto yy1697;
			if(yych <= 'O')	goto yy238;
			goto yy1698;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'm')	goto yy238;
			goto yy1697;
		} else {
			if(yych == 'p')	goto yy1698;
			goto yy238;
		}
	}

#line 3069 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0420, CPU_Any); }
#line 11181 "x86id.c"
yy1697:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1703;
	if(yych == 'p')	goto yy1703;
	goto yy239;
yy1698:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1701;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1701;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3594 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x54, CPU_SSE); }
#line 11203 "x86id.c"
yy1701:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3676 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6654, CPU_SSE2); }
#line 11209 "x86id.c"
yy1703:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1704;
		if(yych <= 'R')	goto yy239;
		goto yy1706;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1706;
			goto yy239;
		}
	}
yy1704:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3675 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6655, CPU_SSE2); }
#line 11228 "x86id.c"
yy1706:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3593 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x55, CPU_SSE); }
#line 11234 "x86id.c"
yy1708:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'O'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'P')	goto yy1712;
			if(yych <= 'R')	goto yy238;
			goto yy1713;
		}
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy238;
			goto yy1712;
		} else {
			if(yych == 's')	goto yy1713;
			goto yy238;
		}
	}

#line 3062 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0000, CPU_Any); }
#line 11256 "x86id.c"
yy1710:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3072 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0210, CPU_Any); }
#line 11262 "x86id.c"
yy1712:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1720;
		if(yych <= 'R')	goto yy239;
		goto yy1718;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1720;
		} else {
			if(yych == 's')	goto yy1718;
			goto yy239;
		}
	}
yy1713:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1716;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy1716;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3592 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF358, CPU_SSE); }
#line 11294 "x86id.c"
yy1716:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3674 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF258, CPU_SSE2); }
#line 11300 "x86id.c"
yy1718:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3591 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x58, CPU_SSE); }
#line 11306 "x86id.c"
yy1720:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3673 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6658, CPU_SSE2); }
#line 11312 "x86id.c"
yy1722:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3075 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x0037, CPU_Any);
	}
#line 11324 "x86id.c"
yy1724:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3082 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x003F, CPU_Any);
	}
#line 11336 "x86id.c"
yy1726:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3103 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(aadm, 0x01, CPU_Any);
	}
#line 11348 "x86id.c"
yy1728:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3110 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(aadm, 0x00, CPU_Any);
	}
#line 11360 "x86id.c"
yy1730:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2584 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a prefix in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_ADDRSIZE;
	    data[1] = 64;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 11375 "x86id.c"
yy1732:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2579 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_ADDRSIZE;
	    data[1] = 32;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 11385 "x86id.c"
yy1734:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2569 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line,
		    N_("Cannot override address size to 16 bits in 64-bit mode"));
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_ADDRSIZE;
	    data[1] = 16;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 11400 "x86id.c"
yy1736:	yych = *++YYCURSOR;
	if(yych == '6')	goto yy1760;
	goto yy239;
yy1737:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1758;
	goto yy239;
yy1738:	yych = *++YYCURSOR;
	if(yych == '4')	goto yy1756;
	goto yy239;
yy1739:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy1740;
		if(yych <= 'O')	goto yy238;
		goto yy1751;
	} else {
		if(yych == 'p')	goto yy1751;
		goto yy238;
	}
yy1740:
#line 3070 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0108, CPU_Any); }
#line 11422 "x86id.c"
yy1741:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1742;
	if(yych != 't')	goto yy239;
yy1742:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= '\000')	goto yy1743;
		if(yych <= 'R')	goto yy238;
		goto yy1744;
	} else {
		if(yych == 's')	goto yy1744;
		goto yy238;
	}
yy1743:
#line 2987 "./modules/arch/x86/x86id.re"
{ RET_INSN(out, 0, CPU_Any); }
#line 11438 "x86id.c"
yy1744:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'C'){
			if(yych != 'B')	goto yy239;
		} else {
			if(yych <= 'D')	goto yy1749;
			if(yych <= 'V')	goto yy239;
			goto yy1747;
		}
	} else {
		if(yych <= 'c'){
			if(yych != 'b')	goto yy239;
		} else {
			if(yych <= 'd')	goto yy1749;
			if(yych == 'w')	goto yy1747;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3259 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x006E, CPU_Any); }
#line 11462 "x86id.c"
yy1747:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3260 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x106F, CPU_Any); }
#line 11468 "x86id.c"
yy1749:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3261 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x206F, CPU_386); }
#line 11474 "x86id.c"
yy1751:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy1752;
		if(yych <= 'R')	goto yy239;
		goto yy1754;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy1754;
			goto yy239;
		}
	}
yy1752:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3714 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6656, CPU_SSE2); }
#line 11493 "x86id.c"
yy1754:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3640 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x56, CPU_SSE); }
#line 11499 "x86id.c"
yy1756:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2558 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a prefix in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_OPERSIZE;
	    data[1] = 64;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 11514 "x86id.c"
yy1758:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2553 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_OPERSIZE;
	    data[1] = 32;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 11524 "x86id.c"
yy1760:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2548 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_OPERSIZE;
	    data[1] = 16;
	    return YASM_ARCH_CHECK_ID_PREFIX;
	}
#line 11534 "x86id.c"
yy1762:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1768;
	if(yych == 's')	goto yy1768;
	goto yy239;
yy1763:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2542 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_TO;
	    return YASM_ARCH_CHECK_ID_TARGETMOD;
	}
#line 11547 "x86id.c"
yy1765:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy239;
	if(yych >= '8')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2641 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_TRREG | (oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 11559 "x86id.c"
yy1768:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1769;
	if(yych != 't')	goto yy239;
yy1769:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3068 "./modules/arch/x86/x86id.re"
{ RET_INSN(test, 0, CPU_Any); }
#line 11568 "x86id.c"
yy1771:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy2098;
	if(yych == 'x')	goto yy2098;
	goto yy239;
yy1772:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'C'){
			if(yych == 'B')	goto yy2091;
			goto yy239;
		} else {
			if(yych <= 'D')	goto yy2090;
			if(yych <= 'Q')	goto yy239;
			goto yy2088;
		}
	} else {
		if(yych <= 'c'){
			if(yych == 'b')	goto yy2091;
			goto yy239;
		} else {
			if(yych <= 'd')	goto yy2090;
			if(yych == 'r')	goto yy2088;
			goto yy239;
		}
	}
yy1773:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'L')	goto yy2081;
		if(yych <= 'R')	goto yy239;
		goto yy2082;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy239;
			goto yy2081;
		} else {
			if(yych == 's')	goto yy2082;
			goto yy239;
		}
	}
yy1774:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'K'){
			if(yych == 'H')	goto yy2044;
			goto yy239;
		} else {
			if(yych <= 'L')	goto yy2045;
			if(yych <= 'M')	goto yy2046;
			if(yych <= 'N')	goto yy239;
			goto yy2043;
		}
	} else {
		if(yych <= 'l'){
			if(yych == 'h')	goto yy2044;
			if(yych <= 'k')	goto yy239;
			goto yy2045;
		} else {
			if(yych <= 'm')	goto yy2046;
			if(yych == 'o')	goto yy2043;
			goto yy239;
		}
	}
yy1775:	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych == 'E')	goto yy2029;
		if(yych <= 'H')	goto yy239;
		goto yy2028;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
			goto yy2029;
		} else {
			if(yych == 'i')	goto yy2028;
			goto yy239;
		}
	}
yy1776:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy2024;
	if(yych == 'm')	goto yy2024;
	goto yy239;
yy1777:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy2018;
	if(yych == 'r')	goto yy2018;
	goto yy239;
yy1778:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy1979;
	case 'C':	case 'c':	goto yy1978;
	case 'D':	case 'd':	goto yy1981;
	case 'L':	case 'l':	goto yy1976;
	case 'M':	case 'm':	goto yy1980;
	case 'N':	case 'n':	goto yy1982;
	case 'S':	case 's':	goto yy1977;
	default:	goto yy239;
	}
yy1779:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1948;
	if(yych == 'd')	goto yy1948;
	goto yy239;
yy1780:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy1943;
	if(yych == 'u')	goto yy1943;
	goto yy239;
yy1781:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'I'){
			if(yych == 'C')	goto yy1916;
			if(yych <= 'H')	goto yy239;
			goto yy1914;
		} else {
			if(yych == 'O')	goto yy1917;
			if(yych <= 'R')	goto yy239;
			goto yy1915;
		}
	} else {
		if(yych <= 'i'){
			if(yych == 'c')	goto yy1916;
			if(yych <= 'h')	goto yy239;
			goto yy1914;
		} else {
			if(yych <= 'o'){
				if(yych <= 'n')	goto yy239;
				goto yy1917;
			} else {
				if(yych == 's')	goto yy1915;
				goto yy239;
			}
		}
	}
yy1782:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'Q'){
			if(yych == 'A')	goto yy1900;
			goto yy239;
		} else {
			if(yych <= 'R')	goto yy1901;
			if(yych <= 'S')	goto yy239;
			goto yy1899;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'a')	goto yy1900;
			goto yy239;
		} else {
			if(yych <= 'r')	goto yy1901;
			if(yych == 't')	goto yy1899;
			goto yy239;
		}
	}
yy1783:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'N')	goto yy1888;
		if(yych <= 'R')	goto yy239;
		goto yy1889;
	} else {
		if(yych <= 'n'){
			if(yych <= 'm')	goto yy239;
			goto yy1888;
		} else {
			if(yych == 's')	goto yy1889;
			goto yy239;
		}
	}
yy1784:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'E'){
			if(yych <= 'A'){
				if(yych <= '\000')	goto yy1785;
				if(yych <= '@')	goto yy238;
				goto yy1846;
			} else {
				if(yych == 'C')	goto yy1845;
				if(yych <= 'D')	goto yy238;
				goto yy1847;
			}
		} else {
			if(yych <= 'P'){
				if(yych == 'I')	goto yy1844;
				goto yy238;
			} else {
				if(yych <= 'Q')	goto yy1843;
				if(yych <= 'S')	goto yy238;
				if(yych <= 'T')	goto yy1840;
				goto yy1842;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'b'){
				if(yych == 'a')	goto yy1846;
				goto yy238;
			} else {
				if(yych <= 'c')	goto yy1845;
				if(yych == 'e')	goto yy1847;
				goto yy238;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= 'i')	goto yy1844;
				if(yych <= 'p')	goto yy238;
				goto yy1843;
			} else {
				if(yych <= 's')	goto yy238;
				if(yych <= 't')	goto yy1840;
				if(yych <= 'u')	goto yy1842;
				goto yy238;
			}
		}
	}
yy1785:
#line 2907 "./modules/arch/x86/x86id.re"
{ data[0] = 0x6404; return YASM_ARCH_CHECK_ID_SEGREG; }
#line 11779 "x86id.c"
yy1786:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1837;
	if(yych == 's')	goto yy1837;
	goto yy239;
yy1787:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1825;
	if(yych == 'c')	goto yy1825;
	goto yy239;
yy1788:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1821;
	if(yych == 'a')	goto yy1821;
	goto yy239;
yy1789:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'C'){
			if(yych == 'A')	goto yy1799;
			if(yych <= 'B')	goto yy239;
			goto yy1798;
		} else {
			if(yych <= 'Q')	goto yy239;
			if(yych <= 'R')	goto yy1802;
			if(yych <= 'S')	goto yy1801;
			goto yy1800;
		}
	} else {
		if(yych <= 'c'){
			if(yych == 'a')	goto yy1799;
			if(yych <= 'b')	goto yy239;
			goto yy1798;
		} else {
			if(yych <= 'r'){
				if(yych <= 'q')	goto yy239;
				goto yy1802;
			} else {
				if(yych <= 's')	goto yy1801;
				if(yych <= 't')	goto yy1800;
				goto yy239;
			}
		}
	}
yy1790:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1791;
	if(yych != 'l')	goto yy239;
yy1791:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy239;
	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy1793;
	if(yych != 'x')	goto yy239;
yy1793:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy1794;
		if(yych <= 'O')	goto yy238;
		goto yy1795;
	} else {
		if(yych == 'p')	goto yy1795;
		goto yy238;
	}
yy1794:
#line 3419 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F1, CPU_FPU); }
#line 11840 "x86id.c"
yy1795:	yych = *++YYCURSOR;
	if(yych != '1')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3427 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F9, CPU_FPU); }
#line 11848 "x86id.c"
yy1798:	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1819;
	if(yych == 'h')	goto yy1819;
	goto yy239;
yy1799:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1817;
	if(yych == 'm')	goto yy1817;
	goto yy239;
yy1800:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1812;
	if(yych == 'r')	goto yy1812;
	goto yy239;
yy1801:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1808;
	if(yych == 'a')	goto yy1808;
	goto yy239;
yy1802:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1803;
	if(yych != 's')	goto yy239;
yy1803:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1804;
	if(yych != 't')	goto yy239;
yy1804:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1805;
	if(yych != 'o')	goto yy239;
yy1805:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1806;
	if(yych != 'r')	goto yy239;
yy1806:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3488 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x010FAE, CPU_686|CPU_FPU); }
#line 11882 "x86id.c"
yy1808:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1809;
	if(yych != 'v')	goto yy239;
yy1809:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1810;
	if(yych != 'e')	goto yy239;
yy1810:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3487 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x000FAE, CPU_686|CPU_FPU); }
#line 11894 "x86id.c"
yy1812:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1813;
	if(yych != 'a')	goto yy239;
yy1813:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1814;
	if(yych != 'c')	goto yy239;
yy1814:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1815;
	if(yych != 't')	goto yy239;
yy1815:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3422 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F4, CPU_FPU); }
#line 11909 "x86id.c"
yy1817:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3392 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9E5, CPU_FPU); }
#line 11915 "x86id.c"
yy1819:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3382 "./modules/arch/x86/x86id.re"
{ RET_INSN(fxch, 0, CPU_FPU); }
#line 11921 "x86id.c"
yy1821:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1822;
	if(yych != 'i')	goto yy239;
yy1822:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1823;
	if(yych != 't')	goto yy239;
yy1823:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3454 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x009B, CPU_FPU); }
#line 11933 "x86id.c"
yy1825:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1826;
	if(yych != 'o')	goto yy239;
yy1826:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1827;
	if(yych != 'm')	goto yy239;
yy1827:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= 'H'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'I')	goto yy1829;
			if(yych <= 'O')	goto yy238;
			goto yy1831;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy238;
			goto yy1829;
		} else {
			if(yych == 'p')	goto yy1831;
			goto yy238;
		}
	}

#line 3388 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom2, 0xDDE0, CPU_286|CPU_FPU); }
#line 11961 "x86id.c"
yy1829:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy1830;
		if(yych <= 'O')	goto yy238;
		goto yy1835;
	} else {
		if(yych == 'p')	goto yy1835;
		goto yy238;
	}
yy1830:
#line 3531 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom2, 0xDBE8, CPU_686|CPU_FPU); }
#line 11974 "x86id.c"
yy1831:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy1832;
		if(yych <= 'O')	goto yy238;
		goto yy1833;
	} else {
		if(yych == 'p')	goto yy1833;
		goto yy238;
	}
yy1832:
#line 3389 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom2, 0xDDE8, CPU_286|CPU_FPU); }
#line 11987 "x86id.c"
yy1833:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3390 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xDAE9, CPU_286|CPU_FPU); }
#line 11993 "x86id.c"
yy1835:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3533 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom2, 0xDFE8, CPU_686|CPU_FPU); }
#line 11999 "x86id.c"
yy1837:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1838;
	if(yych != 't')	goto yy239;
yy1838:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3391 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9E4, CPU_FPU); }
#line 12008 "x86id.c"
yy1840:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'D'){
			if(yych <= '\000')	goto yy1841;
			if(yych == 'C')	goto yy1876;
			goto yy238;
		} else {
			if(yych <= 'O'){
				if(yych <= 'E')	goto yy1877;
				goto yy238;
			} else {
				if(yych <= 'P')	goto yy1878;
				if(yych <= 'R')	goto yy238;
				goto yy1880;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych == 'c')	goto yy1876;
			if(yych <= 'd')	goto yy238;
			goto yy1877;
		} else {
			if(yych <= 'p'){
				if(yych <= 'o')	goto yy238;
				goto yy1878;
			} else {
				if(yych == 's')	goto yy1880;
				goto yy238;
			}
		}
	}
yy1841:
#line 3377 "./modules/arch/x86/x86id.re"
{ RET_INSN(fst, 0, CPU_FPU); }
#line 12043 "x86id.c"
yy1842:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1868;
	if(yych == 'b')	goto yy1868;
	goto yy239;
yy1843:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1865;
	if(yych == 'r')	goto yy1865;
	goto yy239;
yy1844:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1859;
	if(yych == 'n')	goto yy1859;
	goto yy239;
yy1845:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1855;
	if(yych == 'a')	goto yy1855;
	goto yy239;
yy1846:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1852;
	if(yych == 'v')	goto yy1852;
	goto yy239;
yy1847:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1848;
	if(yych != 't')	goto yy239;
yy1848:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1849;
	if(yych != 'p')	goto yy239;
yy1849:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1850;
	if(yych != 'm')	goto yy239;
yy1850:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3817 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xDBE4, CPU_286|CPU_FPU|CPU_Obs); }
#line 12078 "x86id.c"
yy1852:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1853;
	if(yych != 'e')	goto yy239;
yy1853:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3449 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x069BDD, CPU_FPU); }
#line 12087 "x86id.c"
yy1855:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1856;
	if(yych != 'l')	goto yy239;
yy1856:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1857;
	if(yych != 'e')	goto yy239;
yy1857:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3431 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9FD, CPU_FPU); }
#line 12099 "x86id.c"
yy1859:	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= '\000')	goto yy1860;
		if(yych <= 'B')	goto yy238;
		goto yy1861;
	} else {
		if(yych == 'c')	goto yy1861;
		goto yy238;
	}
yy1860:
#line 3432 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9FE, CPU_286|CPU_FPU); }
#line 12112 "x86id.c"
yy1861:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1862;
	if(yych != 'o')	goto yy239;
yy1862:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1863;
	if(yych != 's')	goto yy239;
yy1863:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3429 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9FB, CPU_286|CPU_FPU); }
#line 12124 "x86id.c"
yy1865:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1866;
	if(yych != 't')	goto yy239;
yy1866:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3428 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9FA, CPU_FPU); }
#line 12133 "x86id.c"
yy1868:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'O'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'P')	goto yy1870;
			if(yych <= 'Q')	goto yy238;
			goto yy1872;
		}
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy238;
			goto yy1870;
		} else {
			if(yych == 'r')	goto yy1872;
			goto yy238;
		}
	}

#line 3403 "./modules/arch/x86/x86id.re"
{ RET_INSN(farith, 0x04E0E8, CPU_FPU); }
#line 12155 "x86id.c"
yy1870:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3405 "./modules/arch/x86/x86id.re"
{ RET_INSN(farithp, 0xE8, CPU_FPU); }
#line 12161 "x86id.c"
yy1872:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy1873;
		if(yych <= 'O')	goto yy238;
		goto yy1874;
	} else {
		if(yych == 'p')	goto yy1874;
		goto yy238;
	}
yy1873:
#line 3406 "./modules/arch/x86/x86id.re"
{ RET_INSN(farith, 0x05E8E0, CPU_FPU); }
#line 12174 "x86id.c"
yy1874:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3408 "./modules/arch/x86/x86id.re"
{ RET_INSN(farithp, 0xE0, CPU_FPU); }
#line 12180 "x86id.c"
yy1876:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1886;
	if(yych == 'w')	goto yy1886;
	goto yy239;
yy1877:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1883;
	if(yych == 'n')	goto yy1883;
	goto yy239;
yy1878:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3379 "./modules/arch/x86/x86id.re"
{ RET_INSN(fldstp, 0x0703D8, CPU_FPU); }
#line 12194 "x86id.c"
yy1880:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1881;
	if(yych != 'w')	goto yy239;
yy1881:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3442 "./modules/arch/x86/x86id.re"
{ RET_INSN(fstsw, 0, CPU_FPU); }
#line 12203 "x86id.c"
yy1883:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1884;
	if(yych != 'v')	goto yy239;
yy1884:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3446 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x069BD9, CPU_FPU); }
#line 12212 "x86id.c"
yy1886:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3440 "./modules/arch/x86/x86id.re"
{ RET_INSN(fstcw, 0, CPU_FPU); }
#line 12218 "x86id.c"
yy1888:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1894;
	if(yych == 'd')	goto yy1894;
	goto yy239;
yy1889:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1890;
	if(yych != 't')	goto yy239;
yy1890:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1891;
	if(yych != 'o')	goto yy239;
yy1891:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1892;
	if(yych != 'r')	goto yy239;
yy1892:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3450 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebytemem, 0x04DD, CPU_FPU); }
#line 12237 "x86id.c"
yy1894:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1895;
	if(yych != 'i')	goto yy239;
yy1895:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1896;
	if(yych != 'n')	goto yy239;
yy1896:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1897;
	if(yych != 't')	goto yy239;
yy1897:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3430 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9FC, CPU_FPU); }
#line 12252 "x86id.c"
yy1899:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1911;
	if(yych == 'a')	goto yy1911;
	goto yy239;
yy1900:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1907;
	if(yych == 't')	goto yy1907;
	goto yy239;
yy1901:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1902;
	if(yych != 'e')	goto yy239;
yy1902:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1903;
	if(yych != 'm')	goto yy239;
yy1903:	yych = *++YYCURSOR;
	if(yych <= '\000')	goto yy1904;
	if(yych == '1')	goto yy1905;
	goto yy238;
yy1904:
#line 3426 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F8, CPU_FPU); }
#line 12274 "x86id.c"
yy1905:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3423 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F5, CPU_286|CPU_FPU); }
#line 12280 "x86id.c"
yy1907:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1908;
	if(yych != 'a')	goto yy239;
yy1908:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1909;
	if(yych != 'n')	goto yy239;
yy1909:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3421 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F3, CPU_FPU); }
#line 12292 "x86id.c"
yy1911:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1912;
	if(yych != 'n')	goto yy239;
yy1912:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3420 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F2, CPU_FPU); }
#line 12301 "x86id.c"
yy1914:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1939;
	if(yych == 'n')	goto yy1939;
	goto yy239;
yy1915:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'A')	goto yy1924;
		if(yych <= 'S')	goto yy239;
		goto yy1925;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy239;
			goto yy1924;
		} else {
			if(yych == 't')	goto yy1925;
			goto yy239;
		}
	}
yy1916:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1920;
	if(yych == 'l')	goto yy1920;
	goto yy239;
yy1917:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1918;
	if(yych != 'p')	goto yy239;
yy1918:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3453 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9D0, CPU_FPU); }
#line 12332 "x86id.c"
yy1920:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1921;
	if(yych != 'e')	goto yy239;
yy1921:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy1922;
	if(yych != 'x')	goto yy239;
yy1922:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3443 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xDBE2, CPU_FPU); }
#line 12344 "x86id.c"
yy1924:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1936;
	if(yych == 'v')	goto yy1936;
	goto yy239;
yy1925:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'D'){
			if(yych != 'C')	goto yy239;
		} else {
			if(yych <= 'E')	goto yy1928;
			if(yych <= 'R')	goto yy239;
			goto yy1927;
		}
	} else {
		if(yych <= 'd'){
			if(yych != 'c')	goto yy239;
		} else {
			if(yych <= 'e')	goto yy1928;
			if(yych == 's')	goto yy1927;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1934;
	if(yych == 'w')	goto yy1934;
	goto yy239;
yy1927:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1932;
	if(yych == 'w')	goto yy1932;
	goto yy239;
yy1928:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1929;
	if(yych != 'n')	goto yy239;
yy1929:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1930;
	if(yych != 'v')	goto yy239;
yy1930:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3445 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebytemem, 0x06D9, CPU_FPU); }
#line 12386 "x86id.c"
yy1932:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3441 "./modules/arch/x86/x86id.re"
{ RET_INSN(fnstsw, 0, CPU_FPU); }
#line 12392 "x86id.c"
yy1934:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3439 "./modules/arch/x86/x86id.re"
{ RET_INSN(fldnstcw, 0x07, CPU_FPU); }
#line 12398 "x86id.c"
yy1936:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1937;
	if(yych != 'e')	goto yy239;
yy1937:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3448 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebytemem, 0x06DD, CPU_FPU); }
#line 12407 "x86id.c"
yy1939:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1940;
	if(yych != 'i')	goto yy239;
yy1940:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1941;
	if(yych != 't')	goto yy239;
yy1941:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3436 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xDBE3, CPU_FPU); }
#line 12419 "x86id.c"
yy1943:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1944;
	if(yych != 'l')	goto yy239;
yy1944:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy1945;
		if(yych <= 'O')	goto yy238;
		goto yy1946;
	} else {
		if(yych == 'p')	goto yy1946;
		goto yy238;
	}
yy1945:
#line 3409 "./modules/arch/x86/x86id.re"
{ RET_INSN(farith, 0x01C8C8, CPU_FPU); }
#line 12435 "x86id.c"
yy1946:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3411 "./modules/arch/x86/x86id.re"
{ RET_INSN(farithp, 0xC8, CPU_FPU); }
#line 12441 "x86id.c"
yy1948:	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= 'D'){
			if(yych <= '1'){
				if(yych <= '\000')	goto yy1949;
				if(yych <= '0')	goto yy238;
				goto yy1950;
			} else {
				if(yych == 'C')	goto yy1952;
				goto yy238;
			}
		} else {
			if(yych <= 'L'){
				if(yych <= 'E')	goto yy1953;
				if(yych <= 'K')	goto yy238;
				goto yy1954;
			} else {
				if(yych == 'P')	goto yy1955;
				goto yy238;
			}
		}
	} else {
		if(yych <= 'k'){
			if(yych <= 'c'){
				if(yych <= 'Z')	goto yy1956;
				if(yych <= 'b')	goto yy238;
				goto yy1952;
			} else {
				if(yych == 'e')	goto yy1953;
				goto yy238;
			}
		} else {
			if(yych <= 'p'){
				if(yych <= 'l')	goto yy1954;
				if(yych <= 'o')	goto yy238;
				goto yy1955;
			} else {
				if(yych == 'z')	goto yy1956;
				goto yy238;
			}
		}
	}
yy1949:
#line 3374 "./modules/arch/x86/x86id.re"
{ RET_INSN(fldstp, 0x0500C0, CPU_FPU); }
#line 12487 "x86id.c"
yy1950:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3393 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9E8, CPU_FPU); }
#line 12493 "x86id.c"
yy1952:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1974;
	if(yych == 'w')	goto yy1974;
	goto yy239;
yy1953:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1971;
	if(yych == 'n')	goto yy1971;
	goto yy239;
yy1954:	yych = *++YYCURSOR;
	if(yych <= 'M'){
		if(yych <= '2'){
			if(yych <= '1')	goto yy239;
			goto yy1960;
		} else {
			if(yych == 'G')	goto yy1961;
			goto yy239;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'N')	goto yy1962;
			if(yych <= 'f')	goto yy239;
			goto yy1961;
		} else {
			if(yych == 'n')	goto yy1962;
			goto yy239;
		}
	}
yy1955:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1958;
	if(yych == 'i')	goto yy1958;
	goto yy239;
yy1956:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3399 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9EE, CPU_FPU); }
#line 12530 "x86id.c"
yy1958:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3396 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9EB, CPU_FPU); }
#line 12536 "x86id.c"
yy1960:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'E')	goto yy1967;
		if(yych <= 'S')	goto yy239;
		goto yy1969;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy239;
			goto yy1967;
		} else {
			if(yych == 't')	goto yy1969;
			goto yy239;
		}
	}
yy1961:	yych = *++YYCURSOR;
	if(yych == '2')	goto yy1965;
	goto yy239;
yy1962:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3398 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9ED, CPU_FPU); }
#line 12561 "x86id.c"
yy1965:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3397 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9EC, CPU_FPU); }
#line 12567 "x86id.c"
yy1967:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3395 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9EA, CPU_FPU); }
#line 12573 "x86id.c"
yy1969:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3394 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9E9, CPU_FPU); }
#line 12579 "x86id.c"
yy1971:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1972;
	if(yych != 'v')	goto yy239;
yy1972:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3447 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebytemem, 0x04D9, CPU_FPU); }
#line 12588 "x86id.c"
yy1974:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3438 "./modules/arch/x86/x86id.re"
{ RET_INSN(fldnstcw, 0x05, CPU_FPU); }
#line 12594 "x86id.c"
yy1976:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2016;
	if(yych == 'd')	goto yy2016;
	goto yy239;
yy1977:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'S')	goto yy239;
		if(yych <= 'T')	goto yy2007;
		goto yy2009;
	} else {
		if(yych <= 's')	goto yy239;
		if(yych <= 't')	goto yy2007;
		if(yych <= 'u')	goto yy2009;
		goto yy239;
	}
yy1978:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy2002;
	if(yych == 'o')	goto yy2002;
	goto yy239;
yy1979:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1999;
	if(yych == 'd')	goto yy1999;
	goto yy239;
yy1980:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy1996;
	if(yych == 'u')	goto yy1996;
	goto yy239;
yy1981:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1991;
	if(yych == 'i')	goto yy1991;
	goto yy239;
yy1982:	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych == 'C')	goto yy1983;
		if(yych <= 'H')	goto yy239;
		goto yy1984;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy239;
		} else {
			if(yych == 'i')	goto yy1984;
			goto yy239;
		}
	}
yy1983:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1987;
	if(yych == 's')	goto yy1987;
	goto yy239;
yy1984:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1985;
	if(yych != 't')	goto yy239;
yy1985:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3437 "./modules/arch/x86/x86id.re"
{ RET_INSN(threebyte, 0x98DBE3UL, CPU_FPU); }
#line 12651 "x86id.c"
yy1987:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1988;
	if(yych != 't')	goto yy239;
yy1988:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1989;
	if(yych != 'p')	goto yy239;
yy1989:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3425 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F7, CPU_FPU); }
#line 12663 "x86id.c"
yy1991:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1992;
	if(yych != 'v')	goto yy239;
yy1992:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= '\000')	goto yy1993;
		if(yych <= 'Q')	goto yy238;
		goto yy1994;
	} else {
		if(yych == 'r')	goto yy1994;
		goto yy238;
	}
yy1993:
#line 3413 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x06DA, CPU_FPU); }
#line 12679 "x86id.c"
yy1994:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3416 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x07DA, CPU_FPU); }
#line 12685 "x86id.c"
yy1996:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1997;
	if(yych != 'l')	goto yy239;
yy1997:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3410 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x01DA, CPU_FPU); }
#line 12694 "x86id.c"
yy1999:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2000;
	if(yych != 'd')	goto yy239;
yy2000:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3402 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x00DA, CPU_FPU); }
#line 12703 "x86id.c"
yy2002:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy2003;
	if(yych != 'm')	goto yy239;
yy2003:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy2004;
		if(yych <= 'O')	goto yy238;
		goto yy2005;
	} else {
		if(yych == 'p')	goto yy2005;
		goto yy238;
	}
yy2004:
#line 3384 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x02DA, CPU_FPU); }
#line 12719 "x86id.c"
yy2005:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3386 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x03DA, CPU_FPU); }
#line 12725 "x86id.c"
yy2007:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy2008;
		if(yych <= 'O')	goto yy238;
		goto yy2014;
	} else {
		if(yych == 'p')	goto yy2014;
		goto yy238;
	}
yy2008:
#line 3378 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x02DB, CPU_FPU); }
#line 12738 "x86id.c"
yy2009:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy2010;
	if(yych != 'b')	goto yy239;
yy2010:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= '\000')	goto yy2011;
		if(yych <= 'Q')	goto yy238;
		goto yy2012;
	} else {
		if(yych == 'r')	goto yy2012;
		goto yy238;
	}
yy2011:
#line 3404 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x04DA, CPU_FPU); }
#line 12754 "x86id.c"
yy2012:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3407 "./modules/arch/x86/x86id.re"
{ RET_INSN(fiarith, 0x05DA, CPU_FPU); }
#line 12760 "x86id.c"
yy2014:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3380 "./modules/arch/x86/x86id.re"
{ RET_INSN(fildstp, 0x0703, CPU_FPU); }
#line 12766 "x86id.c"
yy2016:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3375 "./modules/arch/x86/x86id.re"
{ RET_INSN(fildstp, 0x0500, CPU_FPU); }
#line 12772 "x86id.c"
yy2018:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy2019;
	if(yych != 'e')	goto yy239;
yy2019:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy2020;
	if(yych != 'e')	goto yy239;
yy2020:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy2021;
		if(yych <= 'O')	goto yy238;
		goto yy2022;
	} else {
		if(yych == 'p')	goto yy2022;
		goto yy238;
	}
yy2021:
#line 3451 "./modules/arch/x86/x86id.re"
{ RET_INSN(ffree, 0xDD, CPU_FPU); }
#line 12791 "x86id.c"
yy2022:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3452 "./modules/arch/x86/x86id.re"
{ RET_INSN(ffree, 0xDF, CPU_686|CPU_FPU|CPU_Undoc); }
#line 12797 "x86id.c"
yy2024:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy2025;
	if(yych != 'm')	goto yy239;
yy2025:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2026;
	if(yych != 's')	goto yy239;
yy2026:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3754 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F0E, CPU_3DNow); }
#line 12809 "x86id.c"
yy2028:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy2035;
	if(yych == 'v')	goto yy2035;
	goto yy239;
yy2029:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy2030;
	if(yych != 'c')	goto yy239;
yy2030:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2031;
	if(yych != 's')	goto yy239;
yy2031:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2032;
	if(yych != 't')	goto yy239;
yy2032:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy2033;
	if(yych != 'p')	goto yy239;
yy2033:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3424 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F6, CPU_FPU); }
#line 12831 "x86id.c"
yy2035:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'O'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'P')	goto yy2037;
			if(yych <= 'Q')	goto yy238;
			goto yy2039;
		}
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy238;
			goto yy2037;
		} else {
			if(yych == 'r')	goto yy2039;
			goto yy238;
		}
	}

#line 3412 "./modules/arch/x86/x86id.re"
{ RET_INSN(farith, 0x06F0F8, CPU_FPU); }
#line 12853 "x86id.c"
yy2037:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3414 "./modules/arch/x86/x86id.re"
{ RET_INSN(farithp, 0xF8, CPU_FPU); }
#line 12859 "x86id.c"
yy2039:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy2040;
		if(yych <= 'O')	goto yy238;
		goto yy2041;
	} else {
		if(yych == 'p')	goto yy2041;
		goto yy238;
	}
yy2040:
#line 3415 "./modules/arch/x86/x86id.re"
{ RET_INSN(farith, 0x07F8F0, CPU_FPU); }
#line 12872 "x86id.c"
yy2041:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3417 "./modules/arch/x86/x86id.re"
{ RET_INSN(farithp, 0xF0, CPU_FPU); }
#line 12878 "x86id.c"
yy2043:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'M')	goto yy2069;
		if(yych <= 'R')	goto yy239;
		goto yy2071;
	} else {
		if(yych <= 'm'){
			if(yych <= 'l')	goto yy239;
			goto yy2069;
		} else {
			if(yych == 's')	goto yy2071;
			goto yy239;
		}
	}
yy2044:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2067;
	if(yych == 's')	goto yy2067;
	goto yy239;
yy2045:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy2064;
	if(yych == 'e')	goto yy2064;
	goto yy239;
yy2046:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy2047;
	if(yych != 'o')	goto yy239;
yy2047:	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy2048;
	if(yych != 'v')	goto yy239;
yy2048:	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'E'){
			if(yych == 'B')	goto yy2049;
			if(yych <= 'D')	goto yy239;
			goto yy2051;
		} else {
			if(yych == 'N')	goto yy2053;
			if(yych <= 'T')	goto yy239;
			goto yy2054;
		}
	} else {
		if(yych <= 'e'){
			if(yych == 'b')	goto yy2049;
			if(yych <= 'd')	goto yy239;
			goto yy2051;
		} else {
			if(yych <= 'n'){
				if(yych <= 'm')	goto yy239;
				goto yy2053;
			} else {
				if(yych == 'u')	goto yy2054;
				goto yy239;
			}
		}
	}
yy2049:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2050;
		if(yych <= 'D')	goto yy238;
		goto yy2062;
	} else {
		if(yych == 'e')	goto yy2062;
		goto yy238;
	}
yy2050:
#line 3522 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcmovcc, 0xDAC0, CPU_686|CPU_FPU); }
#line 12945 "x86id.c"
yy2051:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3523 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcmovcc, 0xDAC8, CPU_686|CPU_FPU); }
#line 12951 "x86id.c"
yy2053:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych == 'B')	goto yy2056;
		if(yych <= 'D')	goto yy239;
		goto yy2058;
	} else {
		if(yych <= 'b'){
			if(yych <= 'a')	goto yy239;
			goto yy2056;
		} else {
			if(yych == 'e')	goto yy2058;
			goto yy239;
		}
	}
yy2054:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3525 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcmovcc, 0xDAD8, CPU_686|CPU_FPU); }
#line 12971 "x86id.c"
yy2056:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2057;
		if(yych <= 'D')	goto yy238;
		goto yy2060;
	} else {
		if(yych == 'e')	goto yy2060;
		goto yy238;
	}
yy2057:
#line 3526 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcmovcc, 0xDBC0, CPU_686|CPU_FPU); }
#line 12984 "x86id.c"
yy2058:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3527 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcmovcc, 0xDBC8, CPU_686|CPU_FPU); }
#line 12990 "x86id.c"
yy2060:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3528 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcmovcc, 0xDBD0, CPU_686|CPU_FPU); }
#line 12996 "x86id.c"
yy2062:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3524 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcmovcc, 0xDAD0, CPU_686|CPU_FPU); }
#line 13002 "x86id.c"
yy2064:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy2065;
	if(yych != 'x')	goto yy239;
yy2065:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3444 "./modules/arch/x86/x86id.re"
{ RET_INSN(threebyte, 0x98DBE2UL, CPU_FPU); }
#line 13011 "x86id.c"
yy2067:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3434 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9E0, CPU_FPU); }
#line 13017 "x86id.c"
yy2069:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= 'H'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'I')	goto yy2075;
			if(yych <= 'O')	goto yy238;
			goto yy2073;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy238;
			goto yy2075;
		} else {
			if(yych == 'p')	goto yy2073;
			goto yy238;
		}
	}

#line 3383 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom, 0x02D0, CPU_FPU); }
#line 13039 "x86id.c"
yy2071:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3433 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9FF, CPU_286|CPU_FPU); }
#line 13045 "x86id.c"
yy2073:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy2074;
		if(yych <= 'O')	goto yy238;
		goto yy2079;
	} else {
		if(yych == 'p')	goto yy2079;
		goto yy238;
	}
yy2074:
#line 3385 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom, 0x03D8, CPU_FPU); }
#line 13058 "x86id.c"
yy2075:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy2076;
		if(yych <= 'O')	goto yy238;
		goto yy2077;
	} else {
		if(yych == 'p')	goto yy2077;
		goto yy238;
	}
yy2076:
#line 3530 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom2, 0xDBF0, CPU_686|CPU_FPU); }
#line 13071 "x86id.c"
yy2077:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3532 "./modules/arch/x86/x86id.re"
{ RET_INSN(fcom2, 0xDFF0, CPU_686|CPU_FPU); }
#line 13077 "x86id.c"
yy2079:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3387 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xDED9, CPU_FPU); }
#line 13083 "x86id.c"
yy2081:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2086;
	if(yych == 'd')	goto yy2086;
	goto yy239;
yy2082:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2083;
	if(yych != 't')	goto yy239;
yy2083:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy2084;
	if(yych != 'p')	goto yy239;
yy2084:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3381 "./modules/arch/x86/x86id.re"
{ RET_INSN(fbldstp, 0x06, CPU_FPU); }
#line 13099 "x86id.c"
yy2086:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3376 "./modules/arch/x86/x86id.re"
{ RET_INSN(fbldstp, 0x04, CPU_FPU); }
#line 13105 "x86id.c"
yy2088:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2538 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_FAR;
	    return YASM_ARCH_CHECK_ID_TARGETMOD;
	}
#line 13114 "x86id.c"
yy2090:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2094;
	if(yych == 'd')	goto yy2094;
	goto yy239;
yy2091:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2092;
	if(yych != 's')	goto yy239;
yy2092:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3435 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9E1, CPU_FPU); }
#line 13127 "x86id.c"
yy2094:	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych <= '\000')	goto yy2095;
		if(yych <= 'O')	goto yy238;
		goto yy2096;
	} else {
		if(yych == 'p')	goto yy2096;
		goto yy238;
	}
yy2095:
#line 3400 "./modules/arch/x86/x86id.re"
{ RET_INSN(farith, 0x00C0C0, CPU_FPU); }
#line 13140 "x86id.c"
yy2096:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3401 "./modules/arch/x86/x86id.re"
{ RET_INSN(farithp, 0xC0, CPU_FPU); }
#line 13146 "x86id.c"
yy2098:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy2099;
	if(yych != 'm')	goto yy239;
yy2099:	yych = *++YYCURSOR;
	if(yych != '1')	goto yy239;
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3418 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0xD9F0, CPU_FPU); }
#line 13157 "x86id.c"
yy2102:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'K'){
			if(yych == 'H')	goto yy2331;
			goto yy239;
		} else {
			if(yych <= 'L')	goto yy2332;
			if(yych <= 'Q')	goto yy239;
			goto yy2334;
		}
	} else {
		if(yych <= 'k'){
			if(yych == 'h')	goto yy2331;
			goto yy239;
		} else {
			if(yych <= 'l')	goto yy2332;
			if(yych == 'r')	goto yy2334;
			goto yy239;
		}
	}
yy2103:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy2329;
	if(yych == 'b')	goto yy2329;
	goto yy239;
yy2104:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy2319;
	if(yych == 'a')	goto yy2319;
	goto yy239;
yy2105:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2257;
	if(yych == 't')	goto yy2257;
	goto yy239;
yy2106:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy2252;
	if(yych == 'e')	goto yy2252;
	goto yy239;
yy2107:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2249;
	if(yych == 'd')	goto yy2249;
	goto yy239;
yy2108:	yych = *++YYCURSOR;
	switch(yych){
	case 'L':	case 'l':	goto yy2231;
	case 'O':	case 'o':	goto yy2230;
	case 'R':	case 'r':	goto yy2233;
	case 'U':	case 'u':	goto yy2235;
	default:	goto yy239;
	}
yy2109:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= 'C'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'D')	goto yy2227;
			if(yych <= 'K')	goto yy238;
			goto yy2225;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy238;
			goto yy2227;
		} else {
			if(yych == 'l')	goto yy2225;
			goto yy238;
		}
	}

#line 2800 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 6; return YASM_ARCH_CHECK_ID_REG; }
#line 13227 "x86id.c"
yy2111:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2222;
	if(yych == 'd')	goto yy2222;
	goto yy239;
yy2112:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'I')	goto yy2211;
		if(yych <= 'R')	goto yy239;
		goto yy2210;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy239;
			goto yy2211;
		} else {
			if(yych == 's')	goto yy2210;
			goto yy239;
		}
	}
yy2113:	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '\000')	goto yy2114;
		if(yych <= 'K')	goto yy238;
		goto yy2208;
	} else {
		if(yych == 'l')	goto yy2208;
		goto yy238;
	}
yy2114:
#line 2798 "./modules/arch/x86/x86id.re"
{ data[0] = X86_REG16 | 4; return YASM_ARCH_CHECK_ID_REG; }
#line 13258 "x86id.c"
yy2115:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy2196;
	if(yych == 'r')	goto yy2196;
	goto yy239;
yy2116:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2893 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64)
		yasm__warning(YASM_WARN_GENERAL, line,
		    N_("`%s' segment register ignored in 64-bit mode"), oid);
	    data[0] = 0x3602;
	    return YASM_ARCH_CHECK_ID_SEGREG;
	}
#line 13274 "x86id.c"
yy2118:	yych = *++YYCURSOR;
	switch(yych){
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy2170;
	case 'C':	case 'c':	goto yy2172;
	case 'D':	case 'd':	goto yy2174;
	case 'I':	case 'i':	goto yy2176;
	case 'M':	case 'm':	goto yy2181;
	case 'O':	case 'o':	goto yy2178;
	case 'R':	case 'r':	goto yy2179;
	default:	goto yy239;
	}
yy2119:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy2158;
	if(yych == 'b')	goto yy2158;
	goto yy239;
yy2120:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'K'){
			if(yych == 'D')	goto yy2148;
			goto yy239;
		} else {
			if(yych <= 'L')	goto yy2149;
			if(yych <= 'S')	goto yy239;
			goto yy2150;
		}
	} else {
		if(yych <= 'k'){
			if(yych == 'd')	goto yy2148;
			goto yy239;
		} else {
			if(yych <= 'l')	goto yy2149;
			if(yych == 't')	goto yy2150;
			goto yy239;
		}
	}
yy2121:	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy2143;
	if(yych == 'a')	goto yy2143;
	goto yy239;
yy2122:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2123;
	if(yych != 's')	goto yy239;
yy2123:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'D'){
			if(yych != 'C')	goto yy239;
		} else {
			if(yych <= 'E')	goto yy2125;
			if(yych <= 'Q')	goto yy239;
			goto yy2126;
		}
	} else {
		if(yych <= 'd'){
			if(yych != 'c')	goto yy239;
		} else {
			if(yych <= 'e')	goto yy2125;
			if(yych == 'r')	goto yy2126;
			goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy2139;
	if(yych == 'a')	goto yy2139;
	goto yy239;
yy2125:	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == 'N')	goto yy2130;
		if(yych <= 'W')	goto yy239;
		goto yy2131;
	} else {
		if(yych <= 'n'){
			if(yych <= 'm')	goto yy239;
			goto yy2130;
		} else {
			if(yych == 'x')	goto yy2131;
			goto yy239;
		}
	}
yy2126:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy2127;
	if(yych != 'e')	goto yy239;
yy2127:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2128;
	if(yych != 't')	goto yy239;
yy2128:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3781 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F07, CPU_686|CPU_AMD|CPU_Priv); }
#line 13371 "x86id.c"
yy2130:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2135;
	if(yych == 't')	goto yy2135;
	goto yy239;
yy2131:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy2132;
	if(yych != 'i')	goto yy239;
yy2132:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2133;
	if(yych != 't')	goto yy239;
yy2133:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3480 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(twobyte, 0x0F35, CPU_686|CPU_Priv);
	}
#line 13393 "x86id.c"
yy2135:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy2136;
	if(yych != 'e')	goto yy239;
yy2136:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy2137;
	if(yych != 'r')	goto yy239;
yy2137:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3473 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(twobyte, 0x0F34, CPU_686);
	}
#line 13411 "x86id.c"
yy2139:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy2140;
	if(yych != 'l')	goto yy239;
yy2140:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy2141;
	if(yych != 'l')	goto yy239;
yy2141:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3780 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F05, CPU_686|CPU_AMD); }
#line 13423 "x86id.c"
yy2143:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy2144;
	if(yych != 'p')	goto yy239;
yy2144:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy2145;
	if(yych != 'g')	goto yy239;
yy2145:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2146;
	if(yych != 's')	goto yy239;
yy2146:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3783 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(threebyte, 0x0F01F8, CPU_Hammer|CPU_64);
	}
#line 13446 "x86id.c"
yy2148:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy2156;
	if(yych == 'c')	goto yy2156;
	goto yy239;
yy2149:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2153;
	if(yych == 'd')	goto yy2153;
	goto yy239;
yy2150:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2151;
	if(yych != 's')	goto yy239;
yy2151:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3812 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixsmm, 0x7C, CPU_486|CPU_Cyrix|CPU_SMM); }
#line 13463 "x86id.c"
yy2153:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2154;
	if(yych != 't')	goto yy239;
yy2154:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3811 "./modules/arch/x86/x86id.re"
{ RET_INSN(cyrixsmm, 0x7A, CPU_486|CPU_Cyrix|CPU_SMM); }
#line 13472 "x86id.c"
yy2156:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3810 "./modules/arch/x86/x86id.re"
{ RET_INSN(svdc, 0, CPU_486|CPU_Cyrix|CPU_SMM); }
#line 13478 "x86id.c"
yy2158:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'O'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'P')	goto yy2160;
			if(yych <= 'R')	goto yy238;
			goto yy2161;
		}
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy238;
			goto yy2160;
		} else {
			if(yych == 's')	goto yy2161;
			goto yy238;
		}
	}

#line 3064 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0528, CPU_Any); }
#line 13500 "x86id.c"
yy2160:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy2168;
		if(yych <= 'R')	goto yy239;
		goto yy2166;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy2168;
		} else {
			if(yych == 's')	goto yy2166;
			goto yy239;
		}
	}
yy2161:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy2164;
		if(yych <= 'R')	goto yy239;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy2164;
		} else {
			if(yych != 's')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3667 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF35C, CPU_SSE); }
#line 13532 "x86id.c"
yy2164:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3719 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF25C, CPU_SSE2); }
#line 13538 "x86id.c"
yy2166:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3666 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x5C, CPU_SSE); }
#line 13544 "x86id.c"
yy2168:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3718 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x665C, CPU_SSE2); }
#line 13550 "x86id.c"
yy2170:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2647 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_FPUREG | (oid[2]-'0');
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 13559 "x86id.c"
yy2172:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3058 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00F9, CPU_Any); }
#line 13565 "x86id.c"
yy2174:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3059 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00FD, CPU_Any); }
#line 13571 "x86id.c"
yy2176:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3060 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00FB, CPU_Any); }
#line 13577 "x86id.c"
yy2178:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2187;
	if(yych == 's')	goto yy2187;
	goto yy239;
yy2179:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3370 "./modules/arch/x86/x86id.re"
{ RET_INSN(str, 0, CPU_286|CPU_Prot); }
#line 13587 "x86id.c"
yy2181:	yych = *++YYCURSOR;
	if(yych == 'X')	goto yy2182;
	if(yych != 'x')	goto yy239;
yy2182:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy2183;
	if(yych != 'c')	goto yy239;
yy2183:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2184;
	if(yych != 's')	goto yy239;
yy2184:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy2185;
	if(yych != 'r')	goto yy239;
yy2185:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3665 "./modules/arch/x86/x86id.re"
{ RET_INSN(ldstmxcsr, 0x03, CPU_SSE); }
#line 13605 "x86id.c"
yy2187:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych == 'B')	goto yy2188;
			if(yych <= 'C')	goto yy239;
			goto yy2192;
		} else {
			if(yych == 'Q')	goto yy2194;
			if(yych <= 'V')	goto yy239;
			goto yy2190;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'b')	goto yy2188;
			if(yych <= 'c')	goto yy239;
			goto yy2192;
		} else {
			if(yych <= 'q'){
				if(yych <= 'p')	goto yy239;
				goto yy2194;
			} else {
				if(yych == 'w')	goto yy2190;
				goto yy239;
			}
		}
	}
yy2188:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3298 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00AA, CPU_Any); }
#line 13637 "x86id.c"
yy2190:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3299 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x10AB, CPU_Any); }
#line 13643 "x86id.c"
yy2192:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3300 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x20AB, CPU_386); }
#line 13649 "x86id.c"
yy2194:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3301 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x40AB, CPU_Hammer|CPU_64);
	}
#line 13663 "x86id.c"
yy2196:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2197;
	if(yych != 't')	goto yy239;
yy2197:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'P')	goto yy2198;
		if(yych <= 'R')	goto yy239;
		goto yy2199;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
		} else {
			if(yych == 's')	goto yy2199;
			goto yy239;
		}
	}
yy2198:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy2204;
		if(yych <= 'R')	goto yy239;
		goto yy2206;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
			goto yy2204;
		} else {
			if(yych == 's')	goto yy2206;
			goto yy239;
		}
	}
yy2199:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy2200;
		if(yych <= 'R')	goto yy239;
		goto yy2202;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy2202;
			goto yy239;
		}
	}
yy2200:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3717 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF251, CPU_SSE2); }
#line 13712 "x86id.c"
yy2202:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3664 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0xF351, CPU_SSE); }
#line 13718 "x86id.c"
yy2204:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3716 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssess, 0x6651, CPU_SSE2); }
#line 13724 "x86id.c"
yy2206:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3663 "./modules/arch/x86/x86id.re"
{ RET_INSN(sseps, 0x51, CPU_SSE); }
#line 13730 "x86id.c"
yy2208:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2829 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG8X | 4;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 13744 "x86id.c"
yy2210:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy2220;
	if(yych == 'w')	goto yy2220;
	goto yy239;
yy2211:	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= '\000')	goto yy2212;
		if(yych <= 'M')	goto yy238;
		goto yy2213;
	} else {
		if(yych == 'n')	goto yy2213;
		goto yy238;
	}
yy2212:
#line 3828 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00F1, CPU_386|CPU_Undoc); }
#line 13761 "x86id.c"
yy2213:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2214;
	if(yych != 't')	goto yy239;
yy2214:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= '\000')	goto yy2215;
		if(yych <= 'N')	goto yy238;
		goto yy2216;
	} else {
		if(yych == 'o')	goto yy2216;
		goto yy238;
	}
yy2215:
#line 3813 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F38, CPU_686|CPU_Cyrix); }
#line 13777 "x86id.c"
yy2216:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy2217;
	if(yych != 'l')	goto yy239;
yy2217:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy2218;
	if(yych != 'd')	goto yy239;
yy2218:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3814 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobyte, 0x0F7E, CPU_486|CPU_Cyrix|CPU_Obs); }
#line 13789 "x86id.c"
yy2220:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3369 "./modules/arch/x86/x86id.re"
{ RET_INSN(sldtmsw, 0x0401, CPU_286); }
#line 13795 "x86id.c"
yy2222:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2223;
	if(yych != 't')	goto yy239;
yy2223:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3368 "./modules/arch/x86/x86id.re"
{ RET_INSN(sldtmsw, 0x0000, CPU_286); }
#line 13804 "x86id.c"
yy2225:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2847 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is a register in 64-bit mode"), oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    data[0] = X86_REG8X | 6;
	    return YASM_ARCH_CHECK_ID_REG;
	}
#line 13818 "x86id.c"
yy2227:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2228;
	if(yych != 't')	goto yy239;
yy2228:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3367 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x010F01, CPU_286|CPU_Priv); }
#line 13827 "x86id.c"
yy2230:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy2246;
	if(yych == 'r')	goto yy2246;
	goto yy239;
yy2231:	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= '\000')	goto yy2232;
		if(yych <= 'C')	goto yy238;
		goto yy2244;
	} else {
		if(yych == 'd')	goto yy2244;
		goto yy238;
	}
yy2232:
#line 3151 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x04, CPU_Any); }
#line 13844 "x86id.c"
yy2233:	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= '\000')	goto yy2234;
		if(yych <= 'C')	goto yy238;
		goto yy2242;
	} else {
		if(yych == 'd')	goto yy2242;
		goto yy238;
	}
yy2234:
#line 3152 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x05, CPU_Any); }
#line 13857 "x86id.c"
yy2235:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy2236;
	if(yych != 'f')	goto yy239;
yy2236:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy2237;
	if(yych != 'p')	goto yy239;
yy2237:	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == 'D')	goto yy2238;
		if(yych <= 'R')	goto yy239;
		goto yy2240;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy239;
		} else {
			if(yych == 's')	goto yy2240;
			goto yy239;
		}
	}
yy2238:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3715 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssessimm, 0x66C6, CPU_SSE2); }
#line 13882 "x86id.c"
yy2240:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3662 "./modules/arch/x86/x86id.re"
{ RET_INSN(ssepsimm, 0xC6, CPU_SSE); }
#line 13888 "x86id.c"
yy2242:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3155 "./modules/arch/x86/x86id.re"
{ RET_INSN(shlrd, 0xAC, CPU_386); }
#line 13894 "x86id.c"
yy2244:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3154 "./modules/arch/x86/x86id.re"
{ RET_INSN(shlrd, 0xA4, CPU_386); }
#line 13900 "x86id.c"
yy2246:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2247;
	if(yych != 't')	goto yy239;
yy2247:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2534 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_SHORT;
	    return YASM_ARCH_CHECK_ID_TARGETMOD;
	}
#line 13912 "x86id.c"
yy2249:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy2250;
	if(yych != 't')	goto yy239;
yy2250:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3366 "./modules/arch/x86/x86id.re"
{ RET_INSN(twobytemem, 0x000F01, CPU_286|CPU_Priv); }
#line 13921 "x86id.c"
yy2252:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy2253;
	if(yych != 'n')	goto yy239;
yy2253:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy2254;
	if(yych != 'c')	goto yy239;
yy2254:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy2255;
	if(yych != 'e')	goto yy239;
yy2255:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3661 "./modules/arch/x86/x86id.re"
{ RET_INSN(threebyte, 0x0FAEF8, CPU_P3); }
#line 13936 "x86id.c"
yy2257:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy2258;
	case 'B':	case 'b':	goto yy2260;
	case 'C':	case 'c':	goto yy2262;
	case 'E':	case 'e':	goto yy2264;
	case 'G':	case 'g':	goto yy2266;
	case 'L':	case 'l':	goto yy2268;
	case 'N':	case 'n':	goto yy2270;
	case 'O':	case 'o':	goto yy2271;
	case 'P':	case 'p':	goto yy2273;
	case 'S':	case 's':	goto yy2275;
	case 'Z':	case 'z':	goto yy2277;
	default:	goto yy239;
	}
yy2258:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2259;
		if(yych <= 'D')	goto yy238;
		goto yy2317;
	} else {
		if(yych == 'e')	goto yy2317;
		goto yy238;
	}
yy2259:
#line 3228 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x07, CPU_386); }
#line 13964 "x86id.c"
yy2260:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2261;
		if(yych <= 'D')	goto yy238;
		goto yy2315;
	} else {
		if(yych == 'e')	goto yy2315;
		goto yy238;
	}
yy2261:
#line 3215 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x02, CPU_386); }
#line 13977 "x86id.c"
yy2262:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3216 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x02, CPU_386); }
#line 13983 "x86id.c"
yy2264:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3221 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x04, CPU_386); }
#line 13989 "x86id.c"
yy2266:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2267;
		if(yych <= 'D')	goto yy238;
		goto yy2313;
	} else {
		if(yych == 'e')	goto yy2313;
		goto yy238;
	}
yy2267:
#line 3242 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0F, CPU_386); }
#line 14002 "x86id.c"
yy2268:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2269;
		if(yych <= 'D')	goto yy238;
		goto yy2311;
	} else {
		if(yych == 'e')	goto yy2311;
		goto yy238;
	}
yy2269:
#line 3235 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0C, CPU_386); }
#line 14015 "x86id.c"
yy2270:	yych = *++YYCURSOR;
	switch(yych){
	case 'A':	case 'a':	goto yy2285;
	case 'B':	case 'b':	goto yy2287;
	case 'C':	case 'c':	goto yy2289;
	case 'E':	case 'e':	goto yy2291;
	case 'G':	case 'g':	goto yy2299;
	case 'L':	case 'l':	goto yy2301;
	case 'O':	case 'o':	goto yy2283;
	case 'P':	case 'p':	goto yy2297;
	case 'S':	case 's':	goto yy2295;
	case 'Z':	case 'z':	goto yy2293;
	default:	goto yy239;
	}
yy2271:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3213 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x00, CPU_386); }
#line 14035 "x86id.c"
yy2273:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych >= '\001')	goto yy238;
		} else {
			if(yych <= 'E')	goto yy2279;
			if(yych <= 'N')	goto yy238;
			goto yy2281;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy238;
			goto yy2279;
		} else {
			if(yych == 'o')	goto yy2281;
			goto yy238;
		}
	}

#line 3231 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0A, CPU_386); }
#line 14057 "x86id.c"
yy2275:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3229 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x08, CPU_386); }
#line 14063 "x86id.c"
yy2277:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3222 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x04, CPU_386); }
#line 14069 "x86id.c"
yy2279:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3232 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0A, CPU_386); }
#line 14075 "x86id.c"
yy2281:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3234 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0B, CPU_386); }
#line 14081 "x86id.c"
yy2283:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3214 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x01, CPU_386); }
#line 14087 "x86id.c"
yy2285:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2286;
		if(yych <= 'D')	goto yy238;
		goto yy2309;
	} else {
		if(yych == 'e')	goto yy2309;
		goto yy238;
	}
yy2286:
#line 3226 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x06, CPU_386); }
#line 14100 "x86id.c"
yy2287:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2288;
		if(yych <= 'D')	goto yy238;
		goto yy2307;
	} else {
		if(yych == 'e')	goto yy2307;
		goto yy238;
	}
yy2288:
#line 3218 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x03, CPU_386); }
#line 14113 "x86id.c"
yy2289:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3219 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x03, CPU_386); }
#line 14119 "x86id.c"
yy2291:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3223 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x05, CPU_386); }
#line 14125 "x86id.c"
yy2293:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3224 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x05, CPU_386); }
#line 14131 "x86id.c"
yy2295:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3230 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x09, CPU_386); }
#line 14137 "x86id.c"
yy2297:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3233 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0B, CPU_386); }
#line 14143 "x86id.c"
yy2299:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2300;
		if(yych <= 'D')	goto yy238;
		goto yy2305;
	} else {
		if(yych == 'e')	goto yy2305;
		goto yy238;
	}
yy2300:
#line 3240 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0E, CPU_386); }
#line 14156 "x86id.c"
yy2301:	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= '\000')	goto yy2302;
		if(yych <= 'D')	goto yy238;
		goto yy2303;
	} else {
		if(yych == 'e')	goto yy2303;
		goto yy238;
	}
yy2302:
#line 3237 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0D, CPU_386); }
#line 14169 "x86id.c"
yy2303:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3241 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0F, CPU_386); }
#line 14175 "x86id.c"
yy2305:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3236 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0C, CPU_386); }
#line 14181 "x86id.c"
yy2307:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3227 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x07, CPU_386); }
#line 14187 "x86id.c"
yy2309:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3217 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x02, CPU_386); }
#line 14193 "x86id.c"
yy2311:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3239 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0E, CPU_386); }
#line 14199 "x86id.c"
yy2313:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3238 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x0D, CPU_386); }
#line 14205 "x86id.c"
yy2315:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3225 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x06, CPU_386); }
#line 14211 "x86id.c"
yy2317:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3220 "./modules/arch/x86/x86id.re"
{ RET_INSN(setcc, 0x03, CPU_386); }
#line 14217 "x86id.c"
yy2319:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy2320;
	if(yych != 's')	goto yy239;
yy2320:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'D'){
			if(yych == 'B')	goto yy2321;
			if(yych <= 'C')	goto yy239;
			goto yy2325;
		} else {
			if(yych == 'Q')	goto yy2327;
			if(yych <= 'V')	goto yy239;
			goto yy2323;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'b')	goto yy2321;
			if(yych <= 'c')	goto yy239;
			goto yy2325;
		} else {
			if(yych <= 'q'){
				if(yych <= 'p')	goto yy239;
				goto yy2327;
			} else {
				if(yych == 'w')	goto yy2323;
				goto yy239;
			}
		}
	}
yy2321:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3286 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x00AE, CPU_Any); }
#line 14252 "x86id.c"
yy2323:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3287 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x10AF, CPU_Any); }
#line 14258 "x86id.c"
yy2325:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3288 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x20AF, CPU_386); }
#line 14264 "x86id.c"
yy2327:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3289 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits != 64) {
		yasm__warning(YASM_WARN_GENERAL, line,
			      N_("`%s' is an instruction in 64-bit mode"),
			      oid);
		return YASM_ARCH_CHECK_ID_NONE;
	    }
	    RET_INSN(onebyte, 0x40AF, CPU_Hammer|CPU_64);
	}
#line 14278 "x86id.c"
yy2329:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3066 "./modules/arch/x86/x86id.re"
{ RET_INSN(arith, 0x0318, CPU_Any); }
#line 14284 "x86id.c"
yy2331:	yych = *++YYCURSOR;
	if(yych == 'F')	goto yy2338;
	if(yych == 'f')	goto yy2338;
	goto yy239;
yy2332:	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= '\000')	goto yy2333;
		if(yych <= 'B')	goto yy238;
		goto yy2336;
	} else {
		if(yych == 'c')	goto yy2336;
		goto yy238;
	}
yy2333:
#line 3150 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x04, CPU_Any); }
#line 14301 "x86id.c"
yy2334:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3153 "./modules/arch/x86/x86id.re"
{ RET_INSN(shift, 0x07, CPU_Any); }
#line 14307 "x86id.c"
yy2336:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3821 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x00D6, CPU_Undoc);
	}
#line 14319 "x86id.c"
yy2338:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3021 "./modules/arch/x86/x86id.re"
{
	    if (arch_x86->mode_bits == 64) {
		yasm__error(line, N_("`%s' invalid in 64-bit mode"), oid);
		RET_INSN(not64, 0, CPU_Not64);
	    }
	    RET_INSN(onebyte, 0x009E, CPU_Any);
	}
#line 14331 "x86id.c"
yy2340:	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych == 'A')	goto yy2346;
		if(yych <= 'F')	goto yy239;
		goto yy2347;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy239;
			goto yy2346;
		} else {
			if(yych == 'g')	goto yy2347;
			goto yy239;
		}
	}
yy2341:	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'P')	goto yy2344;
		if(yych <= 'S')	goto yy239;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy239;
			goto yy2344;
		} else {
			if(yych != 't')	goto yy239;
		}
	}
	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3074 "./modules/arch/x86/x86id.re"
{ RET_INSN(f6, 0x02, CPU_Any); }
#line 14363 "x86id.c"
yy2344:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3350 "./modules/arch/x86/x86id.re"
{ RET_INSN(onebyte, 0x0090, CPU_Any); }
#line 14369 "x86id.c"
yy2346:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy2349;
	if(yych == 'r')	goto yy2349;
	goto yy239;
yy2347:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 3073 "./modules/arch/x86/x86id.re"
{ RET_INSN(f6, 0x03, CPU_Any); }
#line 14379 "x86id.c"
yy2349:	yych = *++YYCURSOR;
	if(yych >= '\001')	goto yy238;

#line 2530 "./modules/arch/x86/x86id.re"
{
	    data[0] = X86_NEAR;
	    return YASM_ARCH_CHECK_ID_TARGETMOD;
	}
#line 14388 "x86id.c"
}
#line 3840 "./modules/arch/x86/x86id.re"

}
