


RE2C(1)                                                   RE2C(1)


NNAAMMEE
       re2c - convert regular expressions to C/C++


SSYYNNOOPPSSIISS
       rree22cc [--eessbb] _n_a_m_e


DDEESSCCRRIIPPTTIIOONN
       rree22cc  is a preprocessor that generates C-based recognizers
       from regular expressions.  The input to rree22cc  consists  of
       C/C++ source interleaved with comments of the form //**!!rree22cc
       ... **// which contain scanner specifications.  In the  out-
       put  these comments are replaced with code that, when exe-
       cuted, will find the next input  token  and  then  execute
       some user-supplied token-specific code.

       For example, given the following code

          #define NULL            ((char*) 0)
          char *scan(char *p){
          char *q;
          #define YYCTYPE         char
          #define YYCURSOR        p
          #define YYLIMIT         p
          #define YYMARKER        q
          #define YYFILL(n)
          /*!re2c
                  [0-9]+          {return YYCURSOR;}
                  [\000-\377]     {return NULL;}
          */
          }

       rree22cc will generate

          /* Generated by re2c on Sat Apr 16 11:40:58 1994 */
          #line 1 "simple.re"
          #define NULL            ((char*) 0)
          char *scan(char *p){
          char *q;
          #define YYCTYPE         char
          #define YYCURSOR        p
          #define YYLIMIT         p
          #define YYMARKER        q
          #define YYFILL(n)
          {
                  YYCTYPE yych;
                  unsigned int yyaccept;
                  goto yy0;
          yy1:    ++YYCURSOR;
          yy0:
                  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
                  yych = *YYCURSOR;
                  if(yych <= '/') goto yy4;



Version 0.5                8 April 1994                         1





RE2C(1)                                                   RE2C(1)


                  if(yych >= ':') goto yy4;
          yy2:    yych = *++YYCURSOR;
                  goto yy7;
          yy3:
          #line 10
                  {return YYCURSOR;}
          yy4:    yych = *++YYCURSOR;
          yy5:
          #line 11
                  {return NULL;}
          yy6:    ++YYCURSOR;
                  if(YYLIMIT == YYCURSOR) YYFILL(1);
                  yych = *YYCURSOR;
          yy7:    if(yych <= '/') goto yy3;
                  if(yych <= '9') goto yy6;
                  goto yy3;
          }
          #line 12

          }


OOPPTTIIOONNSS
       rree22cc provides the following options:

       --ee     Cross-compile  from  an ASCII platform to an EBCDIC
              one.

       --ss     Generate nested iiffs for some sswwiittcchhes.   Many  com-
              pilers need this assist to generate better code.

       --bb     Implies --ss.  Use bit vectors as well in the attempt
              to coax better code out of the compiler.  Most use-
              ful  for  specifications  with more than a few key-
              words (e.g. for most programming languages).


IINNTTEERRFFAACCEE CCOODDEE
       Unlike other scanner generators, rree22cc  does  not  generate
       complete  scanners:  the  user  must supply some interface
       code.  In particular, the user must define  the  following
       macros:

       YYYYCCHHAARR Type used to hold an input symbol.  Usually cchhaarr or
              uunnssiiggnneedd cchhaarr.

       YYYYCCUURRSSOORR
              _l-expression of type **YYYYCCHHAARR  that  points  to  the
              current  input symbol.  The generated code advances
              YYYYCCUURRSSOORR as symbols are matched.  On entry,  YYYYCCUURR--
              SSOORR  is  assumed to point to the first character of
              the current token.  On exit, YYYYCCUURRSSOORR will point to
              the first character of the following token.




Version 0.5                8 April 1994                         2





RE2C(1)                                                   RE2C(1)


       YYLLIIMMIITT Expression  of  type  **YYYYCCHHAARR that marks the end of
              the buffer (YYLLIIMMIITT[[--11]] is the last character in the
              buffer).   The  generated  code repeatedly compares
              YYYYCCUURRSSOORR to YYLLIIMMIITT to  determine  when  the  buffer
              needs (re)filling.

       YYYYMMAARRKKEERR
              _l-expression  of  type **YYYYCCHHAARR.  The generated code
              saves backtracking information in YYYYMMAARRKKEERR.

       YYYYFFIILLLL((_n))
              The generated code "calls" YYYYFFIILLLL when  the  buffer
              needs  (re)filling:   at least _n additional charac-
              ters should  be  provided.   YYYYFFIILLLL  should  adjust
              YYYYCCUURRSSOORR,  YYYYLLIIMMIITT  and  YYYYMMAARRKKEERR  as needed.  Note
              that for typical programming languages  _n  will  be
              the length of the longest keyword plus one.


SSCCAANNNNEERR SSPPEECCIIFFIICCAATTIIOONNSS
       Each  scanner specification consists of a set of _r_u_l_e_s and
       name definitions.  Rules consist of a  regular  expression
       along  with  a  block of C/C++ code that is to be executed
       when the associated regular expression is  matched.   Name
       definitions  are  of  the  form  ``_n_a_m_e  == _r_e_g_u_l_a_r _e_x_p_r_e_s_-
       _s_i_o_n;;''.


SSUUMMMMAARRYY OOFF RREE22CC RREEGGUULLAARR EEXXPPRREESSSSIIOONNSS
       ""ffoooo""  the literal string ffoooo.   ANSI-C  escape  sequences
              can be used.

       [[xxyyzz]]  a  "character  class";  in  this  case, the regular
              expression matches either an 'xx', a 'yy', or a  'zz'.

       [[aabbjj--ooZZ]]
              a  "character class" with a range in it; matches an
              'aa', a 'bb', any letter from 'jj' through 'oo',  or  a
              'ZZ'.

       _r\\_s    match any _r which isn't an _s. _r and _s must be regu-
              lar expressions which can be expressed as character
              classes.

       _r**     zero or more _r's, where _r is any regular expression

       _r++     one or more _r's

       _r??     zero or one _r's (that is, "an optional _r")

       name   the expansion of the "name" definition (see above)

       ((_r))    an _r; parentheses are used to  override  precedence
              (see below)



Version 0.5                8 April 1994                         3





RE2C(1)                                                   RE2C(1)


       _r_s     an _r followed by an _s ("concatenation")

       _r||_s    either an _r or an _s

       _r//_s    an  _r  but only if it is followed by an _s. The s is
              not part of the matched text. This type of  regular
              expression is called "trailing context".

       The regular expressions listed above are grouped according
       to precedence, from highest precedence at the top to  low-
       est  at  the  bottom.   Those  grouped together have equal
       precedence.


AA LLAARRGGEERR EEXXAAMMPPLLEE
          #include <stdlib.h>
          #include <stdio.h>
          #include <fcntl.h>
          #include <string.h>

          #define ADDEQ   257
          #define ANDAND  258
          #define ANDEQ   259
          #define ARRAY   260
          #define ASM     261
          #define AUTO    262
          #define BREAK   263
          #define CASE    264
          #define CHAR    265
          #define CONST   266
          #define CONTINUE        267
          #define DECR    268
          #define DEFAULT 269
          #define DEREF   270
          #define DIVEQ   271
          #define DO      272
          #define DOUBLE  273
          #define ELLIPSIS        274
          #define ELSE    275
          #define ENUM    276
          #define EQL     277
          #define EXTERN  278
          #define FCON    279
          #define FLOAT   280
          #define FOR     281
          #define FUNCTION        282
          #define GEQ     283
          #define GOTO    284
          #define ICON    285
          #define ID      286
          #define IF      287
          #define INCR    288
          #define INT     289
          #define LEQ     290



Version 0.5                8 April 1994                         4





RE2C(1)                                                   RE2C(1)


          #define LONG    291
          #define LSHIFT  292
          #define LSHIFTEQ        293
          #define MODEQ   294
          #define MULEQ   295
          #define NEQ     296
          #define OREQ    297
          #define OROR    298
          #define POINTER 299
          #define REGISTER        300
          #define RETURN  301
          #define RSHIFT  302
          #define RSHIFTEQ        303
          #define SCON    304
          #define SHORT   305
          #define SIGNED  306
          #define SIZEOF  307
          #define STATIC  308
          #define STRUCT  309
          #define SUBEQ   310
          #define SWITCH  311
          #define TYPEDEF 312
          #define UNION   313
          #define UNSIGNED        314
          #define VOID    315
          #define VOLATILE        316
          #define WHILE   317
          #define XOREQ   318
          #define EOI     319

          typedef unsigned int uint;
          typedef unsigned char uchar;

          #define BSIZE   8192

          #define YYCTYPE         uchar
          #define YYCURSOR        cursor
          #define YYLIMIT         s->lim
          #define YYMARKER        s->ptr
          #define YYFILL(n)       {cursor = fill(s, cursor);}

          #define RET(i)  {s->cur = cursor; return i;}

          typedef struct Scanner {
              int                 fd;
              uchar               *bot, *tok, *ptr, *cur, *pos, *lim, *top, *eof;
              uint                line;
          } Scanner;

          uchar *fill(Scanner *s, uchar *cursor){
              if(!s->eof){
                  uint cnt = s->tok - s->bot;
                  if(cnt){
                      memcpy(s->bot, s->tok, s->lim - s->tok);



Version 0.5                8 April 1994                         5





RE2C(1)                                                   RE2C(1)


                      s->tok = s->bot;
                      s->ptr -= cnt;
                      cursor -= cnt;
                      s->pos -= cnt;
                      s->lim -= cnt;
                  }
                  if((s->top - s->lim) < BSIZE){
                      uchar *buf = (uchar*)
                          malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
                      memcpy(buf, s->tok, s->lim - s->tok);
                      s->tok = buf;
                      s->ptr = &buf[s->ptr - s->bot];
                      cursor = &buf[cursor - s->bot];
                      s->pos = &buf[s->pos - s->bot];
                      s->lim = &buf[s->lim - s->bot];
                      s->top = &s->lim[BSIZE];
                      free(s->bot);
                      s->bot = buf;
                  }
                  if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
                      s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
                  }
                  s->lim += cnt;
              }
              return cursor;
          }

          int scan(Scanner *s){
                  uchar *cursor = s->cur;
          std:
                  s->tok = cursor;
          /*!re2c
          any     = [\000-\377];
          O       = [0-7];
          D       = [0-9];
          L       = [a-zA-Z_];
          H       = [a-fA-F0-9];
          E       = [Ee] [+-]? D+;
          FS      = [fFlL];
          IS      = [uUlL]*;
          ESC     = [\\] ([abfnrtv?'"\\] | "x" H+ | O+);
          */

          /*!re2c
                  "/*"                    { goto comment; }

                  "auto"                  { RET(AUTO); }
                  "break"                 { RET(BREAK); }
                  "case"                  { RET(CASE); }
                  "char"                  { RET(CHAR); }
                  "const"                 { RET(CONST); }
                  "continue"              { RET(CONTINUE); }
                  "default"               { RET(DEFAULT); }
                  "do"                    { RET(DO); }



Version 0.5                8 April 1994                         6





RE2C(1)                                                   RE2C(1)


                  "double"                { RET(DOUBLE); }
                  "else"                  { RET(ELSE); }
                  "enum"                  { RET(ENUM); }
                  "extern"                { RET(EXTERN); }
                  "float"                 { RET(FLOAT); }
                  "for"                   { RET(FOR); }
                  "goto"                  { RET(GOTO); }
                  "if"                    { RET(IF); }
                  "int"                   { RET(INT); }
                  "long"                  { RET(LONG); }
                  "register"              { RET(REGISTER); }
                  "return"                { RET(RETURN); }
                  "short"                 { RET(SHORT); }
                  "signed"                { RET(SIGNED); }
                  "sizeof"                { RET(SIZEOF); }
                  "static"                { RET(STATIC); }
                  "struct"                { RET(STRUCT); }
                  "switch"                { RET(SWITCH); }
                  "typedef"               { RET(TYPEDEF); }
                  "union"                 { RET(UNION); }
                  "unsigned"              { RET(UNSIGNED); }
                  "void"                  { RET(VOID); }
                  "volatile"              { RET(VOLATILE); }
                  "while"                 { RET(WHILE); }

                  L (L|D)*                { RET(ID); }

                  ("0" [xX] H+ IS?) | ("0" D+ IS?) | (D+ IS?) |
                  (['] (ESC|any\[\n\\'])* ['])
                                          { RET(ICON); }

                  (D+ E FS?) | (D* "." D+ E? FS?) | (D+ "." D* E? FS?)
                                          { RET(FCON); }

                  (["] (ESC|any\[\n\\"])* ["])
                                          { RET(SCON); }

                  "..."                   { RET(ELLIPSIS); }
                  ">>="                   { RET(RSHIFTEQ); }
                  "<<="                   { RET(LSHIFTEQ); }
                  "+="                    { RET(ADDEQ); }
                  "-="                    { RET(SUBEQ); }
                  "*="                    { RET(MULEQ); }
                  "/="                    { RET(DIVEQ); }
                  "%="                    { RET(MODEQ); }
                  "&="                    { RET(ANDEQ); }
                  "^="                    { RET(XOREQ); }
                  "|="                    { RET(OREQ); }
                  ">>"                    { RET(RSHIFT); }
                  "<<"                    { RET(LSHIFT); }
                  "++"                    { RET(INCR); }
                  "--"                    { RET(DECR); }
                  "->"                    { RET(DEREF); }
                  "&&"                    { RET(ANDAND); }



Version 0.5                8 April 1994                         7





RE2C(1)                                                   RE2C(1)


                  "||"                    { RET(OROR); }
                  "<="                    { RET(LEQ); }
                  ">="                    { RET(GEQ); }
                  "=="                    { RET(EQL); }
                  "!="                    { RET(NEQ); }
                  ";"                     { RET(';'); }
                  "{"                     { RET('{'); }
                  "}"                     { RET('}'); }
                  ","                     { RET(','); }
                  ":"                     { RET(':'); }
                  "="                     { RET('='); }
                  "("                     { RET('('); }
                  ")"                     { RET(')'); }
                  "["                     { RET('['); }
                  "]"                     { RET(']'); }
                  "."                     { RET('.'); }
                  "&"                     { RET('&'); }
                  "!"                     { RET('!'); }
                  "~"                     { RET('~'); }
                  "-"                     { RET('-'); }
                  "+"                     { RET('+'); }
                  "*"                     { RET('*'); }
                  "/"                     { RET('/'); }
                  "%"                     { RET('%'); }
                  "<"                     { RET('<'); }
                  ">"                     { RET('>'); }
                  "^"                     { RET('^'); }
                  "|"                     { RET('|'); }
                  "?"                     { RET('?'); }


                  [ \t\v\f]+           { goto std; }

                  "\n"
                      {
                          if(cursor == s->eof) RET(EOI);
                          s->pos = cursor; s->line++;
                          goto std;
                      }

                  any
                      {
                          printf("unexpected character: %c\n", *s->tok);
                          goto std;
                      }
          */

          comment:
          /*!re2c
                  "*/"                    { goto std; }
                  "\n"
                      {
                          if(cursor == s->eof) RET(EOI);
                          s->tok = s->pos = cursor; s->line++;



Version 0.5                8 April 1994                         8





RE2C(1)                                                   RE2C(1)


                          goto comment;
                      }
                  any                     { goto comment; }
          */
          }

          main(){
              Scanner in;
              int t;
              memset((char*) &in, 0, sizeof(in));
              in.fd = 0;
              while((t = scan(&in)) != EOI){
          /*
                  printf("%d\t%.*s\n", t, in.cur - in.tok, in.tok);
                  printf("%d\n", t);
          */
              }
              close(in.fd);
          }


SSEEEE AALLSSOO
       flex(1), lex(1).


FFEEAATTUURREESS
       rree22cc does not provide a default action: the generated code
       assumes  that  the  input  will  consist  of a sequence of
       tokens.  Typically this can be dealt with by adding a rule
       such  as  the one for unexpected characters in the example
       above.

       The user must arrange for a sentinel token  to  appear  at
       the  end  of  input  (and provide a rule for matching it):
       rree22cc does not  provide  an  <<<<EEOOFF>>>>  expression.   If  the
       source  is  from  a  null-byte  terminated  string, a rule
       matching a null character will suffice.  If the source  is
       from  a file then the approach taken in the example can be
       used: pad the input with a newline (or some other  charac-
       ter  that  can't appear within another token); upon recog-
       nizing such a character check to see if it is the sentinel
       and act accordingly.

       rree22cc  does  not  provide start conditions:  use a separate
       scanner specification for each start condition (as  illus-
       trated in the above example).

       No [^x].  Use difference instead.

BBUUGGSS
       Only fixed length trailing context can be handled.

       The  maximum value appearing as a parameter _n to YYYYFFIILLLL is
       not provided to the generated code (this value  is  needed



Version 0.5                8 April 1994                         9





RE2C(1)                                                   RE2C(1)


       for  constructing  the  interface  code).   Note that this
       value is usually relatively small: for typical programming
       languages _n will be the length of the longest keyword plus
       one.

       Difference only works for character sets.

       The rree22cc internal algorithms need documentation.


AAUUTTHHOORR
       Please send bug reports, fixes and feedback to:

       Peter Bumbulis
       Computer Systems Group
       University of Waterloo
       Waterloo, Ontario
       N2L 3G1
       Internet:  peterr@csg.uwaterloo.ca






































Version 0.5                8 April 1994                        10


