/****************************************************************************
 *
 * 			color.cc: Color type and operators implementation 
 *      This is part of the yafray package
 *      Copyright (C) 2002  Alejandro Conty Estvez
 *
 *      This library is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU Lesser General Public
 *      License as published by the Free Software Foundation; either
 *      version 2.1 of the License, or (at your option) any later version.
 *
 *      This library is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *      Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public
 *      License along with this library; if not, write to the Free Software
 *      Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *      
 */

#include "color.h"
using namespace std;
#include<iostream>

__BEGIN_YAFRAY

void operator >> (unsigned char *data,color_t &c)
{
	c.R= ((CFLOAT) data[0])/((CFLOAT)255);
	c.G= ((CFLOAT) data[1])/((CFLOAT)255);
	c.B= ((CFLOAT) data[2])/((CFLOAT)255);
}

void operator << (unsigned char *data,const color_t &c)
{
	data[0]=(char)( ((CFLOAT)255) * ((c.R>(CFLOAT)1) ? 1 :c.R) );
	data[1]=(char)( ((CFLOAT)255) * ((c.G>(CFLOAT)1) ? 1 :c.G) );
	data[2]=(char)( ((CFLOAT)255) * ((c.B>(CFLOAT)1) ? 1 :c.B) );
}

void operator >> (unsigned char *data,colorA_t &c)
{
	c.R = ((CFLOAT) data[0])/((CFLOAT)255);
	c.G = ((CFLOAT) data[1])/((CFLOAT)255);
	c.B = ((CFLOAT) data[2])/((CFLOAT)255);
	c.A = ((CFLOAT) data[3])/((CFLOAT)255);
}


void operator << (unsigned char *data,const colorA_t &c)
{
	data[0] = (char)( ((CFLOAT)255) * ((c.R>(CFLOAT)1) ? 1 :c.R) );
	data[1] = (char)( ((CFLOAT)255) * ((c.G>(CFLOAT)1) ? 1 :c.G) );
	data[2] = (char)( ((CFLOAT)255) * ((c.B>(CFLOAT)1) ? 1 :c.B) );
	data[3] = (char)( ((CFLOAT)255) * ((c.A>(CFLOAT)1) ? 1 :c.A) );
}

void operator >> (float *data,color_t &c)
{
	c.R = data[0];
	c.G = data[1];
	c.B = data[2];
}


void operator << (float *data,const color_t &c)
{
	data[0] = c.R;
	data[1] = c.G;
	data[2] = c.B;
}

void operator >> (float *data,colorA_t &c)
{
	c.R = data[0];
	c.G = data[1];
	c.B = data[2];
	c.A = data[3];
}


void operator << (float *data,const colorA_t &c)
{
	data[0] = c.R;
	data[1] = c.G;
	data[2] = c.B;
	data[3] = c.A;
}

//char lumtochar[12]=" -;+&%G@$*";

ostream & operator << (ostream & out,const color_t c)
{
	out<<"["<<c.R<<" "<<c.G<<" "<<c.B<<"]";
	return out;
}

ostream & operator << (ostream & out,const colorA_t c)
{
	out << "[" << c.R << ", " << c.G << ", " << c.B << ", " << c.A << "]";
	return out;
}

color_t mix(const color_t &a,const color_t &b,CFLOAT point)
{
	if(point<0.0) return b;
	if(point>1.0) return a;

	return ( a*point + (1-point)*b );
}

colorA_t mix(const colorA_t &a,const colorA_t &b,CFLOAT point)
{
	if(point<0.0) return b;
	if(point>1.0) return a;

	return ( a*point + (1-point)*b );
}

color_t convergenceAccell(const color_t &cn_1,const color_t &cn0,const color_t &cn1)
{
	CFLOAT r=(cn1.R-2.0*cn0.R+cn_1.R);
	if(r!=0.0)
		r=cn1.R - ((cn1.R-cn0.R)*(cn1.R-cn0.R))/r;
	else
		r=cn1.R;
	CFLOAT g=(cn1.G-2.0*cn0.G+cn_1.G);
	if(g!=0.0)
		g=cn1.G - ((cn1.G-cn0.G)*(cn1.G-cn0.G))/g;
	else
		g=cn1.G;
	CFLOAT b=(cn1.B-2.0*cn0.B+cn_1.B);
	if(b!=0.0)
		b=cn1.B - ((cn1.B-cn0.B)*(cn1.B-cn0.B))/b;
	else
		b=cn1.B;

	return color_t(r,g,b);
}

color_t BilerpWeight(CFLOAT xf, CFLOAT yf,
		const color_t &c1, const color_t &c2,
		const color_t &c3, const color_t &c4)

{
	CFLOAT dx=xf-floor(xf), dy=yf-floor(yf);
	CFLOAT w0=(1-dx)*(1-dy), w1=(1-dx)*dy, w2=dx*(1-dy), w3=dx*dy;
	return color_t(	w0*c1.R + w1*c3.R + w2*c2.R + w3*c4.R,
			w0*c1.G + w1*c3.G + w2*c2.G + w3*c4.G,
			w0*c1.B + w1*c3.B + w2*c2.B + w3*c4.B);
}

colorA_t BilerpWeight(CFLOAT xf, CFLOAT yf,
		const colorA_t &c1, const colorA_t &c2,
		const colorA_t &c3, const colorA_t &c4)
{
	CFLOAT dx=xf-floor(xf), dy=yf-floor(yf);
	CFLOAT w0=(1-dx)*(1-dy), w1=(1-dx)*dy, w2=dx*(1-dy), w3=dx*dy;
	return colorA_t(	w0*c1.R + w1*c3.R + w2*c2.R + w3*c4.R,
									w0*c1.G + w1*c3.G + w2*c2.G + w3*c4.G,
									w0*c1.B + w1*c3.B + w2*c2.B + w3*c4.B,
									w0*c1.A + w1*c3.A + w2*c2.A + w3*c4.A);
}

__END_YAFRAY
