/****************************************************************************
 *
 * 			camera.cc: Camera implementation
 *      This is part of the yafray package
 *      Copyright (C) 2002  Alejandro Conty Estvez
 *
 *      This library is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU Lesser General Public
 *      License as published by the Free Software Foundation; either
 *      version 2.1 of the License, or (at your option) any later version.
 *
 *      This library is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *      Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public
 *      License along with this library; if not, write to the Free Software
 *      Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */


#include "camera.h"

__BEGIN_YAFRAY

camera_t::camera_t(const point3d_t &pos,const point3d_t &look,
		 const point3d_t &up,int _resx,int _resy, PFLOAT df, PFLOAT ap, bool useq)
{
	vup = up-pos;
	vto = look-pos;
	fdist = vto.length();
	vright = vup^vto;
	vup = vright^vto;
	vup.normalize();
	vto.normalize();
	vright.normalize();
	_eye = _position = pos;
	resx = _resx;
	resy = _resy;
	focal_distance = df;
	xXr = 1.0 / (PFLOAT)resx;
	yYr = 1.0 / (PFLOAT)resy;
	yratio = ((PFLOAT)resy)/((PFLOAT)resx);
	aperture = ap;
	HSEQ1.setBase(2);
	HSEQ2.setBase(3);
	use_qmc = useq;
}


vector3d_t  camera_t::shootRay(PFLOAT px, PFLOAT py)
{
	vector3d_t ray = vright*(0.5- px*xXr) + vup*((py*yYr - 0.5)*yratio) + (vto*focal_distance);
	ray.normalize();
	if (aperture!=0) {
		PFLOAT u, v;
		if (use_qmc)
			ShirleyDisc(HSEQ1.getNext(), HSEQ2.getNext(), u, v);
		else
			ShirleyDisc(ourRandom(), ourRandom(), u, v);
		vector3d_t LI = aperture * (vright*u + vup*v);
		_position = _eye + point3d_t(LI);
		ray = (ray * fdist) - LI;
		ray.normalize();
	}
	return ray;
}
__END_YAFRAY
