#!/usr/bin/perl -w

$mapname = "mapgen.map";

if( @ARGV % 2 ) {
	push @ARGV, $mapname; #even number of map names.
}
$maps = @ARGV;

$height = 2 + $maps/2 * 3; # 3 lines per 2 map entrances.
die "Min maps = 4" if $maps < 4;

die unless open F, ">$mapname"; 

print F <<EOT;
#Generated by mapgen.pl
link map..
16 $height
default.table
Generated by mapgen.pl
EOT

@base = ();
@object = ();
@event = ();

####################################################################

print F "BASE\n";
for( $i = 0 ; $i + 3 < $height - 1 ; $i += 3 ) {
	push @base, '.' x 16 . "\n"; 
	push @base, '.' x 16 . "\n"; 
	push @base, "....S......S....\n";
}
push @base, '.' x 16 . "\n"; 
push @base, '.' x 16 . "\n"; 
print F @base;

#####################################################################

print F "OBJECT\n";
for( $i = 0 ; $i < $height ; $i++ ) {
	push @object, ' ' x 16 . "\n";
}
print F @object;

######################################################################

print F "EVENT\n";

$id = 0;
foreach( @base ) {
	if( /S/ ) {
		if( $id > 9 ) {
			$a = chr( 55 + $id++);
			$b = chr( 55 + $id++);
		} else {
			$a = $id++;
			$b = $id++;
		}
		s/[^S^\n]/ /g;
		s/S/$a/;
		s/S/$b/;
		push @event, $_;
	} else {
		push @event, ' ' x 16 . "\n";
	}
}


print F @event;

######################################################################

print F "EVENTMETA\n";

for( $i=0 ; $i < $id ; $i++ ) {
	if( $i <= 9 ) {
		$c = $i;
	} else {
		$c = chr(55 + $i);
	}
	print "i = $i, map = $ARGV[$i]\n";
	print F "endlevel $c y y y y $ARGV[$i]\n";
}

######################################################################

print F "TEXT\n";

$x = 224;
$y = 64;
for( $i = 0 ; $i < $maps ; $i++ ) {
	print F "$x $y black 1 $ARGV[$i]\n";
	if( $i % 2 ) { 
		$x = 224;
		$y += 192;
	} else {
		$x = 672;
	}
}


######################################################################

print F <<EOT;
ENTITY
SPAWN 64 64 128 0
EOT

