#! /usr/bin/perl -w

# Ham contest logger Xtlf.pl by PA0R. 

# This program is published under the GPL license.
#   Copyright (C) 2006
#       Rein Couperus PA0R (rein at couperus.com)
# 
# *    Xtlf.pl is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    Xtlf.pl is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


use warnings;
#use strict;

use Gtk2 -init;
use Gtk2::GladeXML;
use Glib;
use IO::Select;
use IO::Handle;
use Symbol qw(qualify_to_ref);
use Gtk2::SimpleList;
use FindBin qw($Bin);
use lib "$Bin/scoring";
use lib "$ENV{HOME}/.xtlf";
use lib "$Bin";
use lib "/usr/share/xtlf/scoring";

my $exchangemethod = "";
my $resultsmethod = "";
my $pointsmethod = "";

#use rules;
my $contestinfo = "";
if (-e "$ENV{HOME}/.xtlf/rules.pm") {
	$contestinfo = `cat "$ENV{HOME}/.xtlf/rules.pm"`;
} else {
	$contestinfo = `cat "/usr/share/.xtlf/rules.pm"`;
}
eval  ($contestinfo);

use printmults;
use printsections;
use printcqzones;
use contest;
use scoring;
use make_adif;
use make_cbr;
use tlf_lib;

# constants
my $SPmode = 0;
my $contestmode = 1;
my $cqmodus = 0;
my $xsent = 1;
my $xrcvd = 2;




# global definitions...
my %checkcalls = ();
%freqmemory = ();
my @info = ();
my $Call_valid = 0;
my $modus = 0;
my $Multi1 = "";
my $Multi2 = "";
my $Call = "";
#$Mycall = "";
my $rest = "";
my $Mode = "CW ";
$Band = " 20";
$Bandindex = 4;
my @Bands = ("160"," 80"," 40", " 30"," 20", " 17", " 15", " 12", " 10");
$freqmemory{"160"} = 1800;
$freqmemory{" 80"} = 3500;
$freqmemory{" 40"} = 7000;
$freqmemory{" 30"} = 10100;
$freqmemory{" 20"} = 14000;
$freqmemory{" 17"} = 18060;
$freqmemory{" 15"} = 21000;
$freqmemory{" 12"} = 24890;
$freqmemory{" 10"} = 28000;
$Ctydatfile = "";
$Callmasterfile = "";	
my $nrofbands = $#Bands;
my $autocq_dur = 0;
$Allbandspots = 1;
$trxcontrol = 0;
$autocq_active = 0;
$spots_all = 1;
$spots_new = 0;
$mults_only = 0;
$Qsonum = 1;
$autostart = 2;
$finishtime = 0;
$hundredth = 0;
$shortserial = 1;
$wwvmsg = "";

$exchangetype = "standardexchange";
$standardexchange = "";
$trlog_file = "";
$adif_file = "";
$cabrillo_file = "";
$totalscore = 0;
@qso10 = ();
@qso100 = ();
push @qso10, time();
push @qso100, time();
$rate = 0;

$clusterstatus = 0;
$gmfskstatus = 0;
$cwdaemonstatus = 0;
$trxstatus = 0;

$SIG{CHLD} = 'IGNORE';

# get the start window...       #############################################
my $h = Gtk2::GladeXML->new("/usr/share/xtlf/xtlfstart.glade");	
my $Startwindow = $h->get_widget("startwindow");
my $Startlabel = $h->get_widget("startlabel");
$Startwindow->show_all();
$Startlabel->set_label("\nStarting Xtlf, moment please... \n"); 

# get the GUI and the widgets...#############################################
my $g = Gtk2::GladeXML->new("/usr/share/xtlf/xtlf-1.0.1.glade");
my $window = $g->get_widget("window1");
my $Savelogbutton = $g->get_widget("savelogbutton");
#############
my $Modebutton = $g->get_widget("modebutton");
my $Modebutton_ssb = $g->get_widget("modebuttonssb");
my $Modebutton_dig = $g->get_widget("modebuttondig");
my $Bandplusbutton = $g->get_widget("bandplus");
my $Bandminusbutton = $g->get_widget("bandminus");
my $CWspeed = $g->get_widget("cwspeed");
#############
my $Keyerwindow = $g->get_widget("keyerwindow");
my $Keyboardclose = $g->get_widget("keyboardclose");
my $Keyboardentry = $g->get_widget("keyboardentry");
my $Keyboardbutton = $g->get_widget("keyboardbutton");
#############
$Infowindow = $g->get_widget("callwindow");
$Callokbutton = $g->get_widget("callokbutton");
$Callcancelbutton = $g->get_widget("callcancelbutton");
$Mycallentry = $g->get_widget("mycallentry");
$Countrylabel = $g->get_widget("countrylabel");
$Logfileentry = $g->get_widget("logfileentry");
$Logfileokbutton = $g->get_widget("logfileokbutton");
$Logfilecancelbutton = $g->get_widget("logfilecancelbutton");
$Ctydatentry = $g->get_widget("ctyfileentry");
$Callmasterentry = $g->get_widget("callmasterentry");
$Rtty_inentry = $g->get_widget("rttyinentry");
$Rtty_outentry = $g->get_widget("rttyoutentry");
$Scorewindow2 = $g->get_widget("scorewindow2");
$Statuslabel = $g->get_widget("statuslabel");
$Statusclosebutton = $g->get_widget("statusclosebutton");
#############
my $Contestwindow = $g->get_widget("contestwindow");
my $Contestmodeindicator = $g->get_widget("contestmodeindicator");
my $Contestwindowclose = $g->get_widget("contestwindowclose");
if ($contestmode) { Gtk2::ToggleButton::set_active($Contestmodeindicator,is_active);} 
my $Contestinfolabel = $g->get_widget("contestinfolabel");
$Contestinfolabel->set_label($contestinfo);
#############
$Dxspots =  $g->get_widget("dxspots");
$Dxspots->set_title("DX spots!");
$DXspotclosebutton = $g->get_widget("spotclosebutton");
$B160button =  $g->get_widget("160button");
$B80button =  $g->get_widget("80button");
$B40button =  $g->get_widget("40button");
$B20button =  $g->get_widget("20button");
$B15button =  $g->get_widget("15button");
$B10button =  $g->get_widget("10button");
#############
$Trxwindow = $g->get_widget("trxwindow");
$Trxokbutton = $g->get_widget("trxokbutton");
$Trxcancelbutton =  $g->get_widget("trxcancelbutton");
$Trxctlonbutton  =  $g->get_widget("rigctlonbutton");
$Testresultentry  =  $g->get_widget("testresultentry");
$Rigmodelentry  =  $g->get_widget("rigmodelentry");
$Speedentry = $g->get_widget("speedentry");
$Deviceentry = $g->get_widget("deviceentry");
$Testbutton = $g->get_widget("testbutton");

#############
my $Treeview = $g->get_widget("treeview"); 
$slist = Gtk2::SimpleList->new_from_treeview ($Treeview, "DX spots", "text");
@spotarray = ();
$slist->set_data_array (\@spotarray);
#############
my $Summarywindow = $g->get_widget("summarywindow");
my $Summaryokbutton = $g->get_widget("summaryokbutton");
my $Summarywritebutton = $g->get_widget("sumwritebutton");
my $Summarycancelbutton = $g->get_widget("summarycancelbutton");
$Sumcall = $g->get_widget("sumcall");
$Sumsection = $g->get_widget("sumsection");
$Sumop_cat = $g->get_widget("sumop_cat");
$Sumfreq = $g->get_widget("sumfreq");
$Sumpwr = $g->get_widget("sumpwr");
$Summode = $g->get_widget("summode");
$Sumass = $g->get_widget("sumass");
$Sumcontest = $g->get_widget("sumcontest");
$Sumopentry = $g->get_widget("sumopentry");
$Sumoverlay = $g->get_widget("sumoverlay");
$Sumnameentry = $g->get_widget("sumnameentry");
$Sumadds1 = $g->get_widget("sumadds1");
$Sumadds2 = $g->get_widget("sumadds2");
$Sumadds3 = $g->get_widget("sumadds3");
$Sumemail = $g->get_widget("sumemail");
$Sumsb1 = $g->get_widget("sumsb1");
$Sumdxp = $g->get_widget("sumdxp");
$Sumtime = $g->get_widget("sumtime");
$Sumisl = $g->get_widget("sumisl");
$Sumclub = $g->get_widget("sumclub");
$Sumisl = $g->get_widget("sumisl");
#############
$Mult1window = $g->get_widget("mult1_window");
$MultsAll = $g->get_widget("multsall");
$Multsallbuffer = $MultsAll->get_buffer;
$Multseu = $g->get_widget("multseu");
$Multseubuffer = $Multseu->get_buffer;
$Multsas = $g->get_widget("multsas");
$Multsasbuffer = $Multsas->get_buffer;
$Multsna = $g->get_widget("multsna");
$Multsnabuffer = $Multsna->get_buffer;
$Multssa = $g->get_widget("multssa");
$Multssabuffer = $Multssa->get_buffer;
$Multsaf = $g->get_widget("multsaf");
$Multsafbuffer = $Multsaf->get_buffer;
$Multsoc = $g->get_widget("multsoc");
$Multsocbuffer = $Multsoc->get_buffer;
$Multssection = $g->get_widget("multssections");
$Multssectionbuffer = $Multssection->get_buffer;
$Multscqzones = $g->get_widget("multszones");
$Multscqzonesbuffer = $Multscqzones->get_buffer;

$Mult1closebutton = $g->get_widget("mult1closebutton");
$Multsallbuffer->set_text("HERE");


#############
my $F1button = $g->get_widget("F1button");
my $F2button = $g->get_widget("F2button");
my $F3button = $g->get_widget("F3button");
my $F4button = $g->get_widget("F4button");
my $F5button = $g->get_widget("F5button");
my $F6button = $g->get_widget("F6button");
my $F7button = $g->get_widget("F7button");
my $F8button = $g->get_widget("F8button");
my $F9button = $g->get_widget("F9button");
my $F10button = $g->get_widget("F10button");
my $F11button = $g->get_widget("F11button");
my $F12button = $g->get_widget("F12button");
my $SPbutton = $g->get_widget("SPbutton");
my $TUbutton = $g->get_widget("TUbutton");
my $Shortserialcheck = $g->get_widget("shortserialcheck");
#############
my $Messages = $g->get_widget("messages");
my $Messageokbutton = $g->get_widget("messageokbutton");
my $Messagecancelbutton = $g->get_widget("messagecancelbutton");
my $F1_entry = $g->get_widget("F1entry");
my $F2_entry = $g->get_widget("F2entry");
my $F3_entry = $g->get_widget("F3entry");
my $F4_entry = $g->get_widget("F4entry");
my $F5_entry = $g->get_widget("F5entry");
my $F6_entry = $g->get_widget("F6entry");
my $F7_entry = $g->get_widget("F7entry");
my $F8_entry = $g->get_widget("F8entry");
my $F9_entry = $g->get_widget("F9entry");
my $F10_entry = $g->get_widget("F10entry");
my $F11_entry = $g->get_widget("F11entry");
my $F12_entry = $g->get_widget("F12entry");
my $TU_CQentry = $g->get_widget("TUCQentry");
my $TU_SPentry = $g->get_widget("TUSPentry");
#############
my $CWdialog = $g->get_widget("cwdialog");
my $CWokbutton = $g->get_widget("CW_okbutton");
my $CWcancelbutton = $g->get_widget("CW_cancelbutton");
my $Use_cwd = $g->get_widget("usecwd");
my $Send_qrv = $g->get_widget("send_qrv");
my $CW_speed = $g->get_widget("cw_speed");
my $CW_weight = $g->get_widget("cw_weight");
my $CW_tone = $g->get_widget("cw_tone");
my $CW_volume = $g->get_widget("cw_volume");
my $PTT_delay = $g->get_widget("ptt_delay");
my $Autocq_del = $g->get_widget("autocq_del");
my $Autocwchar = $g->get_widget("autochars");
#############
my $About = $g->get_widget("aboutdialog1");
#############
my $Logfiles = $g->get_widget("logfiles");
my $Logclosebutton = $g->get_widget("logclosebutton");
my $Logokbutton = $g->get_widget("logokbutton");
$TRlogentry = $g->get_widget("trlog_file_entry");
$Adifentry = $g->get_widget("adif_file_entry");
$Cabrilloentry = $g->get_widget("cabrillo_file_entry");
$Stdexchangeentry = $g->get_widget("stdexchangeentry");
my $Makeadifbutton = $g->get_widget("makeadifbutton");
my $Makecabrillobutton = $g->get_widget("makecabrillobutton");
my $Maketrbutton = $g->get_widget("maketrbutton");
#############
my $Call_entry = $g->get_widget("callentry");
my $Exchange_entry = $g->get_widget("exchange");
$Qrgentry =  $g->get_widget("qrgentry");
my $Bottomlabel = $g->get_widget("bottomlabel");
my $Clrbutton = $g->get_widget("clrbutton");
my $Modelabel = $g->get_widget("modelabel");
my $Moduslabel = $g->get_widget("moduslabel");
my $Callcheck_window = $g->get_widget("callcheck_window");
my $Callbuffer = $Callcheck_window->get_buffer;
my $Datelabel = $g->get_widget("datelabel");

my $Choosefile = $g->get_widget("choosefile");
my $Openbutton = $g->get_widget("openbutton");
my $Cancelopenbutton= $g->get_widget("cancelopenbutton");
#############
$RTTYwindow = $g->get_widget("rttywindow");
$RTTYview = $g->get_widget("rttyview");
$RTTYbuffer = $RTTYview->get_buffer;
$RTTYclosebutton = $g->get_widget("rttyclosebutton");
#############

my $Statusbar = $g->get_widget("statusbar");
my $Context_id = Gtk2::Statusbar::get_context_id($Statusbar, "messages");
$TRXstatusbar = $g->get_widget("trxstatusbar");
$TRXContext_id = Gtk2::Statusbar::get_context_id($TRXstatusbar, "trxmessages");
$Statusbar_wwv = $g->get_widget("statusbar3");
$Context_id_wwv = Gtk2::Statusbar::get_context_id($Statusbar_wwv, "wwv");

my $Newdialog = $g->get_widget("newdialog");
my $Newentry = $g->get_widget("newentry");
my $Newokbutton = $g->get_widget("newokbutton");

my $Checkwindow = $g->get_widget("checkwindow");
my $Checkbuffer = $Checkwindow->get_buffer;
my $Logview = $g->get_widget("logview");
my $Logbuffer = $Logview->get_buffer;
my $start_mark = $Logbuffer->create_mark ('end', $Logbuffer->get_end_iter, FALSE);
my $end_mark = $Logbuffer->create_mark ('end', $Logbuffer->get_end_iter, FALSE);
my $tag = $Logbuffer->create_tag("blue_foreground", foreground => "blue");
my $rtag = $Logbuffer->create_tag("red_foreground", foreground => "red");

my $Deleteqso = $g->get_widget("deleteqso");
my $Deleteokbutton = $g->get_widget("deletebutton");
my $Deletecancelbutton = $g->get_widget("deletecancelbutton");
##############
my $Scorewindow = $g->get_widget("scorewindow");
my $Scoreview = $g->get_widget("scoreview");
my $Scorebar = $g->get_widget("progressbar1");
my $Scoreclosebutton = $g->get_widget("scoreclosebutton");
my $Scorebuffer = $Scoreview->get_buffer;


# Change default font throughout the widget
$font_desc = Gtk2::Pango::FontDescription->from_string ("Mono 9");
$font_desc1= Gtk2::Pango::FontDescription->from_string ("Mono  8");
$font_desc2 = Gtk2::Pango::FontDescription->from_string ("Mono Bold 10");
#$font_desc3 = Gtk2::Pango::FontDescription->from_string ("Mono 11");

$Logview->modify_font ($font_desc);
$Scoreview->modify_font ($font_desc1);
$Callcheck_window->modify_font ($font_desc);
$Call_entry->modify_font ($font_desc2);
$Checkwindow->modify_font ($font_desc);
	
#Set the colors

$color = Gtk2::Gdk::Color->new (65000, 65000, 63000); # WHITE
$color2 = Gtk2::Gdk::Color->new (0, 40000, 0); # GREEN
$color3 = Gtk2::Gdk::Color->new (0, 0, 50000); # BLUE
#$color4 = Gtk2::Gdk::Color->new (60000, 65000, 65000); # LIGHT BLUE 
$color5 = Gtk2::Gdk::Color->new (64250, 64250, 57050); # LIGHT YELLOW

$Logview->modify_base('normal', $color5);
$Scoreview->modify_base('normal', $color5);
$Callcheck_window->modify_base('normal', $color5);
$Callcheck_window->set_wrap_mode ('word');
$Call_entry->modify_base('normal', $color);
$Checkwindow->modify_base('normal', $color5); 
$Call_entry->modify_text('normal' , $color2);
$Logview->modify_text('normal', $color3);
$Callcheck_window->modify_text('normal' , $color2);  

$dupetag = $Checkbuffer->create_tag ("red_foreground", foreground => "red");
$uniquetag = $Callbuffer->create_tag ("red_foreground", foreground => "red");

$MultsAll->modify_font ($font_desc1);
$MultsAll->modify_text('normal' , $color2);
$Multseu->modify_font ($font_desc1);
$Multseu->modify_text('normal' , $color2);
$Multsas->modify_font ($font_desc1);
$Multsas->modify_text('normal' , $color2);
$Multsna->modify_font ($font_desc1);
$Multsna->modify_text('normal' , $color2);
$Multssa->modify_font ($font_desc1);
$Multssa->modify_text('normal' , $color2);
$Multsaf->modify_font ($font_desc1);
$Multsaf->modify_text('normal' , $color2);
$Multsoc->modify_font ($font_desc1);
$Multsoc->modify_text('normal' , $color2);
$Multssection->modify_font ($font_desc1);
$Multssection->modify_text('normal' , $color2);
$Multscqzones->modify_font ($font_desc1);
$Multscqzones->modify_text('normal' , $color2);

$Multssectionbuffer->create_tag ("green_char", foreground => "dark green");
$Multssectionbuffer->create_tag ("grey_char", foreground => "grey");
$Multscqzonesbuffer->create_tag ("green_char", foreground => "dark green");
$Multscqzonesbuffer->create_tag ("grey_char", foreground => "grey");
$Multsallbuffer->create_tag ("green_char", foreground => "dark green");
$Multsallbuffer->create_tag ("grey_char", foreground => "grey");
$Multseubuffer->create_tag ("green_char", foreground => "dark green");
$Multseubuffer->create_tag ("grey_char", foreground => "grey");
$Multsasbuffer->create_tag ("green_char", foreground => "dark green");
$Multsasbuffer->create_tag ("grey_char", foreground => "grey");
$Multsnabuffer->create_tag ("green_char", foreground => "dark green");
$Multsnabuffer->create_tag ("grey_char", foreground => "grey");
$Multssabuffer->create_tag ("green_char", foreground => "dark green");
$Multssabuffer->create_tag ("grey_char", foreground => "grey");
$Multsafbuffer->create_tag ("green_char", foreground => "dark green");
$Multsafbuffer->create_tag ("grey_char", foreground => "grey");
$Multsocbuffer->create_tag ("green_char", foreground => "dark green");
$Multsocbuffer->create_tag ("grey_char", foreground => "grey");

########## BUTTONS #####################################

$Modebutton->signal_connect(toggled =>
		sub {
			$Mode = "CW ";
			my @cmd = ();
			push @cmd, "CW";
			push @cmd, 500;
			my $error = set_trx_mode(@cmd);
		}
);
	
$Modebutton_ssb->signal_connect(toggled =>
		sub {
			$Mode = "SSB";
			my @cmd = ();
			if ($Qrgentry->get_text > 7300) {
				push @cmd, "USB";
			} else {
				push @cmd, "LSB";
			}
			push @cmd, 1900;
			my $error = set_trx_mode(@cmd);
		}
);
	
$Modebutton_dig->signal_connect(toggled =>
		sub {
			$Mode = "DIG";
			my @cmd = ();
			push @cmd, "USB";
			push @cmd, 500;
			my $error = set_trx_mode(@cmd);
		}
);

$Bandplusbutton->signal_connect(clicked =>
		sub {
			if ($trxcontrol) { $freqmemory{$Band} = get_trx() /1000; }
			
			if ($contestmode && $contestname ne "DXpedition mode" && ($Bands[$Bandindex] eq " 40" ||
							$Bands[$Bandindex] eq " 20" ||
							$Bands[$Bandindex] eq " 15")) {
				$Bandindex++;
				$Bandindex++;
			} else { $Bandindex++; }

			if ($Bandindex > $nrofbands) {
				$Bandindex = 0;
			}
			$Band = substr(" " . $Bands[$Bandindex], -3, 3);
			showband($Band);		
			set_trx($freqmemory{$Band});
			clusterspots("", $Band);
		}
);
$Bandminusbutton->signal_connect(clicked =>
		sub {
			if ($trxcontrol) {$freqmemory{$Band} = get_trx() / 1000;}

			if ($contestmode && $contestname ne "DXpedition mode" && ($Bands[$Bandindex] eq " 10" ||
							$Bands[$Bandindex] eq " 15" ||
							$Bands[$Bandindex] eq " 20")) {
				$Bandindex--;
				$Bandindex--;
			} else { $Bandindex--; }

			if ($Bandindex < 0) {
				$Bandindex = $nrofbands;
			}
			$Band = substr(" " . $Bands[$Bandindex], -3, 3);
			showband($Band);
			set_trx($freqmemory{$Band});
			clusterspots("", $Band);
		}
);
$CW_speed->signal_connect(changed =>
		sub {
			my $oldspeed = 0;
			my $cwspeed = $CWspeed->get_value_as_int();
			if ($cwspeed != $oldspeed) {
				sendcwcmd("2",$cwdWpm);
				$oldspeed = $cwdWpm;
				$cwdWpm = $cwspeed;
			}
		}
);
$CWspeed->signal_connect(changed =>
		sub {
			my $oldspeed = 0;
			my $cwspeed = $CWspeed->get_value_as_int();
			if ($cwspeed != $oldspeed) {
				sendcwcmd("2",$cwdWpm);
				$oldspeed = $cwdWpm;
				$cwdWpm = $cwspeed;
			}
		}
);


$CW_weight->signal_connect(changed =>
		sub {
			$cwdWeight = $CW_weight->get_value_as_int();
		}
);
$CW_tone->signal_connect(changed =>
		sub {
			$cwdSideTone = $CW_tone->get_value_as_int();
		}
);
$CW_volume->signal_connect(changed =>
		sub {
			$cwdVolume = $CW_volume->get_value_as_int();
		}
);

$PTT_delay->signal_connect(changed =>
		sub {
			$cwdDelay = $PTT_delay->get_value_as_int();
		}
);

$Autocq_del->signal_connect(changed =>
		sub {
			$autocq_delay = $Autocq_del->get_value_as_int();
		}
);
$Autocwchar->signal_connect(changed =>
		sub {
			$autostart = $Autocwchar->get_value_as_int();
		}
);

############function keys ################	

$F1button->signal_connect(clicked =>
		sub {
			if ($contestmode){
				if ($SPmode) {
					sendstuff($Mycall, $Mode);
				} else {
					sendstuff($F1txt, $Mode);
				}
			} else {
				sendstuff($F1txt, $Mode);
			}
		}
);
$F2button->signal_connect(clicked =>
		sub {
			sendstuff($F2txt, $Mode);
		}
);
$F3button->signal_connect(clicked =>
		sub {
			sendstuff($F3txt, $Mode);
		}
);
$F4button->signal_connect(clicked =>
		sub {
			sendstuff($F4txt, $Mode);
		}
);
$F5button->signal_connect(clicked =>
		sub {
			sendstuff($F5txt, $Mode);
		}
);
$F6button->signal_connect(clicked =>
		sub {
			sendstuff($F6txt, $Mode);
		}
);
$F7button->signal_connect(clicked =>
		sub {
			sendstuff($F7txt, $Mode);
		}
);
$F8button->signal_connect(clicked =>
		sub {
			sendstuff($F8txt, $Mode);
		}
);
$F9button->signal_connect(clicked =>
		sub {
			sendstuff($F9txt, $Mode);
		}
);
$F10button->signal_connect(clicked =>
		sub {
			sendstuff($F10txt, $Mode);
		}
);
$F11button->signal_connect(clicked =>
		sub {
			sendstuff($F11txt, $Mode);
		}
);
$F12button->signal_connect(clicked =>
		sub {
			sendstuff($F12txt, $Mode);
			$autocq_active = 1;
		}
);
$Shortserialcheck->signal_connect(toggled =>
		sub {
			if ($shortserial) {
				$shortserial = 0;
			} else {
				$shortserial = 1;
			}
		}
);
$SPbutton->signal_connect(clicked =>
		sub {
			if ($contestmode) {
				if ($SPmode == 0) {
					$SPmode = 1;
					$SPbutton->set_label("CQmode");
					$F1button->set_label("F1:Call");
					$Moduslabel->set_label("  S&P");
				} else {
					$SPmode = 0;
					$SPbutton->set_label("S&Pmode");
					$F1button->set_label("F1:CQ");
					$Moduslabel->set_label("  Log");
				}
			}
		}
);
$TUbutton->signal_connect(clicked =>
		sub {
			if ($contestmode) {
				if ($SPmode == 0) {
					sendstuff($TUmesg, $Mode);
				} else {
					sendstuff($SPTUmesg, $Mode);
				}
			}
		}
);
############ end function keys ###############

$Call_entry->signal_connect(changed =>
		sub {
			my $outline;
			
			$c = $Call_entry->get_text;
### some commands....			
			if ($c eq "-") {		# delete qso
				$Call_entry->set_text("");
				$Deleteqso->show();

			}
			if ($c eq "+") { 	# set S&P mode
				$Call_entry->set_text("");
				if ($contestmode) {
					if ($SPmode == 0) {
						$SPmode = 1;
						$SPbutton->set_label("CQmode");
						$F1button->set_label("F1:Call");
						$Moduslabel->set_label("  S&P");
					} else {
						$SPmode = 0;
						$SPbutton->set_label("S&Pmode");
						$F1button->set_label("F1:CQ");
						$Moduslabel->set_label("  Log");
					}
				}				
			}
			
			if (substr($c, 0, 1) eq ":") {
				if ($c =~ /:char (\d)/) {
					$autostart = $1;
					errormsg("Setting autostart to $autostart characters");
				$Call_entry->set_text("");
				}
				return;
			}
			
			if ($autostart && $SPmode == 0) {
				
				if ($autostart == 1) { $autostart = 2;}
				
				if (length($c) == $autostart && $finishtime == 0) {
					$finishtime = 200;
					sendstuff($c, $Mode);
					sendcwcmd("h",0);
				} 
			}
			if ($contestmode) {
				$uc = uc($c);
			} else {
				$uc = $c;
			}
			$Call = $uc =~ /(\w*\/*\w*\/*\w*)\s*(\w*-*\w*)\s*(\w*-*\w*)\s*(.*)/;
			$Call = uc ($1);
			$Multi1 = $2;
			$Multi2 = $3;
			$rest = $4;

			@info = getinfo($Call);
			
#			@newmults = checkmults ($Band, @info);

			printinfo(@info);
			
			$call_list = callcheck($Call);	# check for possible calls
			
			if ($call_list) {
				for ($i = 0; $i < 4 ; $i++) {
					if (($i * 32) > length $call_list) { last; }
						$outline .= substr ($call_list, $i * 32, 32);
						$outline .= "\n";
				}
			} elsif (length ($call) > 2) {
				$outline = "UNIQUE!!\n";				
			} else {
				$outline = "" unless $outline;
			}
=head  momentarily broken....
	
			if ($newmults[0] == 0 && length ($call) > 2) {
				$outline .= "-------------------------\n";
				my $multname = $newmults[1];
				$outline .= "NEW $multname\n";
			} else {
				$outline .= "                  \n";			
			}
=cut			
			
			
			$Callbuffer->set_text($outline);# print possible calls
			if (substr ($outline, 0, 4) eq "UNIQ") {
				$dupestart = $Callbuffer->get_iter_at_offset (0);
				$dupeend = $Callbuffer->get_iter_at_offset (8);
				$Callbuffer->apply_tag ($uniquetag, $dupestart, $dupeend);
			}
# search log
			
			$checkcontent = "";
			$dupeline = -1;
			for ($i = 0; $i < 9; $i++) {
				
				if ($i == 3 || $i == 5 || $i == 7) {
					next;
				}
				
				$qsoinfo = searchtable($Bands[$i], $Call);
				
				if ($qsoinfo) {
					if ($qsoinfo =~ /:\d\d \d\d\d\d  (\w*\/*\w*\/*\w*)\s+/) {
						my $clfrag = $1;
						$checkcontent .= $qsoinfo;
						$checkcontent .= "\n";
						if ($clfrag eq $Call && $Bands[$i] eq $Band) {
							$dupeline = $i;
							if ($i == 4) {
								$dupeline = 3;
							} elsif ($dupeline == 6) {
								$dupeline = 4;
							} elsif ($i == 8) {
								$dupeline = 5;
							}
						}
					}
				} else {
					$checkcontent .= $Bands[$i];
					$checkcontent .= "                                               \n";				
				}
			}
			$Checkbuffer->set_text($checkcontent);	

			if ($dupeline >= 0) {
				$dupestart = $Checkbuffer->get_iter_at_offset (($dupeline * 50) + 0);
				$dupeend = $Checkbuffer->get_iter_at_offset ((($dupeline + 1) * 50) - 14);
				$Checkbuffer->apply_tag ($dupetag, $dupestart, $dupeend);
			}
			
			
		}
);
$Call_entry->signal_connect(activate =>		# send, log, etc...
		sub {
# set qrg
			if ($Call_entry->get_text =~ /(\d\d\d\d\d*)/) {
				set_trx($1);
				$Call_entry->set_text("");
				return;
			}
			
			if ($contestmode) {
				if ($Call_valid == 0) {  
						if ($SPmode) {
							sendstuff($Mycall, $Mode);
						} else {
							sendstuff($F1txt, $Mode);
						}		
					return; 
				}

				if ($modus == $cqmodus) {				
					if ($SPmode) {
						sendstuff($Mycall, $Mode);
					} else {
						if ($autostart) {
							sendstuff(substr($F3txt, 1), $Mode);
						}else {
							sendstuff($F3txt, $Mode);
						}
					}
					$modus = $xsent;
					$Modelabel->set_text("Xsnt");
					my $CCall = $Call . " ";
					
					if ($mult2 eq "cqzone") {
						$CCall .= $info[1];
					} elsif ($mult1 eq "ituzone") {
						$CCall .= $info[2];
					}
					
					$Call_entry->set_text($CCall);
					$Call_entry->set_position(length $CCall);	
				} elsif ($modus == $xsent) {
												# LOG THE QSO
					my $line = makelog ($Band, $Mode, $Qsonum, $Call, $Multi1, $Multi2, $rest, $Qrgentry->get_text);
					addsearchtable($line);
					
					$Logbuffer->insert($Logbuffer->get_end_iter, $line);
					addlog($line);
					addcall($Call);
					$Qsonum++;

					if ($SPmode) {
						sendstuff($SPTUmesg, $Mode)
					} else {
						sendstuff($TUmesg, $Mode);
					}
					$modus = $cqmodus;
					$Modelabel->set_text("CQ");	
					$Call_entry->set_text("");				
				}
			} else {
				my $line = makelog ($Band, $Mode, $Qsonum, $Call, $Multi1, $Multi2, $rest);
				
				addsearchtable($line);
				
				$Logbuffer->insert($Logbuffer->get_end_iter, $line);
				addlog($line);
				addcall($Call);
				$Qsonum++;
				errormsg("Qso logged to $logfile");
				$Call_entry->set_text("");				
			}
		}
); 
$Clrbutton->signal_connect(clicked =>
		sub {
			$Call_entry->set_text("");
			$modus = $cqmodus;
			$Modelabel->set_text("CQ");	
			if ($Mode eq "CW ") { sendcwcmd(4,0); }
			$autocq_active = 0;
			$autocq_dur = 0;
			if ($SPmode) {
				$Moduslabel->set_label("  S&P");
			} else {
				$Moduslabel->set_label("  Log");			
			}
		}
);
$Logbuffer->signal_connect (insert_text => sub {
			$end_mark = $Logbuffer->create_mark ('end', $Logbuffer->get_end_iter, FALSE);
			$Logview->scroll_mark_onscreen ($end_mark);
});
$Deleteokbutton->signal_connect(clicked =>
		sub {
			deletelastqso();
			$Deleteqso->hide();
			$logcontent = readlog();
			$Logbuffer->set_text("");
			$Logbuffer->insert($Logbuffer->get_end_iter, $logcontent);
			$end_mark = $Logbuffer->create_mark ('end', $Logbuffer->get_end_iter, FALSE);
			$Logview->scroll_mark_onscreen ($end_mark);
		}
);
$Deletecancelbutton->signal_connect(clicked =>
		sub {
			$Deleteqso->hide();
		}
);
$Deletecancelbutton->signal_connect(destroy =>
		sub {
			$Deleteqso->hide();
		}
);
$Openbutton->signal_connect(clicked =>
		sub {
			my $choice = $Choosefile->get_filename;
			if (! $choice) { 
				errormsg("No log file chosen!!");
			}
			else { 
				if ($choice =~ /\.log/) {
					$logfile = $choice;
					errormsg("Using $logfile");
					$logcontent = readlog();
					$Logbuffer->set_text("");
					$Logbuffer->insert($Logbuffer->get_end_iter, $logcontent);
					$end_mark = $Logbuffer->create_mark ('end', $Logbuffer->get_end_iter, FALSE);
					$Logview->scroll_mark_onscreen ($end_mark);
				} elsif ($choice =~ /\.rules/) {
					`cp "$choice" $ENV{HOME}/.xtlf/rules.pm`;
					errormsg ("New rules??; pse restart the program");
				} else {
					errormsg ("No file chosen");
				}
				
			}
			$Choosefile->hide();
		}
);
$Cancelopenbutton->signal_connect(clicked =>
		sub {
			$Choosefile->hide();
		}
);
$CWokbutton->signal_connect(clicked =>
		sub {			

			if ($Use_cwd->get_active) {
				$cwdaemon = 1;
			} else {
				$cwdaemon = 0;
			}
			if ($Send_qrv->get_active) {
				$sendqrv = 1;
			} else {
				$sendqrv = 0;
			}
			
			$cwdWpm= $CW_speed->get_value_as_int();
			$cwdWeight = $CW_weight->get_value_as_int();
			$cwdSideTone = $CW_tone->get_value_as_int();
			$cwdVolume = $CW_volume->get_value_as_int();
			$cwdDelay = $PTT_delay->get_value_as_int();
			$autocq_delay = $Autocq_del->get_value_as_int();
			$autostart = $Autocwchar->get_value_as_int();
			
			open ($fh, ">", "$ENV{HOME}/.xtlf/cwdaemon_defaults");
			print $fh "Use Cwdaemon=$cwdaemon\n";
			print $fh "Send qrv=$sendqrv\n";
			print $fh "CW speed=$cwdWpm\n";
			print $fh "CW weight=$cwdWeight\n";
			print $fh "CW Side tone=$cwdSideTone\n";
			print $fh "CW side tone volume=$cwdVolume\n";
			print $fh "PTT delay=$cwdDelay\n";
			print $fh "Auto CQ delay=$autocq_delay\n";
			print $fh "CW autostart=$autostart\n";
			close ($fh);
			
			errormsg("writing cwd config");
			initialize_keyer();
			
			$CWdialog->hide();
		}
);
$CWcancelbutton->signal_connect(clicked =>
		sub {
			$CWdialog->hide();
		}
);
$Newokbutton->signal_connect(clicked =>
		sub {
			$logfile = $Newentry->get_text;
			$Logbuffer->set_text("");
			errormsg($logfile);
			$Newdialog->hide();
		}
);
$Messageokbutton->signal_connect(clicked =>
		sub {
			$F1txt = $F1_entry->get_text;
			$F2txt = $F2_entry->get_text;
			$F3txt = $F3_entry->get_text;
			$F4txt = $F4_entry->get_text;
			$F5txt = $F5_entry->get_text;
			$F6txt = $F6_entry->get_text;
			$F7txt = $F7_entry->get_text;
			$F8txt = $F8_entry->get_text;
			$F9txt = $F9_entry->get_text;
			$F10txt = $F10_entry->get_text;
			$F11txt = $F11_entry->get_text;
			$F12txt = $F12_entry->get_text;
			$TUmesg = $TU_CQentry->get_text;
			$SPTUmesg = $TU_SPentry->get_text;
			
			open ($fh, ">", "$ENV{HOME}/.xtlf/messages");
			print $fh "F1=$F1txt\n";
			print $fh "F2=$F2txt\n";
			print $fh "F3=$F3txt\n";
			print $fh "F4=$F4txt\n";
			print $fh "F5=$F5txt\n";
			print $fh "F6=$F6txt\n";
			print $fh "F7=$F7txt\n";
			print $fh "F8=$F8txt\n";
			print $fh "F9=$F9txt\n";
			print $fh "F10=$F10txt\n";
			print $fh "F11=$F11txt\n";
			print $fh "F12=$F12txt\n";
			print $fh "TUmesg=$TUmesg\n";
			print $fh "SPTUmesg=$SPTUmesg\n";
			close ($fh);
			
			$Messages->hide();
			errormsg("Setting message table");
		}
);
$Messagecancelbutton->signal_connect(clicked =>
		sub {
			$Messages->hide();
		}
);
$Newentry->signal_connect(activate =>
		sub {
			$logfile = $Newentry->get_text;
			$Logbuffer->set_text("");
			errormsg($logfile);
			$Newdialog->hide();
		}
);
$Keyboardbutton->signal_connect(clicked =>
		sub {
			if ($Mode eq "CW ") {
				$Keyboardentry->set_text("");
				$Keyerwindow->show();
			}
		}
);
$Keyboardclose->signal_connect(clicked =>
		sub {
			$Keyerwindow->hide();
		}
);
$Keyboardentry->signal_connect(activate =>
		sub {
			$Keyboardentry->set_text("");
			$Keyerwindow->hide();
		}
);

$Keyboardentry->signal_connect(changed =>
		sub {
			$keys = $Keyboardentry->get_text;
			if (length $keys) {
				$outstring = substr($keys, -1, 1);
				sendstuff ($outstring, $Mode);
			}
		}
);
$Contestwindowclose->signal_connect(clicked =>
		sub {
			$Contestwindow->hide();
		}
);
$Contestmodeindicator->signal_connect(toggled =>
		sub {
			if ($contestmode) {
				$contestmode = 0;
				$Modelabel->set_text("qso\nmode");
			} else {
				$contestmode = 1;
			}
		}
);
$Treeview->signal_connect (row_activated =>
		sub {
			my @indexes = $slist->get_selected_indices;
			my $index = $indexes[0];
			my $val = $slist->{data}[$index][0];
			if ($trxcontrol && $val =~ /(\d*\.\d*)\s*(\w*\/*\w*\/*\w*).*/) {
				set_trx($1);
				$Call_entry->set_text($2 . " ");
			}
		}
);
$Trxokbutton->signal_connect(clicked =>
		sub {
			
			if ($Trxctlonbutton->get_active) {
				$trxcontrol = 1;
			} else {
				$trxcontrol = 0;
			}
			$rigmodel = $Rigmodelentry->get_text;
			$rigspeed = $Speedentry->get_text;
			$rigdevice = $Deviceentry->get_text;

			open ($fh, ">", "$ENV{HOME}/.xtlf/trxcontrol");
			print ($fh "Use TRX Control =$trxcontrol\n");
			print ($fh "Rig model nr.   =$rigmodel\n");
			print ($fh "Baud rate       =$rigspeed\n");
			print ($fh "Device          =$rigdevice\n");
			close ($fh);
			
			errormsg("Setting interface data");
			
			$Trxwindow->hide();
		}
);
$Trxcancelbutton->signal_connect(clicked =>
		sub {
			$Trxwindow->hide();
		}
);
$Trxctlonbutton->signal_connect(toggled =>
		sub {
			if ($trxcontrol) {
				$trxcontrol = 0;
			} else {
				$trxcontrol = 1;
				$TRXstatusbar->push($TRXContext_id, "");

			}
		}
);
$Testbutton->signal_connect(clicked =>
		sub {
			$Testresultentry->set_text("");
			if ($trxcontrol) {
				my $result = get_trx();
				$Testresultentry->set_text($result);
			}else {
				$TRXstatusbar->push($TRXContext_id, "TRX Control is OFF");
			}
		}
);
$Callokbutton->signal_connect(clicked =>
	sub {
			$Mycall = $Mycallentry->get_text;
			$logfile = $Logfileentry->get_text;
			$Ctydatfile = $Ctydatentry->get_text;
			$Callmasterfile = $Callmasterentry->get_text;
			$Rtty_infile = $Rtty_inentry->get_text;
			$Rtty_outfile = $Rtty_outentry->get_text;
			
			open ($fh, ">", "$ENV{HOME}/.xtlf/config");
			print $fh "My call =$Mycall\n";
			print $fh "Logfile =$logfile\n";
			print $fh "Cty.dat file =$Ctydatfile\n";
			print $fh "Callmasterfile =$Callmasterfile\n";
			print $fh "Rtty input file =$Rtty_infile\n";
			print $fh "Rtty output file =$Rtty_outfile\n";
			
			close ($fh);
			
			$Infowindow->hide();
		}
);
$Callcancelbutton->signal_connect(clicked =>
	sub {
			$Infowindow->hide();
		}
);
$Logfilecancelbutton->signal_connect(clicked =>
	sub {

			$Infowindow->hide();
	}
);
$Logfileokbutton->signal_connect(clicked =>
	sub {
			$Mycall = $Mycallentry->get_text;
			$logfile = $Logfileentry->get_text;			
			$Ctydatfile = $Ctydatentry->get_text;
			$Callmasterfile = $Callmasterentry->get_text;
			$Rtty_infile = $Rtty_inentry->get_text;
			$Rtty_outfile = $Rtty_outentry->get_text;
			
			open ($fh, ">", "$ENV{HOME}/.xtlf/config");
			print $fh "My call =$Mycall\n";
			print $fh "Logfile =$logfile\n";
			print $fh "Cty.dat file =$Ctydatfile\n";
			print $fh "Callmasterfile =$Callmasterfile\n";
			print $fh "Rtty input file =$Rtty_infile\n";
			print $fh "Rtty output file =$Rtty_outfile\n";
			close ($fh);

			$Infowindow->hide();
	}
);
$Savelogbutton->signal_connect(clicked =>
	sub {
			my $start = $Logbuffer->get_iter_at_offset (0);
			my $end = $Logbuffer->get_end_iter;
			my $outtext = Gtk2::TextBuffer::get_text($Logbuffer, $start, $end, FALSE);

			if ($logfile) {
				open ($LOG, ">", $logfile) or die "Cannot save file";
				print $LOG $outtext;
				close ($LOG);
			}
			errormsg("Saving $logfile");
		}	
);

$Logclosebutton->signal_connect(clicked =>
	sub {
		$Logfiles->hide();
	}
);
$DXspotclosebutton->signal_connect(clicked =>
	sub {
		$Dxspots->hide();
	}
);
$Logokbutton->signal_connect(clicked =>
	sub {
		$trlog_file = $TRlogentry->get_text;
		$adif_file = $Adifentry->get_text;
		$cabrillo_file = $Cabrilloentry->get_text;
		$stdexchange = $Stdexchangeentry->get_text;
		
		open ($fh, ">", "$ENV{HOME}/.xtlf/logfiles");
		print $fh "TRlog name=$trlog_file\n";
		print $fh "Adif log name=$adif_file\n";
		print $fh "Cabrillo log name=$cabrillo_file\n";
		print $fh "Standard exchange=$stdexchange\n";
		
		close ($fh);


		$Logfiles->hide();
	}
);
$Makeadifbutton->signal_connect(clicked =>
	sub {
		$adif_file = $Adifentry->get_text;
		make_adif($logfile, $adif_file, $exchangetype, $standardexchange);
		errormsg("Writing ADIF file $adif_file");
	}
);
$Makecabrillobutton->signal_connect(clicked =>
	sub {
		loadlogfilenames();
		$cabrillo_file = $Cabrilloentry->get_text;
		make_cbr($logfile, $cabrillo_file, $exchangetype, $standardexchange);
		errormsg("Writing CBR file $cabrillo_file");
	}
);
$Maketrbutton->signal_connect(clicked =>
	sub {
		my $eval_mode = 1;
		$trlog_file = $TRlogentry->get_text;
		$result = evaluate($logfile, $trlog_file, $eval_mode, $resultsmethod);
		errormsg("Writing TRlog file $trlog_file");
	}
);
$Scoreclosebutton->signal_connect(clicked =>
	sub {
		$Scorewindow->hide();
	}
);
$Summaryokbutton->signal_connect(clicked =>
	sub {
		open ($fh, ">", "$ENV{HOME}/.xtlf/summarydata");
			print $fh "Call=" . $Sumcall->get_text . "\n";
			print $fh "Section=" . $Sumsection->get_text . "\n";
			print $fh "Op_category=" . $Sumop_cat->get_text . "\n";
			print $fh "Bands=" . $Sumfreq->get_text . "\n";
			print $fh "Pwr_category=" . $Sumpwr->get_text . "\n";
			print $fh "Mode_category=" . $Summode->get_text . "\n";
			print $fh "Assist_category=" . $Sumass->get_text . "\n";
			print $fh "Contest=" . $Sumcontest->get_text . "\n";
			print $fh "Operators=" . $Sumopentry->get_text . "\n";
			print $fh "Overlay=" . $Sumoverlay->get_text . "\n";
			print $fh "Name=" . $Sumnameentry->get_text . "\n";
			print $fh "Addr1=" . $Sumadds1->get_text . "\n";
			print $fh "Addr2=" . $Sumadds2->get_text . "\n";
			print $fh "Addr3=" . $Sumadds3->get_text . "\n";
			print $fh "Email=" . $Sumemail->get_text . "\n";
			print $fh "Soapbox=" . $Sumsb1->get_text . "\n";
			print $fh "Dxpedition(IOTA)=" . $Sumdxp->get_text . "\n";
			print $fh "Time category(IOTA)=" . $Sumtime->get_text . "\n";
			print $fh "Island name(IOTA)=" . $Sumisl->get_text . "\n";
			print $fh "Club=" . $Sumclub->get_text . "\n";
			errormsg ("Writing info to ~/.xtlf/summarydata");
		close ($fh);
		$Summarywindow->hide();	
	}
);

$Summarycancelbutton->signal_connect(clicked =>
	sub {
		$Summarywindow->hide();
	}
);
$B160button->signal_connect(clicked =>
	sub {
		if ($trxcontrol) { $freqmemory{$Band} = get_trx() /1000; }
		$Band = substr(" " . $Bands[0], -3, 3);
		$Bandindex = 0;
		showband($Band);		
		set_trx($freqmemory{$Band});
		clusterspots("", $Band);
	}
);
$B80button->signal_connect(clicked =>
	sub {
		if ($trxcontrol) { $freqmemory{$Band} = get_trx() /1000; }
		$Band = substr(" " . $Bands[1], -3, 3);
		$Bandindex = 1;
		showband($Band);		
		set_trx($freqmemory{$Band});
		clusterspots("", $Band);
	}
);
$B40button->signal_connect(clicked =>
	sub {
		if ($trxcontrol) { $freqmemory{$Band} = get_trx() /1000; }
		$Band = substr(" " . $Bands[2], -3, 3);
		$Bandindex = 2;
		showband($Band);		
		set_trx($freqmemory{$Band});
		clusterspots("", $Band);
	}
);
$B20button->signal_connect(clicked =>
	sub {
		if ($trxcontrol) { $freqmemory{$Band} = get_trx() /1000; }
		$Band = substr(" " . $Bands[4], -3, 3);
		$Bandindex = 4;
		showband($Band);		
		set_trx($freqmemory{$Band});
		clusterspots("", $Band);
	}
);
$B15button->signal_connect(clicked =>
	sub {
		if ($trxcontrol) { $freqmemory{$Band} = get_trx() /1000; }
		$Band = substr(" " . $Bands[6], -3, 3);
		$Bandindex = 6;
		showband($Band);		
		set_trx($freqmemory{$Band});
		clusterspots("", $Band);
	}
);
$B10button->signal_connect(clicked =>
	sub {
		if ($trxcontrol) { $freqmemory{$Band} = get_trx() /1000; }
		$Band = substr(" " . $Bands[8], -3, 3);
		$Bandindex = 8;
		showband($Band);		
		set_trx($freqmemory{$Band});
		clusterspots("", $Band);
	}
);
$Mult1closebutton->signal_connect(clicked =>
	sub {
		$Mult1window->hide();
	}
);
$Statusclosebutton->signal_connect(clicked =>
	sub {
		$Infowindow->hide();
	}
);
$RTTYclosebutton->signal_connect(clicked =>
	sub {
		$RTTYwindow->hide();
	}
);

$window->signal_connect (destroy => sub { 
	if ($pid) { kill("TERM" => $pid);}
	if ($rypid) { kill("TERM" => $rypid);}

	$window->hide();	

	Gtk2->main_quit; 
	}
);

######################### menu actions ######################

$g->signal_autoconnect_all(
		
		on_quit1_activate => 
		sub {
			if ($pid) { kill("TERM" => $pid);}
			if ($rypid) { kill("TERM" => $rypid);}

			$window->destroy;
			Gtk2->main_quit;
		},
		on_new1_activate =>
		sub {
			$Newdialog->show();
		},
		on_open1_activate =>
		sub {
			$Choosefile->show();
		},
		on_save1_activate =>
		sub {
			my $start = $Logbuffer->get_iter_at_offset (0);
			my $end = $Logbuffer->get_end_iter;
			
			my $outtext = Gtk2::TextBuffer::get_text($Logbuffer, $start, $end, FALSE);

			if ($logfile) {
				open ($LOG, ">", $logfile) or die "Cannot save file";
				print $LOG $outtext;
				close ($LOG);
			}
			errormsg("Saving $logfile");
		},
		on_cw_keyer1_activate =>
		sub {
#		Gtk2::ToggleButton::set_active(toggle_button, is_active)
			if ($cwdaemon) {
				Gtk2::ToggleButton::set_active($Use_cwd,is_active); 
			}
			if ($sendqrv) {
				Gtk2::ToggleButton::set_active($Send_qrv,is_active); 
			}
			$CW_speed->set_value($cwdWpm);
			$CW_weight->set_value($cwdWeight);
			$CW_tone->set_value($cwdSideTone);
			$CW_volume->set_value($cwdVolume);
			$PTT_delay->set_value($cwdDelay);
			$Autocq_del->set_value($autocq_delay);
			$CWdialog->show();
		},
		on_messages1_activate =>
		sub {
			$F1_entry->set_text($F1txt);
			$F2_entry->set_text($F2txt);
			$F3_entry->set_text($F3txt);
			$F4_entry->set_text($F4txt);
			$F5_entry->set_text($F5txt);
			$F6_entry->set_text($F6txt);
			$F7_entry->set_text($F7txt);
			$F8_entry->set_text($F8txt);
			$F9_entry->set_text($F9txt);
			$F10_entry->set_text($F10txt);
			$F11_entry->set_text($F11txt);
			$F12_entry->set_text($F12txt);
			$TU_CQentry->set_text($TUmesg);
			$TU_SPentry->set_text($SPTUmesg);
			$Messages->show();
		},
		on_mode1_activate =>
		sub {
			$Contestwindow->show();
		},
		on_load_activate => 
		sub {
			$Choosefile->show();
		},

		
		
		on_about1_activate =>
		sub {
			$About->show();
		},
		on_allbands_activate =>
			sub {
				$Allbandspots = 1;
				showband($Band);
				clusterspots("", $Band);
		},
		on_follow_activate =>
			sub {
				$Allbandspots = 0;
				showband($Band);
				clusterspots("", $Band);
		},
		on_allspots_activate =>
			sub {
				$spots_all = 1;
				$mults_only = 0;
				clusterspots("", $Band);
				showband($Band);
		},
		on_mults_only1_activate =>
			sub {
				$mults_only = 1;
				$spots_all = 0;
				clusterspots("", $Band);
				showband($Band);
		},
		on_trx_control1_activate =>
		sub {
			$Trxwindow->show();
		},
		on_General_activate =>
			sub {
			$Logfileentry->set_text($logfile);
			$Mycallentry->set_text($Mycall);
			my @info = getinfo($Mycall);
			$Countrylabel->set_label("$info[0]  $info[3]  CQ:$info[1] ITU:$info[2]\n");

			($cwdaemonstatus, $clusterstatus, $gmfskstatus) = checkstatus();
			showstatus($contestmode, $cwdaemonstatus, $clusterstatus, $gmfskstatus, $trxstatus);
			$Infowindow->show();
		},
		on_Generatelogfiles_activate =>
			sub {
				$Logfiles->show();
			},
		on_summary_activate =>
			sub {
				loadsummarydata();
				$Summarywindow->show();
			},
		on_cluster1_activate =>
			sub {
				if ($clusterstatus == 0) {
					errormsg("Xdx is NOT running, no cluster support...");
				} else {
					$Dxspots->show();
				}
			},
		on_score1_activate =>
			sub {
				$Scorewindow->show();
			},
		on_mults1_activate =>
			sub {
				printcountries($Band);
				printsections($Band);
				$Mult1window->show();
			},
		on_rtty_activate =>
			sub {
				$RTTYwindow->show();
			},
);

$spid = fork; # scoring thread
if ($spid == 0) {
	`renice +20 0`;
	
	while (1) {
		sleep 1;
		$result = evaluate($logfile, $trlog_file, $eval_mode, $resultsmethod);
		`echo "$result" > ~/.xtlf/score`;
		$eval_mode = 0;
	}
	
	exit;
}


($cwdaemonstatus, $clusterstatus, $gmfskstatus) = checkstatus();
showstatus ($contestmode, $cwdaemonstatus, $clusterstatus, $gmfskstatus, $trxstatus);

if ($clusterstatus) { #cluster present

#####################################################################
# make a comm pipe for text input from xdx...
pipe READHANDLE, WRITEHANDLE or die "Cannot open pipe..";
WRITEHANDLE->autoflush(1);

# fork off a child to do the input stuff...
our $pid = fork();
die "failed to fork" unless defined $pid;

# off goes the child... reading in info from the xdx logfile and
# sending it to the add_watch routine waiting for \*READHANDLE

if ($pid == 0) {
		
	close (READHANDLE);
	
	if ($clusterstatus) { 
		getstuff(\*WRITEHANDLE); 
	} else {
		errormsg("Xdx is NOT running, no cluster support...");
	}
	die "Cluster thread killed";
}

Glib::IO->add_watch(
		fileno(\*READHANDLE), 'in', \&watch_callback
	);
} # end cluster

if ($gmfskstatus) { # gmfsk is running

#####################################################################
# make a comm pipe for text input from gmfsk...
	pipe RTTYREAD, RTTYWRITE or die "Cannot open pipe..";
	RTTYWRITE->autoflush(1);

	# fork off a child to do the input stuff...
	our $rypid = fork();
	die "failed to fork" unless defined $rypid;

	# off goes the child... reading in info from the gmfsk logfile and
	# sending it to the add_watch routine waiting for \*RTTYREAD

	if ($rypid == 0) {
			
		close (RTTYREAD);
		
		getrtty(\*RTTYWRITE); 

		die "rtty dying";
	}

	Glib::IO->add_watch(
			fileno(\*RTTYREAD), 'in', \&watch_callback_rtty
		);
} # end gmfsk link	


## timer ##################################################################
# my $seconds = 0;
my $halfseconds = 0;
my $messageshown = 0;

Glib::Timeout->add(50,  ############## timer ##############################
        sub {
			$hundredth++;
				# do hundredth
				####### austostart ########################
				if ($finishtime) {
					$finishtime--; 
					$answer = rcvbuf();
					if ($answer) {
						my $reststring = substr($c, $autostart, length ($c) - $autostart);
						sendstuff($reststring, $Mode);

						$finishtime = 0;
						$Call_entry->activate;
					}		
				} 	

				if ($hundredth > 8)	{
					$hundredth = 0;
					$halfseconds++;
				# half seconds
				if ($autocq_active) {
					$autocq_dur++;
					if ($autocq_dur > $autocq_delay){
						$autocq_dur = 0;
						sendstuff($F12txt, $Mode);
					}
					my $label = sprintf ("  Auto %d", $autocq_delay - $autocq_dur); 
					$Moduslabel->set_label($label);
				}
			####### get trx frequency #################		
					
					if ($trxcontrol) {
						$trxtime++;
						if ($trxtime > 1) {
							$trxtime = 0;
							my $oldfreq = $Qrgentry->get_text;
							my $freq = get_trx();
							my $pmode = get_trx_mode();
							if ($freq =~ /(\d*).*/ && $freq) {
								if ($1 / 1000 != $oldfreq){
									$Qrgentry->set_text($1/1000);
									
									my $showfreq = $1/1000;
									
									if ($mults_only && ! $Allbandspots) {
										$showfreq .= " Mults";
									} 
									
									$Dxspots->set_title($showfreq);
									$freqmemory{$Band} = $1/1000;
									$trxstatus = 1;
								}
							} else {
								$trxstatus = 0;
							}
							$Band = getband($1/1000);
						}
						
					}
			######## end get frequency #################
				# end half seconds
				
				if ($halfseconds > 1) {
					$halfseconds = 0;
					# seconds
					$datestring = makedate ($Band, $Mode, $Qsonum);
					$Datelabel->set_text($datestring);

					if ($contestmode) {
						while ($#qso10) {
							if ($qso10[0] < time() - 600) {
								$dummy = shift @qso10;
							} else {
								last;
							}
						}
						$rate = $#qso10 * 6 / 200;
						if ($rate > 1) {$rate = 1;}
						$Scorebar->set_fraction($rate);
						$trate = sprintf ("Q/h = %d", $#qso10 * 6);
						$Scorebar->set_text($trate);
					}				
					
					if ($messageshown) {	# time error messages
						$messageshown--;
						if ($messageshown == 0) {
							errormsg("");	
						}
					}
#=header
					$showscore++;
										
					if ($showscore > 10 ) {
						$showscore = 0;
						if ($contestmode) {
							my $eval_mode = 0;
								$result = `cat "$ENV{HOME}/.xtlf/score"`;
								chomp $result;
								$Scorewindow2->set_label($result);
								$Scorebuffer->set_text($result);
						}
					}
#=cut
					$wwvseconds++;
					if ($wwvseconds > 1800) {
						$wwvseconds = 0;
						printwwv();
					}
					$clustercleanup--;
					if ($clustercleanup <= 0) {
						$clustercleanup = 3600;
						$dummy = `tail -n 100 ~/.xdx/dxspots > ~/.xdx/test`;
						$dummy = `mv ~/.xdx/test ~/.xdx/dxspots`;
					}
				}
			} 
1;      }
); # end timer ######################################################################



##### initialize ##########

showband($Band);
loadconfig();

makehash();

# load logfile names
loadlogfilenames();

# load country information
use ctyinfo;
initialize_ctydat();

loadmessages();
my $logcontent = readlog();

$Logbuffer->set_text("");
$Logbuffer->insert($Logbuffer->get_end_iter, $logcontent);
$end_mark = $Logbuffer->create_mark ('end', $Logbuffer->get_end_iter, FALSE);
$Logview->scroll_mark_onscreen ($end_mark);

loadkeyer();
initialize_keyer();



# tickle cwdaemon
if ($sendqrv && $cwdaemonstatus) { sendbuf("qrv"); }

loadinterfaceconfig();

printwwv();

$CWspeed->set_value($cwdWpm);

$window->set_title("Xtlf 1.0.3 beta - $contestname");

$window->show_all();

$Startwindow->destroy();

	
#testmuf();

errormsg($contestname);
# enter main loop
Gtk2->main();

if ($pid) {kill "TERM" => $pid; }
if ($spid) {kill "TERM" => $spid;}
if ($rypid) {kill "TERM" => $rypid;}

exit(1);
1;

############################################
sub printinfo {
############################################

	my @info = @_;
	my $infoline = "";

		if ($info[7] eq "---") {
			$Bottomlabel->set_text("");
			$Call_valid = 0;
			return ; 
		}
		
		if ($mult1 ne "ituzone" && $mult2 ne "ituzone") {
			$infoline = sprintf (" %s:  %20s  %s  %s        %s km/%s deg                      ", 
			$info[7],substr($info[0] . "                    ", 0, 20),$info[1],$info[3],$info[11],
			$info[12]);
		} else {
			$infoline = sprintf (" %s:  %20s  %s  %s        %s km/%s deg                      ", 
			$info[7],substr($info[0] . "                    ", 0, 20),$info[2],$info[3],$info[11],
			$info[12]);
		
		}


			
			$Bottomlabel->set_text($infoline);
			
			$Call_valid = 1;
					
}	
############################################
sub sendstuff {
############################################
 my ($txt, $Mode) = @_;
 	
 	if (length ($Qsonum) == 4 && substr($Qsonum, 0, 1) eq "0") {
 		$cwnum = substr($Qsonum, 1, 3);
 	} else {
 		$cwnum = $Qsonum;
 	} 
 	if ($Mode eq "CW " && $shortserial) {$cwnum =~ tr/[09]/[TN]/;}
 	
 	$txt =~ s/\%/$Mycall/g;
 	$txt =~ s/\@/$Call/g; 
 	$txt =~ s/\#/$cwnum/g; 

 	if ($cwdaemon && $Mode eq "CW ") {
 		sendbuf($txt);
 	} elsif ($Mode eq "DIG") {
 		my $outfile = "$ENV{HOME}/gmfsk_autofile";
 		$mytxt = "\n" . $txt;
 		my $error = `echo "$mytxt" > $outfile`;
 		$error = "";
 	}

}
############################################
sub errormsg {
############################################
my $msg = shift @_;

	$Statusbar->pop($Context_id);
	$Statusbar->push($Context_id, $msg);
	$messageshown = 5;

}
############################################
sub showmsg {
############################################
my $msg = shift @_;

	$Statusbar->pop($Context_id);
	$Statusbar->push($Context_id, $msg);
	$messageshown = 10;
}
################################
sub getstuff {
################################

WRITEHANDLE->autoflush(1);
$oldline = "";
	while (1){
		my $line = `tail -n 1 ~/.xdx/dxspots`;
		if ($line ne $oldline) {
			$oldline = $line;
			if ($line) {
#				print $line;
				print WRITEHANDLE $line;
			}
		}
		select undef, undef, undef, 0.5;
		if ($clusterstatus == 0) {
			last;
		}
#		sleep 1;
	}

}
################################
sub watch_callback {
################################

my $line = sysreadline(READHANDLE, 0.1);

		clusterspots($line, $Band);
1;
}

################################
sub watch_callback_rtty {
################################

my $line = sysreadline(RTTYREAD, 0.01);

	if ($line || $line eq "0") {
		$RTTYbuffer->insert($RTTYbuffer->get_end_iter, $line);
		$ry_end_mark = $RTTYbuffer->create_mark ('end', $RTTYbuffer->get_end_iter, FALSE);
		$RTTYview->scroll_mark_onscreen ($ry_end_mark);
	}
1;
}
################################
sub getrtty {
################################
open (GMFSK, "<", $Rtty_infile) or die "cannot open RTTY";

RTTYWRITE->autoflush(1);
	while (1){
		if ($gmfskstatus) {
			sysread (GMFSK, $buffer, 1000);
			if (length ($buffer) > 20) {
				$buffer = substr ($buffer, 24);	
			}
			if ($buffer || $buffer eq "0") {print RTTYWRITE $buffer; }
			
			select undef, undef, undef, 0.1;
			
		} else {
			last;
		}
	}

}
#############################################################
sub sysreadline (*;$) {		# read complete line non-blocking
#############################################################

	my ($handle, $timeout) = @_;
	
	$handle = qualify_to_ref($handle, caller());
	my $infinitely_patient = (@_ == 1 || $timeout < 0);
	my $start_time = time();
	my $selector = IO::Select->new();
	$selector->add($handle);
	my $line = "";
SLEEP:
	until (at_eol($line)) {
		unless ($infinitely_patient) {
			return $line if time() > ($start_time + $timeout);	
		}
		# sleep only 1 sec before checking again
		next SLEEP unless $selector->can_read(1.0);
INPUT_READY:
		while ($selector->can_read(0.0)) {
			my $was_blocking = $handle->blocking(0);
CHAR:		while ( sysread($handle, my $nextbyte, 1)) {
				$line .= $nextbyte;
				last CHAR if $nextbyte eq "\n";
			}
			$handle->blocking($was_blocking);
			# if incomplete line keep trying
			next SLEEP unless at_eol($line);
			last INPUT_READY;		
		} 
	}
	return $line;
}
sub at_eol($) { $_[0] =~ /\n\z/ }
################################# end sysreadline ####################

###################################################
sub loadconfig {
###################################################
	my $input = "";
	eval {
		my @messages = ();
		open ($fh, "$ENV{HOME}/.xtlf/config") or die "Cannot find config\n";
		while (<$fh>) {
			if (/=(~*)(.*)/) {
				if ($1) {
					$input = "$ENV{HOME}" . $2;
				} else {
					$input = $2;
				}
				push @messages, $input;
			}
		}
		close ($fh);
		
		$Mycall = $messages[0];
		$logfile = $messages[1];
		$Ctydatfile = $messages[2];
		$Callmasterfile = $messages[3];
		$Rtty_infile = $messages[4];
		$Rtty_outfile = $messages[5];

		
		$Logfileentry->set_text($logfile);
		$Mycallentry->set_text($Mycall);
		$Ctydatentry->set_text($Ctydatfile);
		$Callmasterentry->set_text($Callmasterfile);
		$Rtty_inentry->set_text($Rtty_infile);
		$Rtty_outentry->set_text($Rtty_outfile);

	};
	if ($@) {
		print $@;
	}
}

############################################################
sub testmuf {

my $muf = minimuf(101, 5, 1, 2, 51, -5, 55, -40);

print "MUF=$muf\n";

}

=header
	my $flux = shift;		# 10-cm solar flux 
	my $month = shift;		# month of year (1 - 12) 
	my $day = shift;		# day of month (1 - 31) 
	my $hour = shift;		# hour of day (utc) (0 - 23) 
	my $lat1 = shift;		# transmitter latitude (deg n) 
	my $lon1 = shift;		# transmitter longitude (deg w) 
	my $lat2 = shift;		# receiver latitude (deg n) 
	my $lon2 = shift;		# receiver longitude (deg w) 

=cut
