#! /usr/bin/perl -w


# Ham Radio Country info module testinput.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    testinput.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    testinput.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 05-04-06

use rules;
use ctyinfo;
use countries;
use sections;
use scoring;
use calls;


####################globals ############################
my $call = "";
my $qsonumber = 0;
my $comment = "";
my $mode = "";
my $band = 0;
my $cqzone = 0;
my $ituzone = 0;
my $continent = "";
my $country = -1;
my $prefix = "";
my $district = "";
my @mults = ();

initialize_ctydat();

$logfile = "$ENV{HOME}/.xtlf/qso.log";

my @owninfo = getinfo($Mycall);
my $mycqzone = $owninfo[1];
my $myituzone = $owninfo[2];
my $mycontinent = $owninfo[3];
my $mycountry = $owninfo[10];
my $myprefix = $owninfo[8];
my $mydistrict = $owninfo[9];
#########################################################

#while (1) {
	init_qso();
	
	open (OUT, ">outlog.log");
	
	open (IN, $logfile);
	my @file = <IN>;
	close (IN);

foreach $inline (@file) {

	if ($inline =~ /(\s*(\d*)(...)(\s.*:\d\d\s)(\d\d\d\d)(\s*)(\w*\/*\w*\/*\w*)(\s*59.\s\s59.\s*)(\w*)\s*(.*))\s/){
		my $points = 0;
		$band = $2;
		my $mode = $3;
		$qsonumber = $5;
		$call = $7;
		$comment = $9;
		$comment2 = $10;
		my $all = $1;
		@info = getinfo($call);
		$cqzone = $info[1];
		$ituzone = $info[2];
		$continent = $info[3];
		$country = $info[10];
		$prefix = $info[8];
		$district = $info[9];
#		printinfo();

		if ($method eq "iota") {
			
			if ($comment2 =~ m/([ENSOA][SFCUA]-\d\d\d)\s/) { # test format EU-123
				$comment2 = $1;
			}

			@mults = setmults($call, $band,$mode ,$country, $comment2);
		} else {
			@mults = setmults($call, $band, $mode, $country, $comment);
		}
		
		my $p = addcalls($call, $band);

		my $c = addcontinent($continent);
		
		if ($p == 1) {	# no dupe
			$points = setpoints($call, $band, $country, $comment);
		}
		
		$totalpoints += $points;
		
		writenewlog($all, @mults, $points);
		select undef, undef, undef, 0.001;
	} # end if
} # end for
		close (OUT);


	printresults($totalpoints);
#} # end while



exit;
####################################
sub printinfo {
####################################
	print "$info[0]\n";
	print "$info[1]\n";
	print "$info[2]\n";
	print "$info[3]\n";
	print "$info[4]\n";
	print "$info[5]\n";
	print "$info[6]\n";
	print "$info[7]\n";
	print "$info[8]\n";
	print "$info[9]\n";
	print "$info[10]\n";

}

######## end pgm ####################


