/*******************************************************************
 * EAP-SIM (draft 5 specific) function implementations
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 * 
 * File: simd5.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: simd5.c,v 1.8 2005/08/09 01:39:17 chessing Exp $
 * $Date: 2005/08/09 01:39:17 $
 * $Log: simd5.c,v $
 * Revision 1.8  2005/08/09 01:39:17  chessing
 * Cleaned out old commit notes from the released version.  Added a few small features including the ability to disable the friendly warnings that are spit out.  (Such as the warning that is displayed when keys aren't rotated after 10 minutes.)  We should also be able to start when the interface is down.  Last, but not least, we can handle empty network configs.  (This may be useful for situations where there isn't a good reason to have a default network defined.)
 *
 *
 *******************************************************************/

/*******************************************************************
 *
 * The development of the EAP/SIM support was funded by Internet
 * Foundation Austria (http://www.nic.at/ipa)
 *
 *******************************************************************/


#ifdef EAP_SIM_ENABLE

#include <inttypes.h>
#include <string.h>
#include <netinet/in.h>
#include <openssl/hmac.h>

#include "winscard.h"
#include "config.h"
#include "profile.h"
#include "eap.h"
#include "eapsim.h"
#include "xsup_debug.h"
#include "xsup_err.h"

// Draft 5 (version 0) specific calls.

int do_v0_at_mac(struct generic_eap_data *thisint, char *K_int, char *indata, 
		 int in_size, int inoffset, char *resultmac)
{
  char *framecpy, *mac_calc;
  int saved_offset, i;
  uint16_t value16;

  if ((!thisint) || (!K_int) || (!indata) || (!resultmac))
    {
      debug_printf(DEBUG_NORMAL, "Invalid data passed in to do_v0_at_mac()!\n");
      return XEMALLOC;
    }

  if (indata[inoffset] != AT_MAC)
    {
      printf("Error!  The offset passed in is not of type AT_MAC!\n");
      return -1;
    }
  
  inoffset++;
	      
  if (indata[inoffset] != 5) printf("AT_MAC length isn't 5!\n");
  inoffset+=2;  // Skip the reserved bytes.

  saved_offset = inoffset;

  framecpy = (char *)malloc(in_size+50);  // We need extra to
	                                  // reconstruct the eap 
	                                  // piece.
  if (framecpy == NULL)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't allocate memory for framecpy!\n");
      return XEMALLOC;
    }

  // Now, reconstruct the header for the EAP piece, so we can
  // calculate the MAC across all of it.
  framecpy[0] = 1;  // It was a request.
  framecpy[1] = thisint->eapid;
  value16 = in_size + 5;
  value16 = htons(value16);

  memcpy((char *)&framecpy[2], &value16, 2);
  framecpy[4] = EAP_TYPE_SIM;  
  
  memcpy((char *)&framecpy[5], (char *)&indata[0], in_size);

  // Now, zero out the MAC value.
  for (i=(saved_offset+5);i<=(in_size+5);i++)
    {
      framecpy[i] = 0x00;
    }

  debug_printf(DEBUG_AUTHTYPES, "Calculating MAC on : \n");
  debug_hex_dump(DEBUG_AUTHTYPES, framecpy, (in_size+5));
  
  // We should now be ready to calculate the AT_MAC for 
  // ourselves.
  mac_calc = (char *)malloc(100);
  if (mac_calc == NULL)
    {
      debug_printf(DEBUG_NORMAL, "Couldn't allocate memory for mac_calc! "
		   "(%s:%d)\n", __FUNCTION__, __LINE__);
      return XEMALLOC;
    }

  HMAC(EVP_sha1(), &K_int[0], 16, framecpy, (in_size+5), mac_calc, &i);

  memcpy(resultmac, mac_calc, 16);  // We get 20 back, but we only want 16.

  free(framecpy);
  framecpy = NULL;
  
  free(mac_calc);
  mac_calc = NULL;
  return 0;
}

#endif
