/*******************************************************************
 * PEAP Phase 2 Function Headers
 * 
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: peap_phase2.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef PEAP_PHASE2_H
#define PEAP_PHASE2_H

#define PEAP_EAP_EXTENSION    33

#define PEAP_SESSION_KEY_CONST         "client EAP encryption"
#define PEAP_SESSION_KEY_CONST_SIZE    21

#define PEAPv1_SESSION_KEY_CONST       "client PEAP encryption"
#define PEAPv1_SESSION_KEY_CONST_SIZE  22

struct phase2_data {
  struct generic_eap_data *eapdata;
  struct generic_eap_data *activemethod;
  int peap_version;
};

int peap_do_phase2(struct generic_eap_data *, u_char *, int, u_char *, int *);
int set_peap_version(struct phase2_data *,int);
void peap_phase2_failed(struct generic_eap_data *);

#endif
