/*******************************************************************
 *
 * License under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: eapmd5.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EAPMD5_H_
#define _EAPMD5_H_

#include "profile.h"

#define EAP_TYPE_MD5    0x04

struct md5_values {
  uint8_t length;
  uint8_t randval[16];
};

int eapmd5_setup(struct generic_eap_data *);
int eapmd5_process(struct generic_eap_data *, u_char *, int, u_char *, int *);
int eapmd5_get_keys(struct interface_data *);
int eapmd5_cleanup(struct generic_eap_data *);
int eapmd5_failed(struct generic_eap_data *);

#endif
