/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *    Cody Russell <crussell@canonical.com>
 */

#ifndef __XSPLASH_SERVER_H__
#define __XSPLASH_SERVER_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define XSPLASH_TYPE_SERVER (xsplash_server_get_type ())
#define XSPLASH_SERVER(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), XSPLASH_TYPE_SERVER, XsplashServer))
#define XSPLASH_IS_SERVER(object) (G_TYPE_CHECK_INSTANCE_TYPE((object), XSPLASH_TYPE_SERVER))
#define XSPLASH_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), XSPLASH_TYPE_SERVER, XsplashServerClass))
#define XSPLASH_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), XSPLASH_TYPE_SERVER))
#define XSPLASH_SERVER_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS((object), XSPLASH_TYPE_SERVER, XsplashServerClass))

typedef struct _XsplashServer      XsplashServer;
typedef struct _XsplashServerClass XsplashServerClass;

struct _XsplashServer {
  GObject parent;
};

struct _XsplashServerClass {
  GObjectClass parent;
};

GType xsplash_server_get_type (void) G_GNUC_CONST;

void xsplash_server_show (XsplashServer *server);

G_END_DECLS

#endif
