/*
	Copyright (C) 2002 zhang lu

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <dlfcn.h>

#include "panel.h"

//ANSI C++ forbids implicit conversion from `void *' in assignment :(
typedef void * DLHANDLE;

typedef TPanel * (* ClassCreatorProc)();

TPanel * TPanel::create(TWstring * plugins_path, Obj_Config * conf)
{
	TWstring path;
	
	path.copy(plugins_path->data());
	path.append(L"/panel_");
	path.append(conf->ident);
	path.append(L".so");
	
	char dummy[256];
	DLHANDLE handle;
	const char * error;
	
	if ((handle = (DLHANDLE) dlopen(path.tombs(dummy, 255), RTLD_LAZY)) == NULL){
		TWstring err_msg;
		error = dlerror();
		err_msg.copy("Failed opening share library: ");
		err_msg.append(path);
		err_msg.append('\n');
		err_msg.append(error);
		throw err_msg;
		}

	ClassCreatorProc ClassCreator;
	ClassCreator = (ClassCreatorProc) dlsym(handle, "ClassCreator");
	if ((error = dlerror()) != NULL){
		TWstring err_msg;
		err_msg.copy("Failed opening share library function: ");
		err_msg.append(error);
		throw err_msg;
		}

	TPanel * panel = ClassCreator();

	if (!panel)
		return NULL;
        
        TWstring * err;
	if ((err = panel->create(conf)) != NULL){
		delete panel;
		TWstring err_msg;
		err_msg.copy(err->data());
		delete err;
		throw err_msg;
		}
	
	panel->dlhandle = handle;

	return panel;
}

void TPanel::destory(TPanel * panel)
{       
	DLHANDLE handle = panel->dlhandle;
	
	delete panel;
	
	dlclose(handle);
}

