/*
	Copyright (C) 2002 zhang lu

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <csignal>
#include <iostream>
#include <clocale>

#include "xim.h"
#include "conf.h"
#include "wstring.h"

using std::cerr;
using std::endl;

TXIM * xim;
TConf * conf;

void signalhandler(int sig)
{
	delete xim;
	delete conf;
	cerr << "XSIM stopped." << endl;
	exit (0);
}

#include <stdexcept>
int main(int argc, char * argv[])
{
	conf = new TConf;
 
	if (setlocale(LC_ALL, "") == NULL){
		cerr << "Can't set locale." << endl;
		return 1;
		}

        switch (conf->init(argc, argv)){
		case 1:
			cerr << "Failed reading config file" << endl;
	        	return 1;
		case 2:
			return 0;
		}

	try{
		xim = new TXIM;
		}catch (TWstring s){
			char dummy[256];
			cerr << "XSIM : " << s.tombs(dummy, 255) << endl;
			return 1;
			}

	signal(SIGQUIT, signalhandler);
	signal(SIGTERM, signalhandler);
	signal(SIGINT,  signalhandler);

	if (!xim->run(conf))
		return 1;

	delete xim;
	delete conf;

        return 0;
}
