#ifndef _ICMAN_H
#define _ICMAN_H

#include <vector>
#include <X11/Xlib.h>

#include "IMdkit/IMdkit.h"
#include "IMdkit/Xi18n.h"

#include "ic.h"

using std::vector;

class TIM;

class TICManager
{
typedef struct Locale_Info_tag
{
	uint8_t	locale_id;
	CARD16	connect_id;
}Locale_Info;
private:
	TIC * ics;
	TIC * freeics;

	CARD16 icid_;

	vector<Locale_Info> localeinfo;
private:
	int saveic(TIC * ic, IMChangeICStruct *call_data);
	int loadic(TIC * ic, IMChangeICStruct *call_data);
	
public:
	TICManager();
	~TICManager();

	void clientopen(IMOpenStruct *call_data, uint8_t locale_id);
	void clientclose(IMCloseStruct *call_data);
	uint8_t localeid(CARD16 connect_id);
	TIC * newic(IMChangeICStruct *call_data, TIM * val);
	TIC * deleteic(IMDestroyICStruct *call_data);
	int seticvalue(IMChangeICStruct *call_data);//return 1 if input panel need repaint
	int geticvalue(IMChangeICStruct *call_data);

	TIC * getic(CARD16 icid);
	void destory_all();
};

#endif
