/*
	Copyright (C) 2002 zhang lu

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <string>
#include <db_cxx.h>
#include <locale.h>
#include <wchar.h>

#include "../simpleimc.h"

using std::cerr;
using std::cout;
using std::endl;
using std::cin;

int main(int argc, char * argv[])
{
	setlocale(LC_ALL, "zh_CN.GBK");

	Db db(NULL, 0);
	db.set_flags(DB_DUP | DB_DUPSORT);
#ifdef BDB_VERSION41
	if (argc > 1)
		db.open(NULL, argv[1], NULL, DB_BTREE, DB_RDONLY, 0644);
		else
			db.open(NULL, "chardb", NULL, DB_BTREE, DB_RDONLY, 0644);
#else	
	if (argc > 1)
		db.open(argv[1], NULL, DB_BTREE, DB_RDONLY, 0644);
		else
			db.open("chardb", NULL, DB_BTREE, DB_RDONLY, 0644);
#endif

	Char_Key ck;
	Char_Rec cr;
	char output[256];

	cout << "input key:";
	cin >> ck.py;
	Dbt key(&ck, sizeof(Char_Key));
	Dbt data(&cr, sizeof(Char_Rec));
	key.set_flags(DB_DBT_USERMEM);
	key.set_ulen(sizeof(Char_Key));
	data.set_flags(DB_DBT_USERMEM);
	data.set_ulen(sizeof(Char_Rec));

	Dbc * cursor;
	key.set_size(ck.size());
	db.cursor(0, &cursor, 0);

	int i = 0;
	if (cursor->get(&key, &data, DB_SET)){
		cerr << "nothing found" << endl;
		goto UGLY_EXIT_GOTO;
		}

	for (;;){
		if (wctomb(output, cr.c) == -1){
			cout << "failed converting char to mbs" << endl;
			exit (0);
			}
		output[2] = 0;
		cout << ck.py << " --> " << output << " accesscount = " << cr.access_count << " code = " << cr.c << endl;
		i++;
		if (cursor->get(&key, &data, DB_NEXT_DUP))
			break;
		}

	cout << i << " char(s) found" << endl;

UGLY_EXIT_GOTO:
	db.close(0);
	exit (0);
}
