/*
 * Copyright © 2005 Novell, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of
 * Novell, Inc. not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.
 * Novell, Inc. makes no representations about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.
 *
 * NOVELL, INC. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL NOVELL, INC. BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: David Reveman <davidr@novell.com>
 */

#include "glxserver.h"
#include "glxext.h"

extern void __MESA_resetExtension(void);
extern Bool __MESA_initVisuals(VisualPtr *visualp, DepthPtr *depthp,
			int *nvisualp, int *ndepthp, int *rootDepthp,
			VisualID *defaultVisp, unsigned long sizes,
			int bitsPerRGB);
extern void __MESA_setVisualConfigs(int nconfigs, __GLXvisualConfig *configs,
				    void **privates);
extern Bool __MESA_screenProbe(int screen);
extern __GLinterface *__MESA_createContext(__GLimports *imports,
				    __GLcontextModes *modes,
				     __GLinterface *shareGC);
extern void __MESA_createBuffer(__GLXdrawablePrivate *glxPriv);

__GLXextensionInfo __glDDXExtensionInfo = {
  GL_CORE_MESA,
  __MESA_resetExtension,
  __MESA_initVisuals,
  __MESA_setVisualConfigs
};

__GLXscreenInfo __glDDXScreenInfo = {
  __MESA_screenProbe,   /* Must be generic and handle all screens */
  __MESA_createContext, /* Substitute screen's createContext routine */
  __MESA_createBuffer,  /* Substitute screen's createBuffer routine */
  NULL,
  NULL,
  0,
  0,
  "Vendor String",
  "Version String",
  "Extensions String",
  NULL
};

