/*
    chips.c - Part of xsensors

    Copyright (c) 2002 Kris Kersey <augustus@linuxhardware.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "main.h"

#define ADM1021_NUM_FEAT 2

/* Get the feature info for adm1021 sensor. */
int get_feat_info_adm1021( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_ADM1021_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_ADM1021_TEMP_OVER;
            node->feattype = TEMP;
            break;
        case 2:
            node->featnum = SENSORS_ADM1021_REMOTE_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_ADM1021_REMOTE_TEMP_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }
 
    return SUCCESS;
}

#define EEPROM_NUM_FEAT 2   /* Was 5, see comment below. */

/* Get the feature info for eeprom. */
int get_feat_info_eeprom( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_EEPROM_TYPE;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = EEPROM;
            break;
        case 2:
            node->featnum = SENSORS_EEPROM_ROWADDR;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = EEPROM;
            break;
#if 0 /* Removed so that we can now compute the memory size. */
        case 3:
            node->featnum = SENSORS_EEPROM_COLADDR;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = EEPROM;
            break;
        case 4:
            node->featnum = SENSORS_EEPROM_NUMROWS;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = EEPROM;
            break;
        case 5:
            node->featnum = SENSORS_EEPROM_BANKS;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = EEPROM;
            break;
#endif
        default:
            return FAILURE;
    }
 
    return SUCCESS;
}

#define IT87_NUM_FEAT 15

/* Get the feature info for lm87 sensor. */
int get_feat_info_it87( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_IT87_IN0;
            node->featminnum = SENSORS_IT87_IN0_MIN;
            node->featmaxnum = SENSORS_IT87_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_IT87_IN1;
            node->featminnum = SENSORS_IT87_IN1_MIN;
            node->featmaxnum = SENSORS_IT87_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_IT87_IN2;
            node->featminnum = SENSORS_IT87_IN2_MIN;
            node->featmaxnum = SENSORS_IT87_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_IT87_IN3;
            node->featminnum = SENSORS_IT87_IN3_MIN;
            node->featmaxnum = SENSORS_IT87_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_IT87_IN4;
            node->featminnum = SENSORS_IT87_IN4_MIN;
            node->featmaxnum = SENSORS_IT87_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_IT87_IN5;
            node->featminnum = SENSORS_IT87_IN5_MIN;
            node->featmaxnum = SENSORS_IT87_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_IT87_IN6;
            node->featminnum = SENSORS_IT87_IN6_MIN;
            node->featmaxnum = SENSORS_IT87_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_IT87_IN7;
            node->featminnum = SENSORS_IT87_IN7_MIN;
            node->featmaxnum = SENSORS_IT87_IN7_MAX;
            node->feattype = VOLT;
            break;
        case 9:
            node->featnum = SENSORS_IT87_IN8;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = VOLT;
            break;
        case 10:
            node->featnum = SENSORS_IT87_FAN1;
            node->featminnum = SENSORS_IT87_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_IT87_FAN2;
            node->featminnum = SENSORS_IT87_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 12:
            node->featnum = SENSORS_IT87_FAN3;
            node->featminnum = SENSORS_IT87_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 13:
            node->featnum = SENSORS_IT87_TEMP1;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_IT87_TEMP1_HIGH;
            node->feattype = TEMP;
            break;
        case 14:
            node->featnum = SENSORS_IT87_TEMP2;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_IT87_TEMP2_HIGH;
            node->feattype = TEMP;
            break;
        case 15:
            node->featnum = SENSORS_IT87_TEMP3;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_IT87_TEMP3_HIGH;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }

    return SUCCESS;
}

#define LM75_NUM_FEAT 1

/* Get the feature info for lm75 sensor. */
int get_feat_info_lm75( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM75_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM75_TEMP_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }

    return SUCCESS;
}

#define LM78_NUM_FEAT 11

/* Get the feature info for lm78 sensor. */
int get_feat_info_lm78( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM78_IN0;
            node->featminnum = SENSORS_LM78_IN0_MIN;
            node->featmaxnum = SENSORS_LM78_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_LM78_IN1;
            node->featminnum = SENSORS_LM78_IN1_MIN;
            node->featmaxnum = SENSORS_LM78_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_LM78_IN2;
            node->featminnum = SENSORS_LM78_IN2_MIN;
            node->featmaxnum = SENSORS_LM78_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_LM78_IN3;
            node->featminnum = SENSORS_LM78_IN3_MIN;
            node->featmaxnum = SENSORS_LM78_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_LM78_IN4;
            node->featminnum = SENSORS_LM78_IN4_MIN;
            node->featmaxnum = SENSORS_LM78_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_LM78_IN5;
            node->featminnum = SENSORS_LM78_IN5_MIN;
            node->featmaxnum = SENSORS_LM78_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_LM78_IN6;
            node->featminnum = SENSORS_LM78_IN6_MIN;
            node->featmaxnum = SENSORS_LM78_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_LM78_FAN1;
            node->featminnum = SENSORS_LM78_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 9:
            node->featnum = SENSORS_LM78_FAN2;
            node->featminnum = SENSORS_LM78_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_LM78_FAN3;
            node->featminnum = SENSORS_LM78_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_LM78_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM78_TEMP_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
            break;
    }

    return SUCCESS;
}

#define LM78J_NUM_FEAT 11

/* Get the feature info for lm78 sensor. */
int get_feat_info_lm78j( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM78J_IN0;
            node->featminnum = SENSORS_LM78J_IN0_MIN;
            node->featmaxnum = SENSORS_LM78J_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_LM78J_IN1;
            node->featminnum = SENSORS_LM78J_IN1_MIN;
            node->featmaxnum = SENSORS_LM78J_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_LM78J_IN2;
            node->featminnum = SENSORS_LM78J_IN2_MIN;
            node->featmaxnum = SENSORS_LM78J_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_LM78J_IN3;
            node->featminnum = SENSORS_LM78J_IN3_MIN;
            node->featmaxnum = SENSORS_LM78J_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_LM78J_IN4;
            node->featminnum = SENSORS_LM78J_IN4_MIN;
            node->featmaxnum = SENSORS_LM78J_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_LM78J_IN5;
            node->featminnum = SENSORS_LM78J_IN5_MIN;
            node->featmaxnum = SENSORS_LM78J_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_LM78J_IN6;
            node->featminnum = SENSORS_LM78J_IN6_MIN;
            node->featmaxnum = SENSORS_LM78J_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_LM78J_FAN1;
            node->featminnum = SENSORS_LM78J_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 9:
            node->featnum = SENSORS_LM78J_FAN2;
            node->featminnum = SENSORS_LM78J_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_LM78J_FAN3;
            node->featminnum = SENSORS_LM78J_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_LM78J_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM78J_TEMP_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
            break;
    }

    return SUCCESS;
}

#define LM79_NUM_FEAT 11

/* Get the feature info for lm78 sensor. */
int get_feat_info_lm79( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM79_IN0;
            node->featminnum = SENSORS_LM79_IN0_MIN;
            node->featmaxnum = SENSORS_LM79_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_LM79_IN1;
            node->featminnum = SENSORS_LM79_IN1_MIN;
            node->featmaxnum = SENSORS_LM79_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_LM79_IN2;
            node->featminnum = SENSORS_LM79_IN2_MIN;
            node->featmaxnum = SENSORS_LM79_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_LM79_IN3;
            node->featminnum = SENSORS_LM79_IN3_MIN;
            node->featmaxnum = SENSORS_LM79_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_LM79_IN4;
            node->featminnum = SENSORS_LM79_IN4_MIN;
            node->featmaxnum = SENSORS_LM79_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_LM79_IN5;
            node->featminnum = SENSORS_LM79_IN5_MIN;
            node->featmaxnum = SENSORS_LM79_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_LM79_IN6;
            node->featminnum = SENSORS_LM79_IN6_MIN;
            node->featmaxnum = SENSORS_LM79_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_LM79_FAN1;
            node->featminnum = SENSORS_LM79_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 9:
            node->featnum = SENSORS_LM79_FAN2;
            node->featminnum = SENSORS_LM79_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_LM79_FAN3;
            node->featminnum = SENSORS_LM79_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_LM79_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM79_TEMP_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
            break;
    }

    return SUCCESS;
}


#define LM80_NUM_FEAT 10

/* Get the feature info for lm80 sensor. */
int get_feat_info_lm80( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM80_IN0;
            node->featminnum = SENSORS_LM80_IN0_MIN;
            node->featmaxnum = SENSORS_LM80_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_LM80_IN1;
            node->featminnum = SENSORS_LM80_IN1_MIN;
            node->featmaxnum = SENSORS_LM80_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_LM80_IN2;
            node->featminnum = SENSORS_LM80_IN2_MIN;
            node->featmaxnum = SENSORS_LM80_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_LM80_IN3;
            node->featminnum = SENSORS_LM80_IN3_MIN;
            node->featmaxnum = SENSORS_LM80_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_LM80_IN4;
            node->featminnum = SENSORS_LM80_IN4_MIN;
            node->featmaxnum = SENSORS_LM80_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_LM80_IN5;
            node->featminnum = SENSORS_LM80_IN5_MIN;
            node->featmaxnum = SENSORS_LM80_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_LM80_IN6;
            node->featminnum = SENSORS_LM80_IN6_MIN;
            node->featmaxnum = SENSORS_LM80_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_LM80_FAN1;
            node->featminnum = SENSORS_LM80_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 9:
            node->featnum = SENSORS_LM80_FAN2;
            node->featminnum = SENSORS_LM80_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_LM80_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM80_TEMP_HOT_MAX;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
            break;
    }

    return SUCCESS;
}

#define LM85_NUM_FEAT 12

/* Get the feature info for lm87 sensor. */
int get_feat_info_lm85( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM85_IN0;
            node->featminnum = SENSORS_LM85_IN0_MIN;
            node->featmaxnum = SENSORS_LM85_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_LM85_IN1;
            node->featminnum = SENSORS_LM85_IN1_MIN;
            node->featmaxnum = SENSORS_LM85_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_LM85_IN2;
            node->featminnum = SENSORS_LM85_IN2_MIN;
            node->featmaxnum = SENSORS_LM85_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_LM85_IN3;
            node->featminnum = SENSORS_LM85_IN3_MIN;
            node->featmaxnum = SENSORS_LM85_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_LM85_IN4;
            node->featminnum = SENSORS_LM85_IN4_MIN;
            node->featmaxnum = SENSORS_LM85_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_LM85_FAN1;
            node->featminnum = SENSORS_LM85_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 7:
            node->featnum = SENSORS_LM85_FAN2;
            node->featminnum = SENSORS_LM85_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 8:
            node->featnum = SENSORS_LM85_FAN3;
            node->featminnum = SENSORS_LM85_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 9:
            node->featnum = SENSORS_LM85_FAN4;
            node->featminnum = SENSORS_LM85_FAN4_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_LM85_TEMP1;
            node->featminnum = SENSORS_LM85_TEMP1_MIN;
            node->featmaxnum = SENSORS_LM85_TEMP1_MAX;
            node->feattype = TEMP;
            break;
        case 11:
            node->featnum = SENSORS_LM85_TEMP2;
            node->featminnum = SENSORS_LM85_TEMP2_MIN;
            node->featmaxnum = SENSORS_LM85_TEMP2_MAX;
            node->feattype = TEMP;
            break;
        case 12:
            node->featnum = SENSORS_LM85_TEMP3;
            node->featminnum = SENSORS_LM85_TEMP3_MIN;
            node->featmaxnum = SENSORS_LM85_TEMP3_MAX;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
            break;
    }

    return SUCCESS;
}

#define LM87_NUM_FEAT 13

/* Get the feature info for lm87 sensor. */
int get_feat_info_lm87( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM87_IN0;
            node->featminnum = SENSORS_LM87_IN0_MIN;
            node->featmaxnum = SENSORS_LM87_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_LM87_IN1;
            node->featminnum = SENSORS_LM87_IN1_MIN;
            node->featmaxnum = SENSORS_LM87_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_LM87_IN2;
            node->featminnum = SENSORS_LM87_IN2_MIN;
            node->featmaxnum = SENSORS_LM87_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_LM87_IN3;
            node->featminnum = SENSORS_LM87_IN3_MIN;
            node->featmaxnum = SENSORS_LM87_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_LM87_IN4;
            node->featminnum = SENSORS_LM87_IN4_MIN;
            node->featmaxnum = SENSORS_LM87_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_LM87_IN5;
            node->featminnum = SENSORS_LM87_IN5_MIN;
            node->featmaxnum = SENSORS_LM87_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_LM87_AIN1;
            node->featminnum = SENSORS_LM87_AIN1_MIN;
            node->featmaxnum = SENSORS_LM87_AIN1_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_LM87_AIN2;
            node->featminnum = SENSORS_LM87_AIN2_MIN;
            node->featmaxnum = SENSORS_LM87_AIN2_MAX;
            node->feattype = VOLT;
            break;
        case 9:
            node->featnum = SENSORS_LM87_FAN1;
            node->featminnum = SENSORS_LM87_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_LM87_FAN2;
            node->featminnum = SENSORS_LM87_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_LM87_TEMP1;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM87_TEMP1_OVER;
            node->feattype = TEMP;
            break;
        case 12:
            node->featnum = SENSORS_LM87_TEMP2;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM87_TEMP2_OVER;
            node->feattype = TEMP;
            break;
        case 13:
            node->featnum = SENSORS_LM87_TEMP3;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_LM87_TEMP3_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
            break;
    }

    return SUCCESS;
}

#define LM90_NUM_FEAT 2

/* Get the feature info for lm90 sensor. */
int get_feat_info_lm90( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_LM90_LOCAL_TEMP;
            node->featminnum = SENSORS_LM90_LOCAL_LOW;
            node->featmaxnum = SENSORS_LM90_LOCAL_HIGH;
            node->feattype = TEMP;
            break;
        case 2:
            node->featnum = SENSORS_LM90_REMOTE_TEMP;
            node->featminnum = SENSORS_LM90_REMOTE_LOW;
            node->featmaxnum = SENSORS_LM90_REMOTE_HIGH;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
            break;
    }

    return SUCCESS;
}

#define MAX1617_NUM_FEAT 2

/* Get the feature info for max1617 sensor. */
int get_feat_info_max1617( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_MAX1617_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_MAX1617_TEMP_OVER;
            node->feattype = TEMP;
            break;
        case 2:
            node->featnum = SENSORS_MAX1617_REMOTE_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_MAX1617_REMOTE_TEMP_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }
 
    return SUCCESS;
}

#define MAX1617A_NUM_FEAT 2

/* Get the feature info for max1617a sensor. */
int get_feat_info_max1617a( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_MAX1617A_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_MAX1617A_TEMP_OVER;
            node->feattype = TEMP;
            break;
        case 2:
            node->featnum = SENSORS_MAX1617A_REMOTE_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_MAX1617A_REMOTE_TEMP_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }
 
    return SUCCESS;
}

#define VIA686A_NUM_FEAT 10
                
/* Get the feature info for via686a sensor. */
int get_feat_info_via686a( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_VIA686A_IN0;
            node->featminnum = SENSORS_VIA686A_IN0_MIN;
            node->featmaxnum = SENSORS_VIA686A_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_VIA686A_IN1;
            node->featminnum = SENSORS_VIA686A_IN1_MIN;
            node->featmaxnum = SENSORS_VIA686A_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_VIA686A_IN2;
            node->featminnum = SENSORS_VIA686A_IN2_MIN;
            node->featmaxnum = SENSORS_VIA686A_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_VIA686A_IN3;
            node->featminnum = SENSORS_VIA686A_IN3_MIN;
            node->featmaxnum = SENSORS_VIA686A_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_VIA686A_IN4;
            node->featminnum = SENSORS_VIA686A_IN4_MIN;
            node->featmaxnum = SENSORS_VIA686A_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_VIA686A_FAN1;
            node->featminnum = SENSORS_VIA686A_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 7:
            node->featnum = SENSORS_VIA686A_FAN2;
            node->featminnum = SENSORS_VIA686A_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 8:
            node->featnum = SENSORS_VIA686A_TEMP;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_VIA686A_TEMP_OVER;
            node->feattype = TEMP;
            break;
        case 9:
            node->featnum = SENSORS_VIA686A_TEMP2;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_VIA686A_TEMP2_OVER;
            node->feattype = TEMP;
            break;
        case 10:
            node->featnum = SENSORS_VIA686A_TEMP3;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_VIA686A_TEMP3_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }

    return SUCCESS;
}

#define W83781D_NUM_FEAT 13
                
/* Get the feature info for w83781d sensor. */
int get_feat_info_w83781d( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_W83781D_IN0;
            node->featminnum = SENSORS_W83781D_IN0_MIN;
            node->featmaxnum = SENSORS_W83781D_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_W83781D_IN1;
            node->featminnum = SENSORS_W83781D_IN1_MIN;
            node->featmaxnum = SENSORS_W83781D_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_W83781D_IN2;
            node->featminnum = SENSORS_W83781D_IN2_MIN;
            node->featmaxnum = SENSORS_W83781D_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_W83781D_IN3;
            node->featminnum = SENSORS_W83781D_IN3_MIN;
            node->featmaxnum = SENSORS_W83781D_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_W83781D_IN4;
            node->featminnum = SENSORS_W83781D_IN4_MIN;
            node->featmaxnum = SENSORS_W83781D_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_W83781D_IN5;
            node->featminnum = SENSORS_W83781D_IN5_MIN;
            node->featmaxnum = SENSORS_W83781D_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_W83781D_IN6;
            node->featminnum = SENSORS_W83781D_IN6_MIN;
            node->featmaxnum = SENSORS_W83781D_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_W83781D_FAN1;
            node->featminnum = SENSORS_W83781D_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 9:
            node->featnum = SENSORS_W83781D_FAN2;
            node->featminnum = SENSORS_W83781D_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_W83781D_FAN3;
            node->featminnum = SENSORS_W83781D_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_W83781D_TEMP1;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83781D_TEMP1_OVER;
            node->feattype = TEMP;
            break;
        case 12:
            node->featnum = SENSORS_W83781D_TEMP2;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83781D_TEMP2_OVER;
            node->feattype = TEMP;
            break;
        case 13:
            node->featnum = SENSORS_W83781D_TEMP3;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83781D_TEMP3_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }

    return SUCCESS;
}

#define W83782D_NUM_FEAT 15
                
/* Get the feature info for w83782d sensor. */
int get_feat_info_w83782d( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_W83782D_IN0;
            node->featminnum = SENSORS_W83782D_IN0_MIN;
            node->featmaxnum = SENSORS_W83782D_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_W83782D_IN1;
            node->featminnum = SENSORS_W83782D_IN1_MIN;
            node->featmaxnum = SENSORS_W83782D_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_W83782D_IN2;
            node->featminnum = SENSORS_W83782D_IN2_MIN;
            node->featmaxnum = SENSORS_W83782D_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_W83782D_IN3;
            node->featminnum = SENSORS_W83782D_IN3_MIN;
            node->featmaxnum = SENSORS_W83782D_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_W83782D_IN4;
            node->featminnum = SENSORS_W83782D_IN4_MIN;
            node->featmaxnum = SENSORS_W83782D_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_W83782D_IN5;
            node->featminnum = SENSORS_W83782D_IN5_MIN;
            node->featmaxnum = SENSORS_W83782D_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_W83782D_IN6;
            node->featminnum = SENSORS_W83782D_IN6_MIN;
            node->featmaxnum = SENSORS_W83782D_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_W83782D_IN7;
            node->featminnum = SENSORS_W83782D_IN7_MIN;
            node->featmaxnum = SENSORS_W83782D_IN7_MAX;
            node->feattype = VOLT;
            break;
        case 9:
            node->featnum = SENSORS_W83782D_IN8;
            node->featminnum = SENSORS_W83782D_IN8_MIN;
            node->featmaxnum = SENSORS_W83782D_IN8_MAX;
            node->feattype = VOLT;
            break;
        case 10:
            node->featnum = SENSORS_W83782D_FAN1;
            node->featminnum = SENSORS_W83782D_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_W83782D_FAN2;
            node->featminnum = SENSORS_W83782D_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 12:
            node->featnum = SENSORS_W83782D_FAN3;
            node->featminnum = SENSORS_W83782D_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 13:
            node->featnum = SENSORS_W83782D_TEMP1;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83782D_TEMP1_OVER;
            node->feattype = TEMP;
            break;
        case 14:
            node->featnum = SENSORS_W83782D_TEMP2;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83782D_TEMP2_OVER;
            node->feattype = TEMP;
            break;
        case 15:
            node->featnum = SENSORS_W83782D_TEMP3;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83782D_TEMP3_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }

    return SUCCESS;
}




#define W83783S_NUM_FEAT 12
                
/* Get the feature info for w83783s and w83697hf sensor. */
int get_feat_info_w83783s( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_W83783S_IN0;
            node->featminnum = SENSORS_W83783S_IN0_MIN;
            node->featmaxnum = SENSORS_W83783S_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_W83783S_IN1;
            node->featminnum = SENSORS_W83783S_IN1_MIN;
            node->featmaxnum = SENSORS_W83783S_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_W83783S_IN2;
            node->featminnum = SENSORS_W83783S_IN2_MIN;
            node->featmaxnum = SENSORS_W83783S_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_W83783S_IN3;
            node->featminnum = SENSORS_W83783S_IN3_MIN;
            node->featmaxnum = SENSORS_W83783S_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_W83783S_IN4;
            node->featminnum = SENSORS_W83783S_IN4_MIN;
            node->featmaxnum = SENSORS_W83783S_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_W83783S_IN5;
            node->featminnum = SENSORS_W83783S_IN5_MIN;
            node->featmaxnum = SENSORS_W83783S_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_W83783S_IN6;
            node->featminnum = SENSORS_W83783S_IN6_MIN;
            node->featmaxnum = SENSORS_W83783S_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_W83783S_FAN1;
            node->featminnum = SENSORS_W83783S_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 9:
            node->featnum = SENSORS_W83783S_FAN2;
            node->featminnum = SENSORS_W83783S_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 10:
            node->featnum = SENSORS_W83783S_FAN3;
            node->featminnum = SENSORS_W83783S_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_W83783S_TEMP1;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83783S_TEMP1_OVER;
            node->feattype = TEMP;
            break;
        case 12:
            node->featnum = SENSORS_W83783S_TEMP2;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83783S_TEMP2_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }

    return SUCCESS;
}

#define AS99127F_NUM_FEAT 15
                
/* Get the feature info for as99127f sensor. */
int get_feat_info_as99127f( updates *node, sensors_chip_name name, int num ) {
    switch (num) {
        case 1:
            node->featnum = SENSORS_W83782D_IN0;
            node->featminnum = SENSORS_W83782D_IN0_MIN;
            node->featmaxnum = SENSORS_W83782D_IN0_MAX;
            node->feattype = VOLT;
            break;
        case 2:
            node->featnum = SENSORS_W83782D_IN1;
            node->featminnum = SENSORS_W83782D_IN1_MIN;
            node->featmaxnum = SENSORS_W83782D_IN1_MAX;
            node->feattype = VOLT;
            break;
        case 3:
            node->featnum = SENSORS_W83782D_IN2;
            node->featminnum = SENSORS_W83782D_IN2_MIN;
            node->featmaxnum = SENSORS_W83782D_IN2_MAX;
            node->feattype = VOLT;
            break;
        case 4:
            node->featnum = SENSORS_W83782D_IN3;
            node->featminnum = SENSORS_W83782D_IN3_MIN;
            node->featmaxnum = SENSORS_W83782D_IN3_MAX;
            node->feattype = VOLT;
            break;
        case 5:
            node->featnum = SENSORS_W83782D_IN4;
            node->featminnum = SENSORS_W83782D_IN4_MIN;
            node->featmaxnum = SENSORS_W83782D_IN4_MAX;
            node->feattype = VOLT;
            break;
        case 6:
            node->featnum = SENSORS_W83782D_IN5;
            node->featminnum = SENSORS_W83782D_IN5_MIN;
            node->featmaxnum = SENSORS_W83782D_IN5_MAX;
            node->feattype = VOLT;
            break;
        case 7:
            node->featnum = SENSORS_W83782D_IN6;
            node->featminnum = SENSORS_W83782D_IN6_MIN;
            node->featmaxnum = SENSORS_W83782D_IN6_MAX;
            node->feattype = VOLT;
            break;
        case 8:
            node->featnum = SENSORS_W83782D_IN7;
            node->featminnum = SENSORS_W83782D_IN7_MIN;
            node->featmaxnum = SENSORS_W83782D_IN7_MAX;
            node->feattype = VOLT;
            break;
        case 9:
            node->featnum = SENSORS_W83782D_IN8;
            node->featminnum = SENSORS_W83782D_IN8_MIN;
            node->featmaxnum = SENSORS_W83782D_IN8_MAX;
            node->feattype = VOLT;
            break;
        case 10:
            node->featnum = SENSORS_W83782D_FAN1;
            node->featminnum = SENSORS_W83782D_FAN1_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 11:
            node->featnum = SENSORS_W83782D_FAN2;
            node->featminnum = SENSORS_W83782D_FAN2_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 12:
            node->featnum = SENSORS_W83781D_FAN3;
            node->featminnum = SENSORS_W83781D_FAN3_MIN;
            node->featmaxnum = UNDEFMAXMIN;
            node->feattype = FAN;
            break;
        case 13:
            node->featnum = SENSORS_W83782D_TEMP1;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83782D_TEMP1_OVER;
            node->feattype = TEMP;
            break;
        case 14:
            node->featnum = SENSORS_W83781D_TEMP2;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83782D_TEMP2_OVER;
            node->feattype = TEMP;
            break;
        case 15:
            node->featnum = SENSORS_W83782D_TEMP3;
            node->featminnum = UNDEFMAXMIN;
            node->featmaxnum = SENSORS_W83782D_TEMP3_OVER;
            node->feattype = TEMP;
            break;
        default:
            return FAILURE;
    }

    return SUCCESS;
}

/* Simply return the number of features a specified sensor has from
 * defines above.
 */
int get_num_feat( sensors_chip_name name ) {
    if ( ( strcmp( name.prefix, SENSORS_ADM1021_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_ADM1023_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_LM84_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_GL523_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_THMC10_PREFIX ) == 0 ) ) {
        return ADM1021_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_EEPROM_PREFIX ) == 0 ) {
        return EEPROM_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_IT87_PREFIX ) == 0 ) {
        return IT87_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_LM75_PREFIX ) == 0 ) {
        return LM75_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_LM78_PREFIX ) == 0 ) {
        return LM78_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_LM78J_PREFIX ) == 0 ) {
        return LM78J_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_LM79_PREFIX ) == 0 ) {
        return LM79_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_LM80_PREFIX ) == 0 ) {
        return LM80_NUM_FEAT;
    } else if ( ( strcmp( name.prefix, SENSORS_LM85_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_LM85B_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_LM85C_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_ADM1027_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_ADT7463_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_EMC6D100_PREFIX ) == 0 ) ) {
        return LM85_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_LM87_PREFIX ) == 0 ) {
        return LM87_NUM_FEAT;
    } else if ( ( strcmp( name.prefix, SENSORS_LM90_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_ADM1032_PREFIX ) == 0 ) ) {
        return LM90_NUM_FEAT;
    } else if ( ( strcmp( name.prefix, SENSORS_MAX1617_PREFIX ) == 0 ) ||
    		( strcmp( name.prefix, SENSORS_MC1066_PREFIX ) == 0 ) ) {
        return MAX1617_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_MAX1617A_PREFIX ) == 0 ) {
        return MAX1617A_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_VIA686A_PREFIX ) == 0 ) {
        return VIA686A_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_W83781D_PREFIX ) == 0 ) {
        return W83781D_NUM_FEAT;
    } else if ( ( strcmp( name.prefix, SENSORS_W83782D_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83627HF_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83627THF_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83791D_PREFIX ) == 0 ) ) {
        return W83782D_NUM_FEAT;
    } else if ( ( strcmp( name.prefix, SENSORS_W83783S_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83697HF_PREFIX ) == 0 ) ) {
        return W83783S_NUM_FEAT;
    } else if ( strcmp( name.prefix, SENSORS_AS99127F_PREFIX ) == 0 ) {
        return AS99127F_NUM_FEAT;
    } else {
        return 0;
    }
}

/* Add a node to the feature linked list at the passed node pointer. */
updates *add_node( updates *node, sensors_chip_name name, GtkWidget *darea, 
                   GtkWidget *pbar, int num ) {
    int retval = 0;

    if( ( node = g_malloc( sizeof( updates ) ) ) == NULL ) {
        fprintf( stderr, "malloc failed!\n" );
        return NULL;
    }

    if ( ( strcmp( name.prefix, SENSORS_ADM1021_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_ADM1023_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_LM84_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_GL523_PREFIX ) == 0 ) ||
         ( strcmp( name.prefix, SENSORS_THMC10_PREFIX ) == 0 ) ) {
        retval = get_feat_info_adm1021( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_EEPROM_PREFIX ) == 0 ) {
        retval = get_feat_info_eeprom( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_IT87_PREFIX ) == 0 ) {
        retval = get_feat_info_it87( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_LM75_PREFIX ) == 0 ) {
        retval = get_feat_info_lm75( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_LM78_PREFIX ) == 0 ) {
        retval = get_feat_info_lm78( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_LM78J_PREFIX ) == 0 ) {
        retval = get_feat_info_lm78j( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_LM79_PREFIX ) == 0 ) {
        retval = get_feat_info_lm79( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_LM80_PREFIX ) == 0 ) {
        retval = get_feat_info_lm80( node, name, num );
    } else if ( ( strcmp( name.prefix, SENSORS_LM85_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_LM85B_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_LM85C_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_ADM1027_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_ADT7463_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_EMC6D100_PREFIX ) == 0 ) ) {
        retval = get_feat_info_lm85( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_LM87_PREFIX ) == 0 ) {
        retval = get_feat_info_lm87( node, name, num );
    } else if ( ( strcmp( name.prefix, SENSORS_LM90_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_ADM1032_PREFIX ) == 0 ) ) {
        retval = get_feat_info_lm90( node, name, num );
    } else if ( ( strcmp( name.prefix, SENSORS_MAX1617_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_MC1066_PREFIX ) == 0 ) ) {
        retval = get_feat_info_max1617( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_MAX1617A_PREFIX ) == 0 ) {
        retval = get_feat_info_max1617a( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_VIA686A_PREFIX ) == 0 ) {
        retval = get_feat_info_via686a( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_W83781D_PREFIX ) == 0 ) {
        retval = get_feat_info_w83781d( node, name, num );
    } else if ( ( strcmp( name.prefix, SENSORS_W83782D_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83627HF_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83627THF_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83791D_PREFIX ) == 0 ) ) {
        retval = get_feat_info_w83782d( node, name, num );
    } else if ( ( strcmp( name.prefix, SENSORS_W83783S_PREFIX ) == 0 ) ||
                ( strcmp( name.prefix, SENSORS_W83697HF_PREFIX ) == 0 ) ) {
        retval = get_feat_info_w83783s( node, name, num );
    } else if ( strcmp( name.prefix, SENSORS_AS99127F_PREFIX ) == 0 ) {
        retval = get_feat_info_as99127f( node, name, num );
    } else {
        g_free( node );
        return NULL;
    }
    
    node->name = name;
    node->darea = darea;
    node->pbar = pbar;
    node->next = NULL;

    return node;
}
