// file      : tests/cxx/parser/validation/built-in/qname/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Test the built-in QName type validation.
//
#include <cassert>

#include <xsde/config.h>

// Let the runtime header sort out which version (stl/no-stl) to
// include.
//
#include <xsde/cxx/parser/validating/xml-schema-pimpl.hxx>

using namespace xsde::cxx;
using namespace xsde::cxx::parser::validating;

#ifdef XSDE_STL
bool
compare (const qname& x, const char* p, const char* n)
{
  return x == qname (p, n);
}
#else
bool
compare (qname* x, const char* p, const char* n)
{
  qname y;
  y.prefix (p);
  y.name (n);

  bool r = *x == y;
  delete x;
  return r;
}
#endif

int
main (int argc, char* argv[])
{
  // Good.
  //
  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    p._characters (" xsi");
    p._characters (":");
    p._characters ("schemaLocation");
    p._post ();
    assert (!p._error_type () &&
            compare (p.post_qname (), "xsi", "schemaLocation"));
  }

  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("schemaLocation");
    p._post ();
    assert (!p._error_type () &&
            compare (p.post_qname (), "", "schemaLocation"));
  }


  // Bad
  //
  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    //p._characters ("");
    p._post ();
    assert (p._schema_error () == schema_error::invalid_qname_value);
  }

  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    p._characters (":");
    p._post ();
    assert (p._schema_error () == schema_error::invalid_qname_value);
  }

  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("xsi:");
    p._post ();
    assert (p._schema_error () == schema_error::invalid_qname_value);
  }

  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    p._characters (":schemaLocation");
    p._post ();
    assert (p._schema_error () == schema_error::invalid_qname_value);
  }

  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("x?i:schemaLocation");
    p._post ();
    assert (p._schema_error () == schema_error::invalid_qname_value);
  }

  {
    qname_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("xsi:schema Location");
    p._post ();
    assert (p._schema_error () == schema_error::invalid_qname_value);
  }
}
