// file      : tests/cxx/parser/validation/built-in/float/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Test the built-in float, double, and decimal types validation.
//
#include <math.h>
#include <cassert>

#include <xsde/cxx/parser/validating/float.hxx>
#include <xsde/cxx/parser/validating/double.hxx>
#include <xsde/cxx/parser/validating/decimal.hxx>

using namespace xsde::cxx::parser::validating;

int
main (int argc, char* argv[])
{
  // Good.
  //

  // float
  //
  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters (" 0000123.456 ");
    p._post ();
    assert (!p._error_type () && p.post_float () == 123.456F);
  }

  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-12.345E2");
    p._post ();
    assert (!p._error_type () && p.post_float () == -12.345E2F);
  }

  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("0");
    p._post ();
    assert (!p._error_type () && p.post_float () == 0.0F);
  }

  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-0");
    p._post ();
    assert (!p._error_type () && p.post_float () == -0.0F);
  }

  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("INF");
    p._post ();
    assert (!p._error_type () && isinf (p.post_float ()));
  }

  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-INF");
    p._post ();
    assert (!p._error_type () && isinf (p.post_float ()));
  }

  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("NaN");
    p._post ();
    assert (!p._error_type () && isnan (p.post_float ()));
  }

  // double
  //
  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters (" 0000123.456789 ");
    p._post ();
    assert (!p._error_type () && p.post_double () == 123.456789);
  }

  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-12.3456789E2");
    p._post ();
    assert (!p._error_type () && p.post_double () == -12.3456789E2);
  }

  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("0");
    p._post ();
    assert (!p._error_type () && p.post_double () == 0.0);
  }

  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-0");
    p._post ();
    assert (!p._error_type () && p.post_double () == -0.0);
  }

  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("INF");
    p._post ();
    assert (!p._error_type () && isinf (p.post_double ()));
  }

  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-INF");
    p._post ();
    assert (!p._error_type () && isinf (p.post_double ()));
  }

  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("NaN");
    p._post ();
    assert (!p._error_type () && isnan (p.post_double ()));
  }

  // decimal
  //
  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters (" 0000123.456789 ");
    p._post ();
    assert (!p._error_type () && p.post_decimal () == 123.456789);
  }

  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-123.45678912345");
    p._post ();
    assert (!p._error_type () && p.post_decimal () == -123.45678912345);
  }

  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("0");
    p._post ();
    assert (!p._error_type () && p.post_decimal () == 0.0);
  }

  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-0");
    p._post ();
    assert (!p._error_type () && p.post_decimal () == -0.0);
  }


  // Bad
  //

  // float
  //
  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("+INF");
    p._post ();
    assert (p._schema_error ());
  }

  {
    float_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("1.45 E2");
    p._post ();
    assert (p._schema_error ());
  }

  // double
  //
  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("+INF");
    p._post ();
    assert (p._schema_error ());
  }

  {
    double_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("1.45 E2");
    p._post ();
    assert (p._schema_error ());
  }

  // decimal
  //
  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("INF");
    p._post ();
    assert (p._schema_error ());
  }

  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("+INF");
    p._post ();
    assert (p._schema_error ());
  }

  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-INF");
    p._post ();
    assert (p._schema_error ());
  }

  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("NaN");
    p._post ();
    assert (p._schema_error ());
  }

  {
    decimal_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("1.45 2");
    p._post ();
    assert (p._schema_error ());
  }
}
