/* global.h, global variables                                               */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

#include "mpeg2dec.h"

/* choose between declaration (GLOBAL undefined)
 * and definition (GLOBAL defined)
 * GLOBAL is defined in exactly one file mpeg2dec.c)
 */

#ifndef GLOBAL
#define EXTERN extern
#else
#define EXTERN
#endif

struct mpeg2obj;

/* prototypes of global functions */
/* readpic.c */
void _mpeg2Substitute_Frame_Buffer _ANSI_ARGS_ ((struct mpeg2obj *m, int bitstream_framenum, 
  int sequence_framenum));

/* Get_Bits.c */
void _mpeg2Initialize_Buffer _ANSI_ARGS_((struct mpeg2obj *m));
void _mpeg2Fill_Buffer _ANSI_ARGS_((struct mpeg2obj *m));
unsigned int _mpeg2Show_Bits _ANSI_ARGS_((struct mpeg2obj *m, int n));
unsigned int _mpeg2Get_Bits1 _ANSI_ARGS_((struct mpeg2obj *m));
void _mpeg2Flush_Buffer _ANSI_ARGS_((struct mpeg2obj *m, int n));
unsigned int _mpeg2Get_Bits _ANSI_ARGS_((struct mpeg2obj *m, int n));
int _mpeg2Get_Byte _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_Word _ANSI_ARGS_((struct mpeg2obj *m));

/* systems.c */
void _mpeg2Next_Packet _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_Long _ANSI_ARGS_((struct mpeg2obj *m));
void _mpeg2Flush_Buffer32 _ANSI_ARGS_((struct mpeg2obj *m));
unsigned int _mpeg2Get_Bits32 _ANSI_ARGS_((struct mpeg2obj *m));


/* getblk.c */
void _mpeg2Decode_MPEG1_Intra_Block _ANSI_ARGS_((struct mpeg2obj *m, int comp, int dc_dct_pred[]));
void _mpeg2Decode_MPEG1_Non_Intra_Block _ANSI_ARGS_((struct mpeg2obj *m, int comp));
void _mpeg2Decode_MPEG2_Intra_Block _ANSI_ARGS_((struct mpeg2obj *m, int comp, int dc_dct_pred[]));
void _mpeg2Decode_MPEG2_Non_Intra_Block _ANSI_ARGS_((struct mpeg2obj *m, int comp));

/* gethdr.c */
int _mpeg2Get_Hdr _ANSI_ARGS_((struct mpeg2obj *m));
void _mpeg2next_start_code _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2slice_header _ANSI_ARGS_((struct mpeg2obj *m));
void _mpeg2marker_bit _ANSI_ARGS_((struct mpeg2obj *m, const char *text));

/* getpic.c */
void _mpeg2Decode_Picture _ANSI_ARGS_((struct mpeg2obj *m, int bitstream_framenum, 
  int sequence_framenum));
void _mpeg2Output_Last_Frame_of_Sequence _ANSI_ARGS_((struct mpeg2obj *m, int framenum));

/* getvlc.c */
int _mpeg2Get_macroblock_type _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_motion_code _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_dmvector _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_coded_block_pattern _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_macroblock_address_increment _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_Luma_DC_dct_diff _ANSI_ARGS_((struct mpeg2obj *m));
int _mpeg2Get_Chroma_DC_dct_diff _ANSI_ARGS_((struct mpeg2obj *m));

/* idct.c */
void _mpeg2Fast_IDCT _ANSI_ARGS_((struct mpeg2obj *m, short *block));
void _mpeg2Initialize_Fast_IDCT _ANSI_ARGS_((struct mpeg2obj *m));

/* Reference_IDCT.c */
void _mpeg2Initialize_Reference_IDCT _ANSI_ARGS_((struct mpeg2obj *m));
void _mpeg2Reference_IDCT _ANSI_ARGS_((struct mpeg2obj *m, short *block));

/* motion.c */
void _mpeg2motion_vectors _ANSI_ARGS_((struct mpeg2obj *m, int PMV[2][2][2], int dmvector[2],
  int motion_vertical_field_select[2][2], int s, int motion_vector_count, 
  int mv_format, int h_r_size, int v_r_size, int dmv, int mvscale));
void _mpeg2motion_vector _ANSI_ARGS_((struct mpeg2obj *m, int *PMV, int *dmvector,
  int h_r_size, int v_r_size, int dmv, int mvscale, int full_pel_vector));
void _mpeg2Dual_Prime_Arithmetic _ANSI_ARGS_((struct mpeg2obj *m, int DMV[][2], int *dmvector, int mvx, int mvy));

/* mpeg2dec.c */
void _mpeg2Error _ANSI_ARGS_((struct mpeg2obj *m, const char *text));
void _mpeg2Warning _ANSI_ARGS_((struct mpeg2obj *m, const char *text));
void _mpeg2Print_Bits _ANSI_ARGS_((struct mpeg2obj *m, int code, int bits, int len));

/* recon.c */
void _mpeg2form_predictions _ANSI_ARGS_((struct mpeg2obj *m, int bx, int by, int macroblock_type, 
  int motion_type, int PMV[2][2][2], int motion_vertical_field_select[2][2], 
  int dmvector[2], int stwtype));

/* spatscal.c */
void _mpeg2Spatial_Prediction _ANSI_ARGS_((struct mpeg2obj *m));

/* store.c */
void _mpeg2Write_Frame _ANSI_ARGS_((struct mpeg2obj *m, unsigned char *src[], int frame));

/* global variables */

EXTERN char _mpeg2Version[]
#ifdef GLOBAL
  ="mpeg2decode V1.2a, 96/07/19"
#endif
;

EXTERN char _mpeg2Author[]
#ifdef GLOBAL
  ="(C) 1996, MPEG Software Simulation Group"
#endif
;


/* zig-zag and alternate scan patterns */
EXTERN unsigned char _mpeg2scan[2][64]
#ifdef GLOBAL
=
{
  { /* Zig-Zag scan pattern  */
    0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,
    12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,
    35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,
    58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63
  },
  { /* Alternate scan pattern */
    0,8,16,24,1,9,2,10,17,25,32,40,48,56,57,49,
    41,33,26,18,3,11,4,12,19,27,34,42,50,58,35,43,
    51,59,20,28,5,13,6,14,21,29,36,44,52,60,37,45,
    53,61,22,30,7,15,23,31,38,46,54,62,39,47,55,63
  }
}
#endif
;

/* default intra quantization matrix */
EXTERN unsigned char _mpeg2default_intra_quantizer_matrix[64]
#ifdef GLOBAL
=
{
  8, 16, 19, 22, 26, 27, 29, 34,
  16, 16, 22, 24, 27, 29, 34, 37,
  19, 22, 26, 27, 29, 34, 34, 38,
  22, 22, 26, 27, 29, 34, 37, 40,
  22, 26, 27, 29, 32, 35, 40, 48,
  26, 27, 29, 32, 35, 40, 48, 58,
  26, 27, 29, 34, 38, 46, 56, 69,
  27, 29, 35, 38, 46, 56, 69, 83
}
#endif
;

/* non-linear quantization coefficient table */
EXTERN unsigned char _mpeg2Non_Linear_quantizer_scale[32]
#ifdef GLOBAL
=
{
   0, 1, 2, 3, 4, 5, 6, 7,
   8,10,12,14,16,18,20,22,
  24,28,32,36,40,44,48,52,
  56,64,72,80,88,96,104,112
}
#endif
;

/* color space conversion coefficients
 * for YCbCr -> RGB mapping
 *
 * entries are {crv,cbu,cgu,cgv}
 *
 * crv=(255/224)*65536*(1-cr)/0.5
 * cbu=(255/224)*65536*(1-cb)/0.5
 * cgu=(255/224)*65536*(cb/cg)*(1-cb)/0.5
 * cgv=(255/224)*65536*(cr/cg)*(1-cr)/0.5
 *
 * where Y=cr*R+cg*G+cb*B (cr+cg+cb=1)
 */

/* ISO/IEC 13818-2 section 6.3.6 sequence_display_extension() */

EXTERN int _mpeg2Inverse_Table_6_9[8][4]
#ifdef GLOBAL
=
{
  {117504, 138453, 13954, 34903}, /* no sequence_display_extension */
  {117504, 138453, 13954, 34903}, /* ITU-R Rec. 709 (1990) */
  {104597, 132201, 25675, 53279}, /* unspecified */
  {104597, 132201, 25675, 53279}, /* reserved */
  {104448, 132798, 24759, 53109}, /* FCC */
  {104597, 132201, 25675, 53279}, /* ITU-R Rec. 624-4 System B, G */
  {104597, 132201, 25675, 53279}, /* SMPTE 170M */
  {117579, 136230, 16907, 35559}  /* SMPTE 240M (1987) */
}
#endif
;





/* decoder operation control flags */
EXTERN int _mpeg2Quiet_Flag;
EXTERN int _mpeg2Trace_Flag;
EXTERN int _mpeg2Verbose_Flag;








/* layer specific variables (needed for SNR and DP scalability) */
struct layer_data {
  /* bit input */
  int Infile;
  unsigned char Rdbfr[2048];
  unsigned char *Rdptr;
  unsigned char Inbfr[16];
  /* from mpeg2play */
  unsigned int Bfr;
  unsigned char *Rdmax;
  int Incnt;
  int Bitcnt;
  /* sequence header and quant_matrix_extension() */
  int intra_quantizer_matrix[64];
  int non_intra_quantizer_matrix[64];
  int chroma_intra_quantizer_matrix[64];
  int chroma_non_intra_quantizer_matrix[64];
  
  int load_intra_quantizer_matrix;
  int load_non_intra_quantizer_matrix;
  int load_chroma_intra_quantizer_matrix;
  int load_chroma_non_intra_quantizer_matrix;

  int MPEG2_Flag;
  /* sequence scalable extension */
  int scalable_mode;
  /* picture coding extension */
  int q_scale_type;
  int alternate_scan;
  /* picture spatial scalable extension */
  int pict_scal;
  /* slice/macroblock */
  int priority_breakpoint;
  int quantizer_scale;
  int intra_slice;
  short block[12][64];
};



#ifdef VERIFY
EXTERN int verify_sequence_header;
EXTERN int verify_group_of_pictures_header;
EXTERN int verify_picture_header;
EXTERN int verify_slice_header;
EXTERN int verify_sequence_extension;
EXTERN int verify_sequence_display_extension;
EXTERN int verify_quant_matrix_extension;
EXTERN int verify_sequence_scalable_extension;
EXTERN int verify_picture_display_extension;
EXTERN int verify_picture_coding_extension;
EXTERN int verify_picture_spatial_scalable_extension;
EXTERN int verify_picture_temporal_scalable_extension;
EXTERN int verify_copyright_extension;
#endif /* VERIFY */


/* EXTERN int Decode_Layer; */

/* verify.c */
#ifdef VERIFY
void Check_Headers _ANSI_ARGS_((int Bitstream_Framenum, int Sequence_Framenum));
void Clear_Verify_Headers _ANSI_ARGS_((void));
#endif /* VERIFY */


/* EXTERN int global_MBA; */
/* EXTERN int global_pic; */

#define STATE_FIRST_IN_SEQUENCE 0
#define STATE_NEXT_IN_SEQUENCE  1

struct mpeg2obj
{
  int bitstream_framenum, sequence_framenum;
  int state;

  /* filenames */
  const char *Main_Bitstream_Filename; 
  const char *Substitute_Picture_Filename;
  const char *Enhancement_Layer_Bitstream_Filename; 

  struct layer_data base, enhan, *ld;
  int Second_Field;
  int System_Stream_Flag;
  int Fault_Flag;

/* normative derived variables (as per ISO/IEC 13818-2) */
  int horizontal_size;
  int vertical_size;
  int mb_width;
  int mb_height;
  double bit_rate;
  double frame_rate; 



/* headers */

/* non-normative variables derived from normative elements */
  int Coded_Picture_Width;
  int Coded_Picture_Height;
  int Chroma_Width;
  int Chroma_Height;
  int block_count;
  int profile, level;

/* ISO/IEC 13818-2 section 6.2.2.1:  sequence_header() */
  int aspect_ratio_information;
  int frame_rate_code; 
  int bit_rate_value; 
  int vbv_buffer_size;
  int constrained_parameters_flag;

/* ISO/IEC 13818-2 section 6.2.2.3:  sequence_extension() */
  int profile_and_level_indication;
  int progressive_sequence;
  int chroma_format;
  int low_delay;
  int frame_rate_extension_n;
  int frame_rate_extension_d;

/* ISO/IEC 13818-2 section 6.2.2.4:  sequence_display_extension() */
  int video_format;  
  int color_description;
  int color_primaries;
  int transfer_characteristics;
  int matrix_coefficients;
  int display_horizontal_size;
  int display_vertical_size;

/* ISO/IEC 13818-2 section 6.2.3: picture_header() */
  int temporal_reference;
  int picture_coding_type;
  int vbv_delay;
  int full_pel_forward_vector;
  int forward_f_code;
  int full_pel_backward_vector;
  int backward_f_code;


/* ISO/IEC 13818-2 section 6.2.3.1: picture_coding_extension() header */
  int f_code[2][2];
  int intra_dc_precision;
  int picture_structure;
  int top_field_first;
  int frame_pred_frame_dct;
  int concealment_motion_vectors;

  int intra_vlc_format;

  int repeat_first_field;

  int chroma_420_type;
  int progressive_frame;
  int composite_display_flag;
  int v_axis;
  int field_sequence;
  int sub_carrier;
  int burst_amplitude;
  int sub_carrier_phase;



/* ISO/IEC 13818-2 section 6.2.3.3: picture_display_extension() header */
  int frame_center_horizontal_offset[3];
  int frame_center_vertical_offset[3];



/* ISO/IEC 13818-2 section 6.2.2.5: sequence_scalable_extension() header */
  int layer_id;
  int lower_layer_prediction_horizontal_size;
  int lower_layer_prediction_vertical_size;
  int horizontal_subsampling_factor_m;
  int horizontal_subsampling_factor_n;
  int vertical_subsampling_factor_m;
  int vertical_subsampling_factor_n;


/* ISO/IEC 13818-2 section 6.2.3.5: picture_spatial_scalable_extension() header */
  int lower_layer_temporal_reference;
  int lower_layer_horizontal_offset;
  int lower_layer_vertical_offset;
  int spatial_temporal_weight_code_table_index;
  int lower_layer_progressive_frame;
  int lower_layer_deinterlaced_field_select;






/* ISO/IEC 13818-2 section 6.2.3.6: copyright_extension() header */
  int copyright_flag;
  int copyright_identifier;
  int original_or_copy;
  int copyright_number_1;
  int copyright_number_2;
  int copyright_number_3;

/* ISO/IEC 13818-2 section 6.2.2.6: group_of_pictures_header()  */
  int drop_flag;
  int hour;
  int minute;
  int sec;
  int frame;
  int closed_gop;
  int broken_link;

  int Temporal_Reference_Base;
  int True_Framenum_max;
  int Temporal_Reference_GOP_Reset;
  int True_Framenum;

  int Two_Streams;
  int Spatial_Flag;
  int Reference_IDCT_Flag;
  int Frame_Store_Flag;
  int Display_Progressive_Flag;
  int Ersatz_Flag;
  int Big_Picture_Flag;
  int Verify_Flag;
  int Stats_Flag;
  int User_Data_Flag;

/* decoder operation control variables */
  int hiQdither;

/* buffers for multiuse purposes */
  char Error_Text[256];
  unsigned char *Clip;

/* pointers to generic picture buffers */
  unsigned char *backward_reference_frame[3];
  unsigned char *forward_reference_frame[3];

  unsigned char *auxframe[3];
  unsigned char *current_frame[3];
  unsigned char *substitute_frame[3];


/* pointers to scalability picture buffers */
  unsigned char *llframe0[3];
  unsigned char *llframe1[3];

  short *lltmp;
  const char *Lower_Layer_Picture_Filename;

  /* tracking variables to insure proper output in spatial scalability */
  int Oldref_progressive_frame, Newref_progressive_frame;

  /* variables set by called of mpeg2 library */
  int scale_width_up, scale_width_down;
  int scale_height_up, scale_height_down;

  unsigned char *output_buffer;

};
