/*
 * Copyright (c) 2001-2007
 *     DecisionSoft Limited. All rights reserved.
 * Copyright (c) 2004-2007
 *     Oracle. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: SingleResult.cpp,v 1.10 2007/11/28 13:13:37 jpcs Exp $
 */

#include "../config/xqilla_config.h"
#include <xqilla/runtime/SingleResult.hpp>

SingleResult::SingleResult(const LocationInfo *o)
  : ResultImpl(o),
    toDo_(true)
{
}

Item::Ptr SingleResult::next(DynamicContext *context)
{
  if(toDo_) {
    toDo_ = false;
    return getSingleResult(context);
  }
  else {
    return 0;
  }
}
