/*
 * Copyright (c) 2001-2007
 *     DecisionSoft Limited. All rights reserved.
 * Copyright (c) 2004-2007
 *     Oracle. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: FunctionReplace.hpp,v 1.10 2007/11/28 13:13:23 jpcs Exp $
 */

#ifndef _FUNCTIONREPLACE_HPP
#define _FUNCTIONREPLACE_HPP

#include <xqilla/ast/ConstantFoldingFunction.hpp>

/** 
 * Returns the string that is obtained by replacing all non-overlapping substrings of $input 
 * that match the given $pattern with an occurrence of the $replacement string.  
 *
 * xf:replace(string? $input, string $pattern, string $replacement) => string?
 * xf:replace(string? $input, string $pattern, string  $replacement, 
 *            string  $flags) => string?
 */
class XQILLA_API FunctionReplace : public ConstantFoldingFunction
{
public:
  static const XMLCh name[];
  static const unsigned int minArgs;
  static const unsigned int maxArgs;

  /**
   * Constructor.
   */
  FunctionReplace(const VectorOfASTNodes &args, XPath2MemoryManager* memMgr);
  
  /**
   * Returns $input with non-overlapping matches to $pattern 
   * replaced by $replacement
   */
  Sequence createSequence(DynamicContext* context, int flags=0) const;

};

#endif // _FUNCTIONREPLACE_HPP

