/*-
# X-BASED TRIANGLES
#
#  TrianglesP.h
#
###
#
#  Copyright (c) 1994 - 2008	David A. Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Triangles */

#ifndef _TrianglesP_h
#define _TrianglesP_h

#include "xwin.h"
#include "timer.h"
#include "Triangles.h"

#ifdef WINVER
extern void DestroyPuzzle(TrianglesWidget w, HBRUSH brush);
extern void ResizePuzzle(TrianglesWidget w);
extern void SizePuzzle(TrianglesWidget w);
extern void InitializePuzzle(TrianglesWidget w, HBRUSH brush);
extern void ExposePuzzle(TrianglesWidget w);
extern void HidePuzzle(TrianglesWidget w);
extern void SelectPuzzle(TrianglesWidget w, const int x, const int y);
extern void ReleasePuzzle(TrianglesWidget w);
extern void GetPuzzle(TrianglesWidget w);
extern void WritePuzzle(TrianglesWidget w);
extern void UndoPuzzle(TrianglesWidget w);
extern void RedoPuzzle(TrianglesWidget w);
extern void ClearPuzzle(TrianglesWidget w);
extern void RandomizePuzzle(TrianglesWidget w);
extern void SolvePuzzle(TrianglesWidget w);
extern void IncrementPuzzle(TrianglesWidget w);
extern void DecrementPuzzle(TrianglesWidget w);
extern void SpeedPuzzle(TrianglesWidget w);
extern void SlowPuzzle(TrianglesWidget w);
extern void SoundPuzzle(TrianglesWidget w);
extern void EnterPuzzle(TrianglesWidget w);
extern void LeavePuzzle(TrianglesWidget w);
extern int MovePuzzle(TrianglesWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _TrianglesClassPart {
	int ignore;
} TrianglesClassPart;

typedef struct _TrianglesClassRec {
	CoreClassPart coreClass;
	TrianglesClassPart trianglesClass;
} TrianglesClassRec;

extern TrianglesClassRec trianglesClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif

#define SYMBOL ':'

#define TR 0
#define RIGHT 1
#define BR 2
#define BL 3
#define LEFT 4
#define TL 5
#define COORD 6
#define TRBL 0
#define TLBR 1
#define ROW 2
#define ROW_TYPES 3
#define DOWN 0
#define UP 1
#define MAX_ORIENT 2
#define BLOCKED (-3)
#define SPACE (-2)
#define FG_SHADES 3
#define BG_SHADES 5
#define MAX_SLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _MoveRecord {
#if 0
	int direction;
#endif
	unsigned char packed;	/* This makes assumptions on the data. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _TrianglesStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} TrianglesStack;

typedef struct _TrianglesPart {
	int        *tileOfPosition, spacePosition[MAX_ORIENT];
	int         spaceRow[MAX_ORIENT][ROW_TYPES];
	int         currentPosition, currentRow[ROW_TYPES];
	int         currentPositionOrient;
	Boolean     started, cheat, sound, cw;
	Boolean     mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices;
	int         base;
	int         size, sizeSize;
	Point       offset, tileSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          textGC;
	GC          tileGC[FG_SHADES];
	GC          inverseGC[BG_SHADES];
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81];
	char	    picture[81];
#else
	int         menu, graphicsFormat, pixmapSize;
	char       *userName, *scoreFile, *bumpSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       tileColor, textColor;
	XtCallbackList select;
#endif
} TrianglesPart;

typedef struct _TrianglesRec {
	CorePart core;
	TrianglesPart triangles;
} TrianglesRec;

extern int *startPosition;
extern void setPuzzle(TrianglesWidget w, int reason);
extern int MovePuzzleDir(TrianglesWidget w, const int direction,
	const int fast);

#if 0
/* For future auto-solver */
extern void SolveSomeTiles(TrianglesWidget w);
#endif
extern void DrawAllTiles(const TrianglesWidget w);
extern Boolean CheckSolved(const TrianglesWidget w);
extern void newMoves(TrianglesStack *s);
extern void deleteMoves(TrianglesStack *s);
extern void setMove(TrianglesStack *s, int direction);
extern void getMove(TrianglesStack *s, int *direction);
extern int madeMoves(TrianglesStack *s);
extern void flushMoves(TrianglesWidget w, TrianglesStack *s, Boolean undo);
extern int numMoves(TrianglesStack *s);
extern void scanMoves(FILE *fp, TrianglesWidget w, int moves);
extern void printMoves(FILE *fp, TrianglesStack *s);
extern void scanStartPosition(FILE *fp, TrianglesWidget w);
extern void printStartPosition(FILE *fp, TrianglesWidget w);
extern void setStartPosition(TrianglesWidget w);
extern int Row(const int pos);
extern int TrBl(const int pos, const int posRow);
extern int TlBr(const int pos, const int posRow);

#endif /* _TrianglesP_h */
