.\" X-BASED RUBIK'S CUBE(tm)
.\"
.\" xrubik.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2007	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XRUBIK 6 "03 Apr 2007" "V7.3.1"
.SH NAME
xrubik \- Magic cube X widgets
.SH SYNOPSIS
.B /usr/games/xrubik
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-face{0|1|2|3|4|5} {color}] [-{border|bd} {color}]
[-delay msecs] [-[no]sound] [-moveSound {filename}]
[-{font|fn} {fontname}] [-view {int}] [-size{x|y|z} {int}]
[-[no]orient] [-[no]practice] [-userName {string}]
[-scoreFile {filename}] [-scores] [-version]
.SH DESCRIPTION
.LP
The original puzzle has 9 squares per face (size = 3).  The puzzle
was designed by Erno Rubik and called the Rubik's Cube.  This has
8!*12!*3^8*2^12/12 or 4.3 * 10^19 different combinations.
.sp
The Pocket Cube has 4 squares per face (size = 2) also designed by
Erno Rubik.  This has 7!*3^6 or 3,674,160 different combinations.
.sp
Rubik's Revenge has 16 squares per face (size = 4) also designed by
Erno Rubik.  This has 7!*3^6*24!*24!/(4!)^6 or 7.4 * 10^46 different
combinations.
.sp
5x5x5 Cube.  This has 8!*12!*3^7*2^10*(24!)^3/(4!)^12 or 2.83 * 10^74
different combinations.
.sp
There is also the Magic Domino 3x3x2 cube which has (8!)^2/4 or
406,425,600 combinations.
.sp
A physical 6x6x6 cube is possible but to my knowledge no one has been
too successful in building one.  7x7x7 is also possible, but here one
must make the center most cubes smaller than the outside cubes, so
the corners do not fall off when turned.
.SH FEATURES
.LP
Press "\fBmouse-left\fP" button to move a piece.  Release
"\fBmouse-left\fP" button on a piece on the same face and in the same row.
The pieces will then turn towards where the mouse button was released.
.LP
Click "\fBmouse-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
This is good for learning moves and experimenting.
.LP
Click "\fBmouse-right\fP", or press "\fBZ\fP" or "\fBz\fP" keys, to
randomize the puzzle (this must be done first to set a new record).
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save (write) a puzzle.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to redo a move.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear the puzzle.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to start auto-solver.  Only works
on 1x1x1, 2x2x2, and 3x3x3 cubes.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the faces in orient mode, besides getting all the faces to be the
same color.  To do this one has to get the lines to be oriented in the
same direction, this only matters with center piece, if at all (i.e.
those pieces not on a corner or edge).  This does add complexity so
there are 2 sets of records.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of pieces.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of pieces.
.LP
Press "\fBx\fP" key to increase the number of pieces along the x axis.
.LP
Press "\fBX\fP" key to decrease the number of pieces along the x axis.
.LP
Press "\fBy\fP" key to increase the number of pieces along the y axis.
.LP
Press "\fBY\fP" key to decrease the number of pieces along the y axis.
.LP
Press "\fBf\fP" key to increase the number of pieces along the z axis.
.LP
Press "\fBF\fP" key to decrease the number of pieces along the z axis.
.LP
Press "\fBV\fP" or "\fBv\fP" keys to change the view of the cube.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of pieces.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of pieces.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad or arrow keys to move without the mouse.
.br
Key pad is defined for the Rubik2d as:
.br
  /     Counterclockwise
.sp
  8     Up
.br
  ^
.br
4<5>6   Left, Clockwise, Right
.br
  v
.br
  2     Down
.sp
Key pad for Rubik3d, use must use your intuition (is this a cop out or
what?).  The key pad is defined differently depending on which side of the
cube your mouse is pointing at.  One thing that stays the same is "5" is
Clockwise and "/" is Counterclockwise.
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole cube.  This is not recorded as a turn.
.LP
The title is in the following format (non-motif version):
.RS
xrubik{2|3}d<dimension>: {1|2|3|4|5|6<cubes per edge on
x-axis>x{1|2|3|4|5|6<cubes per edge on y-axis>x{1|2|3|4|5|6<cubes per
edge on z-axis>} @ (<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"|"practice"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the rubik window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the rubik window on a color screen as
if it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the rubik window in reverse video
(resource name "\fIreverseVideo\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the rubik window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the rubik window (resource name
"\fIbackground\fP").
.TP 8
.B \-face{0|1|2|3|4|5} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. On the 2-D version, the faces are ordered top to bottom
and left to right on the "t" configuration. The sideways "t" or "+-"
configuration is physically consistent with the former, so it is ordered
"0, 1, 2, 3, 5, 4".  If you has two colors that begin with the same letter
you should have one in uppercase and one in lowercase to distinguish them in
mono-mode. You can change the colors of the faces to make a stupid cube (i.e.
all White or in mono-mode all "W"). Unfortunately, it will not normally say
its solved when its randomized. This would be cheating.
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the pieces in the rubik
window (resource name "\fIborderColor\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move pieces
(1-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if sliding pieces should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-moveSound \fIfilename\fP
This option specifies the file for the move sound (resource name
"\fImoveSound\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-view <\fIint\fP>
This option allows you to change the view of the cube for OpenGL with
choice of 4 views (resource name "\fIint\fP").
.TP 8
.B \-sizex <\fIint\fP>
This option allows you to change the number of pieces on a edge along
x-axis (resource name "\fIsizex\fP").
.TP 8
.B \-sizey <\fIint\fP>
This option allows you to change the number of pieces on a edge along
y-axis (resource name "\fIsizey\fP").
.TP 8
.B \-sizez <\fIint\fP>
This option allows you to change the number of pieces on a edge along
z-axis (resource name "\fIsizez\fP").
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xrubik you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get or an
auto-solve.
.SH SAVE FORMAT
Here is the format for the xrubik configuration, starting position, and
the movement of its pieces.  The format is not standard.  The reason is
that this is simple to produce and the standard notation is no good for
variable number of pieces.
.sp
Rubik2d with default colors, not randomized (front is face 2) :
.br
  0       R     Red
.br
1 2 3   Y W G   Yellow, White, Green
.br
  4       O     Orange
.br
  5       B     Blue
.sp
.RS
sizex: 1-6 <the number of cubes per row along x-axis>
.br
sizey: 1-6 <the number of cubes per row along y-axis>
.br
sizez: 1-6 <the number of cubes per row along z-axis>
.br
orient: 0-1 <0 false, 1 true; if 1 then lines on pieces to be oriented>
.br
practice: 0-1 <0 false, 1 true>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of face and piece position, each
face has size1 * size2 pieces, if orient mode then orientation number
follows face number: 0 up, 1 right, 2 down, and 3 left>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <face> <position> <direction> <control>
.RE
Each turn is with respect to a face and position.
.br
Position is 0 to size * size - 1.  Position 0 is in the upper left.
.br
Direction is represented as 0 up, 1 right, 2 down, 3 left, 5 clockwise, and
7 counterclockwise.
.br
Control is represented as 0 or 1, 1 if the whole cube is moved at once
(here position does not matter), 0 if not.  The xrubik record keeper does
not count a control move as a move, but here we do.
.sp
If you have a Rubik's Cube you can not solve (2x2x2 or 3x3x3) enter it in
rubik.log file.  Have size = 2 or 3, orient = 0, practice = 0,
randomized = 1, and moves = 0 and the number representation for the color
of the piece (usually 0=R, 1=Y, 2=W, 3=G, 4=O, 5=B).  Bring up
xrubik, hit 'g' so it will get your configuration and then 's' to solve
your cube and then 'w' to write out the steps.  Then examine your
rubik.log file.
.SH REFERENCES
Inside Rubik's Cube and Beyond by Christoph Bandelow, Birkhauser,
1982. pp 44, 45, 88, 89
.sp
Magic Cubes 1996 Catalog of Dr. Christoph Bandelow.
.sp
The Simple Solution To Rubik's Cube, James G. Nourse, June 1981
.sp
Rubik's Cube Newsletter by Ideal Aug 1982 Vol.1 No. 2
.sp
Rubik's Cube The Solution, Ideal Toy Corporation, 1981
.sp
Rubik's Revenge Puzzle The Solution, Ideal Toy Corporation, 1982
.SH SEE ALSO
.LP
X(1), xcubes(6), xtriangles(6), xhexagons(6), xmlink(6), xbarrel(6), xpanex(6),
xmball(6), xpyraminx(6), xoct(6), xskewb(6), xdino(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2007, David Albert Bagley
.LP
Michael B. Martin, <\fImartinm@sps1.phys.vt.edu\fP> wrote an independent
program cubist10.c-- for IBM PC.  I added the auto-solve code into xrubik,
with his permission.
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIhttp://www.tux.org/~bagleyd/puzzles.html\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
