/*-
# X-BASED MISSING LINK(tm)
#
#  Mlink.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Mlink */

#ifndef _XtMlink_h
#define _XtMlink_h

/***********************************************************************
 *
 * Mlink Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNfaceColor6 ((char *) "faceColor6")
#define XtNfaceColor7 ((char *) "faceColor7")
#define XtNtileBorder ((char *) "tileBorder")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNtiles ((char *) "tiles")
#define XtNfaces ((char *) "faces")
#define XtNorient ((char *) "orient")
#define XtNmiddle ((char *) "middle")
#define XtNpractice ((char *) "practice")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCTiles ((char *) "Tiles")
#define XtCFaces ((char *) "Faces")
#define XtCOrient ((char *) "Orient")
#define XtCMiddle ((char *) "Middle")
#define XtCPractice ((char *) "Practice")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")

typedef struct _MlinkClassRec *MlinkWidgetClass;

extern WidgetClass mlinkWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} mlinkCallbackStruct;
#endif

#define MLINK_HIDE (-9)
#define MLINK_PRACTICE_QUERY (-8)
#define MLINK_RANDOMIZE_QUERY (-7)
#define MLINK_SOLVE_MESSAGE (-6)
#define MLINK_RESTORE (-5)
#define MLINK_RESET (-4)
#define MLINK_BLOCKED (-3)
#define MLINK_SPACE (-2)
#define MLINK_IGNORE (-1)
#define MLINK_MOVED 0
#define MLINK_SOLVED 1
#define MLINK_CONTROL 2
#define MLINK_PRACTICE 3
#define MLINK_RANDOMIZE 4
#define MLINK_ORIENT 5
#define MLINK_MIDDLE 6
#define MLINK_DEC_X 7
#define MLINK_INC_X 8
#define MLINK_DEC_Y 9
#define MLINK_INC_Y 10
#define MLINK_COMPUTED 11
#define MLINK_UNDO 12
#define MLINK_SPEED 13

#define MINFACES 1
#define MAXFACES 8
#define MINTILES 1
#define DEFAULTTILES 4
#define DEFAULTFACES 4
#define DEFAULTORIENT FALSE
#define DEFAULTMIDDLE TRUE
#define DEFAULTPRACTICE FALSE
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

typedef struct _MlinkRec *MlinkWidget;

#endif /* _XtMlink_h */
/* DON'T ADD STUFF AFTER THIS #endif */
