/*

    xpuyopuyo - pnet.c        Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Network code
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <xpuyopuyo.h>
#if USE_NETWORK /* Allow network support? */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <psnprintf.h>
#include <pnetint.h>
#include <pwindow.h>
#include <pconfig.h>


#define P_NET_ERROR_LENGTH       0x100
static char net_error[P_NET_ERROR_LENGTH] = { '\0' };


void pnet_set_error(const char *function, const char *errormsg) {

   /* Display a debug error message */
   #ifdef P_NET_DEBUG_COMM
   printf("network error:  (%s)  %s\n", function, errormsg);
   #endif /* Debug communication? */

   /* Write the new error message to the internal error variable */
   p_snprintf(net_error, P_NET_ERROR_LENGTH, "(%s)  %s", function, errormsg);

}


const char *pnet_get_error(void) {

   /* Return a pointer to the internal error variable */
   return(net_error);

}


int pnet_get_hostname(char *buf, int size) {

   if(buf == NULL || size <= 0) return(0);
   if(gethostname(buf, size) == 0) {
      buf[size - 1] = '\0';
      return(1);
   } else {
      strncpy(buf, "localhost", size);
      buf[size - 1] = '\0';
      return(0);
   }

}


#endif /* Allow network? */
