.\" Id: pswrap.man,v 6.1 1994/05/18 23:21:11 asente Exp $
.na
.nh
.TH  PSWRAP  1 "4 Apr 1994" "Adobe Systems"
.SH NAME
pswrap \- creates C procedures from segments of PostScript language code

.SH SYNOPSIS
.B pswrap
[
.B \-apr
] [
.B \-o 
.I outputCfile
] [
.B \-h 
.I outputHfile
] [
.B \-s
.I maxstring
] 
.I inputfile

.SH DESCRIPTION 
.LP
.B pswrap
reads input from 
.I inputfile 
and creates C-callable procedures, known as wraps, that send PostScript 
language code to the PostScript interpreter. 
.I inputfile
contains segments of PostScript language code wrapped with a C-like
procedure syntax.
.LP
Wraps are the most efficient way for an application to communicate with the 
PostScript interpreter. For complete documentation of 
.B pswrap 
and the language it accepts, see "pswrap Reference Manual"
in \fIProgramming the Display PostScript System with X.\fR
.LP

.SH OPTIONS 
.LP
.TP
.I inputfile
A file that contains one or more wrap definitions. 
.B pswrap 
transforms the definitions in 
.I inputfile 
into C procedures. If no input file is specified, the standard 
input (which can be redirected from a file or pipe) is used. The input file 
can include text other than wrap definitions. 
.B pswrap 
converts wrap definitions to C procedures and passes the other text 
through unchanged. Therefore, it is possible to intersperse C-language 
source code with wrap definitions in the input file. 
.RS
.LP
.I Note:
Although C code is allowed in a pswrap input file, it is not allowed 
within a wrap body. In particular, no CPP macros (for example, #define) are 
allowed inside a wrap. 
.RE
.TP
.B \-a
Generates ANSI C procedure prototypes for procedure definitions in 
.I outputCfile 
and, optionally,
.I outputHfile. 
The 
.B \-a 
option allows compilers that recognize the 
ANSI C standard to do more complete type checking of parameters. The 
.B \-a 
option also causes 
.B pswrap 
to generate const declarations.
.RS
.LP
.I Note:
ANSI C procedure prototype syntax is not recognized by most non-ANSI C 
compilers, including many compilers based on the Portable C Compiler. Use the 
.B \-a 
option only in conjunction with a compiler that conforms to the ANSI C Standard.
.RE
.TP
.BI \-h " outputHFile"
Generates a header file that contains extern declarations for non-static 
wraps. This file can be used in #include statements in modules that use 
wraps. If the 
.B \-a 
option is specified, the declarations in the header file 
are ANSI C procedure prototypes. If the 
.B \-h 
option is omitted, a header file is not produced. 
.TP
.BI \-o " outputCFile"
Specifies the file to which the generated wraps and passed-through text are 
written. If omitted, the standard output is used. If the 
.B \-a 
option is also specified, the procedure definitions generated by 
.B pswrap 
are in ANSI C procedure prototype syntax. 
.TP
.B \-p
Specifies that strings passed by wraps are padded so that each data object 
begins on a long-word (4-byte) boundary. This option allows wraps to run on 
architectures that restrict data alignment to 4-byte boundaries and 
improves performance on some other architectures. 
.TP
.B \-r
Generates reentrant code for wraps shared by more than one process (as in 
shared libraries). Reentrant code can be called recursively or by more than 
one thread. The 
.B \-r 
option causes 
.B pswrap 
to generate extra code, so use it only when necessary. 
.TP
.BI \-s " maxstring"
Sets the maximum allowable length of a PostScript string object or 
hexadecimal string object in the wrap body input. A syntax error is reported if a 
string is not terminated with ) or > within 
.I maxstring 
characters. 
.I maxstring 
cannot be set lower than 80; the default is 200.

.SH SEE ALSO
\fIProgramming the Display PostScript System with X\fR
(Addison-Wesley Publishing Company, Inc., 1993).

.SH AUTHOR
Adobe Systems Incorporated

.SH NOTES
PostScript and Display PostScript are trademarks
of Adobe Systems Incorporated which may be registered
in certain jurisdictions.
.PP
Copyright (c) 1988-1994 Adobe Systems Incorporated.  All rights reserved.
