/* xpenguins_applet.h - gnome panel applet implementation of xpenguins
 * Copyright (C) 1999, 2000  Robin Hogan
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Structure that contains all data worth remembering */
typedef struct {
  /* Application widget, and its subwidgets */
  PanelApplet *applet;
/*  GConfClient *gconf_client;*/
  GtkWidget *penguin, *playpause, *stop;
  GtkWidget *penguin_pixmap, *playpause_pixmap, *stop_pixmap;
  GtkWidget *hbox, *vbox;
  /* Property box widgets */
  GtkWidget *prop_window;
  GtkAdjustment *number_adj, *speed_adj;
  GtkWidget *ignorepopups_check;
  GtkWidget *noblood_check, *noangels_check;
  GtkWidget *squish_check;
  GtkWidget *overridetheme_check;
  GtkWidget *table;
  GtkWidget *preview_pixmap, *preview, *info;
  GtkTreeView *treeview;
  gulong treeview_signal_id;
  /* Theme information */
  gchar **theme_list;
  gchar **theme_info;
  gchar *theme_name; /* slash-separated list of the active themes */
  gchar *focussed_theme_name; /* The single selected themes */
  gint nthemes;
  XPenguinsTheme theme;
  /* Properties */
  gint timeout, number, speed;
  gboolean noblood, noangels, overridetheme, ignorepopups;
  gboolean active, paused, loaded, squish;
} XPenguinsApplet;


/* applet_main.c */

/* Load theme and handle errors */
gboolean xpa_load_theme (XPenguinsApplet *);

/* Timeout callback to update toons */
gboolean xpa_service_xpenguins (gpointer);



/* applet_properties.c */

/* Shows the property dialog (called via context-menu)
 *
 * param: BonoboUIComponent * - bonobo component (unused)
 * param: XPenguinsApplet * - data structure of the applet
 * param: const gchar * - verb which called this function (unused)
 */
void xpa_property_show (BonoboUIComponent *, XPenguinsApplet *, const gchar *);



/* Loads the properties
 *
 * param: XPenguinsApplet * - data structure of the applet
 */
void xpa_property_load (XPenguinsApplet *);

