/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/socket4_user_xif.hh,v 1.19 2009/01/05 18:31:13 jtc Exp $
 */

#ifndef __XRL_INTERFACES_SOCKET4_USER_XIF_HH__
#define __XRL_INTERFACES_SOCKET4_USER_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifSocket4User"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlSocket4UserV0p1Client {
public:
    XrlSocket4UserV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlSocket4UserV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr RecvEventCB;
    /**
     *  Send Xrl intended to:
     *
     *  Method invoked by target implementing socket4/0.1 when a packet arrives
     *  from an IPv4 source.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the identifier associated with socket where the event
     *  occurred.
     *
     *  @param if_name the interface name the packet arrived on, if known. If
     *  unknown, then it is an empty string.
     *
     *  @param vif_name the vif name the packet arrived on, if known. If
     *  unknown, then it is an empty string.
     *
     *  @param src_host the originating host.
     *
     *  @param src_port the originating IP port.
     *
     *  @param data the data received.
     */
    bool send_recv_event(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const string&	if_name,
	const string&	vif_name,
	const IPv4&	src_host,
	const uint32_t&	src_port,
	const vector<uint8_t>&	data,
	const RecvEventCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr InboundConnectEventCB;
    /**
     *  Send Xrl intended to:
     *
     *  Method invoked by target implementing socket4/0.1 when a connection
     *  request is received from an IPv4 source. It applies only to TCP
     *  sockets.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the identifier associated with socket where the event
     *  occurred.
     *
     *  @param src_host the connecting host.
     *
     *  @param src_port the connecting IP port.
     *
     *  @param new_sockid the identifier associated with the new socket that
     *  has been created to handle the new connection.
     */
    bool send_inbound_connect_event(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const IPv4&	src_host,
	const uint32_t&	src_port,
	const string&	new_sockid,
	const InboundConnectEventCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr OutgoingConnectEventCB;
    /**
     *  Send Xrl intended to:
     *
     *  Method invoked by target implementing socket4/0.1 when an outgoing
     *  connection request originated by the local host is completed. It
     *  applies only to TCP sockets. Note that if the connection failed, the
     *  error_event will be dispatched instead.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the identifier associated with socket where the event
     *  occurred.
     */
    bool send_outgoing_connect_event(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const OutgoingConnectEventCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ErrorEventCB;
    /**
     *  Send Xrl intended to:
     *
     *  Method invoked by target implementing socket4/0.1 when an error occurs.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the identifier associated with socket where the event
     *  occurred.
     *
     *  @param error a textual description of the error.
     *
     *  @param fatal indication of whether socket is shutdown because of error.
     */
    bool send_error_event(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const string&	error,
	const bool&	fatal,
	const ErrorEventCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DisconnectEventCB;
    /**
     *  Send Xrl intended to:
     *
     *  Method invoked by target implementing socket4/0.1 when the peer has
     *  closed the connection. It applies only to TCP sockets. Note that the
     *  socket itself is left open and must be explicitly closed.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the identifier associated with socket where the event
     *  occurred.
     */
    bool send_disconnect_event(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const DisconnectEventCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_recv_event(
	const XrlError&	e,
	XrlArgs*	a,
	RecvEventCB		cb
    );

    void unmarshall_inbound_connect_event(
	const XrlError&	e,
	XrlArgs*	a,
	InboundConnectEventCB		cb
    );

    void unmarshall_outgoing_connect_event(
	const XrlError&	e,
	XrlArgs*	a,
	OutgoingConnectEventCB		cb
    );

    void unmarshall_error_event(
	const XrlError&	e,
	XrlArgs*	a,
	ErrorEventCB		cb
    );

    void unmarshall_disconnect_event(
	const XrlError&	e,
	XrlArgs*	a,
	DisconnectEventCB		cb
    );

};

#endif /* __XRL_INTERFACES_SOCKET4_USER_XIF_HH__ */
