/*
 * Copyright (c) 2001-2008 XORP, Inc.
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/socket4_xif.hh,v 1.23 2008/07/23 05:11:59 pavlin Exp $
 */

#ifndef __XRL_INTERFACES_SOCKET4_XIF_HH__
#define __XRL_INTERFACES_SOCKET4_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifSocket4"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlSocket4V0p1Client {
public:
    XrlSocket4V0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlSocket4V0p1Client() {}

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr TcpOpenCB;
    /**
     *  Send Xrl intended to:
     *
     *  Open a TCP socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     */
    bool send_tcp_open(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const TcpOpenCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr UdpOpenCB;
    /**
     *  Send Xrl intended to:
     *
     *  Open an UDP socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     */
    bool send_udp_open(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const UdpOpenCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr TcpOpenAndBindCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a bound TCP socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     *
     *  @param local_addr the interface address to bind socket to.
     *
     *  @param local_port the port to bind socket to.
     */
    bool send_tcp_open_and_bind(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const TcpOpenAndBindCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr UdpOpenAndBindCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a bound UDP socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     *
     *  @param local_addr the interface address to bind socket to.
     *
     *  @param local_port the port to bind socket to.
     */
    bool send_udp_open_and_bind(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const UdpOpenAndBindCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr UdpOpenBindJoinCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a bound UDP multicast socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     *
     *  @param local_addr the interface address to bind socket to.
     *
     *  @param local_port the port to bind socket to.
     *
     *  @param mcast_addr the multicast group address to join.
     *
     *  @param ttl the TTL to use for this multicast socket.
     *
     *  @param reuse allow other sockets to bind to same multicast group.
     */
    bool send_udp_open_bind_join(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const IPv4&	mcast_addr,
	const uint32_t&	ttl,
	const bool&	reuse,
	const UdpOpenBindJoinCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr TcpOpenBindConnectCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a bound and connected TCP socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     *
     *  @param local_addr the interface address to bind socket to.
     *
     *  @param local_port the port to bind socket to.
     *
     *  @param remote_addr the address to connect to.
     *
     *  @param remote_port the remote port to connect to.
     */
    bool send_tcp_open_bind_connect(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const IPv4&	remote_addr,
	const uint32_t&	remote_port,
	const TcpOpenBindConnectCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr UdpOpenBindConnectCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a bound and connected UDP socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     *
     *  @param local_addr the interface address to bind socket to.
     *
     *  @param local_port the port to bind socket to.
     *
     *  @param remote_addr the address to connect to.
     *
     *  @param remote_port the remote port to connect to.
     */
    bool send_udp_open_bind_connect(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const IPv4&	remote_addr,
	const uint32_t&	remote_port,
	const UdpOpenBindConnectCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr UdpOpenBindBroadcastCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a bound, and optionally connected, UDP broadcast socket. This
     *  socket may be used for sending and receiving IPv4 broadcasts on a named
     *  if/vif. The TTL is always set to 1 on creation. The creator must
     *  specify if this socket is to be used for limited broadcasts
     *  (255.255.255.255) as this is a special case on many platforms.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param creator the Xrl Target instance name of the socket creator. The
     *  named target must implement socket4_user/0.1.
     *
     *  @param ifname the interface name to bind socket to.
     *
     *  @param vifname the vif to bind socket to.
     *
     *  @param local_port the port to bind socket to.
     *
     *  @param remote_port the remote port to connect to.
     *
     *  @param reuse allow other sockets to bind to same port.
     *
     *  @param limited set the socket up for transmission to the limited
     *  broadcast address 255.255.255.255.
     *
     *  @param connected connect the socket for use with send() not sendto().
     */
    bool send_udp_open_bind_broadcast(
	const char*	dst_xrl_target_name,
	const string&	creator,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	local_port,
	const uint32_t&	remote_port,
	const bool&	reuse,
	const bool&	limited,
	const bool&	connected,
	const UdpOpenBindBroadcastCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr BindCB;
    /**
     *  Send Xrl intended to:
     *
     *  Bind a socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the socket ID of the socket to bind.
     *
     *  @param local_addr the interface address to bind socket to.
     *
     *  @param local_port the port to bind socket to.
     */
    bool send_bind(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const BindCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UdpJoinGroupCB;
    /**
     *  Send Xrl intended to:
     *
     *  Join multicast group on already bound socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID.
     *
     *  @param mcast_addr group to join.
     *
     *  @param join_if_addr interface address to perform join on.
     */
    bool send_udp_join_group(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const IPv4&	mcast_addr,
	const IPv4&	join_if_addr,
	const UdpJoinGroupCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UdpLeaveGroupCB;
    /**
     *  Send Xrl intended to:
     *
     *  Leave multicast group on already bound socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID.
     *
     *  @param mcast_addr group to leave.
     *
     *  @param leave_if_addr interface address to perform leave on.
     */
    bool send_udp_leave_group(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const IPv4&	mcast_addr,
	const IPv4&	leave_if_addr,
	const UdpLeaveGroupCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CloseCB;
    /**
     *  Send Xrl intended to:
     *
     *  Close socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID of socket to be closed.
     */
    bool send_close(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const CloseCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr TcpListenCB;
    /**
     *  Send Xrl intended to:
     *
     *  Listen for inbound connections on socket. When a connection request
     *  received the socket creator will receive notification through
     *  socket4_user/0.1/inbound_connect_event.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the unique socket ID of the socket to perform listen.
     *
     *  @param backlog the maximum number of pending connections.
     */
    bool send_tcp_listen(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const uint32_t&	backlog,
	const TcpListenCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UdpEnableRecvCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable a UDP socket for datagram reception. If a UDP socket has been
     *  created without using the usual convenience XRLs, it is necessary to
     *  hook up its FEA internal input path by calling this XRL. It is similar
     *  in intent to tcp_listen, but named differently as it never uses the
     *  listen() socket API.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid the unique socket ID of the socket to enable for datagram
     *  reception.
     */
    bool send_udp_enable_recv(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const UdpEnableRecvCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendCB;
    /**
     *  Send Xrl intended to:
     *
     *  Send data on socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID.
     *
     *  @param data block of data to be sent.
     */
    bool send_send(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const vector<uint8_t>&	data,
	const SendCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendToCB;
    /**
     *  Send Xrl intended to:
     *
     *  Send data on socket to a given destination. The packet is not routed as
     *  the forwarding engine sending the packet may not have access to the
     *  full routing table.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID.
     *
     *  @param remote_addr destination address for data.
     *
     *  @param remote_port destination port for data.
     *
     *  @param data block of data to be sent.
     */
    bool send_send_to(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const IPv4&	remote_addr,
	const uint32_t&	remote_port,
	const vector<uint8_t>&	data,
	const SendToCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendFromMulticastIfCB;
    /**
     *  Send Xrl intended to:
     *
     *  Send data on socket to a given multicast group from a given interface.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID.
     *
     *  @param group_addr destination address for data.
     *
     *  @param group_port destination port for data.
     *
     *  @param ifaddr interface address
     */
    bool send_send_from_multicast_if(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const IPv4&	group_addr,
	const uint32_t&	group_port,
	const IPv4&	ifaddr,
	const vector<uint8_t>&	data,
	const SendFromMulticastIfCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetSocketOptionCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set a named socket option with an integer value. XXX: The "onesbcast"
     *  and "reuseport" options exist to work around an architectural issue in
     *  the BSD IPv4 stack. They SHOULD NOT be used for new code.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID.
     *
     *  @param optname name of option to be set. Valid values are: "onesbcast"
     *  "receive_broadcast" "reuseport" "send_broadcast" "tos" "ttl"
     *  "multicast_loopback" "multicast_ttl"
     *
     *  @param optval integer value of option to be set. If value is logically
     *  boolean, then zero represents 'false', and any non-zero value
     *  represents 'true'.
     */
    bool send_set_socket_option(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const string&	optname,
	const uint32_t&	optval,
	const SetSocketOptionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetSocketOptionTxtCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set a named socket option with a string value. XXX: The "bindtodevice"
     *  option exists to workaround an architectural issue in the Linux IPv4
     *  stack. It SHOULD NOT be used for new code.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param sockid unique socket ID.
     *
     *  @param optname name of option to be set. Valid values are:
     *  "bindtodevice"
     *
     *  @param optval value of option to be set.
     */
    bool send_set_socket_option_txt(
	const char*	dst_xrl_target_name,
	const string&	sockid,
	const string&	optname,
	const string&	optval,
	const SetSocketOptionTxtCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_tcp_open(
	const XrlError&	e,
	XrlArgs*	a,
	TcpOpenCB		cb
    );

    void unmarshall_udp_open(
	const XrlError&	e,
	XrlArgs*	a,
	UdpOpenCB		cb
    );

    void unmarshall_tcp_open_and_bind(
	const XrlError&	e,
	XrlArgs*	a,
	TcpOpenAndBindCB		cb
    );

    void unmarshall_udp_open_and_bind(
	const XrlError&	e,
	XrlArgs*	a,
	UdpOpenAndBindCB		cb
    );

    void unmarshall_udp_open_bind_join(
	const XrlError&	e,
	XrlArgs*	a,
	UdpOpenBindJoinCB		cb
    );

    void unmarshall_tcp_open_bind_connect(
	const XrlError&	e,
	XrlArgs*	a,
	TcpOpenBindConnectCB		cb
    );

    void unmarshall_udp_open_bind_connect(
	const XrlError&	e,
	XrlArgs*	a,
	UdpOpenBindConnectCB		cb
    );

    void unmarshall_udp_open_bind_broadcast(
	const XrlError&	e,
	XrlArgs*	a,
	UdpOpenBindBroadcastCB		cb
    );

    void unmarshall_bind(
	const XrlError&	e,
	XrlArgs*	a,
	BindCB		cb
    );

    void unmarshall_udp_join_group(
	const XrlError&	e,
	XrlArgs*	a,
	UdpJoinGroupCB		cb
    );

    void unmarshall_udp_leave_group(
	const XrlError&	e,
	XrlArgs*	a,
	UdpLeaveGroupCB		cb
    );

    void unmarshall_close(
	const XrlError&	e,
	XrlArgs*	a,
	CloseCB		cb
    );

    void unmarshall_tcp_listen(
	const XrlError&	e,
	XrlArgs*	a,
	TcpListenCB		cb
    );

    void unmarshall_udp_enable_recv(
	const XrlError&	e,
	XrlArgs*	a,
	UdpEnableRecvCB		cb
    );

    void unmarshall_send(
	const XrlError&	e,
	XrlArgs*	a,
	SendCB		cb
    );

    void unmarshall_send_to(
	const XrlError&	e,
	XrlArgs*	a,
	SendToCB		cb
    );

    void unmarshall_send_from_multicast_if(
	const XrlError&	e,
	XrlArgs*	a,
	SendFromMulticastIfCB		cb
    );

    void unmarshall_set_socket_option(
	const XrlError&	e,
	XrlArgs*	a,
	SetSocketOptionCB		cb
    );

    void unmarshall_set_socket_option_txt(
	const XrlError&	e,
	XrlArgs*	a,
	SetSocketOptionTxtCB		cb
    );

};

#endif /* __XRL_INTERFACES_SOCKET4_XIF_HH__ */
