// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef XMULEDLG_H
#define XMULEDLG_H

#include "types.h"                          // Needed for uint32

class CTransferWnd;
class CServerWnd;
class CPreferencesDlg;
class CSharedFilesWnd;
class CSearchDlg;
class CChatWnd;
class CFlowChart;
class CStatisticsDlg;
class CSysTray;

class wxMenu;
class wxSocketEvent;
class wxTimerEvent;

#include <wx/imaglist.h>

enum APPState {APP_STATE_RUNNING=0,
               APP_STATE_SHUTINGDOWN,
               APP_STATE_DONE,
               APP_STATE_STARTING
};

#define MP_RESTORE              4001
#define MP_CONNECT              4002
#define MP_DISCONNECT   4003
#define MP_EXIT                 4004

#include <wx/button.h>
#include <wx/frame.h>
#include <wx/toolbar.h>

class CKnownFileList;
// CxmuleDlg Dialogfeld
class CxmuleDlg :public wxFrame //CTrayDialog
{
// Konstruktion
public:
        CxmuleDlg(wxWindow* pParent=NULL, wxString title=wxT(""));      // Standardkonstruktor
        ~CxmuleDlg();

//      void                    AddLogLine(bool addtostatusbar,char* line,...);
        void                    AddLogLine(bool addtostatusbar,const wxChar* line,...);
        void                    AddServerMessageLine(char* line,...);
        void                    ShowConnectionState(bool connected);
        void                    ShowConnectionState(bool connected,wxString server,bool iconOnly=false);
        void                    ShowNotifier(wxString Text, int MsgType, bool ForceSoundOFF = false);
        void                    ShowUserCount(uint32 toshow,uint32 filetoshow);
        void                    ShowMessageState(uint8 iconnr);
        void                    SetActiveDialog(wxWindow* dlg);
        void                    ShowTransferRate(bool forceAll=true);
        void                    ShowStatistics();
        void                    Localize();
        void                    ResetLog();
        void                    ResetDebugLog();
        void                    StopTimer();
        // Barry - To find out if app is running or shutting/shut down
        bool                    IsRunning();
        void                    DoVersioncheck(bool manual);
        // has to be done in own method
        void createSystray(const wxString& title);
        void changeDesktopMode();

        CTransferWnd *transferwnd;
        CServerWnd *serverwnd;
        CPreferencesDlg *preferenceswnd;
        CSharedFilesWnd *sharedfileswnd;
        CSearchDlg *searchwnd;
        CFlowChart *flowchartwnd;
        CChatWnd *chatwnd;
        wxWindow *activewnd;
        CStatisticsDlg *statisticswnd;
        CSysTray *m_wndTaskbarNotifier;
        volatile APPState               m_app_state;    // added volatile to get some more security when accessing this as a shared object...
        uint8                   status;
        uint16                  lastbutton;

        DECLARE_EVENT_TABLE()

protected:
        void socketHandler(wxSocketEvent& event);
        void OnUQTimer(wxTimerEvent& evt);
        void OnUDPTimer(wxTimerEvent& evt);
        void OnSocketTimer(wxTimerEvent& evt);
        void OnQLTimer(wxTimerEvent& evt);

        void OnToolClick(wxCommandEvent& event);
        void btnPreferences(wxCommandEvent & ev);

 public:
        void OnFinishedHashing(wxCommandEvent& evt);
        void OnHashingShutdown(wxCommandEvent& evt);
        void OnDnsDone(wxCommandEvent& evt);

        void InitDialog();
        void OnBnConnect(wxCommandEvent& event);
        void OnClose(wxCloseEvent& evt);

        /* Public function to check which tab is active. Needed to check what to redraw. */
        int GetActiveDialog()   {return m_nActiveDialog;}
private:
    void ShutDown();
        void MinimizeDlg(wxIconizeEvent& event);
        wxString                        logtext;
        bool                    ready;
        wxBitmap transicons[4];

        uint32                  lastuprate;
        uint32                  lastdownrate;
        wxImageList             imagelist;
        wxMenu          *trayPopup;

        wxButton        m_btnConnect;
        wxButton        m_btnDownloads;
        wxButton        m_btnServers;
        wxButton        m_btnSearch;
        wxButton        m_btnFiles;
        wxButton        m_btnPreferences;
        wxButton        m_btnMessages;
        wxButton        m_btnStatistics;
        wxButton        m_btnIrc;
        wxToolBar*      m_wndToolbar;

        void StartConnection();
        void CloseConnection();
        void RestoreWindow();
        void UpdateTrayIcon(int procent);

        int m_nActiveDialog;
public:
    int split_pos;
};


#endif
