// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef XMULE_H
#define XMULE_H

#include "types.h"                          // Needed for uint64
#include "wintypes.h"                       // Needed for DWORD

#include <wx/app.h>                         // Needed for wxApp
#include <wx/intl.h>                        // Needed for wxLocale
#include <wx/settings.h>                    // Needed for wxSystemColour

class CAbstractFile;
class CClientCreditsList;
class CClientList;
class CClientUDPSocket;
class CDownloadQueue;
class CFriendList;
class CIPFilter;
class CKnownFileList;
class CLDaemon;
class CListenSocket;
class CPreferences;
class CServerConnect;
class CServerList;
class CSharedFileList;
class CUploadQueue;
class CxmuleDlg;

class DynamicPreferences;

#define theApp (*((CxmuleApp*)wxTheApp))
#define G_BLEND(a,b) ( ((int)a*b)/100>255?255:((int)a*b)/100 )

class CxmuleApp: public wxApp
{
public:
    CxmuleApp();
    virtual ~CxmuleApp();
    int OnExit();
    void OnFatalException();
    CxmuleDlg *xmuledlg;
    CClientList *clientlist;
    CKnownFileList *knownfiles;
    CPreferences *glob_prefs;
    DynamicPreferences* dynprefs;
    CServerConnect *serverconnect;
    CServerList *serverlist;
    CSharedFileList *sharedfiles;
    CListenSocket *listensocket;
    CUploadQueue *uploadqueue;
    CDownloadQueue *downloadqueue;
    CClientCreditsList *clientcredits;
    CFriendList *friendlist;
//    CWebServer *webserver;
    //virtual BOOL		InitInstance();
    virtual bool OnInit();
    wxString *pendinglink;
    //tagCOPYDATASTRUCT  sendstruct; //added by Cax2 28/10/02
    CIPFilter *ipfilter;
    uint64 stat_sessionReceivedBytes;
    uint64 stat_sessionSentBytes;
    uint16 stat_reconnects;
    DWORD stat_transferStarttime;
    DWORD stat_serverConnectTime;
    uint16 stat_filteredclients;
    DWORD Start_time;
    bool daemon, nowindow;
    CLDaemon* lda;
    // Implementierung
    // ed2k link functions
    wxString StripInvalidFilenameChars(wxString strText, bool bKeepSpaces = true);
    wxString CreateED2kLink(CAbstractFile *f);
    wxString CreateHTMLED2kLink(CAbstractFile *f);
    wxString CreateED2kSourceLink(CAbstractFile *f);
    bool CopyTextToClipboard(wxString strText);
    void OnlineSig(bool zero = false);
    void UpdateReceivedBytes(int32 bytesToAdd);
    void UpdateSentBytes(int32 bytesToAdd);
    void ProcessCommand ();
    void RefreshFiles ();
    
    //DECLARE_MESSAGE_MAP()

protected:
    bool ProcessCommandline();
    void SetTimeOnTransfer();
    wxLocale m_locale;

public:
    void LoadCompatiblePrefs();
    void SetCompatiblePrefs();
};

// helper
wxColour GetColour(wxSystemColour what);

#endif
