// This file is a part of the xMule Project.
// color.h - color related stuff.
//
// Copyright (c) 2004, by
//
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//
#ifndef COLOR_H
#define COLOR_H

#include <wx/defs.h>              // Needed for wxWidgets
#include <wx/settings.h>          // Needed for wxSystemColour

#if defined(__WXMSW__)
#include <windows.h>
#else
#ifndef __WXPM__                  // Otherwise already defined in wx/defs.h.
typedef wxUint32 COLORREF;
#endif

inline COLORREF RGB(int a, int b, int c)
{
    COLORREF result;
    result = (a & 0xff) << 16;
    result |= (b & 0xff) << 8;
    result |= (c & 0xff);
    return result;
}

inline int GetRValue(COLORREF rgb) { return (rgb >> 16) & 0xff; }
inline int GetGValue(COLORREF rgb) { return (rgb >> 8) & 0xff; }
inline int GetBValue(COLORREF rgb) { return rgb & 0xff; }

#endif // 

inline int G_BLEND(int a, int percentage)
{
    int result = a * percentage / 100;
    return (result > 255) ? 255 : result;
}

wxColour GetColour(wxSystemColour what);

#define SYSCOLOR(x) (wxSystemSettings::GetColour(x))

#endif // COLOR_H
