// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PARTFILE_H
#define PARTFILE_H

#include "wintypes.h"
#include "KnownFile.h"
#include "types.h"
#include "NewFunctions.h"
#include "opcodes.h"
#include "BarShader.h"
#include "ED2KLink.h"
#include "wx/dc.h"
#include "wx/dcmemory.h"
#include "wx/treectrl.h"
#include "otherfunctions.h"

#define	PS_READY			0
#define	PS_EMPTY			1
#define PS_WAITINGFORHASH	2
#define PS_HASHING			3
#define PS_ERROR			4
#define	PS_UNKNOWN			6
#define PS_PAUSED			7
#define PS_COMPLETING		8
#define PS_COMPLETE			9

#define PR_VERYLOW			4 // I Had to change this because it didn't save negative number correctly.. Had to modify the sort function for this change..
#define PR_LOW				0 //*
#define PR_NORMAL			1 // Don't change this - needed for edonkey clients and server!
#define	PR_HIGH				2 //*
#define PR_VERYHIGH			3
#define PR_AUTO				5
#define SRV_PR_LOW			2
#define SRV_PR_NORMAL		0
#define SRV_PR_HIGH			1

//#define BUFFER_SIZE_LIMIT	500000 // Max bytes before forcing a flush
#define BUFFER_TIME_LIMIT	5000   // Max milliseconds before forcing a flush

class CSearchFile;
class CUpDownClient;

struct PartFileBufferedData
{
	BYTE *data;						// Barry - This is the data to be written
	uint32 start;					// Barry - This is the start offset of the data
	uint32 end;						// Barry - This is the end offset of the data
	Requested_Block_Struct *block;	// Barry - This is the requested block that this data relates to
};

class CPartFile : public CKnownFile {
public:
	CPartFile();
	CPartFile(CSearchFile* searchresult);  //used when downloading a new file
	CPartFile(CString edonkeylink);
	CPartFile(class CED2KFileLink* fileLink);
	void InitializeFromLink(CED2KFileLink* fileLink);
	virtual ~CPartFile();
	
	bool	CreateFromFile(char* directory,char* filename)	{return false;}// not supported in this class
	bool	LoadFromFile(FILE* file)						{return false;}
	bool	WriteToFile(FILE* file)							{return false;}
	bool	IsPartFile()									{return !(status == PS_COMPLETE);}
	uint32	Process(uint32 reducedownload);
	bool	LoadPartFile(char* in_directory, char* filename); //filename = *.part.met
	bool	SavePartFile(bool Initial=false);
	void	PartFileHashFinished(CKnownFile* result);

	void	DrawStatusBar(wxMemoryDC* dc, wxRect rect, bool bFlat);
	void	DrawShareStatusBar(wxMemoryDC* dc, wxRect rect, bool onlygreyrect, bool bFlat);
	bool	IsComplete(uint32 start, uint32 end);
        
	bool	GetNextRequestedBlock(CUpDownClient* sender,Requested_Block_Struct** newblocks,uint16* count);
	void	WritePartStatus(CMemFile* file);
	void	AddSources(CMemFile* sources,uint32 serverip, uint16 serverport);
	void	NewSrcPartsInfo();
	char*	GetPartMetFileName()							{return partmetfilename;}
	uint32	GetTransfered()									{return transfered;}
	char*	GetFullName()									{return fullname;}
	uint16	GetSourceCount();
	uint16	GetTransferingSrcCount()						{return transferingsrc;}
	uint32	GetDatarate()									{return datarate;}
	float	GetPercentCompleted()							{return percentcompleted;}
	uint16  GetNotCurrentSourcesCount();
	int		GetValidSourcesCount();
	bool	IsMovie();
	bool	IsSound();
	bool	IsArchive(); 
	bool	IsCDImage(); 
	bool 	IsImage();
	bool 	IsText();
	
	
	CString CPartFile::getPartfileStatus(); //<<--9/21/02
	sint32	CPartFile::getTimeRemaining(); //<<--9/21/02
	time_t	lastseencomplete;
	int		getPartfileStatusRang();
        CString GetDownloadFileInfo();

	// Barry - Added as replacement for BlockReceived to buffer data before writing to disk
	uint32	WriteToBuffer(uint32 transize, BYTE *data, uint32 start, uint32 end, Requested_Block_Struct *block);
	void	FlushBuffer(void);

	// Barry - Is archive recovery in progress
	volatile bool m_bRecoveringArchive;

	// Barry - Added to prevent list containing deleted blocks on shutdown
	void	RemoveAllRequestedBlocks(void);

	void	RemoveBlockFromList(uint32 start,uint32 end);
	void	DeleteFile();
	void	StopFile();
	void	PauseFile();
	void	ResumeFile();

	virtual	Packet* CreateSrcInfoPacket(CUpDownClient* forClient);
	void	AddClientSources(CMemFile* sources,uint8 sourceexchangeversion);

	void	PreviewFile();
	bool	PreviewAvailable();
	uint8   GetAvailablePartCount()			{return availablePartsCount;}
	void	UpdateAvailablePartsCount();

	uint32	GetLastAnsweredTime()			{ return m_ClientSrcAnswered; }
	void	SetLastAnsweredTime()			{ m_ClientSrcAnswered = ::GetTickCount(); }
	void	SetLastAnsweredTimeTimeout()		{ m_ClientSrcAnswered = 2 * CONNECTION_LATENCY +
											                        ::GetTickCount() - SOURCECLIENTREASK; }
	uint64	GetLostDueToCorruption()		{return m_iLostDueToCorruption;}
	uint64	GetGainDueToCompression()		{return m_iGainDueToCompression;}
	uint32	TotalPacketsSavedDueToICH()		{return m_iTotalPacketsSavedDueToICH;}
	bool	IsStopped() 				{return stopped;}
	bool	HasComment()				{return hasComment;}
	bool	HasRating()				{return hasRating;}
	bool	HasBadRating();
	void	SetHasComment(bool in)			{hasComment=in;}
	void	SetHasRating(bool in)			{hasRating=in;}
	void	UpdateFileRatingCommentAvail();

        wxString GetProgressString(uint16 size);

	int		GetCommonFilePenalty();
	time_t	GetLastChangeDatetime(bool forcecheck=false);
	uint8	GetCategory();
	void	SetCategory(uint8 cat)			{m_category=cat;SavePartFile();}

	CFile	m_hpartfile;	//permanent opened handle to avoid write conflicts
	volatile bool m_bPreviewing;
	void	SetDownPriority(uint8 newDownPriority);
	bool	IsAutoDownPriority()	{ return m_bAutoDownPriority; }
	void	SetAutoDownPriority(bool flag) { m_bAutoDownPriority = flag; }
	uint8	GetDownPriority()	{ return m_iDownPriority; }
        // Acess to Flag for SourceSharing
        bool    GetDisableXS()          { return m_DisableXS; }
        void    SetDisableXS(bool in)   { m_DisableXS = in; }
protected:
	void	Init();
	wxMutex 	m_FileCompleteMutex;  // Lord KiRon - Mutex for file completion
private:
    int valid_sources;
    int sources_iterations;

	bool	IsCorruptedPart(uint16 partnumber);
	bool	HashSinglePart(uint16 partnumber); // true = ok , false = corrupted	
	void	RemoveAllSources(bool bTryToSwap);
	BOOL 	PerformFileComplete(); // Lord KiRon
	static UINT CompleteThreadProc(CPartFile* pFile); // Lord KiRon - Used as separate thread to complete file
	void	CompleteFile(bool hashingdone);
	void	UpdateCompletedInfos();
	void	AddGap(uint32 start, uint32 end);
	void	FillGap(uint32 start, uint32 end);
	bool	GetNextEmptyBlockInPart(uint16 partnumber,Requested_Block_Struct* result);
	bool	IsAlreadyRequested(uint32 start, uint32 end);
	bool	IsPureGap(uint32 start, uint32 end);
	void	CreatePartFile();

    uint16	count;
	uint16	transferingsrc;
	uint32  completedsize;
	uint64	m_iLostDueToCorruption;
	uint64	m_iGainDueToCompression;
	uint32  m_iTotalPacketsSavedDueToICH;
	uint32	datarate;
	char*	fullname;
	char*	partmetfilename;
	uint32	transfered;
	bool	paused;
	bool	stopped;
        bool    m_DisableXS;                  // Flag for SourceSharing
	uint8	m_iDownPriority;
	bool	m_bAutoDownPriority;
	uint8	status;
	bool	newdate;	             // indicates if there was a writeaccess to the .part file
	uint32	lastsearchtime;
	uint32	lastpurgetime;
	uint32	m_LastNoNeededCheck;
	CTypedPtrList<CPtrList, Gap_Struct*> gaplist;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> requestedblocks_list;
	CArray<uint16,uint16> m_SrcpartFrequency;
	float	percentcompleted;
	CList<uint16,uint16>	corrupted_list;
	uint8	availablePartsCount;
	uint32	m_ClientSrcAnswered;
	uint32	m_nSavedReduceDownload;
	bool	m_bPercentUpdated;
	static	CBarShader s_LoadBar; 
	static	CBarShader s_ChunkBar; 
	bool	hasRating;
	bool	hasComment;

    unsigned long	m_lastRefreshedDLDisplay;
	unsigned long   m_lastdatetimecheck;
	time_t	m_lastdatecheckvalue;

	// Barry - Buffered data to be written
	CTypedPtrList<CPtrList, PartFileBufferedData*> m_BufferedData_list;
	uint32 m_nTotalBufferData;
	uint32 m_nLastBufferFlushTime;
	uint8	m_category;
	
	unsigned long	m_LastSourceDropTime;

public:
	CTypedPtrList<CPtrList, CUpDownClient*> srclist;
	bool	srcarevisible;		// used for downloadlistctrl
	bool	m_bShowOnlyDownloading;	// used for downloadlistctrl
	bool	hashsetneeded;
	uint16	GetMaxSourcesPerFile() { return m_MaxSourcesPerFile; }
	void	SetMaxSourcesPerFile(uint16 in) { m_MaxSourcesPerFile=in; }
	uint32  GetCompletedSize()   {return completedsize;}
	uint8	GetStatus(bool ignorepause = false);
	
	   /* Razor 1a - Modif by MikaelB */

          /* RemoveNoNeededSources function */
          void	RemoveNoNeededSources();

          /* RemoveFullQueueSources function */
          void	RemoveFullQueueSources();

          /* RemoveHighQueueRatingSources function */
          void	RemoveHighQueueRatingSources();

          /* CleanUpSources function */
          void	CleanUpSources();

          /* AddDownloadingSource function */
          void AddDownloadingSource(CUpDownClient* client);
          
          /* RemoveDownloadingSource function */
          void RemoveDownloadingSource(CUpDownClient* client);

          /* A4AF sources list */
          CTypedPtrList<CPtrList, CUpDownClient*> A4AFSourcesList;

          /* SetA4AFAuto function */
          void SetA4AFAuto(bool A4AFauto)
          {
            this->m_IsA4AFAuto = A4AFauto;
          }

          /* IsA4AFAuto function */
          bool IsA4AFAuto()
          {
            return this->m_IsA4AFAuto;
          }

      private:
	  MAP * listof_downloadingSources;


          /* A4AF Auto attribute */
          bool m_IsA4AFAuto;
	  uint16 	m_MaxSourcesPerFile;

/* End modif */
 
};


#endif
