// This file is a part of the xmule project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "MuleNotebook.h"                   // Needed for this Interface's Prototype

IMPLEMENT_DYNAMIC_CLASS(CMuleNotebook, wxNotebook)

BEGIN_EVENT_TABLE(CMuleNotebook, wxNotebook)
    EVT_RIGHT_DOWN(CMuleNotebook::OnRightClick)
END_EVENT_TABLE()

CMuleNotebook::CMuleNotebook(): wxNotebook()
{

}

CMuleNotebook::CMuleNotebook(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style, const wxString& name)
    : wxNotebook(parent, id, pos, size, style, name)
{

}

void CMuleNotebook::OnRightClick(wxMouseEvent& WXUNUSED(event))
{
    wxMouseEvent evt(wxEVT_RIGHT_DOWN);
    if (this->GetMouseListener())
    {
        evt.SetEventObject(this);
        this->GetMouseListener()->AddPendingEvent(evt);
    }
}
