// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "MuleListCtrl.h"                   // Needed for this Interface's Prototype
#include "opcodes.h"                        // Needed for MP_LISTCOL_1
#include "Preferences.h"                    // Needed for CPreferences::SetColumnWidth
#include "xmule.h"                          // Needed for theApp

#include <wx/menu.h>                        // Needed for wxMenu

#define MLC_MENU 650

//////////////////////////////////
// CMuleListCtrl

#include <wx/window.h>

//IMPLEMENT_DYNAMIC(CMuleListCtrl, wxODListCtrl)
IMPLEMENT_DYNAMIC_CLASS(CMuleListCtrl, wxODListCtrl)
CMuleListCtrl::CMuleListCtrl()
{
    m_bCustomDraw = false;
    m_iCurrentSortItem = - 1;
    m_iColumnsTracked = 0;
    m_aColumns = NULL;
#if defined(__WXGTK__)
    m_col_minsize = 10;
#elif defined(__WXMSW__)
    m_col_minsize = 0;
#else
#error Need to set col_minsize for ur OS
#endif
}

CMuleListCtrl::CMuleListCtrl(wxWindow *&parent, int id, const wxPoint &pos, wxSize siz, int flags)
: wxODListCtrl(parent, id, pos, siz, flags)
{
    m_bCustomDraw = false;
    m_iCurrentSortItem = - 1;
    m_iColumnsTracked = 0;
    m_aColumns = NULL;
#if defined(__WXGTK__)
    m_col_minsize = 10;
#elif defined(__WXMSW__)
    m_col_minsize = 0;
#else
#error Need to set col_minsize for ur OS
#endif
}

CMuleListCtrl::~CMuleListCtrl()
{
    if (m_aColumns != NULL)
    delete[] m_aColumns;
}

void CMuleListCtrl::SetNamxMule(LPCTSTR lpszName)
{
    m_Name = lpszName;
}

//new fix for old problem... normally Update(int) causes entire list to redraw
BOOL CMuleListCtrl::Update(int iItem)
{
}

void CMuleListCtrl::PreSubclassWindow()
{
}

void CMuleListCtrl::HideColumn(int iColumn)
{
}

void CMuleListCtrl::ShowColumn(int iColumn)
{
}

void CMuleListCtrl::SaveSettings(const short int tID)
{
    int colTrack = GetColumnCount();
    INT *piArray = new INT[colTrack];
    for (int i = 0 ; i < colTrack ; i++)
    {
        wxListItem mycol;
        GetColumn(i, mycol);
        //	  wxMessageBox(wxString::Format("%s - %i",mycol.GetText().c_str(), mycol.GetWidth()	));
        theApp.glob_prefs->SetColumnWidth(tID, i, mycol.GetWidth());
        //theApp.glob_prefs->SetColumnHidden(tID, i, IsColumnHidden(i));
        //piArray[i] = m_aColumns[i].iLocation;
    }
    //theApp.glob_prefs->SetColumnOrder(tID, piArray);
    delete[] piArray;
}

void CMuleListCtrl::LoadSettings(const short int tID)
{
    //CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
    int colTrack = GetColumnCount();
    INT *piArray = new INT[colTrack];
    for (int i = 0 ; i < colTrack ; i++)
    {
        int iWidth = theApp.glob_prefs->GetColumnWidth(tID, i);
        if (iWidth != DEFAULT_COL_SIZE)
        {
            SetColumnWidth(i, iWidth);
            //wxListItem mycol;
            //mycol.SetWidth(iWidth);
            //SetColumn(i,mycol);
        }
        if (i == 0)
        {
            piArray[0] = 0;
        }
        else
        {
            int iOrder = theApp.glob_prefs->GetColumnOrder(tID, i);
            if (iOrder == 0)
            piArray[i] = i;
            else
            piArray[i] = iOrder;
        }
        //m_aColumns[i].iLocation = piArray[i];
    }
    //pHeaderCtrl->SetOrderArray(m_iColumnsTracked, piArray);
    delete[] piArray;
}

void CMuleListCtrl::SetColors()
{
}

void CMuleListCtrl::SetSortArrow(int iColumn, ArrowType atType)
{
    // integrated in listctrl..
    switch (atType)
    {
    case 263:
        wxODListCtrl::SetSortArrow(iColumn, (int) 1);
        break;
    default:
        wxODListCtrl::SetSortArrow(iColumn, (int) 2);
        break;
    }
}

bool CMuleListCtrl::ProcessEvent(wxEvent& evt)
{
    if ((evt.GetEventType() == wxEVT_COMMAND_MENU_SELECTED) && (evt.GetId() >= MP_LISTCOL_1) && (evt.GetId() <= MP_LISTCOL_15))
    {
        int col = evt.GetId() - MP_LISTCOL_1;

        if (wxODListCtrl::GetColumnWidth(col) > m_col_minsize)
        {
            SetColumnWidth(col, 0);
        }
        else
        {
            SetColumnWidth(col, wxLIST_AUTOSIZE);
        }
    }

    return wxODListCtrl::ProcessEvent(evt);
}

void CMuleListCtrl::OnColumnRclick(wxListEvent &evt)
{
    m_ColumnMenu = new wxMenu();
    wxListItem item;
    for (int a = 0 ; a < GetColumnCount() ; a++)
    {
        GetColumn(a, item);
        m_ColumnMenu->AppendCheckItem(a + MP_LISTCOL_1, item.GetText());
        m_ColumnMenu->Check(a + MP_LISTCOL_1, wxODListCtrl::GetColumnWidth(a) > m_col_minsize ? true: false);
    }
    PopupMenu(m_ColumnMenu, evt.GetPoint());
}

BEGIN_EVENT_TABLE(CMuleListCtrl, wxODListCtrl)
    EVT_LIST_COL_RIGHT_CLICK( - 1, CMuleListCtrl::OnColumnRclick)
END_EVENT_TABLE()

