// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// This file was a part of eMule
// Copyright (c) 2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#include "xmule-headers.h"
#endif

#include <wx/choice.h>            // Needed for wxChoice
#include <wx/filedlg.h>           // Needed for wxFileDialog
#include <wx/msgdlg.h>            // Needed for wxMessageDialog
#include <wx/sizer.h>             // Needed for wxSizer
#include <wx/statbox.h>           // Needed for wxStaticBox
#include <wx/stattext.h>          // Needed for wxStaticText
#include "wx/xrc/xmlres.h"        // Needed for XRCID

#include "FlowChart.h"            // Interface declarations.
#include "xmuleDlg.h"             // Needed for CxmuleDlg
#include "ED2KLink.h"             // Needed for CED2KLink
#include "UploadQueue.h"          // Needed for CUploadQueue
#include "SearchList.h"           // Needed for CSearchList
#include "DownloadQueue.h"        // Needed for CDownloadQueue
#include "otherfunctions.h"       // Needed for URLEncode
#include "packets.h"              // Needed for Packet
#include "server.h"               // Needed for CServer
#include "ServerList.h"           // Needed for CServerList
#include "sockets.h"              // Needed for CServerConnect
#include "muuli_wdr.h"            // Needed for IDC_STARTS

#define ID_SEARCHTIMER 55219

IMPLEMENT_DYNAMIC_CLASS(CFlowChart, wxPanel)

    CFlowChart:: CFlowChart(wxWindow *pParent) /*=NULL*/

: wxPanel(pParent, CFlowChart:: IDD),
m_timer(this, ID_SEARCHTIMER)
{
    wxBoxSizer *root = new wxBoxSizer(wxVERTICAL);
    this -> SetAutoLayout(TRUE);
    this -> SetSizer(root);
    root -> Fit(this);
    root -> SetSizeHints(this);
    root -> Show(this, TRUE);
}

CFlowChart:: ~CFlowChart()
{
}

