/************
 Copyright: A Mennucci Jan 2004
***********/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h>


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>   

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <plyload.h>

#include <gmodule.h>


GdkEventConfigure drawingarea_configure;

#include "libply.h"

#include "gl_widget.h"

PlySurface loadedPS ;

int flat_3d_visual=0;

gboolean
on_drawingarea_expose_event            (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  GdkGC*  gc= gdk_gc_new(widget->window);

  /* the gtk+ manual (see "drawing area" section)   says we have to:*/
  gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			     &event->area);

  gdk_gc_copy  (gc,//GdkGC *dst_gc,
		widget->style->fg_gc[widget->state]);//GdkGC *src_gc);

  if(flat_3d_visual)
    render_ply_gl(&loadedPS,widget);
  else
    render_ply_flat(&loadedPS,widget->window,gc,
		    drawingarea_configure.width/2,
		    drawingarea_configure.height/2);
  /* after that, we  */
  gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			    NULL);

  return FALSE;
}


gboolean
on_drawingarea_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  extern float ply_angle_tilt,ply_angle_pan;
  ply_angle_pan+=(event->x- drawingarea_configure.width/2)/20.;
  ply_angle_tilt+=(event->y-drawingarea_configure.height/2)/20.;
  gtk_widget_draw(widget,NULL);  
  return TRUE;
}


gboolean
on_window_delete_event                 (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_main_quit();
  return FALSE;
}


gboolean
on_drawingarea_key_press               (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  extern float ply_angle_tilt,ply_angle_pan;
    switch (event->keyval) {

    case GDK_space:
      flat_3d_visual=!flat_3d_visual;
      break;

    case GDK_Up:
    case GDK_KP_Up:
      ply_angle_tilt+=5;
        break;

    case GDK_Left:
    case GDK_KP_Left:
      ply_angle_pan-=5;
        break;

    case GDK_Right:
    case GDK_KP_Right:
      ply_angle_pan+=5;
        break;

    case GDK_Down:
    case GDK_KP_Down:
      ply_angle_tilt-=5;
        break;

    default:
        /* Key not found, try a keyboard accelerator. */
        return FALSE;
    }
    gtk_widget_draw(widget,NULL);
    return TRUE;
}



gboolean
on_drawingarea_configure_event         (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  drawingarea_configure=*event;
  return FALSE;
}

