
#include "stdio.h"

#include "mesh.h"


/* safe get functions; these also define the border condition */
#define MESHGETXSAFE meshGetxExt
#define MESHGETYSAFE meshGetyExt

#define MESHGETEXT_NOT_SAFE
#include "mesh-getext.h"

#include "math.h"

#include "assert.h"

#undef	MAX
#define MAX(a, b)  (((a) > (b)) ? (a) : (b))
#undef	MIN
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))
#undef	ABS
#define ABS(a)	   (((a) < 0) ? -(a) : (a))
#undef CLAMP
#define CLAMP(x, low, high)  (((x) > (high)) ? (high) : (((x) < (low)) ? (low) : (x)))

#define SMOOTH_ITERATIONS 5



/********* 
	   this routine will smooth out the mesh

	   it will only move points whose label is 0
*************/

/* relaxing step */
//#define STEP(CEN,WEST,EST,SOUTH,NORTH) (((NORTH)+(SOUTH)+(EST)+(WEST)) / 4.0)
#define STEPY(CEN,WEST,EST,SOUTH,NORTH) (((NORTH)*O+(SOUTH)*O+(EST)+(WEST)) / (2*O+2.0))
#define STEPX(CEN,WEST,EST,SOUTH,NORTH) (((NORTH)+(SOUTH)+(EST)*O+(WEST)*O) / (2*O+2.0))

/* this is now unused */
static
double smooth_elastic_mesh_once
(MeshT *mesh,
 int dontoverlap , /* if true, a point cannot enter a neighbouring cell
		      but the algo is far from perfect in this respect*/
 int keepborder,  /* if true, dont' move border points */
 double O/* orthogonal versus parallel smoothing; 
	     1 is anisotropic, ie laplacian*/
 )
{
  int xi, yi;
  double x,y,ox,oy;
  double change=0;


#ifdef PRESERVE_VARIANCE
  struct mesh_variance_s bef, aft;
  const int anykind=0;
  bef=mesh_variance(mesh, anykind);
#endif

  for(xi=0; xi < mesh->nx ; xi++) {
    for(yi=0; yi<mesh->ny  ; yi++) {
      if( 0 ==  meshGetLabel(mesh,xi,yi)) {
	if ( keepborder && (xi == 0 || xi == mesh->nx -1))
	  ox=x=meshGetx(mesh, xi,yi);
	else
	  {
	    ox=meshGetx(mesh, xi,yi);
	    x=STEPX(ox,
		   MESHGETXSAFE(mesh, xi+1,yi) ,
		   MESHGETXSAFE(mesh, xi-1,yi) ,
		   MESHGETXSAFE(mesh, xi,yi+1) ,
		   MESHGETXSAFE(mesh, xi,yi-1)) ; 
	    if(dontoverlap)
	      {
		if ( x< MESHGETXSAFE(mesh, xi-1,yi))
		  x= MESHGETXSAFE(mesh, xi-1,yi);
		else
		  if(x> MESHGETXSAFE(mesh, xi+1,yi))
		    x= MESHGETXSAFE(mesh, xi+1,yi);
		  else
		    if ( x< MESHGETXSAFE(mesh, xi-1,yi+1))
		      x= MESHGETXSAFE(mesh, xi-1,yi+1);		    
		    else
		      if(x> MESHGETXSAFE(mesh, xi+1,yi-1))
			x= MESHGETXSAFE(mesh, xi+1,yi-1);
	      }
	  }

	if ( keepborder && (  yi == 0 || yi == mesh->ny -1))
	  oy=y=meshGety(mesh, xi,yi);
	else
	  {
	    oy=meshGety(mesh, xi,yi);
	    y=STEPY(oy,
		   MESHGETYSAFE(mesh, xi+1,yi),
		   MESHGETYSAFE(mesh, xi-1,yi),
		   MESHGETYSAFE(mesh, xi,yi+1),
		   MESHGETYSAFE(mesh, xi,yi-1)) ;	
	    if(dontoverlap)
	      {			   
		if ( y< MESHGETYSAFE(mesh, xi,yi-1))
		  y= MESHGETYSAFE(mesh, xi,yi-1);
		else
		  if(y> MESHGETYSAFE(mesh, xi,yi+1))
		    y= MESHGETYSAFE(mesh, xi,yi+1);
		  else
		    if ( y< MESHGETYSAFE(mesh, xi-1,yi-1))
		      y= MESHGETYSAFE(mesh, xi-1,yi-1);
		    else
		      if(y> MESHGETYSAFE(mesh, xi+1,yi+1))
			y= MESHGETYSAFE(mesh, xi+1,yi+1);
	      }
	  }
	meshSetNoundo(mesh,xi,yi,x,y);
	change+=sqrt((x-ox)*(x-ox) + (y-oy)*(y-oy));
      }
    }
  }
#ifdef PRESERVE_VARIANCE
  aft=mesh_variance(mesh, anykind);
  mesh_normalize_variance(mesh,anykind,bef,aft);
#endif

  return change;
} 

double smooth_elastic_mesh(MeshT *mesh,
		 /* if true, a point cannot enter a neighbouring cell
		  but the algo is far from perfect in this respect*/
		 int dontoverlap,
			   
			   int keepborder,
		 double O
		 )
{  
  int lp;
  double change=0;
  assert(mesh->nx>=2 && mesh->ny>=2);
  for(lp =SMOOTH_ITERATIONS ; lp ; lp--) 
    change+=smooth_elastic_mesh_once(mesh,dontoverlap,keepborder,O);
  return change;
}



/******************************
relaxing step with a rubber wrt other mesh labels
***/

/* relaxing step */
#define STEP3DX(CEN,WEST,EST,SOUTH,NORTH,UP) ((2*(UP)+(NORTH)+(SOUTH)+(EST)*O+(WEST)*O) / (2*O+4.0))
#define STEP3DY(CEN,WEST,EST,SOUTH,NORTH,UP) ((2*(UP)+(NORTH)*O+(SOUTH)*O+(EST)+(WEST)) / (2*O+4.0))

static
double smooth_mesh_rubber_once(MeshT *mesh, MeshT *rubber, double rubberish,
			     int i,int j,int label, int dontoverlap,int keepborder, double O)
{
  int xi, yi;
  double x,y,ox,oy;
  double  r=1.0-rubberish;
  double dx=meshGetx(mesh, i,j)-meshGetx(rubber, i,j),
    dy=meshGety(mesh, i,j)-meshGety(rubber, i,j);
  double change=0;


#ifdef PRESERVE_VARIANCE
  struct mesh_variance_s bef, aft;
  const int anykind=0;
  bef=mesh_variance(mesh, anykind);
#endif
  
  for(xi=0; xi < mesh->nx ; xi++) {      	
    for(yi=0; yi<mesh->ny  ; yi++) {
      if( label ==  meshGetLabel(mesh,xi,yi) &&
	  (xi != i || yi != j)) {

	if ( keepborder && (  xi == 0 || xi == mesh->nx -1))
	  ox=x=meshGetx(mesh, xi,yi);
	else
	  {ox=meshGetx(rubber, xi,yi);
	    x=rubberish*
	      STEP3DX(ox,
		   MESHGETXSAFE(mesh, xi+1,yi) ,
		   MESHGETXSAFE(mesh, xi-1,yi) ,
		   MESHGETXSAFE(mesh, xi,yi+1) ,
		   MESHGETXSAFE(mesh, xi,yi-1) ,
		   meshGetx(rubber, xi,yi))
	      +r * (dx+meshGetx(rubber, xi,yi)); 
	    if(dontoverlap)
	      {
		if ( x< MESHGETXSAFE(mesh, xi-1,yi))
		  x= MESHGETXSAFE(mesh, xi-1,yi);
		else
		  if(x> MESHGETXSAFE(mesh, xi+1,yi))
		    x= MESHGETXSAFE(mesh, xi+1,yi);
		  else
		    if ( x< MESHGETXSAFE(mesh, xi-1,yi+1))
		      x= MESHGETXSAFE(mesh, xi-1,yi+1);		    
		    else
		      if(x> MESHGETXSAFE(mesh, xi+1,yi-1))
			x= MESHGETXSAFE(mesh, xi+1,yi-1);
	      }
	  }

	if ( keepborder && ( yi == 0 || yi == mesh->ny -1))
	  oy=y=meshGety(mesh, xi,yi);
	else
	  {
	    oy=meshGety(rubber, xi,yi);
	    y=rubberish*
	      STEP3DY(oy,
		     MESHGETYSAFE(mesh, xi+1,yi),
		     MESHGETYSAFE(mesh, xi-1,yi),
		     MESHGETYSAFE(mesh, xi,yi+1),
		     MESHGETYSAFE(mesh, xi,yi-1),
		     meshGety(rubber, xi,yi))
	      +r * (dy+meshGety(rubber, xi,yi)); 
	    if(dontoverlap)
	      {			   
		if ( y< MESHGETYSAFE(mesh, xi,yi-1))
		  y= MESHGETYSAFE(mesh, xi,yi-1);
		else
		  if(y> MESHGETYSAFE(mesh, xi,yi+1))
		    y= MESHGETYSAFE(mesh, xi,yi+1);
		  else
		    if ( y< MESHGETYSAFE(mesh, xi-1,yi-1))
		      y= MESHGETYSAFE(mesh, xi-1,yi-1);
		    else
		      if(y> MESHGETYSAFE(mesh, xi+1,yi+1))
			y= MESHGETYSAFE(mesh, xi+1,yi+1);
	      }
	  }
	meshSetNoundo(mesh,xi,yi,x,y);
	change+=sqrt((x-ox)*(x-ox) + (y-oy)*(y-oy));
      }
    }
  }

#ifdef PRESERVE_VARIANCE
  aft=mesh_variance(mesh, anykind);
  mesh_normalize_variance(mesh,anykind,bef,aft);
#endif
  
  return change;
} 


double smooth_mesh_rubber(MeshT *mesh, MeshT *rubber, double rubberish,
			int i,int j,int label, int dontoverlap,int keepborder, double O)
{  
  int lp;
  double change=0;
  assert(mesh->nx>=2 && mesh->ny>=2);
  for(lp =SMOOTH_ITERATIONS ; lp ; lp--) {
    change+=
      smooth_mesh_rubber_once(mesh,rubber,rubberish,i,j,label,dontoverlap,keepborder,O);
  }
  return change;
}

/***************************************************/

const static double D2[3][3][3] =
  {{{ 0, 0, 0},{-1,2,-1},{0, 0, 0}},
   {{ 0,-1, 0},{ 0,2,0 },{0,-1, 0}},
   {{-1, 0, 1},{ 0,0,0 },{1, 0,-1}}};


static double smooth_thin_plate_once(MeshT *mesh, int keepborder )
{
  int jx,jy,ix,iy,lx,ly;
  double x,y;
  double ox,oy;
  double meshx_D2[3][mesh->nx+2][mesh->ny+2];
  double meshy_D2[3][mesh->nx+2][mesh->ny+2];
  int k;
  double ene=0, change=0;

#ifdef PRESERVE_VARIANCE
  const int anykind=0;
  struct mesh_variance_s   bef=mesh_variance(mesh, anykind) ,  aft;
#endif
#ifdef RECOMPUTE_CHANGE
  MeshT copymesh;
  meshInit(&copymesh);
  meshAlloc(&copymesh,mesh->nx,mesh->ny);
  meshCopy(&copymesh,mesh);
#endif


  for (k=0;k<2;k++) {
    for(jx=0; jx < mesh->nx+2 ; jx++)
      for(jy=0; jy < mesh->ny+2  ; jy++) {
	
	meshx_D2[k][jx][jy]=0;
	meshy_D2[k][jx][jy]=0;
	for(ix=0; ix <= 2 ; ix++)
	  for(iy=0; iy <= 2  ; iy++) {
 	    meshx_D2[k][jx][jy]+=
	      MESHGETXSAFE(mesh, jx-ix,jy-iy)* D2[k][ix][iy];
	    meshy_D2[k][jx][jy]+=
	      MESHGETYSAFE(mesh, jx-ix,jy-iy)* D2[k][ix][iy];
	  }
/* 	if(!(jx>1 && jx < mesh->nx-2 && jy>1 && jy < mesh->ny-2)) { */
/* 	  meshx_D2[k][jx][jy] *= .1;  */
/* 	  meshy_D2[k][jx][jy] *= .1; */
/* 	} */

	ene+=(meshx_D2[k][jx][jy]*meshx_D2[k][jx][jy]+
	      meshy_D2[k][jx][jy]*meshy_D2[k][jx][jy]);
      }
  }
  //fprintf(stderr,"\r ene %g ",ene/mesh->nx/mesh->ny);

  for(lx=0; lx < mesh->nx ; lx++)
    for(ly=0; ly < mesh->ny  ; ly++) {
      if( 0  ==  meshGetLabel(mesh,lx,ly)) {
	double derEx=0,derEy=0;
	x=meshGetx(mesh, lx,ly);
	y=meshGety(mesh, lx,ly);

#ifdef USE_GAUSS_STYLE_UPDATE
	for (k=0;k<2;k++) 
	  for(jx=MAX(0,lx-2); jx < MIN(lx+3,mesh->nx+2) ; jx++)
	    for(jy=MAX(0,ly-2); jy < MIN(ly+3,mesh->ny+2)  ; jy++) {
	      meshx_D2[k][jx][jy]=0;
	      meshy_D2[k][jx][jy]=0;
	      for(ix=0; ix <= 2 ; ix++)
		for(iy=0; iy <= 2  ; iy++) {
		  meshx_D2[k][jx][jy]+=
		    MESHGETXSAFE(mesh, jx-ix,jy-iy)* D2[k][ix][iy];
		  meshy_D2[k][jx][jy]+=
		    MESHGETYSAFE(mesh, jx-ix,jy-iy)* D2[k][ix][iy];
		}
	    }
#endif

	for (k=0;k<2;k++) 
	  for(ix=0; ix <= 2 ; ix++)
	    for(iy=0; iy <= 2  ; iy++) {
	      derEx+= meshx_D2[k][lx-ix+2][ly-iy+2] * D2[k][ix][iy];
	      derEy+= meshy_D2[k][lx-ix+2][ly-iy+2] * D2[k][ix][iy];
	    }



	ox=x; oy=y;

	if(keepborder &&  lx==0)
	  x=0;
	else
	  if (keepborder && lx == mesh->nx-1)
	    ;//WE DONT REALLY KNOW x=meshMaxx(mesh);
	  else 
	    {x-=derEx/16.;      
	    x=CLAMP(x,-300,700);//AVOID CRISIS
	    }

	if(keepborder &&  ly==0 )
	  y=0;
	else
	  if(keepborder && ly == mesh->ny-1)
	    ;//WE DONT REALLY KNOW  y=meshMaxy(mesh);
	  else
	    { y-=derEy/16.;    
	    y=CLAMP(y,-300,700); //AVOID CRISIS
	    }

#ifdef ENTAGLE_AND_DONT_DISENTANGLE
	{
	  if ( x< MESHGETXSAFE(mesh, lx-1,ly))
	    x= MESHGETXSAFE(mesh, lx-1,ly);
	  if(x> MESHGETXSAFE(mesh, lx+1,ly))
	    x= MESHGETXSAFE(mesh, lx+1,ly);
/* 	  if ( x< MESHGETXSAFE(mesh, lx-1,ly+1)) */
/* 	    x= MESHGETXSAFE(mesh, lx-1,ly+1); */
/* 	  if(x> MESHGETXSAFE(mesh, lx+1,ly-1)) */
/* 	    x= MESHGETXSAFE(mesh, lx+1,ly-1); */
	  if ( y< MESHGETYSAFE(mesh, lx,ly-1))
	    y= MESHGETYSAFE(mesh, lx,ly-1);
	  if(y> MESHGETYSAFE(mesh, lx,ly+1))
	    y= MESHGETYSAFE(mesh, lx,ly+1);
/* 	  if ( y< MESHGETYSAFE(mesh, lx-1,ly-1)) */
/* 	    y= MESHGETYSAFE(mesh, lx-1,ly-1); */
/* 	  if(y> MESHGETYSAFE(mesh, lx+1,ly+1)) */
/* 	    y= MESHGETYSAFE(mesh, lx+1,ly+1); */
	}
#endif

	meshSetNoundo(mesh, lx,ly,x,y);
	change+=sqrt((x-ox)*(x-ox) + (y-oy)*(y-oy));
      }
    }

#ifdef PRESERVE_VARIANCE
  aft=mesh_variance(mesh, anykind);
  mesh_normalize_variance(mesh,anykind,bef,aft);
#endif
#ifdef RECOMPUTE_DISTANCE
  change=meshDistance(mesh,&copymesh,1);
  meshFreeReally(&copymesh);
#endif

  return change;
}

double smooth_thin_plate(MeshT *mesh, int keepborder)
{  
  int lp;
  double change=0;
  assert(mesh->nx>=2 && mesh->ny>=2);
  for(lp =SMOOTH_ITERATIONS ; lp ; lp--) {
    change+=smooth_thin_plate_once(mesh,keepborder);
  }
  return change;
}

