#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include "gtktopdata.h"
#include "gtksettings.h"

#include "settings.h"

//#include "callbacks.h"
//#include "interface.h"
#include "support.h"
#include "main.h"
#include "utils.h"



void
gtkmorph_settings_callback(GtkWidget* thismenu, gpointer userdata)
{
/* if the meshes do not have the same sizes, something will crash */
  if (settings_get_value("mesh auto sync"))
    promote_meshes();
  smooth_idle_stop();

  if (settings_get_value("preserve border")){
    int lp=MAX_WINS; for(; lp>=0; lp--) 
      if(sp->im_widget[lp] != NULL && sp->im_mesh[lp].x != NULL) {
	meshFunctionalize(&sp->im_mesh[lp],
			  sp->resulting_width,sp->resulting_height);
/* 	meshSet(&sp->im_mesh[lp],0,0,0,0); */
/* 	meshSet(&sp->im_mesh[lp],sp->im_mesh[lp].nx-1,sp->im_mesh[lp].ny-1, */
/* 		sp->resulting_width,sp->resulting_height); */
      }}
  set_state();
}

/* trick, so these get in the po files */
#ifdef ENABLE_NLS
#undef _
#define _(S) (S)
#endif

gpointer *gtkmorph_settings=NULL,
  gtkmorph_template[] =
{ 
  //gtkmorph_settings_callback,

  /****** next*******/
  _("no warnings"), //name
  NULL,//integer value, stored in pointer
  NULL,//accels
  _("dont warn, just beep; warnings may be read with 'why the beep' in the 'help' menu"),
  NULL, //widget that is expressing this setting

  /****** next*******/
  _("edit features"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels
  _("permits to add and delete mesh lines, edit features"),
  NULL, //widget that is expressing this setting

  /****** next *****/
  _("preserve border"), //name
  GUINT_TO_POINTER(0),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("border points of the mesh are forced to stay on the border of the image"), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next*******/
  _("hide unusable"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels
  _("hide unusable widgets, instead of deactivating them"),
  NULL, //widget that is expressing this setting

  /****** next*******/
  _("cursor jump"), //name
  GUINT_TO_POINTER(0),//integer value, stored in pointer
  NULL,//accels
  _("moves the image to recenter the last edited point"),
  NULL, //widget that is expressing this setting

  /****** next *****/
  _("mesh cant overlap"), //name
  GUINT_TO_POINTER(0),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("a mesh point cannot enter in a neighbouring cell (this is currently not very well enforced)"), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next *****/
  _("use antialiasing warping"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("use antialiasing routines when warping: they are much slower, but are necessary if the images have fine or grained textures and/or for animations"), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next *****/
  _("smooth elasticly"), //name
  GUINT_TO_POINTER(0),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("use elastic energy instead of thin plate energy to smooth mesh "), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

 /****** next *****/
  _("mesh factors sum to 1"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("always force the mesh factors so that they sum to 1;\n(if not, they are internally renormalized before using)"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  _("image factors sum to 1"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("always force the image factors so that they sum to 1;\n(if not, they are internally renormalized before using)"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  _("automatic mesh interpolation"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("automatically interpolates the resulting mesh when morphing (note that in this case you cannot edit it)" ) , //tooltip 
  NULL, //widget that is expressing this setting 

 /****** next *****/
  _("automatic blending"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("automatically blends the images when the image blending factors are changed" ) , //tooltip 
  NULL, //widget that is expressing this setting 

 /****** next *****/ 
  _("mesh auto sync"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("any change (add/del, label/unlabel) to a mesh is replicated"), //tooltip 
  NULL, //widget that is expressing this setting

  /****** next *****/
  _("warped image in other win"), //name
  GUINT_TO_POINTER(0),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("put warped images in another window"), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next*******/
  /*      what is shown after a "warp" or "mix" or "morph"
     button is hit ?*/
  _("show warp after warp"),
  GUINT_TO_POINTER(EDITVIEW_SHOW),
  NULL,
  _("switch the input window(s) to the warped image after a warp (overridden by the above)"), //name
  NULL,

  /****** next*******/
  NULL};


GtkWidget*
create_gtkmorph_menuSettings ()
{

  g_assert(gtkmorph_settings==NULL);
  gtkmorph_settings=gtk_settings_alloc(gtkmorph_template);
  g_assert(gtkmorph_settings);
  return   gtk_settings_create(gtkmorph_template, gtkmorph_settings,
			       gtkmorph_settings_callback,NULL);
}



int
settings_get_value(char *name)
{
  return gtk_settings_get_value(name, gtkmorph_settings);
}


int
settings_set_value(char *name, int val)
{
  return gtk_settings_set_value(name, gtkmorph_settings, val);
}






/***************************** image pane settings ******************/



void
gtkmorph_image_settings_callback(GtkWidget* thismenu, gpointer userdata)
{
  int i=
    GPOINTER_TO_UINT(userdata);
  //userdata==gtk_widget_get_data_top(thismenu,"userdata"));
  g_assert(i>0);
  if (sp->im_widget[i] && GTK_WIDGET_DRAWABLE(sp->im_widget[i]))
    {
      render_pixmap(i, PIXSUBIMAGE);
      render_pixmap(i, PIXLOADED);
    }
  gtk_widget_draw (sp->im_widget[i] , NULL);  
}


gpointer image_settings_template[] =
{ 
  //gtkmorph_image_settings_callback,

  /****** next *****/
  _("preserve aspect ratio"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  _("when loading an image, preserve aspect ratio"), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next*******/
  _("dim image"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels
  "",
  NULL, //widget that is expressing this setting

  /****** next*******/
  _("view original mesh"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels
  "",
  NULL, //widget that is expressing this setting

  /****** next *****/
  _("view original points"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "",
  NULL, //widget that is expressing this setting

  /****** next *****/
/*   _("view original features"), //name */
/*   GUINT_TO_POINTER(1),//integer value, stored in pointer */
/*   NULL,//accels NOW IGNORED */
/*   "", */
/*   NULL, //widget that is expressing this setting */

  /****** next*******/
  _("view warped mesh"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels
  "",
  NULL, //widget that is expressing this setting

  /****** next *****/
  _("view warped points"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "",
  NULL, //widget that is expressing this setting

  /****** next *****/
/*   _("view warped features"), //name */
/*   GUINT_TO_POINTER(1),//integer value, stored in pointer */
/*   NULL,//accels NOW IGNORED */
/*   "", */
/*   NULL, //widget that is expressing this setting */

  /****** next *****/
  _("view eyes"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "",
  NULL, //widget that is expressing this setting

  //  /****** next *****/ /* HACK FIXME : NOW IGNORED */
  //  "view .../loaded image/subimage/warped image/", //name
  //GUINT_TO_POINTER(1),//integer value, stored in pointer
  //NULL,//accels NOW IGNORED
  //"view warped image instead of original image",
  //NULL, //widget that is expressing this setting

  /****** next *****/
  _("mesh is readonly"), //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "",
  NULL, //widget that is expressing this setting

  /****** next*******/
  NULL};


GtkWidget*
create_image_menu_settings (int i)
{

  sp->im_settings[i] = gtk_settings_alloc(image_settings_template);

  g_assert(sp->im_settings[i]);
  sp->im_menu_settings[i]=
    gtk_settings_create(image_settings_template,
			sp->im_settings[i],
			gtkmorph_image_settings_callback,GINT_TO_POINTER(i));
  g_assert(sp->im_menu_settings[i]); 
  return sp->im_menu_settings[i];
}



int
image_settings_get_value(char *name, int i)
{
  return gtk_settings_get_value(name, sp->im_settings[i]);
}

int
image_settings_set_value(char *name, int i, int value)
{
  return gtk_settings_set_value(name,sp->im_settings[i],value);
}
