
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "stdio.h"
#include "strings.h"
#include "string.h"
#include <unistd.h>
#include "math.h"

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include <gdk/gdk.h>

#include "gtktopdata.h"

#include "gtk_subimagesel.h"

#include "main.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
//#include "pixmaps.h"
#include "mesh-gtk.h"
#include "utils.h"
#include "gtk-extra.h"
#include "../libmorph/relax.h"


/************************************* making movies ******************/





void
on_morph_sequence1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{  
  static GtkWidget* m=NULL;
 if( sp->max_wins<=1)
    {
      show_warning( _("to morph, you must have at least two input images"));
      return;
    }
 else
   {
     if(m==NULL || !GTK_IS_WIDGET (m))
       m=create_window_movie();     
     gtk_widget_show(m);
   }
}



morph_factors_t morph_factors_saved[2];


int movie_init()
{
  int lp;
  for(lp=MAX_WINS; lp >=0; lp--) {
    morph_factors_saved[0].im_warp_factor[lp]=0;
    morph_factors_saved[1].im_warp_factor[lp]=0;
    morph_factors_saved[0].im_dissolve_factor[lp]=0;
    morph_factors_saved[1].im_dissolve_factor[lp]=0;
  }
  morph_factors_saved[0].im_warp_factor[1]=1;
  morph_factors_saved[1].im_warp_factor[2]=1;
  morph_factors_saved[0].im_dissolve_factor[1]=1;
  morph_factors_saved[1].im_dissolve_factor[2]=1;
  return 0;
}

void
store_morph_factors(int i)
{
  memcpy (& morph_factors_saved[i], &sp->mf,  sizeof(morph_factors_t));
}

void
restore_morph_factors(int i)
{
  memcpy(& sp->mf, &morph_factors_saved[i], sizeof(morph_factors_t));
  redraw_spins(-3);
}

void
on_store_morph_factors_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //action_morph_factors=store_morph_factors;
  //on_morph_factors_activate        (menuitem,user_data);
}


void
on_restore_morph_factors1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int lp;
  //action_morph_factors=restore_morph_factors;
  //on_morph_factors_activate        (menuitem,user_data); 
  for(lp=1;lp<=MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL)
      set_editview(lp, EDITVIEW_SHOWMESHES);
}

void
on_restore_equal_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int lp,i=0;
  for(lp=1;lp<=MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL) i++;
  for(lp=1;lp<=MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL) 
      sp->mf.im_warp_factor[lp]=sp->mf.im_dissolve_factor[lp]=1./(double)i;
  redraw_spins(-3);
}


void
on_restore_start_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  restore_morph_factors(0); 
}

void
on_restore_end_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  restore_morph_factors(1);
}


void
on_store_start_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  store_morph_factors(0);
}


void
on_store_end_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  store_morph_factors(1);
}









#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>

void
movie_names(char *name[],char * basename, int first, int tot)
{
  int ima;
  for(ima=0; ima < tot; ima++) 
    name[ima]=g_strdup_printf("%s%0+4d.ppm",basename,ima+first);
}

void
movie_data( GtkButton       *button, int  *first, int *tot, gchar **basename)
{
  GtkWidget* m=NULL, 
    *widget=GTK_WIDGET(button);

  GtkSpinButton *spin;

  m=gtk_widget_get_data_top(widget,"file_base_name");
  g_assert(m);
  *basename=  gtk_entry_get_text(GTK_ENTRY(m));

  m=gtk_widget_get_data_top(widget,"spinbutton_first_file");
  g_assert(m);
  spin = GTK_SPIN_BUTTON (m);  
  *first=gtk_spin_button_get_value_as_float (spin);
  
  m=gtk_widget_get_data_top(widget,"spinbutton_n_files");
  g_assert(m);
  spin = GTK_SPIN_BUTTON (m);  
  *tot=gtk_spin_button_get_value_as_float (spin);

}
void
on_movie_ok_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
 
  char * basename;
  int ima, lp, first, tot;

  /* stops all background processes that are smoothing the meshes */
  smooth_idle_stop();

  movie_data( button, &first, &tot, &basename);
 
  {
    char *name[tot], 
      *err= g_strdup ("");

    movie_names(name,basename,  first, tot);

    {
      struct stat buf;
      for(ima=0; ima < tot; ima++) {
	if (0== stat (name[ima],&buf)) {
	  err=g_strdup_printf("%s\n %s ",err,name[ima]);
	//perror(name[ima]);
	}
      }
    }
    if( strlen(err) > 0) {
      err=g_strdup_printf("the following files already exist:\n%s",err);
      show_error(err);
      g_free(err);
      for(ima=0; ima < tot; ima++)
	g_free(name[ima]);
      return ;      
    }
    g_free(err);    
  
    for(ima=0; ima < tot; ima++) {
      double a = (double)ima / ((double)tot-1.0),      b=1-a;
      for(lp=MAX_WINS; lp >=0; lp--) {
	sp->mf.im_warp_factor[lp]= 
	  morph_factors_saved[0].im_warp_factor[lp] * a +
	  morph_factors_saved[1].im_warp_factor[lp] * b;
	sp->mf.im_dissolve_factor[lp]= 
	  morph_factors_saved[0].im_dissolve_factor[lp] * a +
	  morph_factors_saved[1].im_dissolve_factor[lp] * b;
      }

      on_interpolate_meshes1_activate (NULL,NULL);

      redraw_spins(-3);
      /* computation going on */
      while (gtk_events_pending())
	gtk_main_iteration();
      /* computation continued */
      
      on_morph_images1_activate( NULL, NULL);


      /* computation going on */
      while (gtk_events_pending())
	gtk_main_iteration();
      /* computation continued */
      
      save_image_to_file(MAIN_WIN, name[ima]);
    }

    on_movie_replay_clicked(button, user_data);

    for(ima=0; ima < tot; ima++)
      g_free(name[ima]);
  }
}



void
on_movie_help_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{

  char * basename;
  int ima, first, tot;

  movie_data( button, &first, &tot, &basename);
  {
    char *name[tot], *help;
    movie_names(name,basename,  first, tot);
    
    help=g_strdup_printf(_("Help on movie making: when you hit ok, gtkmorph will repeat a loop for %d times. Any time, it will set the warping and image-blending factors to an interpolation between the values that you have stored as 'first' and 'end'. Any time, it will save the morphed image, starting from '%s' and ending with '%s'. Then it will create any animation that you have asked to create: the animated gif is called '%s.gif', the mpeg file is called '%s.mpeg' (and mpeg_encode will use '%s.param' for parameters if available: see in " PACKAGE_DATA_DIR  "/mpeg.param an example, or copy the end part of %s.auto.param) and play them. You may recreate animations from preexisting frames by hitting 'replay'"),
			 tot, name[0], name[tot-1] ,basename,basename,basename,basename );
    show_info(help);


    for(ima=0; ima < tot; ima++)
      g_free(name[ima]);
    g_free(help);
  }
}  


void
on_movie_replay_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  char * basename;
  int ima,  first, tot;

  movie_data( button, &first, &tot, &basename);

  {
    char *name[tot], 
      *cmd= g_strdup ("");
    char *names=g_strdup("");

    movie_names(name,basename,  first, tot);
    
    for(ima=0; ima < tot; ima++) 
      names=g_strdup_printf("%s '%s'",names,name[ima]);

    {
      GtkWidget *widget=GTK_WIDGET(button);

      GtkCheckButton *b;
      /******************** animate ******************/
      b=gtk_widget_get_data_top(widget,"animate");
      g_assert(b);
      if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b))) {	
	cmd= g_strdup_printf ("animate -delay %d %s &",(int)ceil(300/tot),names);  
	system(cmd);
	g_free(cmd);
      }

      /******************* gif *********************/
      b=gtk_widget_get_data_top(widget,"animated_gif");
      g_assert(b);
      if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b))) {
	cmd= g_strdup_printf ("\
convert %s '%s.gif' && animate  -delay %d '%s.gif' &",
			      names,basename,
			      1+200/tot, basename);	
	system(cmd);
	g_free(cmd);
      }
      
      /***************** mpeg **********************/
      b=gtk_widget_get_data_top(widget,"animated_mpeg");
      g_assert(b);
      if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b))) {
	char *tmpname=g_strdup_printf("%s.auto.param",
				      basename),
	  *parmname=g_strdup_printf ("%s.param",basename);
	FILE *tmpfile=fopen(tmpname,"w"),
	  *parmfile;
	char *cmd= g_strdup_printf ("\
mpeg_encode -quiet 3 '%s' && { \
 if [ -r /usr/bin/X11/mpeg_play ] ; then mpeg_play -quiet '%s.mpeg' ; \
  else xanim  '%s.mpeg' ; fi ;  }  &", tmpname,basename,basename);
	if(tmpfile) {
	  fprintf(tmpfile,"\
#this file is automatically generated and will be overwritten\n");

	  if(tmpname[0]=='/')
	    fprintf(tmpfile,"\
OUTPUT %s.mpeg\n\
INPUT_DIR \n\
INPUT\n",basename);
	  else
	    fprintf(tmpfile,"\
OUTPUT %s.mpeg\n\
INPUT_DIR .\n\
INPUT\n",basename);
	  for(ima=0; ima < tot; ima++)
	    fprintf(tmpfile,"%s\n", name[ima]);
	  fprintf(tmpfile,"\
END_INPUT\n\
BASE_FILE_FORMAT PPM\n\
INPUT_CONVERT *\n");
	  parmfile=fopen(parmname,"r");
	  if( NULL!=  parmfile) {
	    char s[500];
	    while(!feof(parmfile)) {
	      fgets(s,500,parmfile);
	      fputs(s,tmpfile); }
	      fclose(parmfile);
	  } else {
	    int slices=16;
	    while ( slices >1 && ( sp-> resulting_height %slices) != 0 )
	      slices --;
	    fprintf(tmpfile,"\
### these parameters will be read from file %s\n\
### if you create it\n\
### explanation of parameters is in the help of mpeg_encode\n\
PATTERN IBBPBBPBBPBBPBB\n\
GOP_SIZE 30\n\
SLICES_PER_FRAME %d\n\
PIXEL HALF\n\
RANGE 10\n\
FRAME_RATE 24\n\
PSEARCH_ALG TWOLEVEL\n\
BSEARCH_ALG CROSS2\n\
IQSCALE 1\n\
PQSCALE 1\n\
BQSCALE 1\n\
REFERENCE_FRAME DECODED\n",parmname,slices);
	  }
	  fclose(tmpfile);
	  system(cmd);
	  g_free(cmd);
	  g_free(parmname);
	}
	else
	  show_error(g_strdup_printf("\
can't open the temporary file %s for writing: %s", tmpname,strerror(errno)));
      }      
    }

    for(ima=0; ima < tot; ima++)
      g_free(name[ima]);
  }
}

