#!/usr/bin/env python

from distutils.core import setup

setup(name='xmms2tray',
      version='0.5',
      description='tray icon for XMMS2',
      author='Thomas Jollans',
      author_email='thomas@jollans.com',
      url='http://zombiehq.jollybox.de/zhq/projects/xmms2tray',

      requires=['xmmsclient', 'gtk (>=2.10.0)'],

      packages=['xmms2tray'],
      package_dir={'xmms2tray': 'src/xmms2tray'},
      data_files=[('share/doc/xmms2tray', ['README', 'COPYING', 'ChangeLog']),
                  ('share/xmms2tray/data', ['data/xmms2_simple.png',
                                            'data/xmms2_glossy.png',
                                            'data/xmms2_glossy_24.png',
                                            'data/xmms2_simple_64.png',
                                            'data/xmms2_64.png',
                                            'data/xmms2_24.png']),
                  ('share/xmms2tray/data/po/LC_MESSAGES/xmms2tray.mo',
                              ['data/po/de/LC_MESSAGES/xmms2tray.mo'])],
      scripts=['xmms2tray'],

      classifiers=[
          'Development Status :: 4 - Beta',
          'Environment :: X11 Applications :: GTK',
          'License :: DFSG approved',
          'License :: OSI Approved :: GNU General Public License (GPL)',
          'Natural Language :: English',
          'Operating System :: POSIX',
          'Programming Language :: Python',
          'Topic :: Multimedia :: Sound/Audio'
          ]
      )

