/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "singit/macros.h"

#include "gtkglmaterialdialog.h"
#include "displayer_opengl.h"

#include "displayer_opengl_config.h"
#include "displayer_opengl_config_dlg.h"

static GtkWidget *opengl_config_win = NULL;
static GtkWidget
	*config_vbox,
		*config_bass_sensitivity_frame,
			*config_bass_sensitivity_table,
				*config_high_bass_label, *config_high_bass_hscale,
				*config_low_bass_label, *config_low_bass_hscale,

				*config_direct_apply_check_button,
				*config_display_particles_check_button,

		*opengl_material_button,
//			*config_opengl_material_dialog,
		*bottom_button_hbox,
			*bottom_button_ok,
			*bottom_button_cancel,
			*bottom_button_apply;

static GtkObject
	*config_high_bass_hscale_adj = NULL,
	*config_low_bass_hscale_adj = NULL;


static void config_dis_plugins_use_cb(GtkWidget * w, gpointer data)
{

}

static void config_low_bass_hscale_value_changed_event(GtkAdjustment *adj, gpointer user_data)
{

}

static void config_high_bass_hscale_value_changed_event(GtkAdjustment *adj, gpointer user_data)
{

}

static void opengl_config_cleanup()
{
#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_cleanup]\n"));
#endif

	opengl_status_unref(NULL);
	gtk_widget_destroy(opengl_config_win);
}

static void opengl_config_apply_clicked(GtkButton *button, gpointer user_data)
{
	OpenGLConfigData *oglcd;

#ifdef CODEDEBUG
	DEBUG(("displayer_opengl_config_dlg.c [opengl_config_apply_clicked]\n"));
#endif

	g_return_if_fail(opengl_config_win != NULL);
	g_return_if_fail(GTK_WIDGET_REALIZED(opengl_config_win));
	g_return_if_fail(STATUS != NULL);
	g_return_if_fail(STATUS->config != NULL);

	oglcd = GET_OGLCD;

	oglcd->sensitivityBassHigh =
		(gint) GTK_ADJUSTMENT(config_high_bass_hscale_adj)->value;
	oglcd->sensitivityBassLow =
		(gint) GTK_ADJUSTMENT(config_low_bass_hscale_adj)->value;
	oglcd->directApply =
		GTK_TOGGLE_BUTTON(config_direct_apply_check_button)->active;
	oglcd->displayParticles =
		GTK_TOGGLE_BUTTON(config_display_particles_check_button)->active;

	singit_config_gen_emit_update(STATUS->config);
	singit_config_gen_save(STATUS->config);
}

static void opengl_material_changed(GtkGLMaterialDialog *dlg, gpointer user_data)
{
#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_material_changed]\n"));
#endif

	gtk_widget_destroy(GTK_WIDGET(dlg));
}

static void opengl_material_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *config_opengl_material_dialog;

#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_material_clicked]\n"));
#endif

	config_opengl_material_dialog = gtk_gl_material_dialog_new("Test Material");
	gtk_signal_connect(GTK_OBJECT(config_opengl_material_dialog), "delete_event",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), config_opengl_material_dialog);
	gtk_signal_connect(GTK_OBJECT(config_opengl_material_dialog), "material_changed",
		GTK_SIGNAL_FUNC(opengl_material_changed), NULL);
	gtk_widget_show(config_opengl_material_dialog);
}

static void opengl_config_ok_clicked(GtkButton *button, gpointer user_data)
{
	opengl_config_apply_clicked(button, user_data);
	opengl_config_cleanup();
}

static void opengl_config_cancel_clicked(GtkButton *button, gpointer user_data)
{
	opengl_config_cleanup();
}

static gint dlg_opengl_config_delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data )
{
	opengl_config_cleanup(FALSE);
	return (FALSE);
}

void displayer_opengl_config_show(void)
{
	OpenGLConfigData *oglcd;
#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_show]\n"));
#endif

	if (opengl_config_win) {
		gdk_window_raise(opengl_config_win->window);
		return;
	}

	g_return_if_fail(opengl_status_ref() == NULL);

	oglcd = GET_OGLCD;

	opengl_config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(opengl_config_win), "delete_event",
		GTK_SIGNAL_FUNC(dlg_opengl_config_delete_event), NULL);

	/* update opengl_config_win when window is destroyed */
	gtk_signal_connect(GTK_OBJECT(opengl_config_win), "destroy",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &opengl_config_win);

	gtk_window_set_title(GTK_WINDOW(opengl_config_win), "OpenGL Config");
	gtk_window_set_policy(GTK_WINDOW(opengl_config_win), FALSE, FALSE, FALSE);
	gtk_container_border_width(GTK_CONTAINER(opengl_config_win), 5);

	config_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(opengl_config_win), config_vbox);
	gtk_widget_show(config_vbox);


	config_bass_sensitivity_frame = gtk_frame_new(_("Bass Sensitivity"));
	gtk_box_pack_start(GTK_BOX(config_vbox), config_bass_sensitivity_frame, TRUE, TRUE, 0);
	gtk_widget_show(config_bass_sensitivity_frame);

	config_bass_sensitivity_table = gtk_table_new (2, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (config_bass_sensitivity_table), 3);
	gtk_table_set_col_spacings (GTK_TABLE (config_bass_sensitivity_table), 3);
	gtk_container_set_border_width(GTK_CONTAINER(config_bass_sensitivity_table), 2);
	gtk_container_add(GTK_CONTAINER(config_bass_sensitivity_frame), config_bass_sensitivity_table);
	gtk_widget_show(config_bass_sensitivity_table);

	config_high_bass_label = gtk_label_new(_("High"));
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_high_bass_label, 0, 1, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_high_bass_label);

	config_high_bass_hscale_adj = gtk_adjustment_new
		(oglcd->sensitivityBassHigh, 0, 101, 1, 1, 1);
	gtk_signal_connect (GTK_OBJECT (config_high_bass_hscale_adj), "value_changed",
		GTK_SIGNAL_FUNC (config_high_bass_hscale_value_changed_event), NULL);
	config_high_bass_hscale = gtk_hscale_new( GTK_ADJUSTMENT(config_high_bass_hscale_adj) );
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_high_bass_hscale, 1, 2, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_high_bass_hscale);

	config_low_bass_label = gtk_label_new(_("Low"));
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_low_bass_label, 0, 1, 1, 2,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_low_bass_label);

	config_low_bass_hscale_adj = gtk_adjustment_new
		(oglcd->sensitivityBassLow, 0, 101, 1, 1, 1);
	gtk_signal_connect (GTK_OBJECT (config_low_bass_hscale_adj), "value_changed",
		GTK_SIGNAL_FUNC (config_low_bass_hscale_value_changed_event), NULL);
	config_low_bass_hscale = gtk_hscale_new( GTK_ADJUSTMENT(config_high_bass_hscale_adj) );
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_low_bass_hscale, 1, 2, 1, 2,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_low_bass_hscale);

	config_direct_apply_check_button = gtk_check_button_new_with_label(_("Apply directly"));
	gtk_box_pack_start(GTK_BOX(config_vbox), config_direct_apply_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_direct_apply_check_button),
		oglcd->directApply);
	gtk_widget_show(config_direct_apply_check_button);

	config_display_particles_check_button = gtk_check_button_new_with_label(_("Show particles"));
	gtk_box_pack_start(GTK_BOX(config_vbox), config_display_particles_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_display_particles_check_button),
		oglcd->displayParticles);
	gtk_widget_show(config_display_particles_check_button);

	opengl_material_button = gtk_button_new_with_label(_("Material..."));
	gtk_signal_connect_object(GTK_OBJECT(opengl_material_button), "clicked", GTK_SIGNAL_FUNC(opengl_material_clicked), (GtkObject*) TRUE);
	gtk_box_pack_start(GTK_BOX(config_vbox), opengl_material_button, TRUE, TRUE, 0);
	gtk_widget_show(opengl_material_button);

/*
	Bottom button row ([Ok] [Cancel] [Apply])
*/
	bottom_button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bottom_button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(config_vbox), bottom_button_hbox, FALSE, FALSE, 0);
	gtk_widget_show(bottom_button_hbox);

	bottom_button_ok = gtk_button_new_with_label(_("Ok"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_ok), "clicked", GTK_SIGNAL_FUNC(opengl_config_ok_clicked), (GtkObject*) TRUE);
	GTK_WIDGET_SET_FLAGS(bottom_button_ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_ok, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_ok);

	bottom_button_cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_cancel), "clicked", GTK_SIGNAL_FUNC(opengl_config_cancel_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_cancel, TRUE, TRUE, 0);
	gtk_widget_grab_default(bottom_button_cancel);
	gtk_widget_show(bottom_button_cancel);

	bottom_button_apply = gtk_button_new_with_label(_("Apply"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_apply), "clicked", GTK_SIGNAL_FUNC(opengl_config_apply_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_apply, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_apply, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_apply);

	gtk_widget_show(opengl_config_win);
}

void displayer_opengl_config_hide(void)
{
	if (opengl_config_win)
		{ opengl_config_cancel_clicked(NULL, NULL); }
}
