#ifndef _XS_SUPPORT_H
#define _XS_SUPPORT_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <stdio.h>

#ifdef HAVE_ASSERT_H
#include <assert.h>
#else
#define assert(x) /* stub */
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#else
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif

#ifndef HAVE_FSEEKO
#define fseeko fseek
#define ftello ftell
#endif


#define t_xs_file FILE


/* Functions
 */
t_xs_file *xs_fopen(const gchar *, const gchar *);
gint	xs_fclose(t_xs_file *);
gint	xs_fgetc(t_xs_file *);
guint16 xs_fread_be16(t_xs_file *);
guint32 xs_fread_be32(t_xs_file *);
size_t	xs_fread(void *, size_t, size_t, t_xs_file *);
gint	xs_feof(t_xs_file *);
gint	xs_ferror(t_xs_file *);

gchar	*xs_strncpy(gchar *, gchar *, size_t);
gint	xs_pstrcpy(gchar **, const gchar *);
gint	xs_pstrcat(gchar **, const gchar *);
void	xs_pnstrcat(gchar *, size_t, gchar *);
gchar	*xs_strrchr(gchar *, gchar);
inline 	void xs_findnext(gchar *, guint *);
inline 	void xs_findeol(gchar *, guint *);
inline	void xs_findnum(gchar *, guint *);

#ifdef HAVE_MEMSET
#define	xs_memset memset
#else
void	*xs_memset(void *, int, size_t);
#endif

#ifdef __cplusplus
}
#endif
#endif /* _XS_SUPPORT_H */
