#ifndef XS_STIL_H
#define XS_STIL_H

#ifdef __cplusplus
extern "C" {
#endif

#include "xmms-sid.h"

/*
 * Defines and typedefs
 */
typedef struct {
	gchar	*pName,
		*pAuthor,
		*pInfo;
} t_xs_stil_subnode;

typedef struct _t_xs_stil_node {
	gchar			*pcFilename;
	t_xs_stil_subnode	subTune[XS_STIL_MAXENTRY];
	struct _t_xs_stil_node	*pPrev, *pNext;
} t_xs_stil_node;


/*
 * Functions
 */
gint	xs_stil_init(void);		/* Initialize STIL subsystem */
void	xs_stil_close(void);		/* Close/shutdown */
t_xs_stil_node*	xs_stil_get(gchar *);	/* Get STIL information */


#ifdef __cplusplus
}
#endif
#endif /* XS_STIL_H */
