/*      xmms - jack output plugin
 *    Copyright (C) 2000      B. Heath Robinson
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Contains code Copyright (C) 1998-2000 Mikael Alm, Olle Hallnas,
 *  Thomas Nillson, 4Front Technologies and Galex Yen
 */

#include "jack.h"

#include <xmms/configfile.h>
#include <gtk/gtk.h>

extern jackconfig jack_cfg;

static GtkWidget *configure_win = NULL, *vbox, *notebook;


static GtkWidget *buffer_frame, *buffer_vbox, *buffer_table;
static GtkWidget *buffer_size_box, *buffer_size_label, *buffer_size_spin;
static GtkObject *buffer_size_adj;
static GtkWidget *buffer_pre_box, *buffer_pre_label, *buffer_pre_spin;
static GtkObject *buffer_pre_adj;
static GtkWidget *bbox, *ok, *cancel;

static void configure_win_ok_cb(GtkWidget * w, gpointer data)
{
	ConfigFile *cfgfile;
	gchar *filename;

	jack_cfg.buffer_size = (gint) GTK_ADJUSTMENT(buffer_size_adj)->value;
	jack_cfg.prebuffer = (gint) GTK_ADJUSTMENT(buffer_pre_adj)->value;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfgfile = xmms_cfg_open_file(filename);
	if (!cfgfile)
		cfgfile = xmms_cfg_new();

	xmms_cfg_write_int(cfgfile, "jack", "buffer_size", jack_cfg.buffer_size);
	xmms_cfg_write_int(cfgfile, "jack", "prebuffer", jack_cfg.prebuffer);
	xmms_cfg_write_file(cfgfile, filename);
	xmms_cfg_free(cfgfile);

	g_free(filename);

	gtk_widget_destroy(configure_win);
}

void jack_configure(void)
{

	if (!configure_win)
	{
		configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_signal_connect(GTK_OBJECT(configure_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_win);
		gtk_window_set_title(GTK_WINDOW(configure_win), ("jack Plugin configuration"));
		gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
		gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE);
		gtk_container_border_width(GTK_CONTAINER(configure_win), 10);

		vbox = gtk_vbox_new(FALSE, 10);
		gtk_container_add(GTK_CONTAINER(configure_win), vbox);

		notebook = gtk_notebook_new();
		gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

		buffer_frame = gtk_frame_new(("Buffering:"));
		gtk_container_set_border_width(GTK_CONTAINER(buffer_frame), 5);

		buffer_vbox = gtk_vbox_new(FALSE, 0);
		gtk_container_add(GTK_CONTAINER(buffer_frame), buffer_vbox);

		buffer_table = gtk_table_new(2, 1, TRUE);
		gtk_container_set_border_width(GTK_CONTAINER(buffer_table), 5);
		gtk_box_pack_start(GTK_BOX(buffer_vbox), buffer_table, FALSE, FALSE, 0);

		buffer_size_box = gtk_hbox_new(FALSE, 5);
		gtk_table_attach_defaults(GTK_TABLE(buffer_table), buffer_size_box, 0, 1, 0, 1);
		buffer_size_label = gtk_label_new(("Buffer size (ms):"));
		gtk_box_pack_start(GTK_BOX(buffer_size_box), buffer_size_label, FALSE, FALSE, 0);
		gtk_widget_show(buffer_size_label);
		buffer_size_adj = gtk_adjustment_new(jack_cfg.buffer_size, 200, 10000, 100, 100, 100);
		buffer_size_spin = gtk_spin_button_new(GTK_ADJUSTMENT(buffer_size_adj), 8, 0);
		gtk_widget_set_usize(buffer_size_spin, 60, -1);
		gtk_box_pack_start(GTK_BOX(buffer_size_box), buffer_size_spin, FALSE, FALSE, 0);
		gtk_widget_show(buffer_size_spin);
		gtk_widget_show(buffer_size_box);

		buffer_pre_box = gtk_hbox_new(FALSE, 5);
		gtk_table_attach_defaults(GTK_TABLE(buffer_table), buffer_pre_box, 1, 2, 0, 1);
		buffer_pre_label = gtk_label_new(("Pre-buffer (percent):"));
		gtk_box_pack_start(GTK_BOX(buffer_pre_box), buffer_pre_label, FALSE, FALSE, 0);
		gtk_widget_show(buffer_pre_label);
		buffer_pre_adj = gtk_adjustment_new(jack_cfg.prebuffer, 0, 90, 1, 1, 1);
		buffer_pre_spin = gtk_spin_button_new(GTK_ADJUSTMENT(buffer_pre_adj), 1, 0);
		gtk_widget_set_usize(buffer_pre_spin, 60, -1);
		gtk_box_pack_start(GTK_BOX(buffer_pre_box), buffer_pre_spin, FALSE, FALSE, 0);
		gtk_widget_show(buffer_pre_spin);
		gtk_widget_show(buffer_pre_box);

		gtk_widget_show(buffer_table);
		gtk_widget_show(buffer_vbox);
		gtk_widget_show(buffer_frame);
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), buffer_frame, gtk_label_new(("Buffering")));

		gtk_widget_show(notebook);

		bbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
		gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

		ok = gtk_button_new_with_label(("Ok"));
		gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(configure_win_ok_cb), NULL);
		GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
		gtk_widget_show(ok);
		gtk_widget_grab_default(ok);

		cancel = gtk_button_new_with_label(("Cancel"));
		gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(configure_win));
		GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
		gtk_widget_show(cancel);

		gtk_widget_show(bbox);
		gtk_widget_show(vbox);
		gtk_widget_show(configure_win);
	}
	else
		gdk_window_raise(configure_win->window);
}
